/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowIntentionActionsHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler");

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        LookupEx lookup;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file2 = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
        }
        if ((lookup = LookupManager.getActiveLookup(editor)) != null) {
            lookup.showElementActions();
            return;
        }
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
        codeAnalyzer.autoImportReferenceAtCursor(editor, file2);
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        ShowIntentionsPass.getActionsToShow(editor, file2, intentions, -1);
        IntentionHintComponent hintComponent = codeAnalyzer.getLastIntentionHint();
        if (hintComponent != null) {
            IntentionHintComponent.PopupUpdateResult result2;
            IntentionHintComponent.PopupUpdateResult popupUpdateResult = result2 = hintComponent.isForEditor(editor) ? hintComponent.updateActions(intentions) : IntentionHintComponent.PopupUpdateResult.HIDE_AND_RECREATE;
            if (result2 == IntentionHintComponent.PopupUpdateResult.HIDE_AND_RECREATE) {
                hintComponent.hide();
            }
        }
        if (HintManagerImpl.getInstanceImpl().performCurrentQuestionAction()) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(editor);
        if (state != null && !state.isFinished()) {
            return;
        }
        if (!intentions.isEmpty()) {
            IntentionHintComponent.showIntentionHint(project, file2, editor, intentions, true);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static boolean availableFor(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull IntentionAction action) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "availableFor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "availableFor"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "availableFor"));
        }
        if (!psiFile.isValid()) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = psiFile.findElementAt(offset);
        boolean inProject = psiFile.getManager().isInProject((PsiElement)psiFile);
        try {
            Project project = psiFile.getProject();
            if (action instanceof SuppressIntentionActionFromFix) {
                ThreeState shouldBeAppliedToInjectionHost = ((SuppressIntentionActionFromFix)action).isShouldBeAppliedToInjectionHost();
                if (editor instanceof EditorWindow && shouldBeAppliedToInjectionHost == ThreeState.YES) {
                    return false;
                }
                if (!(editor instanceof EditorWindow) && shouldBeAppliedToInjectionHost == ThreeState.NO) {
                    return false;
                }
            }
            if (action instanceof PsiElementBaseIntentionAction ? !inProject || psiElement == null || !((PsiElementBaseIntentionAction)action).isAvailable(project, editor, psiElement) : !action.isAvailable(project, editor, psiFile)) {
                return false;
            }
        }
        catch (IndexNotReadyException e) {
            return false;
        }
        return true;
    }

    @Nullable
    public static Pair<PsiFile, Editor> chooseBetweenHostAndInjected(@NotNull PsiFile hostFile, @NotNull Editor hostEditor, @NotNull PairProcessor<PsiFile, Editor> predicate) {
        Editor injectedEditor;
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseBetweenHostAndInjected"));
        }
        if (hostEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostEditor", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseBetweenHostAndInjected"));
        }
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseBetweenHostAndInjected"));
        }
        Editor editorToApply = null;
        PsiFile fileToApply = null;
        int offset = hostEditor.getCaretModel().getOffset();
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(hostFile, offset);
        if (injectedFile != null && predicate.process((Object)injectedFile, (Object)(injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, injectedFile)))) {
            editorToApply = injectedEditor;
            fileToApply = injectedFile;
        }
        if (editorToApply == null && predicate.process((Object)hostFile, (Object)hostEditor)) {
            editorToApply = hostEditor;
            fileToApply = hostFile;
        }
        if (editorToApply == null) {
            return null;
        }
        return Pair.create(fileToApply, editorToApply);
    }

    public static boolean chooseActionAndInvoke(@NotNull PsiFile hostFile, @NotNull Editor hostEditor, @NotNull IntentionAction action, @NotNull String text) {
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        if (hostEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostEditor", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        Project project = hostFile.getProject();
        return ShowIntentionActionsHandler.chooseActionAndInvoke(hostFile, hostEditor, action, text, project);
    }

    static boolean chooseActionAndInvoke(@NotNull PsiFile hostFile, final @Nullable Editor hostEditor, final @NotNull IntentionAction action, @NotNull String text, final @NotNull Project project) {
        Pair<PsiFile, Editor> pair;
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.quickFix");
        ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getFixesStats().registerInvocation();
        Pair<PsiFile, Editor> pair2 = pair = hostEditor != null ? ShowIntentionActionsHandler.chooseBetweenHostAndInjected(hostFile, hostEditor, new PairProcessor<PsiFile, Editor>(){

            public boolean process(PsiFile psiFile, Editor editor) {
                return ShowIntentionActionsHandler.availableFor(psiFile, editor, action);
            }
        }) : Pair.create((Object)hostFile, null);
        if (pair == null) {
            return false;
        }
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                try {
                    action.invoke(project, (Editor)pair.second, (PsiFile)pair.first);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                if (hostEditor != null) {
                    DaemonCodeAnalyzer.getInstance((Project)project).updateVisibleHighlighters(hostEditor);
                }
            }
        };
        if (action.startInWriteAction()) {
            final Runnable _runnable = runnable2;
            runnable2 = new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(_runnable);
                }
            };
        }
        CommandProcessor.getInstance().executeCommand(project, runnable2, text, null);
        return true;
    }
}

