/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.completion;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesCheckboxTree;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesConfigurable;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;

public class PostfixTemplateLookupActionProvider
implements LookupActionProvider {
    @Override
    public void fillActions(LookupElement element, final Lookup lookup, Consumer<LookupElementAction> consumer) {
        if (element instanceof PostfixTemplateLookupElement) {
            final PostfixTemplateLookupElement templateLookupElement = (PostfixTemplateLookupElement)element;
            final PostfixTemplate template = templateLookupElement.getPostfixTemplate();
            consumer.consume((Object)new LookupElementAction(PlatformIcons.EDIT, "Edit postfix templates settings"){

                @Override
                public LookupElementAction.Result performLookupAction() {
                    final Project project = lookup.getProject();
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (project.isDisposed()) {
                                return;
                            }
                            final PostfixTemplatesConfigurable configurable = new PostfixTemplatesConfigurable();
                            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, new Runnable(){

                                @Override
                                public void run() {
                                    PostfixTemplatesCheckboxTree templatesTree = configurable.getTemplatesTree();
                                    if (templatesTree != null) {
                                        templatesTree.selectTemplate(template, PostfixTemplatesUtils.getLangForProvider(templateLookupElement.getProvider()));
                                    }
                                }
                            });
                        }
                    });
                    return LookupElementAction.Result.HIDE_LOOKUP;
                }
            });
            final PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
            if (settings != null && settings.isTemplateEnabled(template, templateLookupElement.getProvider())) {
                consumer.consume((Object)new LookupElementAction(AllIcons.Actions.Delete, String.format("Disable '%s' template", template.getKey())){

                    @Override
                    public LookupElementAction.Result performLookupAction() {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                settings.disableTemplate(template, templateLookupElement.getProvider());
                            }
                        });
                        return LookupElementAction.Result.HIDE_LOOKUP;
                    }
                });
            }
        }
    }
}

