/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18StreamApi;

import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.java18StreamApi.StreamApiConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PseudoLambdaReplaceTemplate {
    private static final Logger LOG = Logger.getInstance(PseudoLambdaReplaceTemplate.class);
    static final PseudoLambdaReplaceTemplate MAP = new PseudoLambdaReplaceTemplate("map", LambdaRole.FUNCTION, false);
    static final PseudoLambdaReplaceTemplate FILTER = new PseudoLambdaReplaceTemplate("filter", LambdaRole.PREDICATE, false);
    static final PseudoLambdaReplaceTemplate FIND = new PseudoLambdaReplaceTemplate("#findMatched", LambdaRole.PREDICATE, true);
    static final PseudoLambdaReplaceTemplate ALL_MATCH = new PseudoLambdaReplaceTemplate("allMatch", LambdaRole.PREDICATE, false);
    static final PseudoLambdaReplaceTemplate ANY_MATCH = new PseudoLambdaReplaceTemplate("anyMatch", LambdaRole.PREDICATE, false);
    private final String myStreamApiMethodName;
    private final LambdaRole myLambdaRole;
    private final boolean myAcceptDefaultValue;

    public PseudoLambdaReplaceTemplate(String method, LambdaRole type, boolean acceptDefaultValue) {
        this.myStreamApiMethodName = method;
        this.myLambdaRole = type;
        this.myAcceptDefaultValue = acceptDefaultValue;
    }

    public static List<PseudoLambdaReplaceTemplate> getAllTemplates() {
        return ContainerUtil.newArrayList((Object[])new PseudoLambdaReplaceTemplate[]{MAP, FILTER, FIND, ALL_MATCH, ANY_MATCH});
    }

    public ValidationInfo validate(PsiMethod method) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiType[] parameterTypes = (PsiType[])ContainerUtil.map2Array(Arrays.asList(parameters), (Object[])new PsiType[parameters.length], (Function)new Function<PsiParameter, PsiType>(){

            public PsiType fun(PsiParameter parameter) {
                return parameter.getType();
            }
        });
        PsiType returnType = method.getReturnType();
        if ("#findMatched".equals(this.myStreamApiMethodName)) {
            if (!PsiType.BOOLEAN.equals((Object)returnType)) {
                return null;
            }
        } else {
            PsiClass stream = JavaPsiFacade.getInstance((Project)method.getProject()).findClass("java.util.stream.Stream", method.getResolveScope());
            if (stream == null) {
                return null;
            }
            PsiMethod[] methods = stream.findMethodsByName(this.myStreamApiMethodName, false);
            LOG.assertTrue(methods.length != 0);
            PsiMethod representative = methods[0];
            PsiType expectedReturnType = representative.getReturnType();
            if (expectedReturnType instanceof PsiClassType) {
                PsiClass resolvedClass = ((PsiClassType)expectedReturnType).resolve();
                if (resolvedClass == null) {
                    return null;
                }
                if ("java.util.stream.Stream".equals(resolvedClass.getQualifiedName()) && !(returnType instanceof PsiArrayType)) {
                    if (!(returnType instanceof PsiClassType)) {
                        return null;
                    }
                    PsiClass methodReturnType = ((PsiClassType)returnType).resolve();
                    if (methodReturnType == null || !InheritanceUtil.isInheritor((PsiClass)methodReturnType, (String)"java.lang.Iterable") && !InheritanceUtil.isInheritor((PsiClass)methodReturnType, (String)"java.lang.Iterable")) {
                        return null;
                    }
                }
            } else if (PsiType.BOOLEAN.equals((Object)expectedReturnType) && !PsiType.BOOLEAN.equals((Object)returnType)) {
                return null;
            }
        }
        return this.validate(parameterTypes, returnType, null, (PsiElement)method);
    }

    @Nullable
    public ValidationInfo validate(PsiMethodCallExpression expression) {
        PsiType[] argumentTypes = expression.getArgumentList().getExpressionTypes();
        PsiType methodReturnType = expression.getType();
        if (methodReturnType == null) {
            return null;
        }
        JavaResolveResult result2 = expression.getMethodExpression().advancedResolve(false);
        PsiElement element = result2.getElement();
        if (!(element instanceof PsiMethod)) {
            return null;
        }
        PsiParameter[] expectedParameters = ((PsiMethod)element).getParameterList().getParameters();
        if (argumentTypes.length != expectedParameters.length) {
            return null;
        }
        PsiSubstitutor methodSubstitutor = result2.getSubstitutor();
        return this.validate(argumentTypes, methodReturnType, methodSubstitutor, (PsiElement)expression);
    }

    public String getStreamApiMethodName() {
        return this.myStreamApiMethodName;
    }

    public LambdaRole getLambdaRole() {
        return this.myLambdaRole;
    }

    public boolean isAcceptDefaultValue() {
        return this.myAcceptDefaultValue;
    }

    private ValidationInfo validate(PsiType[] arguments, PsiType methodReturnType, @Nullable PsiSubstitutor methodSubstitutor, PsiElement context) {
        int lambdaPosition = -1;
        int defaultValuePosition = -1;
        int iterablePosition = -1;
        if (!this.myAcceptDefaultValue ? arguments.length != 2 : arguments.length != 2 && arguments.length != 3) {
            return null;
        }
        for (int i = 0; i < arguments.length; ++i) {
            PsiType type = arguments[i];
            if (type == null) {
                return null;
            }
            if (this.isFunction(type, methodReturnType, methodSubstitutor, context)) {
                if (lambdaPosition == -1) {
                    lambdaPosition = i;
                    continue;
                }
                return null;
            }
            if (PseudoLambdaReplaceTemplate.isIterableOrArray(type)) {
                if (iterablePosition == -1) {
                    iterablePosition = i;
                    continue;
                }
                return null;
            }
            if (!this.myAcceptDefaultValue || !methodReturnType.isAssignableFrom(type)) continue;
            if (defaultValuePosition == -1) {
                defaultValuePosition = i;
                continue;
            }
            return null;
        }
        if (lambdaPosition == -1 || iterablePosition == -1) {
            return null;
        }
        if (this.myAcceptDefaultValue && defaultValuePosition == -1 && arguments.length == 3) {
            return null;
        }
        return new ValidationInfo(lambdaPosition, iterablePosition, defaultValuePosition);
    }

    private boolean isFunction(PsiType type, PsiType baseMethodReturnType, PsiSubstitutor methodSubstitutor, PsiElement context) {
        if (type instanceof PsiMethodReferenceType) {
            PsiMethodReferenceExpression expression = ((PsiMethodReferenceType)type).getExpression();
            PsiMethod resolvedMethod = (PsiMethod)expression.resolve();
            if (resolvedMethod == null) {
                return false;
            }
            PsiParameter[] parameters = resolvedMethod.getParameterList().getParameters();
            if (parameters.length != 1 && this.myLambdaRole == LambdaRole.FUNCTION || parameters.length != 0 && this.myLambdaRole == LambdaRole.PREDICATE) {
                return false;
            }
            PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression);
            return this.isSuitableLambdaRole(returnType, baseMethodReturnType, methodSubstitutor, context);
        }
        if (type instanceof PsiLambdaExpressionType) {
            PsiLambdaExpression expression = ((PsiLambdaExpressionType)type).getExpression();
            PsiType psiType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)expression.getFunctionalInterfaceType());
            return this.isSuitableLambdaRole(psiType, baseMethodReturnType, methodSubstitutor, context);
        }
        if (this.isSuitableFunctionalType(type, baseMethodReturnType, methodSubstitutor, context)) {
            return true;
        }
        return PseudoLambdaReplaceTemplate.isJavaLangClassType(type) && this.myLambdaRole == LambdaRole.PREDICATE;
    }

    private boolean isSuitableLambdaRole(PsiType lambdaReturnType, PsiType baseMethodReturnType, PsiSubstitutor methodSubstitutor, PsiElement context) {
        if (lambdaReturnType == null) {
            return false;
        }
        if (this.myLambdaRole == LambdaRole.PREDICATE) {
            PsiClassType boxedBoolean = PsiType.BOOLEAN.getBoxedType(context);
            if (!(PsiType.BOOLEAN.equals((Object)lambdaReturnType) || boxedBoolean != null && boxedBoolean.equals((Object)lambdaReturnType))) {
                return false;
            }
        } else {
            LOG.assertTrue(this.myLambdaRole == LambdaRole.FUNCTION);
            if (methodSubstitutor != null) {
                lambdaReturnType = methodSubstitutor.substitute(lambdaReturnType);
            }
            if (baseMethodReturnType instanceof PsiClassType) {
                PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)baseMethodReturnType).resolveGenerics();
                Map substitutionMap = resolveResult.getSubstitutor().getSubstitutionMap();
                if (substitutionMap.size() != 1) {
                    return false;
                }
                PsiType iterableParametrizedType = (PsiType)ContainerUtil.getFirstItem(substitutionMap.values());
                if (!lambdaReturnType.equals(iterableParametrizedType)) {
                    return false;
                }
            } else if (baseMethodReturnType instanceof PsiArrayType && !lambdaReturnType.equals(((PsiArrayType)baseMethodReturnType).getComponentType())) {
                return false;
            }
        }
        return true;
    }

    private static boolean isJavaLangClassType(PsiType type) {
        PsiClass resolvedClass;
        return type instanceof PsiClassType && (resolvedClass = ((PsiClassType)type).resolve()) != null && "java.lang.Class".equals(resolvedClass.getQualifiedName());
    }

    private boolean isSuitableFunctionalType(PsiType type, PsiType baseMethodReturnType, @Nullable PsiSubstitutor methodSubstitutor, PsiElement context) {
        if (type instanceof PsiClassType) {
            PsiClass resolvedClass = ((PsiClassType)type).resolve();
            if (resolvedClass != null) {
                if (resolvedClass instanceof PsiAnonymousClass) {
                    PsiClass baseClass = ((PsiAnonymousClass)resolvedClass).getBaseClassType().resolve();
                    if (baseClass == null) {
                        return false;
                    }
                    if (!LambdaUtil.isFunctionalClass((PsiClass)baseClass)) {
                        return false;
                    }
                    PsiMethod superMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)baseClass);
                    if (superMethod == null) {
                        return false;
                    }
                    PsiMethod[] methods = resolvedClass.findMethodsByName(superMethod.getName(), false);
                    PsiMethod method = null;
                    for (PsiMethod m : methods) {
                        if (!PsiSuperMethodUtil.isSuperMethod((PsiMethod)m, (PsiMethod)superMethod)) continue;
                        method = m;
                    }
                    if (method == null) {
                        return false;
                    }
                    PsiType psiType = methodSubstitutor == null ? method.getReturnType() : methodSubstitutor.substitute(method.getReturnType());
                    return this.isSuitableLambdaRole(psiType, baseMethodReturnType, methodSubstitutor, context);
                }
                if (!LambdaUtil.isFunctionalClass((PsiClass)resolvedClass)) {
                    return false;
                }
                return this.isSuitableLambdaRole(LambdaUtil.getFunctionalInterfaceReturnType((PsiType)type), baseMethodReturnType, methodSubstitutor, context);
            }
            return false;
        }
        return false;
    }

    @NotNull
    public PsiExpression convertToStream(@NotNull PsiMethodCallExpression expression, @Nullable PsiMethod method, boolean force) {
        String lambdaExpressionText;
        String elementText;
        ValidationInfo validationInfo;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/java18StreamApi/PseudoLambdaReplaceTemplate", "convertToStream"));
        }
        if (method == null && (method = expression.resolveMethod()) == null) {
            PsiMethodCallExpression psiMethodCallExpression = expression;
            if (psiMethodCallExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/PseudoLambdaReplaceTemplate", "convertToStream"));
            }
            return psiMethodCallExpression;
        }
        ValidationInfo validationInfo2 = validationInfo = force ? this.validate(method) : this.validate(expression);
        if (validationInfo == null) {
            PsiMethodCallExpression psiMethodCallExpression = expression;
            if (psiMethodCallExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/PseudoLambdaReplaceTemplate", "convertToStream"));
            }
            return psiMethodCallExpression;
        }
        Project project = expression.getProject();
        int lambdaIndex = validationInfo.getLambdaPosition();
        PsiExpression[] expressions = expression.getArgumentList().getExpressions();
        PsiExpression iterableExpression = expressions[validationInfo.getIterablePosition()];
        String pipelineHead = PseudoLambdaReplaceTemplate.createPipelineHeadText(iterableExpression, force);
        if (pipelineHead == null) {
            PsiMethodCallExpression psiMethodCallExpression = expression;
            if (psiMethodCallExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/PseudoLambdaReplaceTemplate", "convertToStream"));
            }
            return psiMethodCallExpression;
        }
        PsiExpression lambdaExpression = expressions[lambdaIndex];
        if (!force) {
            lambdaExpression = PseudoLambdaReplaceTemplate.convertClassTypeExpression(lambdaExpression);
            lambdaExpression = PseudoLambdaReplaceTemplate.convertToJavaLambda(lambdaExpression);
        }
        if (lambdaExpression == null) {
            PsiMethodCallExpression psiMethodCallExpression = expression;
            if (psiMethodCallExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/PseudoLambdaReplaceTemplate", "convertToStream"));
            }
            return psiMethodCallExpression;
        }
        if (!"#findMatched".equals(this.myStreamApiMethodName)) {
            elementText = this.myStreamApiMethodName;
            lambdaExpressionText = lambdaExpression.getText();
        } else {
            elementText = validationInfo.getDefaultValuePosition() != -1 ? String.format("filter(%s).findFirst().orElseGet(() -> %s)", lambdaExpression.getText(), expressions[validationInfo.getDefaultValuePosition()].getText()) : String.format("filter(%s).findFirst().get()", lambdaExpression.getText());
            lambdaExpressionText = null;
        }
        String pipelineTail = ((Set)StreamApiConstants.STREAM_STREAM_API_METHODS.getValue()).contains(this.myStreamApiMethodName) ? PseudoLambdaReplaceTemplate.findSuitableTailMethodForCollection(method) : null;
        PsiElement replaced = expression.replace((PsiElement)PseudoLambdaReplaceTemplate.createPipelineExpression(pipelineHead, elementText, lambdaExpressionText, pipelineTail, project));
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replaced.getParent());
        PsiExpression psiExpression = (PsiExpression)replaced;
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/PseudoLambdaReplaceTemplate", "convertToStream"));
        }
        return psiExpression;
    }

    private static PsiExpression createPipelineExpression(String pipelineHead, String elementText, String lambdaExpression, String pipelineTail, Project project) {
        StringBuilder sb = new StringBuilder();
        sb.append(pipelineHead).append(".").append(elementText);
        if (lambdaExpression != null) {
            sb.append("(").append(lambdaExpression).append(")");
        }
        if (pipelineTail != null) {
            sb.append(".").append(pipelineTail);
        }
        return JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(sb.toString(), null);
    }

    @Nullable
    private static String findSuitableTailMethodForCollection(PsiMethod lambdaHandler) {
        PsiType type = lambdaHandler.getReturnType();
        if (type instanceof PsiArrayType) {
            PsiType arrayComponentType = ((PsiArrayType)type).getComponentType();
            return "toArray(" + arrayComponentType.getCanonicalText() + "[]::new)";
        }
        if (type instanceof PsiClassType) {
            PsiClass resolvedClass = ((PsiClassType)type).resolve();
            if (resolvedClass == null) {
                return null;
            }
            String qName = resolvedClass.getQualifiedName();
            if (qName == null) {
                return null;
            }
            if (qName.equals("java.util.List") || qName.equals("java.util.Collection") || qName.equals("java.lang.Iterable")) {
                return "collect(java.util.stream.Collectors.toList())";
            }
            if (qName.equals("java.util.Set")) {
                return "collect(java.util.stream.Collectors.toSet())";
            }
            if (qName.equals("java.util.Iterator")) {
                return "iterator()";
            }
        }
        return null;
    }

    private static PsiExpression convertToJavaLambda(PsiExpression expression) {
        if (expression instanceof PsiMethodReferenceExpression) {
            return expression;
        }
        if (expression instanceof PsiLambdaExpression) {
            return expression;
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)expression).resolveMethod();
            if (method == null) {
                return null;
            }
            PsiType type = method.getReturnType();
            if (!(type instanceof PsiClassType)) {
                return null;
            }
            PsiClassType.ClassResolveResult result2 = ((PsiClassType)type).resolveGenerics();
            PsiClass lambdaClass = result2.getElement();
            if (lambdaClass == null) {
                return null;
            }
            PsiMethod functionalInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)lambdaClass);
            LOG.assertTrue(functionalInterfaceMethod != null);
            String methodName = functionalInterfaceMethod.getName();
            return JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(expression.getText() + "::" + methodName, null);
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiType expressionType = expression.getType();
            PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)expressionType);
            LOG.assertTrue(method != null);
            return JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(expression.getText() + "::" + method.getName(), null);
        }
        PsiType psiType = expression.getType();
        if (psiType != null) {
            return AnonymousCanBeLambdaInspection.replaceAnonymousWithLambda((PsiElement)expression, psiType);
        }
        return null;
    }

    @NotNull
    private static PsiExpression convertClassTypeExpression(PsiExpression expression) {
        PsiClass resolvedClass;
        PsiType type = expression.getType();
        if (type instanceof PsiClassType && (resolvedClass = ((PsiClassType)type).resolve()) != null && "java.lang.Class".equals(resolvedClass.getQualifiedName())) {
            PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText("(" + expression.getText() + ")::isInstance", null);
            if (psiExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/PseudoLambdaReplaceTemplate", "convertClassTypeExpression"));
            }
            return psiExpression;
        }
        PsiExpression psiExpression = expression;
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/PseudoLambdaReplaceTemplate", "convertClassTypeExpression"));
        }
        return psiExpression;
    }

    public static PsiExpression replaceTypeParameters(PsiExpression collectionExpression) {
        if (collectionExpression instanceof PsiNewExpression) {
            PsiDiamondType.DiamondInferenceResult diamondResolveResult = PsiDiamondTypeImpl.resolveInferredTypesNoCheck((PsiNewExpression)collectionExpression, (PsiElement)collectionExpression);
            if (!diamondResolveResult.getInferredTypes().isEmpty()) {
                collectionExpression = PsiDiamondTypeUtil.expandTopLevelDiamondsInside(collectionExpression);
            }
        } else if (collectionExpression instanceof PsiMethodCallExpression) {
            PsiType currentType = collectionExpression.getType();
            if (currentType == null) {
                return null;
            }
            PsiExpression copiedExpression = (PsiExpression)collectionExpression.copy();
            PsiType newType = copiedExpression.getType();
            if (!currentType.equals(newType)) {
                PsiExpression newExpression = AddTypeArgumentsFix.addTypeArguments(copiedExpression, currentType);
                return newExpression == null ? collectionExpression : newExpression;
            }
        }
        return collectionExpression;
    }

    private static String createPipelineHeadText(PsiExpression collectionExpression, boolean force) {
        if ((collectionExpression = PseudoLambdaReplaceTemplate.replaceTypeParameters(collectionExpression)) == null) {
            return null;
        }
        PsiType type = collectionExpression.getType();
        if (type instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type).resolve();
            LOG.assertTrue(resolved != null && resolved.getQualifiedName() != null, (Object)type);
            if (InheritanceUtil.isInheritor((PsiClass)resolved, (String)"java.util.Collection")) {
                return collectionExpression.getText() + ".stream()";
            }
            return "java.util.stream.StreamSupport.stream(" + collectionExpression.getText() + ".spliterator(), false)";
        }
        if (type instanceof PsiArrayType) {
            return "java.util.Arrays.stream(" + collectionExpression.getText() + ")";
        }
        if (force) {
            return collectionExpression.getText() + ".stream()";
        }
        throw new AssertionError((Object)("type: " + type + " is unexpected for expression: " + collectionExpression.getText()));
    }

    private static boolean isIterableOrArray(PsiType type) {
        if (type instanceof PsiClassType) {
            return InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.Iterable");
        }
        return type instanceof PsiArrayType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PseudoLambdaReplaceTemplate template = (PseudoLambdaReplaceTemplate)o;
        if (this.myAcceptDefaultValue != template.myAcceptDefaultValue) {
            return false;
        }
        if (!this.myStreamApiMethodName.equals(template.myStreamApiMethodName)) {
            return false;
        }
        return this.myLambdaRole == template.myLambdaRole;
    }

    public int hashCode() {
        int result2 = this.myStreamApiMethodName.hashCode();
        result2 = 31 * result2 + this.myLambdaRole.hashCode();
        result2 = 31 * result2 + (this.myAcceptDefaultValue ? 1 : 0);
        return result2;
    }

    public String toString() {
        return "PseudoLambdaReplaceTemplate{myStreamApiMethodName='" + this.myStreamApiMethodName + '\'' + '}';
    }

    public static class ValidationInfo {
        private final int myLambdaPosition;
        private final int myIterablePosition;
        private final int myDefaultValuePosition;

        public ValidationInfo(int lambdaPosition, int iterablePosition, int defaultValuePosition) {
            this.myLambdaPosition = lambdaPosition;
            this.myIterablePosition = iterablePosition;
            this.myDefaultValuePosition = defaultValuePosition;
        }

        public int getLambdaPosition() {
            return this.myLambdaPosition;
        }

        public int getIterablePosition() {
            return this.myIterablePosition;
        }

        public int getDefaultValuePosition() {
            return this.myDefaultValuePosition;
        }
    }

    public static enum LambdaRole {
        PREDICATE,
        FUNCTION;

    }
}

