/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.requests;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReturnValueWatcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.requests.MethodReturnValueWatcher");
    @Nullable
    private Method myLastExecutedMethod;
    @Nullable
    private Value myLastMethodReturnValue;
    private ThreadReference myThread;
    @Nullable
    private MethodEntryRequest myEntryRequest;
    @Nullable
    private Method myEntryMethod;
    @Nullable
    private MethodExitRequest myExitRequest;
    private java.lang.reflect.Method myReturnValueMethod;
    private volatile boolean myEnabled;
    private boolean myFeatureEnabled;
    private final EventRequestManager myRequestManager;
    private static final String WATCHER_REQUEST_KEY = "WATCHER_REQUEST_KEY";

    public MethodReturnValueWatcher(EventRequestManager requestManager) {
        this.myRequestManager = requestManager;
        this.myFeatureEnabled = DebuggerSettings.getInstance().WATCH_RETURN_VALUES;
    }

    private void processMethodExitEvent(MethodExitEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("<- " + event.method());
        }
        try {
            if (Registry.is((String)"debugger.watch.return.speedup") && Comparing.equal((Object)this.myEntryMethod, (Object)event.method())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Now watching all");
                }
                this.enableEntryWatching(true);
                this.createExitRequest().enable();
            }
            Method method = event.method();
            try {
                if (this.myReturnValueMethod == null) {
                    this.myReturnValueMethod = MethodExitEvent.class.getDeclaredMethod("returnValue", ArrayUtil.EMPTY_CLASS_ARRAY);
                }
                Value retVal = (Value)this.myReturnValueMethod.invoke((Object)event, new Object[0]);
                if (method == null || !"void".equals(method.returnTypeName())) {
                    this.myLastExecutedMethod = method;
                    this.myLastMethodReturnValue = retVal;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        catch (UnsupportedOperationException ex) {
            LOG.error((Throwable)ex);
        }
    }

    private void processMethodEntryEvent(MethodEntryEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("-> " + event.method());
        }
        try {
            if (this.myEntryRequest != null && this.myEntryRequest.isEnabled()) {
                this.myExitRequest = this.createExitRequest();
                this.myExitRequest.addClassFilter(event.method().declaringType());
                this.myEntryMethod = event.method();
                this.myExitRequest.enable();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Now watching only " + event.method());
                }
                this.enableEntryWatching(false);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void enableEntryWatching(boolean enable) {
        if (this.myEntryRequest != null) {
            this.myEntryRequest.setEnabled(enable);
        }
    }

    @Nullable
    public Method getLastExecutedMethod() {
        return this.myLastExecutedMethod;
    }

    @Nullable
    public Value getLastMethodReturnValue() {
        return this.myLastMethodReturnValue;
    }

    public boolean isFeatureEnabled() {
        return this.myFeatureEnabled;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setFeatureEnabled(boolean featureEnabled) {
        this.myFeatureEnabled = featureEnabled;
        this.myLastExecutedMethod = null;
        this.myLastMethodReturnValue = null;
    }

    public void enable(ThreadReference thread) {
        this.setTrackingEnabled(true, thread);
    }

    public void disable() {
        this.setTrackingEnabled(false, null);
    }

    private void setTrackingEnabled(boolean trackingEnabled, ThreadReference thread) {
        this.myEnabled = trackingEnabled;
        this.updateRequestState(trackingEnabled && this.myFeatureEnabled, thread);
    }

    private void updateRequestState(boolean enabled, @Nullable ThreadReference thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            if (this.myEntryRequest != null) {
                this.myRequestManager.deleteEventRequest(this.myEntryRequest);
                this.myEntryRequest = null;
            }
            if (this.myExitRequest != null) {
                this.myRequestManager.deleteEventRequest(this.myExitRequest);
                this.myExitRequest = null;
            }
            if (enabled) {
                this.myLastExecutedMethod = null;
                this.myLastMethodReturnValue = null;
                this.myThread = thread;
                if (Registry.is((String)"debugger.watch.return.speedup")) {
                    this.createEntryRequest().enable();
                }
                this.createExitRequest().enable();
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    private MethodEntryRequest createEntryRequest() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myEntryRequest = this.prepareRequest(this.myRequestManager.createMethodEntryRequest());
        return this.myEntryRequest;
    }

    @NotNull
    private MethodExitRequest createExitRequest() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myExitRequest != null) {
            this.myRequestManager.deleteEventRequest(this.myExitRequest);
        }
        MethodExitRequest methodExitRequest = this.myExitRequest = this.prepareRequest(this.myRequestManager.createMethodExitRequest());
        if (methodExitRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/requests/MethodReturnValueWatcher", "createExitRequest"));
        }
        return methodExitRequest;
    }

    @NotNull
    private <T extends EventRequest> T prepareRequest(T request) {
        request.setSuspendPolicy(Registry.is((String)"debugger.watch.return.speedup") ? 1 : 0);
        if (this.myThread != null) {
            if (request instanceof MethodEntryRequest) {
                ((MethodEntryRequest)request).addThreadFilter(this.myThread);
            } else if (request instanceof MethodExitRequest) {
                ((MethodExitRequest)request).addThreadFilter(this.myThread);
            }
        }
        request.putProperty(WATCHER_REQUEST_KEY, true);
        T t = request;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/requests/MethodReturnValueWatcher", "prepareRequest"));
        }
        return t;
    }

    public boolean processEvent(Event event) {
        EventRequest request = event.request();
        if (request == null || request.getProperty(WATCHER_REQUEST_KEY) == null) {
            return false;
        }
        if (event instanceof MethodEntryEvent) {
            this.processMethodEntryEvent((MethodEntryEvent)event);
        } else if (event instanceof MethodExitEvent) {
            this.processMethodExitEvent((MethodExitEvent)event);
        }
        return true;
    }
}

