/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.ToStringBasedRenderer;
import com.intellij.util.ui.ColorIcon;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.awt.Color;
import javax.swing.Icon;

class ColorObjectRenderer
extends ToStringBasedRenderer {
    public ColorObjectRenderer(NodeRendererSettings rendererSettings) {
        super(rendererSettings, "Color", null, null);
        this.setClassName("java.awt.Color");
        this.setEnabled(true);
    }

    @Override
    public Icon calcValueIcon(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
        Value value = descriptor.getValue();
        if (value instanceof ObjectReference) {
            try {
                Value rgbValue;
                ObjectReference objRef = (ObjectReference)value;
                ReferenceType refType = objRef.referenceType();
                Field valueField = refType.fieldByName("value");
                if (valueField != null && (rgbValue = objRef.getValue(valueField)) instanceof IntegerValue) {
                    Color color = new Color(((IntegerValue)rgbValue).value(), true);
                    return new ColorIcon(16, 12, color, true);
                }
            }
            catch (Exception e) {
                throw new EvaluateException(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

