/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.ImageObjectRenderer;
import com.intellij.debugger.ui.tree.render.ToStringBasedRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

class IconObjectRenderer
extends ToStringBasedRenderer
implements FullValueEvaluatorProvider {
    public IconObjectRenderer(NodeRendererSettings rendererSettings) {
        super(rendererSettings, "Icon", null, null);
        this.setClassName("javax.swing.Icon");
        this.setEnabled(true);
    }

    @Override
    public Icon calcValueIcon(final ValueDescriptor descriptor, final EvaluationContext evaluationContext, final DescriptorLabelListener listener) throws EvaluateException {
        EvaluationContextImpl evalContext = (EvaluationContextImpl)evaluationContext;
        DebugProcessImpl debugProcess = evalContext.getDebugProcess();
        if (!Registry.is((String)"debugger.auto.fetch.icons") || DebuggerUtilsImpl.isRemote(debugProcess)) {
            return null;
        }
        debugProcess.getManagerThread().schedule(new SuspendContextCommandImpl(evalContext.getSuspendContext()){

            @Override
            public void contextAction() throws Exception {
                String getterName = AllIcons.Debugger.Value.getIconHeight() <= 16 ? "iconToBytesPreviewNormal" : "iconToBytesPreviewRetina";
                descriptor.setValueIcon(ImageObjectRenderer.getIcon(evaluationContext, descriptor.getValue(), getterName));
                listener.labelChanged();
            }
        });
        return null;
    }

    @Override
    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(EvaluationContextImpl evaluationContext, final ValueDescriptorImpl valueDescriptor) {
        return new ImageObjectRenderer.IconPopupEvaluator(DebuggerBundle.message((String)"message.node.show.icon", (Object[])new Object[0]), evaluationContext){

            @Override
            protected Icon getData() {
                return ImageObjectRenderer.getIcon(this.getEvaluationContext(), valueDescriptor.getValue(), "iconToBytes");
            }
        };
    }
}

