/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.actions.ProxyUndoRedoAction;
import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.merge.TextMergeChange;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.simple.ThreesideTextDiffViewerEx;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.KeyboardModifierListener;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMergeTool
implements MergeTool {
    public static final TextMergeTool INSTANCE = new TextMergeTool();
    public static final Logger LOG = Logger.getInstance(TextMergeTool.class);

    @NotNull
    public MergeTool.MergeViewer createComponent(@NotNull MergeContext context, @NotNull MergeRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/TextMergeTool", "createComponent"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/TextMergeTool", "createComponent"));
        }
        TextMergeViewer textMergeViewer = new TextMergeViewer(context, (TextMergeRequest)request);
        if (textMergeViewer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool", "createComponent"));
        }
        return textMergeViewer;
    }

    public boolean canShow(@NotNull MergeContext context, @NotNull MergeRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/TextMergeTool", "canShow"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/TextMergeTool", "canShow"));
        }
        return request instanceof TextMergeRequest;
    }

    public static class TextMergeViewer
    implements MergeTool.MergeViewer {
        @NotNull
        private final MergeContext myMergeContext;
        @NotNull
        private final TextMergeRequest myMergeRequest;
        @NotNull
        private final DiffContext myDiffContext;
        @NotNull
        private final ContentDiffRequest myDiffRequest;
        @NotNull
        private final MyThreesideViewer myViewer;

        public TextMergeViewer(@NotNull MergeContext context, @NotNull TextMergeRequest request) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer", "<init>"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer", "<init>"));
            }
            this.myMergeContext = context;
            this.myMergeRequest = request;
            this.myDiffContext = new MergeUtil.ProxyDiffContext(this.myMergeContext);
            this.myDiffRequest = new SimpleDiffRequest(this.myMergeRequest.getTitle(), TextMergeViewer.getDiffContents(this.myMergeRequest), TextMergeViewer.getDiffContentTitles(this.myMergeRequest));
            this.myDiffRequest.putUserData(DiffUserDataKeys.FORCE_READ_ONLY_CONTENTS, (Object)new boolean[]{true, false, true});
            this.myViewer = new MyThreesideViewer(this.myDiffContext, this.myDiffRequest);
        }

        @NotNull
        private static List<DiffContent> getDiffContents(@NotNull TextMergeRequest mergeRequest) {
            if (mergeRequest == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeRequest", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer", "getDiffContents"));
            }
            List contents = mergeRequest.getContents();
            DocumentContent left = (DocumentContent)ThreeSide.LEFT.select(contents);
            DocumentContent right = (DocumentContent)ThreeSide.RIGHT.select(contents);
            DocumentContent output = mergeRequest.getOutputContent();
            List list = ContainerUtil.list((Object[])new DiffContent[]{left, output, right});
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer", "getDiffContents"));
            }
            return list;
        }

        @NotNull
        private static List<String> getDiffContentTitles(@NotNull TextMergeRequest mergeRequest) {
            if (mergeRequest == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeRequest", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer", "getDiffContentTitles"));
            }
            List<String> titles = MergeUtil.notNullizeContentTitles(mergeRequest.getContentTitles());
            titles.set(ThreeSide.BASE.getIndex(), "Result");
            List<String> list = titles;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer", "getDiffContentTitles"));
            }
            return list;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myViewer.getComponent();
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer", "getComponent"));
            }
            return jComponent;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myViewer.getPreferredFocusedComponent();
        }

        @NotNull
        public MergeTool.ToolbarComponents init() {
            MergeTool.ToolbarComponents components = new MergeTool.ToolbarComponents();
            FrameDiffTool.ToolbarComponents init = this.myViewer.init();
            components.statusPanel = init.statusPanel;
            components.toolbarActions = init.toolbarActions;
            components.closeHandler = new BooleanGetter(){

                public boolean get() {
                    return MergeUtil.showExitWithoutApplyingChangesDialog(TextMergeViewer.this, (MergeRequest)TextMergeViewer.this.myMergeRequest, TextMergeViewer.this.myMergeContext);
                }
            };
            MergeTool.ToolbarComponents toolbarComponents = components;
            if (toolbarComponents == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer", "init"));
            }
            return toolbarComponents;
        }

        @Nullable
        public Action getResolveAction(@NotNull MergeResult result2) {
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer", "getResolveAction"));
            }
            return this.myViewer.getResolveAction(result2);
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myViewer);
        }

        @NotNull
        public MyThreesideViewer getViewer() {
            MyThreesideViewer myThreesideViewer = this.myViewer;
            if (myThreesideViewer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer", "getViewer"));
            }
            return myThreesideViewer;
        }

        private static class InnerChunkData {
            @NotNull
            public final CharSequence[] text;

            public InnerChunkData(@NotNull TextMergeChange change, @NotNull Document[] documents) {
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$InnerChunkData", "<init>"));
                }
                if (documents == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documents", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$InnerChunkData", "<init>"));
                }
                this.text = new CharSequence[3];
                for (ThreeSide side : ThreeSide.values()) {
                    if (!change.isChange(side) || change.isResolved(side)) continue;
                    this.text[side.getIndex()] = InnerChunkData.getChunkContent(change, documents, side);
                }
            }

            @Nullable
            private static CharSequence getChunkContent(@NotNull TextMergeChange change, @NotNull Document[] documents, @NotNull ThreeSide side) {
                int endLine;
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$InnerChunkData", "getChunkContent"));
                }
                if (documents == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documents", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$InnerChunkData", "getChunkContent"));
                }
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$InnerChunkData", "getChunkContent"));
                }
                int startLine = change.getStartLine(side);
                return startLine != (endLine = change.getEndLine(side)) ? DiffUtil.getLinesContent((Document)side.select((Object[])documents), startLine, endLine) : null;
            }
        }

        public class MyThreesideViewer
        extends ThreesideTextDiffViewerEx {
            @NotNull
            private final ModifierProvider myModifierProvider;
            @Nullable
            private final UndoManager myUndoManager;
            @NotNull
            private final MyInnerDiffWorker myInnerDiffWorker;
            @NotNull
            private final List<TextMergeChange> myAllMergeChanges;
            private boolean myInitialRediffStarted;
            private boolean myInitialRediffFinished;
            private boolean myContentModified;
            @Nullable
            private MergeCommandAction myCurrentMergeCommand;
            private int myBulkChangeUpdateDepth;
            private final Set<TextMergeChange> myChangesToUpdate;

            public MyThreesideViewer(@NotNull DiffContext context, ContentDiffRequest request) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "<init>"));
                }
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "<init>"));
                }
                super(context, request);
                this.myAllMergeChanges = new ArrayList<TextMergeChange>();
                this.myChangesToUpdate = new HashSet();
                this.myModifierProvider = new ModifierProvider();
                this.myUndoManager = this.getProject() != null ? UndoManager.getInstance((Project)this.getProject()) : UndoManager.getGlobalInstance();
                this.myInnerDiffWorker = new MyInnerDiffWorker();
                DiffUtil.registerAction(new ApplySelectedChangesAction(Side.LEFT, true), this.myPanel);
                DiffUtil.registerAction(new ApplySelectedChangesAction(Side.RIGHT, true), this.myPanel);
                DiffUtil.registerAction(new IgnoreSelectedChangesSideAction(Side.LEFT, true), this.myPanel);
                DiffUtil.registerAction(new IgnoreSelectedChangesSideAction(Side.RIGHT, true), this.myPanel);
                ProxyUndoRedoAction.register(this.getProject(), this.getEditor(ThreeSide.BASE), this.myContentPanel);
            }

            @Override
            protected void onInit() {
                super.onInit();
                this.myModifierProvider.init();
            }

            @Override
            protected void onDispose() {
                LOG.assertTrue(this.myBulkChangeUpdateDepth == 0);
                super.onDispose();
            }

            @Override
            @NotNull
            protected List<AnAction> createToolbarActions() {
                ArrayList<AnAction> group = new ArrayList<AnAction>();
                group.add((AnAction)new MyHighlightPolicySettingAction());
                group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
                group.add((AnAction)this.myEditorSettingsAction);
                group.add((AnAction)Separator.getInstance());
                group.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_BASE));
                group.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.BASE_RIGHT));
                group.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_RIGHT));
                group.add((AnAction)Separator.getInstance());
                group.add((AnAction)new ApplyNonConflictsAction());
                group.add((AnAction)new ApplySideNonConflictsAction(Side.LEFT));
                group.add((AnAction)new ApplySideNonConflictsAction(Side.RIGHT));
                ArrayList<AnAction> arrayList = group;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "createToolbarActions"));
                }
                return arrayList;
            }

            @Override
            @NotNull
            protected List<AnAction> createEditorPopupActions() {
                ArrayList<AnAction> group = new ArrayList<AnAction>();
                group.add(new ApplySelectedChangesAction(Side.LEFT, false));
                group.add(new ApplySelectedChangesAction(Side.RIGHT, false));
                group.add(new ResolveSelectedChangesAction(Side.LEFT));
                group.add(new ResolveSelectedChangesAction(Side.RIGHT));
                group.add(new IgnoreSelectedChangesSideAction(Side.LEFT, false));
                group.add(new IgnoreSelectedChangesSideAction(Side.RIGHT, false));
                group.add(new IgnoreSelectedChangesAction());
                group.add((AnAction)Separator.getInstance());
                group.addAll(TextDiffViewerUtil.createEditorPopupActions());
                ArrayList<AnAction> arrayList = group;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "createEditorPopupActions"));
                }
                return arrayList;
            }

            @Override
            @Nullable
            protected List<AnAction> createPopupActions() {
                ArrayList<AnAction> group = new ArrayList<AnAction>();
                group.add((AnAction)Separator.getInstance());
                group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
                return group;
            }

            @Nullable
            public Action getResolveAction(final @NotNull MergeResult result2) {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "getResolveAction"));
                }
                String caption = MergeUtil.getResolveActionTitle(result2, (MergeRequest)TextMergeViewer.this.myMergeRequest, TextMergeViewer.this.myMergeContext);
                return new AbstractAction(caption){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if ((result2 == MergeResult.LEFT || result2 == MergeResult.RIGHT) && MyThreesideViewer.this.myContentModified && Messages.showYesNoDialog((Component)MyThreesideViewer.this.myPanel.getRootPane(), (String)DiffBundle.message((String)"merge.dialog.resolve.side.with.discard.message", (Object[])new Object[]{result2 == MergeResult.LEFT ? 0 : 1}), (String)DiffBundle.message((String)"merge.dialog.resolve.side.with.discard.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                            return;
                        }
                        if (result2 == MergeResult.RESOLVED && (MyThreesideViewer.this.getChangesCount() != 0 || MyThreesideViewer.this.getConflictsCount() != 0) && Messages.showYesNoDialog((Component)MyThreesideViewer.this.myPanel.getRootPane(), (String)DiffBundle.message((String)"merge.dialog.apply.partially.resolved.changes.confirmation.message", (Object[])new Object[]{MyThreesideViewer.this.getChangesCount(), MyThreesideViewer.this.getConflictsCount()}), (String)DiffBundle.message((String)"apply.partially.resolved.merge.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                            return;
                        }
                        if (result2 == MergeResult.CANCEL && !MergeUtil.showExitWithoutApplyingChangesDialog(TextMergeViewer.this, (MergeRequest)TextMergeViewer.this.myMergeRequest, TextMergeViewer.this.myMergeContext)) {
                            return;
                        }
                        MyThreesideViewer.this.destroyChangedBlocks();
                        TextMergeViewer.this.myMergeContext.finishMerge(result2);
                    }
                };
            }

            private void setInitialOutputContent() {
                final Document baseDocument = ((DocumentContent)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContents())).getDocument();
                final Document outputDocument = TextMergeViewer.this.myMergeRequest.getOutputContent().getDocument();
                DiffUtil.executeWriteCommand(outputDocument, this.getProject(), "Init merge content", new Runnable(){

                    @Override
                    public void run() {
                        outputDocument.setText(baseDocument.getCharsSequence());
                        if (MyThreesideViewer.this.myUndoManager != null) {
                            DocumentReference ref = DocumentReferenceManager.getInstance().create(outputDocument);
                            MyThreesideViewer.this.myUndoManager.nonundoableActionPerformed(ref, false);
                        }
                    }
                });
            }

            @Override
            public void rediff(boolean trySync) {
                if (this.myInitialRediffStarted) {
                    return;
                }
                this.myInitialRediffStarted = true;
                assert (this.myAllMergeChanges.isEmpty());
                this.doRediff();
            }

            @Override
            @NotNull
            protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "performRediff"));
                }
                throw new UnsupportedOperationException();
            }

            private void doRediff() {
                this.myStatusPanel.setBusy(true);
                this.getEditor(ThreeSide.BASE).setViewer(true);
                this.setInitialOutputContent();
                List contents = this.myRequest.getContents();
                final List sequences = ContainerUtil.map((Collection)contents, (Function)new Function<DiffContent, CharSequence>(){

                    public CharSequence fun(DiffContent diffContent) {
                        return ((DocumentContent)diffContent).getDocument().getImmutableCharSequence();
                    }
                });
                final long outputModificationStamp = TextMergeViewer.this.myMergeRequest.getOutputContent().getDocument().getModificationStamp();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressManager.getInstance().run((Task)new Task.Modal(MyThreesideViewer.this.getProject(), "Computing differences...", true){
                            private Runnable myCallback;

                            public void run(@NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$4$1", "run"));
                                }
                                this.myCallback = MyThreesideViewer.this.doPerformRediff(sequences, outputModificationStamp, indicator);
                            }

                            public void onCancel() {
                                TextMergeViewer.this.myMergeContext.finishMerge(MergeResult.CANCEL);
                            }

                            public void onSuccess() {
                                if (MyThreesideViewer.this.isDisposed()) {
                                    return;
                                }
                                this.myCallback.run();
                            }
                        });
                    }
                });
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            protected Runnable doPerformRediff(@NotNull List<CharSequence> sequences, long outputModificationStamp, @NotNull ProgressIndicator progressIndicator) {
                Runnable runnable2;
                if (sequences == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequences", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "doPerformRediff"));
                }
                if (progressIndicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "doPerformRediff"));
                }
                try {
                    void indicator;
                    indicator.checkCanceled();
                    List<MergeLineFragment> lineFragments = ByLine.compareTwoStep(sequences.get(0), sequences.get(1), sequences.get(2), ComparisonPolicy.DEFAULT, (ProgressIndicator)indicator);
                    runnable2 = this.apply(lineFragments, outputModificationStamp);
                }
                catch (DiffTooBigException e) {
                    Runnable runnable3 = this.applyNotification(DiffNotifications.createDiffTooBig());
                    if (runnable3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "doPerformRediff"));
                    }
                    return runnable3;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                    Runnable runnable4 = new Runnable(){

                        @Override
                        public void run() {
                            MyThreesideViewer.this.clearDiffPresentation();
                            MyThreesideViewer.this.myPanel.setErrorContent();
                        }
                    };
                    if (runnable4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "doPerformRediff"));
                    }
                    return runnable4;
                }
                if (runnable2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "doPerformRediff"));
                }
                return runnable2;
            }

            @NotNull
            private Runnable apply(final @NotNull List<MergeLineFragment> fragments, final long outputModificationStamp) {
                if (fragments == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "apply"));
                }
                Runnable runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        if (TextMergeViewer.this.myMergeRequest.getOutputContent().getDocument().getModificationStamp() != outputModificationStamp) {
                            MyThreesideViewer.this.setInitialOutputContent();
                        }
                        MyThreesideViewer.this.clearDiffPresentation();
                        MyThreesideViewer.this.resetChangeCounters();
                        for (MergeLineFragment fragment : fragments) {
                            TextMergeChange change = new TextMergeChange(fragment, TextMergeViewer.this);
                            MyThreesideViewer.this.myAllMergeChanges.add(change);
                            MyThreesideViewer.this.onChangeAdded(change);
                        }
                        MyThreesideViewer.this.myInitialScrollHelper.onRediff();
                        MyThreesideViewer.this.myContentPanel.repaintDividers();
                        MyThreesideViewer.this.myStatusPanel.update();
                        MyThreesideViewer.this.getEditor(ThreeSide.BASE).setViewer(false);
                        MyThreesideViewer.this.myInnerDiffWorker.onSettingsChanged();
                        MyThreesideViewer.this.myInitialRediffFinished = true;
                    }
                };
                if (runnable2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "apply"));
                }
                return runnable2;
            }

            @Override
            protected void destroyChangedBlocks() {
                super.destroyChangedBlocks();
                for (TextMergeChange change : this.myAllMergeChanges) {
                    change.destroy();
                }
                this.myAllMergeChanges.clear();
            }

            @Override
            protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "onBeforeDocumentChange"));
                }
                super.onBeforeDocumentChange(e);
                this.enterBulkChangeUpdateBlock();
                if (this.myAllMergeChanges.isEmpty()) {
                    return;
                }
                ThreeSide side = null;
                if (e.getDocument() == this.getEditor(ThreeSide.LEFT).getDocument()) {
                    side = ThreeSide.LEFT;
                }
                if (e.getDocument() == this.getEditor(ThreeSide.RIGHT).getDocument()) {
                    side = ThreeSide.RIGHT;
                }
                if (e.getDocument() == this.getEditor(ThreeSide.BASE).getDocument()) {
                    side = ThreeSide.BASE;
                }
                if (side == null) {
                    LOG.warn("Unknown document changed");
                    return;
                }
                if (side != ThreeSide.BASE) {
                    LOG.error("Non-base side was changed");
                    return;
                }
                if (this.myInitialRediffFinished) {
                    this.myContentModified = true;
                }
                int line1 = e.getDocument().getLineNumber(e.getOffset());
                int line2 = e.getDocument().getLineNumber(e.getOffset() + e.getOldLength()) + 1;
                int shift = DiffUtil.countLinesShift(e);
                final ArrayList corruptedStates = ContainerUtil.newArrayList();
                for (TextMergeChange change : this.myAllMergeChanges) {
                    TextMergeChange.State oldState = change.processBaseChange(line1, line2, shift);
                    if (oldState == null) continue;
                    if (this.myCurrentMergeCommand == null) {
                        corruptedStates.add(Pair.create((Object)change, (Object)oldState));
                    }
                    this.reinstallHighlighter(change);
                }
                if (!corruptedStates.isEmpty() && this.myUndoManager != null) {
                    this.myUndoManager.undoableActionPerformed((UndoableAction)new BasicUndoableAction(new Document[]{this.getEditor(ThreeSide.BASE).getDocument()}){

                        public void undo() throws UnexpectedUndoException {
                            MyThreesideViewer.this.enterBulkChangeUpdateBlock();
                            for (Pair pair : corruptedStates) {
                                MyThreesideViewer.this.restoreChangeState((TextMergeChange)pair.first, (TextMergeChange.State)pair.second);
                            }
                            MyThreesideViewer.this.exitBulkChangeUpdateBlock();
                        }

                        public void redo() throws UnexpectedUndoException {
                        }
                    });
                }
            }

            @Override
            protected void onDocumentChange(@NotNull DocumentEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "onDocumentChange"));
                }
                super.onDocumentChange(e);
                this.exitBulkChangeUpdateBlock();
            }

            public void repaintDividers() {
                this.myContentPanel.repaintDividers();
            }

            public void reinstallHighlighter(@NotNull TextMergeChange change) {
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "reinstallHighlighter"));
                }
                if (this.myBulkChangeUpdateDepth > 0) {
                    this.myChangesToUpdate.add(change);
                } else {
                    change.markInnerFragmentsDamaged();
                    change.doReinstallHighlighter();
                    this.myInnerDiffWorker.scheduleRediff(change);
                }
            }

            public void enterBulkChangeUpdateBlock() {
                ++this.myBulkChangeUpdateDepth;
            }

            public void exitBulkChangeUpdateBlock() {
                --this.myBulkChangeUpdateDepth;
                LOG.assertTrue(this.myBulkChangeUpdateDepth >= 0);
                if (this.myBulkChangeUpdateDepth == 0) {
                    for (TextMergeChange change : this.myChangesToUpdate) {
                        change.markInnerFragmentsDamaged();
                        change.doReinstallHighlighter();
                    }
                    this.myInnerDiffWorker.scheduleRediff(this.myChangesToUpdate);
                    this.myChangesToUpdate.clear();
                }
            }

            private void onChangeResolved(@NotNull TextMergeChange change) {
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "onChangeResolved"));
                }
                if (change.isResolved()) {
                    this.onChangeRemoved(change);
                } else {
                    this.onChangeAdded(change);
                }
                if (this.getChangesCount() == 0 && this.getConflictsCount() == 0) {
                    LOG.assertTrue(this.getFirstUnresolvedChange(true, null) == null);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String message = "All changes have been processed.<br><a href=\"\">Save changes and finish merging</a>";
                            HyperlinkAdapter listener = new HyperlinkAdapter(){

                                protected void hyperlinkActivated(HyperlinkEvent e) {
                                    MyThreesideViewer.this.destroyChangedBlocks();
                                    TextMergeViewer.this.myMergeContext.finishMerge(MergeResult.RESOLVED);
                                }
                            };
                            JComponent component = MyThreesideViewer.this.getEditor(ThreeSide.BASE).getComponent();
                            Point point = new Point(component.getWidth() / 2, JBUI.scale((int)5));
                            Color bgColor = MessageType.INFO.getPopupBackground();
                            BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, null, bgColor, (HyperlinkListener)listener).setAnimationCycle(200);
                            Balloon balloon = balloonBuilder.createBalloon();
                            balloon.show(new RelativePoint((Component)component, point), Balloon.Position.below);
                            Disposer.register((Disposable)MyThreesideViewer.this, (Disposable)balloon);
                        }
                    });
                }
            }

            @NotNull
            private HighlightPolicy getHighlightPolicy() {
                HighlightPolicy policy = this.getTextSettings().getHighlightPolicy();
                if (policy == HighlightPolicy.BY_WORD_SPLIT) {
                    HighlightPolicy highlightPolicy = HighlightPolicy.BY_WORD;
                    if (highlightPolicy == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "getHighlightPolicy"));
                    }
                    return highlightPolicy;
                }
                if (policy == HighlightPolicy.DO_NOT_HIGHLIGHT) {
                    HighlightPolicy highlightPolicy = HighlightPolicy.BY_LINE;
                    if (highlightPolicy == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "getHighlightPolicy"));
                    }
                    return highlightPolicy;
                }
                HighlightPolicy highlightPolicy = policy;
                if (highlightPolicy == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "getHighlightPolicy"));
                }
                return highlightPolicy;
            }

            @NotNull
            public List<TextMergeChange> getAllChanges() {
                List<TextMergeChange> list = this.myAllMergeChanges;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "getAllChanges"));
                }
                return list;
            }

            @NotNull
            public List<TextMergeChange> getChanges() {
                List list = ContainerUtil.filter(this.myAllMergeChanges, (Condition)new Condition<TextMergeChange>(){

                    public boolean value(TextMergeChange mergeChange) {
                        return !mergeChange.isResolved();
                    }
                });
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "getChanges"));
                }
                return list;
            }

            @Override
            @NotNull
            protected DiffDividerDrawUtil.DividerPaintable getDividerPaintable(@NotNull Side side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "getDividerPaintable"));
                }
                MyDividerPaintable myDividerPaintable = new MyDividerPaintable(side);
                if (myDividerPaintable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "getDividerPaintable"));
                }
                return myDividerPaintable;
            }

            @NotNull
            public ModifierProvider getModifierProvider() {
                ModifierProvider modifierProvider = this.myModifierProvider;
                if (modifierProvider == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "getModifierProvider"));
                }
                return modifierProvider;
            }

            @Nullable
            private TextMergeChange getFirstUnresolvedChange(boolean acceptConflicts, @Nullable Side side) {
                for (TextMergeChange change : this.getAllChanges()) {
                    if (change.isResolved() || !acceptConflicts && change.isConflict() || side != null && !change.isChange(side)) continue;
                    return change;
                }
                return null;
            }

            private void restoreChangeState(@NotNull TextMergeChange change, @NotNull TextMergeChange.State state) {
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "restoreChangeState"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "restoreChangeState"));
                }
                boolean wasResolved = change.isResolved();
                change.restoreState(state);
                this.reinstallHighlighter(change);
                if (wasResolved != change.isResolved()) {
                    this.onChangeResolved(change);
                }
            }

            public void executeMergeCommand(@Nullable String commandName, boolean underBulkUpdate, @Nullable List<TextMergeChange> affected, final @NotNull Runnable task) {
                if (task == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "executeMergeCommand"));
                }
                new MergeCommandAction(this.getProject(), commandName, underBulkUpdate, affected){

                    @Override
                    protected void doExecute() {
                        task.run();
                    }
                }.run();
            }

            public void executeMergeCommand(@Nullable String commandName, @Nullable List<TextMergeChange> affected, @NotNull Runnable task) {
                if (task == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "executeMergeCommand"));
                }
                this.executeMergeCommand(commandName, false, affected, task);
            }

            public void markChangeResolved(@NotNull TextMergeChange change) {
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "markChangeResolved"));
                }
                if (change.isResolved()) {
                    return;
                }
                change.setResolved(Side.LEFT, true);
                change.setResolved(Side.RIGHT, true);
                this.onChangeResolved(change);
                this.reinstallHighlighter(change);
            }

            public void markChangeResolved(@NotNull TextMergeChange change, @NotNull Side side) {
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "markChangeResolved"));
                }
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "markChangeResolved"));
                }
                if (change.isResolved(side)) {
                    return;
                }
                change.setResolved(side, true);
                if (change.isResolved()) {
                    this.onChangeResolved(change);
                }
                this.reinstallHighlighter(change);
            }

            public void ignoreChange(@NotNull TextMergeChange change, @NotNull Side side, boolean resolveChange) {
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "ignoreChange"));
                }
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "ignoreChange"));
                }
                if (!change.isConflict() || resolveChange) {
                    this.markChangeResolved(change);
                } else {
                    this.markChangeResolved(change, side);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void replaceChange(@NotNull TextMergeChange change, @NotNull Side side, boolean resolveChange) {
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "replaceChange"));
                }
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "replaceChange"));
                }
                LOG.assertTrue(this.myCurrentMergeCommand != null);
                if (change.isResolved(side)) {
                    return;
                }
                if (!change.isChange(side)) {
                    this.markChangeResolved(change);
                    return;
                }
                ThreeSide sourceSide = (ThreeSide)side.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
                ThreeSide oppositeSide = (ThreeSide)side.select((Object)ThreeSide.RIGHT, (Object)ThreeSide.LEFT);
                ThreeSide outputSide = ThreeSide.BASE;
                int outputStartLine = change.getStartLine(outputSide);
                int outputEndLine = change.getEndLine(outputSide);
                int sourceStartLine = change.getStartLine(sourceSide);
                int sourceEndLine = change.getEndLine(sourceSide);
                this.enterBulkChangeUpdateBlock();
                try {
                    if (change.isConflict()) {
                        boolean append = change.isOnesideAppliedConflict();
                        int actualOutputStartLine = append ? outputEndLine : outputStartLine;
                        DiffUtil.applyModification(this.getContent(outputSide).getDocument(), actualOutputStartLine, outputEndLine, this.getContent(sourceSide).getDocument(), sourceStartLine, sourceEndLine);
                        if (outputStartLine == outputEndLine || append) {
                            int newOutputEndLine = actualOutputStartLine + (sourceEndLine - sourceStartLine);
                            this.moveChangesAfterInsertion(change, outputStartLine, newOutputEndLine);
                        }
                        if (resolveChange || change.getStartLine(oppositeSide) == change.getEndLine(oppositeSide)) {
                            this.markChangeResolved(change);
                        } else {
                            change.markOnesideAppliedConflict();
                            this.markChangeResolved(change, side);
                        }
                    } else {
                        DiffUtil.applyModification(this.getContent(outputSide).getDocument(), outputStartLine, outputEndLine, this.getContent(sourceSide).getDocument(), sourceStartLine, sourceEndLine);
                        if (outputStartLine == outputEndLine) {
                            int newOutputEndLine = outputStartLine + (sourceEndLine - sourceStartLine);
                            this.moveChangesAfterInsertion(change, outputStartLine, newOutputEndLine);
                        }
                        this.markChangeResolved(change);
                    }
                }
                finally {
                    this.exitBulkChangeUpdateBlock();
                }
            }

            private void moveChangesAfterInsertion(@NotNull TextMergeChange change, int newOutputStartLine, int newOutputEndLine) {
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer", "moveChangesAfterInsertion"));
                }
                LOG.assertTrue(this.myCurrentMergeCommand != null);
                if (change.getStartLine(ThreeSide.BASE) != newOutputStartLine || change.getEndLine(ThreeSide.BASE) != newOutputEndLine) {
                    change.setStartLine(ThreeSide.BASE, newOutputStartLine);
                    change.setEndLine(ThreeSide.BASE, newOutputEndLine);
                    this.reinstallHighlighter(change);
                }
                boolean beforeChange = true;
                for (TextMergeChange otherChange : this.getAllChanges()) {
                    int newEndLine;
                    int startLine = otherChange.getStartLine(ThreeSide.BASE);
                    int endLine = otherChange.getEndLine(ThreeSide.BASE);
                    if (endLine < newOutputStartLine) continue;
                    if (startLine > newOutputEndLine) break;
                    if (otherChange == change) {
                        beforeChange = false;
                        continue;
                    }
                    int newStartLine = beforeChange ? Math.min(startLine, newOutputStartLine) : Math.max(startLine, newOutputEndLine);
                    int n = newEndLine = beforeChange ? Math.min(endLine, newOutputStartLine) : Math.max(endLine, newOutputEndLine);
                    if (startLine == newStartLine && endLine == newEndLine) continue;
                    otherChange.setStartLine(ThreeSide.BASE, newStartLine);
                    otherChange.setEndLine(ThreeSide.BASE, newEndLine);
                    this.reinstallHighlighter(otherChange);
                }
            }

            @Nullable
            private List<TextMergeChange> collectAffectedChanges(@Nullable List<TextMergeChange> directChanges) {
                if (directChanges == null || directChanges.isEmpty()) {
                    return null;
                }
                ArrayList<TextMergeChange> result2 = new ArrayList<TextMergeChange>(directChanges.size());
                int directIndex = 0;
                int otherIndex = 0;
                while (directIndex < directChanges.size() && otherIndex < this.myAllMergeChanges.size()) {
                    TextMergeChange otherChange;
                    TextMergeChange directChange = directChanges.get(directIndex);
                    if (directChange == (otherChange = this.myAllMergeChanges.get(otherIndex))) {
                        result2.add(directChange);
                        ++otherIndex;
                        continue;
                    }
                    int directStart = directChange.getStartLine(ThreeSide.BASE);
                    int directEnd = directChange.getEndLine(ThreeSide.BASE);
                    int otherStart = otherChange.getStartLine(ThreeSide.BASE);
                    int otherEnd = otherChange.getEndLine(ThreeSide.BASE);
                    if (otherEnd < directStart) {
                        ++otherIndex;
                        continue;
                    }
                    if (otherStart > directEnd) {
                        ++directIndex;
                        continue;
                    }
                    result2.add(otherChange);
                    ++otherIndex;
                }
                LOG.assertTrue(directChanges.size() <= result2.size());
                return result2;
            }

            public class ModifierProvider
            extends KeyboardModifierListener {
                public void init() {
                    this.init(MyThreesideViewer.this.myPanel, (Disposable)TextMergeViewer.this);
                }

                @Override
                public void onModifiersChanged() {
                    for (TextMergeChange change : MyThreesideViewer.this.myAllMergeChanges) {
                        change.updateGutterActions(false);
                    }
                }
            }

            private class MyDividerPaintable
            implements DiffDividerDrawUtil.DividerPaintable {
                @NotNull
                private final Side mySide;

                public MyDividerPaintable(Side side) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$MyDividerPaintable", "<init>"));
                    }
                    this.mySide = side;
                }

                @Override
                public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
                    if (handler2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$MyDividerPaintable", "process"));
                    }
                    ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
                    ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
                    for (TextMergeChange mergeChange : MyThreesideViewer.this.myAllMergeChanges) {
                        if (!mergeChange.isChange(this.mySide)) continue;
                        Color color = mergeChange.getDiffType().getColor(MyThreesideViewer.this.getEditor(ThreeSide.BASE));
                        boolean isResolved = mergeChange.isResolved(this.mySide);
                        if (handler2.process(mergeChange.getStartLine(left), mergeChange.getEndLine(left), mergeChange.getStartLine(right), mergeChange.getEndLine(right), color, isResolved)) continue;
                        return;
                    }
                }
            }

            public class ApplySideNonConflictsAction
            extends ApplyNonConflictsActionBase {
                @NotNull
                private final Side mySide;

                public ApplySideNonConflictsAction(Side side) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ApplySideNonConflictsAction", "<init>"));
                    }
                    super((String)side.select((Object)DiffBundle.message((String)"merge.dialog.apply.left.non.conflicting.changes.action.name", (Object[])new Object[0]), (Object)DiffBundle.message((String)"merge.dialog.apply.right.non.conflicting.changes.action.name", (Object[])new Object[0])), null, (Icon)side.select((Object)AllIcons.Diff.ApplyNotConflictsLeft, (Object)AllIcons.Diff.ApplyNotConflictsRight));
                    this.mySide = side;
                }

                @Override
                protected void doPerform() {
                    ArrayList allChanges = ContainerUtil.newArrayList(MyThreesideViewer.this.getAllChanges());
                    for (TextMergeChange change : allChanges) {
                        if (change.isConflict() || change.isResolved(this.mySide) || !change.isChange(this.mySide)) continue;
                        MyThreesideViewer.this.replaceChange(change, this.mySide, false);
                    }
                }

                public void update(AnActionEvent e) {
                    e.getPresentation().setEnabled(MyThreesideViewer.this.getFirstUnresolvedChange(false, this.mySide) != null);
                }
            }

            public class ApplyNonConflictsAction
            extends ApplyNonConflictsActionBase {
                public ApplyNonConflictsAction() {
                    super(DiffBundle.message((String)"merge.dialog.apply.all.non.conflicting.changes.action.name", (Object[])new Object[0]), null, AllIcons.Diff.ApplyNotConflicts);
                }

                @Override
                protected void doPerform() {
                    ArrayList allChanges = ContainerUtil.newArrayList(MyThreesideViewer.this.getAllChanges());
                    for (TextMergeChange change : allChanges) {
                        if (change.isConflict() || change.isResolved()) continue;
                        Side masterSide = change.isChange(Side.LEFT) ? Side.LEFT : Side.RIGHT;
                        MyThreesideViewer.this.replaceChange(change, masterSide, false);
                    }
                }

                public void update(AnActionEvent e) {
                    e.getPresentation().setEnabled(MyThreesideViewer.this.getFirstUnresolvedChange(false, null) != null);
                }
            }

            public abstract class ApplyNonConflictsActionBase
            extends DumbAwareAction {
                public ApplyNonConflictsActionBase(@Nullable String text, @Nullable String description, Icon icon) {
                    super(text, description, icon);
                }

                public void actionPerformed(AnActionEvent e) {
                    MyThreesideViewer.this.executeMergeCommand("Apply Non Conflicted Changes", true, null, new Runnable(){

                        @Override
                        public void run() {
                            ApplyNonConflictsActionBase.this.doPerform();
                        }
                    });
                    TextMergeChange firstConflict = MyThreesideViewer.this.getFirstUnresolvedChange(true, null);
                    if (firstConflict != null) {
                        MyThreesideViewer.this.doScrollToChange(firstConflict, true);
                    }
                }

                protected abstract void doPerform();
            }

            private class ResolveSelectedChangesAction
            extends ApplySelectedChangesActionBase {
                @NotNull
                private final Side mySide;

                public ResolveSelectedChangesAction(Side side) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ResolveSelectedChangesAction", "<init>"));
                    }
                    super(false);
                    this.mySide = side;
                }

                @Override
                protected String getText(@NotNull ThreeSide side) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ResolveSelectedChangesAction", "getText"));
                    }
                    return (String)this.mySide.select((Object)"Resolve using Left", (Object)"Resolve using Right");
                }

                @Override
                protected boolean isVisible(@NotNull ThreeSide side) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ResolveSelectedChangesAction", "isVisible"));
                    }
                    return side == ThreeSide.BASE;
                }

                @Override
                protected boolean isEnabled(@NotNull TextMergeChange change) {
                    if (change == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ResolveSelectedChangesAction", "isEnabled"));
                    }
                    return !change.isResolved(this.mySide);
                }

                @Override
                protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ResolveSelectedChangesAction", "apply"));
                    }
                    if (changes == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ResolveSelectedChangesAction", "apply"));
                    }
                    for (int i = changes.size() - 1; i >= 0; --i) {
                        MyThreesideViewer.this.replaceChange(changes.get(i), this.mySide, true);
                    }
                }
            }

            private class ApplySelectedChangesAction
            extends ApplySelectedChangesActionBase {
                @NotNull
                private final Side mySide;

                public ApplySelectedChangesAction(Side side, boolean shortcut) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ApplySelectedChangesAction", "<init>"));
                    }
                    super(shortcut);
                    this.mySide = side;
                    EmptyAction.setupAction((AnAction)this, (String)((String)this.mySide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")), null);
                }

                @Override
                protected String getText(@NotNull ThreeSide side) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ApplySelectedChangesAction", "getText"));
                    }
                    return side != ThreeSide.BASE ? "Accept" : this.getTemplatePresentation().getText();
                }

                @Override
                protected boolean isVisible(@NotNull ThreeSide side) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ApplySelectedChangesAction", "isVisible"));
                    }
                    if (side == ThreeSide.BASE) {
                        return true;
                    }
                    return side == this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
                }

                @Override
                protected boolean isEnabled(@NotNull TextMergeChange change) {
                    if (change == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ApplySelectedChangesAction", "isEnabled"));
                    }
                    return !change.isResolved(this.mySide);
                }

                @Override
                protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ApplySelectedChangesAction", "apply"));
                    }
                    if (changes == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ApplySelectedChangesAction", "apply"));
                    }
                    for (int i = changes.size() - 1; i >= 0; --i) {
                        MyThreesideViewer.this.replaceChange(changes.get(i), this.mySide, false);
                    }
                }
            }

            private class IgnoreSelectedChangesAction
            extends ApplySelectedChangesActionBase {
                public IgnoreSelectedChangesAction() {
                    super(false);
                    this.getTemplatePresentation().setIcon(AllIcons.Diff.Remove);
                }

                @Override
                protected String getText(@NotNull ThreeSide side) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesAction", "getText"));
                    }
                    return "Ignore";
                }

                @Override
                protected boolean isVisible(@NotNull ThreeSide side) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesAction", "isVisible"));
                    }
                    return side == ThreeSide.BASE;
                }

                @Override
                protected boolean isEnabled(@NotNull TextMergeChange change) {
                    if (change == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesAction", "isEnabled"));
                    }
                    return !change.isResolved();
                }

                @Override
                protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesAction", "apply"));
                    }
                    if (changes == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesAction", "apply"));
                    }
                    for (TextMergeChange change : changes) {
                        MyThreesideViewer.this.markChangeResolved(change);
                    }
                }
            }

            private class IgnoreSelectedChangesSideAction
            extends ApplySelectedChangesActionBase {
                @NotNull
                private final Side mySide;

                public IgnoreSelectedChangesSideAction(Side side, boolean shortcut) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesSideAction", "<init>"));
                    }
                    super(shortcut);
                    this.mySide = side;
                    EmptyAction.setupAction((AnAction)this, (String)((String)this.mySide.select((Object)"Diff.IgnoreLeftSide", (Object)"Diff.IgnoreRightSide")), null);
                }

                @Override
                protected String getText(@NotNull ThreeSide side) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesSideAction", "getText"));
                    }
                    return "Ignore";
                }

                @Override
                protected boolean isVisible(@NotNull ThreeSide side) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesSideAction", "isVisible"));
                    }
                    return side == this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
                }

                @Override
                protected boolean isEnabled(@NotNull TextMergeChange change) {
                    if (change == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesSideAction", "isEnabled"));
                    }
                    return !change.isResolved(this.mySide);
                }

                @Override
                protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesSideAction", "apply"));
                    }
                    if (changes == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesSideAction", "apply"));
                    }
                    for (TextMergeChange change : changes) {
                        MyThreesideViewer.this.ignoreChange(change, this.mySide, false);
                    }
                }
            }

            private abstract class ApplySelectedChangesActionBase
            extends AnAction
            implements DumbAware {
                private final boolean myShortcut;

                public ApplySelectedChangesActionBase(boolean shortcut) {
                    this.myShortcut = shortcut;
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ApplySelectedChangesActionBase", "update"));
                    }
                    if (this.myShortcut) {
                        e.getPresentation().setEnabledAndVisible(true);
                        return;
                    }
                    Presentation presentation = e.getPresentation();
                    Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                    ThreeSide side = MyThreesideViewer.this.getEditorSide(editor);
                    if (side == null) {
                        presentation.setEnabledAndVisible(false);
                        return;
                    }
                    if (!this.isVisible(side)) {
                        presentation.setEnabledAndVisible(false);
                        return;
                    }
                    presentation.setText(this.getText(side));
                    presentation.setVisible(true);
                    presentation.setEnabled(this.isSomeChangeSelected(side));
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ApplySelectedChangesActionBase", "actionPerformed"));
                    }
                    Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                    final ThreeSide side = MyThreesideViewer.this.getEditorSide(editor);
                    if (editor == null || side == null) {
                        return;
                    }
                    final List<TextMergeChange> selectedChanges = this.getSelectedChanges(side);
                    if (selectedChanges.isEmpty()) {
                        return;
                    }
                    String title = e.getPresentation().getText() + " in merge";
                    MyThreesideViewer.this.executeMergeCommand(title, selectedChanges.size() > 1, selectedChanges, new Runnable(){

                        @Override
                        public void run() {
                            ApplySelectedChangesActionBase.this.apply(side, selectedChanges);
                        }
                    });
                }

                private boolean isSomeChangeSelected(@NotNull ThreeSide side) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ApplySelectedChangesActionBase", "isSomeChangeSelected"));
                    }
                    EditorEx editor = MyThreesideViewer.this.getEditor(side);
                    List carets = editor.getCaretModel().getAllCarets();
                    if (carets.size() != 1) {
                        return true;
                    }
                    Caret caret = (Caret)carets.get(0);
                    if (caret.hasSelection()) {
                        return true;
                    }
                    int line = editor.getDocument().getLineNumber(editor.getExpectedCaretOffset());
                    List<TextMergeChange> changes = MyThreesideViewer.this.getAllChanges();
                    for (TextMergeChange change : changes) {
                        int line2;
                        int line1;
                        if (!this.isEnabled(change) || !DiffUtil.isSelectedByLine(line, line1 = change.getStartLine(side), line2 = change.getEndLine(side))) continue;
                        return true;
                    }
                    return false;
                }

                @NotNull
                private List<TextMergeChange> getSelectedChanges(@NotNull ThreeSide side) {
                    if (side == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ApplySelectedChangesActionBase", "getSelectedChanges"));
                    }
                    BitSet lines = DiffUtil.getSelectedLines(MyThreesideViewer.this.getEditor(side));
                    List<TextMergeChange> changes = MyThreesideViewer.this.getChanges();
                    ArrayList<TextMergeChange> affectedChanges = new ArrayList<TextMergeChange>();
                    for (TextMergeChange change : changes) {
                        int line2;
                        int line1;
                        if (!this.isEnabled(change) || !DiffUtil.isSelectedByLine(lines, line1 = change.getStartLine(side), line2 = change.getEndLine(side))) continue;
                        affectedChanges.add(change);
                    }
                    ArrayList<TextMergeChange> arrayList = affectedChanges;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$ApplySelectedChangesActionBase", "getSelectedChanges"));
                    }
                    return arrayList;
                }

                protected abstract String getText(@NotNull ThreeSide var1);

                protected abstract boolean isVisible(@NotNull ThreeSide var1);

                protected abstract boolean isEnabled(@NotNull TextMergeChange var1);

                protected abstract void apply(@NotNull ThreeSide var1, @NotNull List<TextMergeChange> var2);
            }

            private class MyHighlightPolicySettingAction
            extends TextDiffViewerUtil.HighlightPolicySettingAction {
                public MyHighlightPolicySettingAction() {
                    super(MyThreesideViewer.this.getTextSettings());
                }

                @Override
                @NotNull
                protected HighlightPolicy getCurrentSetting() {
                    HighlightPolicy highlightPolicy = MyThreesideViewer.this.getHighlightPolicy();
                    if (highlightPolicy == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$MyHighlightPolicySettingAction", "getCurrentSetting"));
                    }
                    return highlightPolicy;
                }

                @Override
                @NotNull
                protected List<HighlightPolicy> getAvailableSettings() {
                    List list = ContainerUtil.list((Object[])new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD});
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$MyHighlightPolicySettingAction", "getAvailableSettings"));
                    }
                    return list;
                }

                @Override
                protected void onSettingsChanged() {
                    MyThreesideViewer.this.myInnerDiffWorker.onSettingsChanged();
                }
            }

            private abstract class MergeCommandAction
            extends DiffUtil.DiffCommandAction {
                @Nullable
                private final List<TextMergeChange> myAffectedChanges;

                public MergeCommandAction(@Nullable Project project, String commandName, @Nullable boolean underBulkUpdate, List<TextMergeChange> changes) {
                    this(project, commandName, null, UndoConfirmationPolicy.DEFAULT, underBulkUpdate, changes);
                }

                public MergeCommandAction(@Nullable Project project, @Nullable String commandName, @NotNull String commandGroupId, UndoConfirmationPolicy confirmationPolicy, @Nullable boolean underBulkUpdate, List<TextMergeChange> changes) {
                    if (confirmationPolicy == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "confirmationPolicy", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$MergeCommandAction", "<init>"));
                    }
                    super(project, MyThreesideViewer.this.getEditor(ThreeSide.BASE).getDocument(), commandName, commandGroupId, confirmationPolicy, underBulkUpdate);
                    this.myAffectedChanges = MyThreesideViewer.this.collectAffectedChanges(changes);
                }

                @Override
                protected final void execute() {
                    ThreesideTextDiffViewerEx.LOG.assertTrue(MyThreesideViewer.this.myCurrentMergeCommand == null);
                    MyThreesideViewer.this.myContentModified = true;
                    MyThreesideViewer.this.myCurrentMergeCommand = this;
                    this.registerUndoRedo(true);
                    MyThreesideViewer.this.enterBulkChangeUpdateBlock();
                    try {
                        this.doExecute();
                    }
                    finally {
                        MyThreesideViewer.this.exitBulkChangeUpdateBlock();
                        this.registerUndoRedo(false);
                        MyThreesideViewer.this.myCurrentMergeCommand = null;
                    }
                }

                private void registerUndoRedo(final boolean undo) {
                    if (MyThreesideViewer.this.myUndoManager == null) {
                        return;
                    }
                    List<TextMergeChange> affectedChanges = this.getAffectedChanges();
                    final ArrayList<TextMergeChange.State> states = new ArrayList<TextMergeChange.State>(affectedChanges.size());
                    for (TextMergeChange change : affectedChanges) {
                        states.add(change.storeState());
                    }
                    MyThreesideViewer.this.myUndoManager.undoableActionPerformed((UndoableAction)new BasicUndoableAction(new Document[]{this.myDocument}){

                        public void undo() throws UnexpectedUndoException {
                            if (undo) {
                                MergeCommandAction.this.restoreStates(states);
                            }
                        }

                        public void redo() throws UnexpectedUndoException {
                            if (!undo) {
                                MergeCommandAction.this.restoreStates(states);
                            }
                        }
                    });
                }

                private void restoreStates(@NotNull List<TextMergeChange.State> states) {
                    if (states == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "states", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$MergeCommandAction", "restoreStates"));
                    }
                    List<TextMergeChange> affectedChanges = this.getAffectedChanges();
                    MyThreesideViewer.this.enterBulkChangeUpdateBlock();
                    for (int i = 0; i < affectedChanges.size(); ++i) {
                        MyThreesideViewer.this.restoreChangeState(affectedChanges.get(i), states.get(i));
                    }
                    MyThreesideViewer.this.exitBulkChangeUpdateBlock();
                }

                @NotNull
                private List<TextMergeChange> getAffectedChanges() {
                    List list = this.myAffectedChanges != null ? this.myAffectedChanges : MyThreesideViewer.this.myAllMergeChanges;
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$MergeCommandAction", "getAffectedChanges"));
                    }
                    return list;
                }

                protected abstract void doExecute();
            }

            private class MyInnerDiffWorker {
                @NotNull
                private final Set<TextMergeChange> myScheduled = ContainerUtil.newHashSet();
                @NotNull
                private final Alarm myAlarm = new Alarm((Disposable)MyThreesideViewer.this);
                @Nullable
                private ProgressIndicator myProgress;
                private boolean myEnabled = false;

                private MyInnerDiffWorker() {
                }

                public void scheduleRediff(@NotNull TextMergeChange change) {
                    if (change == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$MyInnerDiffWorker", "scheduleRediff"));
                    }
                    this.scheduleRediff(Collections.singletonList(change));
                }

                public void scheduleRediff(@NotNull Collection<TextMergeChange> changes) {
                    if (changes == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$MyInnerDiffWorker", "scheduleRediff"));
                    }
                    if (!this.myEnabled) {
                        return;
                    }
                    this.putChanges(changes);
                    this.schedule();
                }

                public void onSettingsChanged() {
                    boolean enabled;
                    boolean bl = enabled = MyThreesideViewer.this.getHighlightPolicy() == HighlightPolicy.BY_WORD;
                    if (this.myEnabled == enabled) {
                        return;
                    }
                    this.myEnabled = enabled;
                    if (this.myProgress != null) {
                        this.myProgress.cancel();
                    }
                    this.myProgress = null;
                    if (this.myEnabled) {
                        this.putChanges(MyThreesideViewer.this.myAllMergeChanges);
                        this.launchRediff();
                    } else {
                        MyThreesideViewer.this.myStatusPanel.setBusy(false);
                        this.myScheduled.clear();
                        for (TextMergeChange change : MyThreesideViewer.this.myAllMergeChanges) {
                            change.setInnerFragments(null);
                        }
                    }
                }

                private void putChanges(@NotNull Collection<TextMergeChange> changes) {
                    if (changes == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$MyInnerDiffWorker", "putChanges"));
                    }
                    for (TextMergeChange change : changes) {
                        if (change.isResolved()) continue;
                        this.myScheduled.add(change);
                    }
                }

                private void schedule() {
                    if (this.myProgress != null) {
                        return;
                    }
                    if (this.myScheduled.isEmpty()) {
                        return;
                    }
                    this.myAlarm.cancelAllRequests();
                    this.myAlarm.addRequest(new Runnable(){

                        @Override
                        public void run() {
                            MyInnerDiffWorker.this.launchRediff();
                        }
                    }, 300);
                }

                private void launchRediff() {
                    MyThreesideViewer.this.myStatusPanel.setBusy(true);
                    this.myProgress = new EmptyProgressIndicator();
                    final ArrayList scheduled = ContainerUtil.newArrayList(this.myScheduled);
                    this.myScheduled.clear();
                    final Document[] documents = new Document[]{MyThreesideViewer.this.getEditor(ThreeSide.LEFT).getDocument(), MyThreesideViewer.this.getEditor(ThreeSide.BASE).getDocument(), MyThreesideViewer.this.getEditor(ThreeSide.RIGHT).getDocument()};
                    final List data = ContainerUtil.map((Collection)scheduled, (Function)new Function<TextMergeChange, InnerChunkData>(){

                        public InnerChunkData fun(TextMergeChange change) {
                            return new InnerChunkData(change, documents);
                        }
                    });
                    final ProgressIndicator indicator = this.myProgress;
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            MyInnerDiffWorker.this.performRediff(scheduled, data, indicator);
                        }
                    });
                }

                private void performRediff(final @NotNull List<TextMergeChange> scheduled, @NotNull List<InnerChunkData> data, final @NotNull ProgressIndicator indicator) {
                    if (scheduled == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheduled", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$MyInnerDiffWorker", "performRediff"));
                    }
                    if (data == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$MyInnerDiffWorker", "performRediff"));
                    }
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/merge/TextMergeTool$TextMergeViewer$MyThreesideViewer$MyInnerDiffWorker", "performRediff"));
                    }
                    final ArrayList<List<MergeWordFragment>> result2 = new ArrayList<List<MergeWordFragment>>(data.size());
                    for (InnerChunkData chunkData : data) {
                        result2.add(DiffUtil.compareThreesideInner(chunkData.text, ComparisonPolicy.DEFAULT, indicator));
                    }
                    ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            indicator.checkCanceled();
                            if (!MyInnerDiffWorker.this.myEnabled) {
                                return;
                            }
                            MyInnerDiffWorker.this.myProgress = null;
                            for (int i = 0; i < scheduled.size(); ++i) {
                                TextMergeChange change = (TextMergeChange)scheduled.get(i);
                                if (MyInnerDiffWorker.this.myScheduled.contains(change)) continue;
                                change.setInnerFragments((List)result2.get(i));
                            }
                            MyThreesideViewer.this.myStatusPanel.setBusy(false);
                            if (!MyInnerDiffWorker.this.myScheduled.isEmpty()) {
                                MyInnerDiffWorker.this.launchRediff();
                            }
                        }
                    }, ModalityState.any());
                }
            }
        }
    }
}

