/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.binary;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.impl.FocusOppositePaneAction;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.side.TwosideDiffViewer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwosideBinaryDiffViewer
extends TwosideDiffViewer<BinaryEditorHolder> {
    public static final Logger LOG = Logger.getInstance(TwosideBinaryDiffViewer.class);
    @NotNull
    private final StatusPanel myStatusPanel;

    public TwosideBinaryDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "<init>"));
        }
        super(context, (ContentDiffRequest)request, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
        this.myStatusPanel = new StatusPanel();
        new MyFocusOppositePaneAction().setupAction(this.myPanel);
        this.myContentPanel.setTopAction((AnAction)new MyAcceptSideAction(Side.LEFT));
        this.myContentPanel.setBottomAction((AnAction)new MyAcceptSideAction(Side.RIGHT));
    }

    @Override
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new MyAcceptSideAction(Side.LEFT));
        group.add((AnAction)new MyAcceptSideAction(Side.RIGHT));
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createToolbarActions());
        return group;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable2;
        List contents;
        block8: {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "performRediff"));
            }
            indicator.checkCanceled();
            contents = this.myRequest.getContents();
            if (contents.get(0) instanceof FileContent && contents.get(1) instanceof FileContent) break block8;
            Runnable runnable3 = this.applyNotification(null);
            if (runnable3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "performRediff"));
            }
            return runnable3;
        }
        try {
            final VirtualFile file1 = ((FileContent)contents.get(0)).getFile();
            final VirtualFile file2 = ((FileContent)contents.get(1)).getFile();
            JComponent notification = (JComponent)ApplicationManager.getApplication().runReadAction((Computable)new Computable<JComponent>(){

                public JComponent compute() {
                    if (!file1.isValid() || !file2.isValid()) {
                        return DiffNotifications.createError();
                    }
                    try {
                        byte[] bytes1 = file1.contentsToByteArray();
                        byte[] bytes2 = file2.contentsToByteArray();
                        return Arrays.equals(bytes1, bytes2) ? DiffNotifications.createEqualContents() : null;
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                        return null;
                    }
                }
            });
            runnable2 = this.applyNotification(notification);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable4 = this.applyNotification(DiffNotifications.createError());
            if (runnable4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "performRediff"));
            }
            return runnable4;
        }
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "performRediff"));
        }
        return runnable2;
    }

    @NotNull
    private Runnable applyNotification(final @Nullable JComponent notification) {
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                TwosideBinaryDiffViewer.this.clearDiffPresentation();
                if (notification != null) {
                    TwosideBinaryDiffViewer.this.myPanel.addNotification(notification);
                }
            }
        };
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "applyNotification"));
        }
        return runnable2;
    }

    private void clearDiffPresentation() {
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
    }

    @NotNull
    FileEditor getCurrentEditor() {
        FileEditor fileEditor = ((BinaryEditorHolder)this.getCurrentEditorHolder()).getEditor();
        if (fileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "getCurrentEditor"));
        }
        return fileEditor;
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        StatusPanel statusPanel = this.myStatusPanel;
        if (statusPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "getStatusPanel"));
        }
        return statusPanel;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer", "canShowRequest"));
        }
        return TwosideDiffViewer.canShowRequest(context, request, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
    }

    private class MyFocusOppositePaneAction
    extends FocusOppositePaneAction {
        private MyFocusOppositePaneAction() {
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer$MyFocusOppositePaneAction", "actionPerformed"));
            }
            TwosideBinaryDiffViewer.this.setCurrentSide(TwosideBinaryDiffViewer.this.getCurrentSide().other());
            DiffUtil.requestFocus(TwosideBinaryDiffViewer.this.getProject(), TwosideBinaryDiffViewer.this.getPreferredFocusedComponent());
        }
    }

    private class MyAcceptSideAction
    extends DumbAwareAction {
        @NotNull
        private final Side myBaseSide;

        public MyAcceptSideAction(Side baseSide) {
            if (baseSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseSide", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer$MyAcceptSideAction", "<init>"));
            }
            this.myBaseSide = baseSide;
            this.getTemplatePresentation().setText("Copy Content to " + (String)baseSide.select((Object)"Right", (Object)"Left"));
            this.getTemplatePresentation().setIcon((Icon)baseSide.select((Object)AllIcons.Vcs.Arrow_right, (Object)AllIcons.Vcs.Arrow_left));
            this.setShortcutSet(ActionManager.getInstance().getAction((String)baseSide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")).getShortcutSet());
        }

        public void update(AnActionEvent e) {
            VirtualFile baseFile = this.getContentFile(this.myBaseSide);
            VirtualFile targetFile = this.getContentFile(this.myBaseSide.other());
            boolean enabled = baseFile != null && targetFile != null && targetFile.isWritable();
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            final VirtualFile baseFile = this.getContentFile(this.myBaseSide);
            final VirtualFile targetFile = this.getContentFile(this.myBaseSide.other());
            assert (baseFile != null && targetFile != null);
            try {
                ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<Void, IOException>(){

                    public Void compute() throws IOException {
                        targetFile.setBinaryContent(baseFile.contentsToByteArray());
                        return null;
                    }
                });
            }
            catch (IOException err) {
                LOG.warn((Throwable)err);
                Messages.showErrorDialog((Project)TwosideBinaryDiffViewer.this.getProject(), (String)err.getMessage(), (String)"Can't Copy File");
            }
        }

        @Nullable
        private VirtualFile getContentFile(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/binary/TwosideBinaryDiffViewer$MyAcceptSideAction", "getContentFile"));
            }
            DiffContent content = (DiffContent)side.select(TwosideBinaryDiffViewer.this.myRequest.getContents());
            VirtualFile file2 = content instanceof FileContent ? ((FileContent)content).getFile() : null;
            return file2 != null && file2.isValid() ? file2 : null;
        }
    }
}

