/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeLineFragmentImpl;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleThreesideDiffChange;
import com.intellij.diff.tools.simple.ThreesideTextDiffViewerEx;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleThreesideDiffViewer
extends ThreesideTextDiffViewerEx {
    public static final Logger LOG = Logger.getInstance(SimpleThreesideDiffViewer.class);
    @NotNull
    private final List<SimpleThreesideDiffChange> myDiffChanges;
    @NotNull
    private final List<SimpleThreesideDiffChange> myInvalidDiffChanges;

    public SimpleThreesideDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "<init>"));
        }
        super(context, (ContentDiffRequest)request);
        this.myDiffChanges = new ArrayList<SimpleThreesideDiffChange>();
        this.myInvalidDiffChanges = new ArrayList<SimpleThreesideDiffChange>();
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new MyIgnorePolicySettingAction());
        group.add((AnAction)new MyHighlightPolicySettingAction());
        group.add((AnAction)new ThreesideTextDiffViewerEx.MyToggleExpandByDefaultAction(this));
        group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new MyEditorReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_BASE));
        group.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.BASE_RIGHT));
        group.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_RIGHT));
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createToolbarActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "createToolbarActions"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new MyIgnorePolicySettingAction().getPopupGroup());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new ThreesideTextDiffViewerEx.MyToggleExpandByDefaultAction(this));
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "createPopupActions"));
        }
        return arrayList;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
        this.myInitialScrollHelper.onSlowRediff();
    }

    @Override
    @NotNull
    protected Runnable performRediff(final @NotNull ProgressIndicator indicator) {
        Runnable runnable2;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "performRediff"));
        }
        try {
            indicator.checkCanceled();
            List contents = this.myRequest.getContents();
            final Document[] documents = new Document[]{((DocumentContent)contents.get(0)).getDocument(), ((DocumentContent)contents.get(1)).getDocument(), ((DocumentContent)contents.get(2)).getDocument()};
            CharSequence[] sequences = (CharSequence[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<CharSequence[]>(){

                public CharSequence[] compute() {
                    CharSequence[] sequences = new CharSequence[]{documents[0].getImmutableCharSequence(), documents[1].getImmutableCharSequence(), documents[2].getImmutableCharSequence()};
                    return sequences;
                }
            });
            ComparisonPolicy comparisonPolicy = this.getIgnorePolicy().getComparisonPolicy();
            List<MergeLineFragment> lineFragments = ByLine.compareTwoStep(sequences[0], sequences[1], sequences[2], comparisonPolicy, indicator);
            if (this.getHighlightPolicy().isFineFragments()) {
                ArrayList<MergeLineFragment> fineLineFragments = new ArrayList<MergeLineFragment>(lineFragments.size());
                for (final MergeLineFragment fragment : lineFragments) {
                    CharSequence[] chunks = (CharSequence[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<CharSequence[]>(){

                        public CharSequence[] compute() {
                            indicator.checkCanceled();
                            CharSequence[] chunks = new CharSequence[]{SimpleThreesideDiffViewer.getChunkContent(fragment, documents, ThreeSide.LEFT), SimpleThreesideDiffViewer.getChunkContent(fragment, documents, ThreeSide.BASE), SimpleThreesideDiffViewer.getChunkContent(fragment, documents, ThreeSide.RIGHT)};
                            return chunks;
                        }
                    });
                    List<MergeWordFragment> wordFragments = DiffUtil.compareThreesideInner(chunks, comparisonPolicy, indicator);
                    fineLineFragments.add(new MergeLineFragmentImpl(fragment, wordFragments));
                }
                lineFragments = fineLineFragments;
            }
            runnable2 = this.apply(lineFragments, comparisonPolicy);
        }
        catch (DiffTooBigException e) {
            Runnable runnable3 = this.applyNotification(DiffNotifications.createDiffTooBig());
            if (runnable3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "performRediff"));
            }
            return runnable3;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable4 = this.applyNotification(DiffNotifications.createError());
            if (runnable4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "performRediff"));
            }
            return runnable4;
        }
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "performRediff"));
        }
        return runnable2;
    }

    @Nullable
    private static CharSequence getChunkContent(@NotNull MergeLineFragment fragment, @NotNull Document[] documents, @NotNull ThreeSide side) {
        int endLine;
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getChunkContent"));
        }
        if (documents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documents", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getChunkContent"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getChunkContent"));
        }
        int startLine = fragment.getStartLine(side);
        return startLine != (endLine = fragment.getEndLine(side)) ? DiffUtil.getLinesContent((Document)side.select((Object[])documents), startLine, endLine) : null;
    }

    @NotNull
    private Runnable apply(final @NotNull List<MergeLineFragment> fragments, final @NotNull ComparisonPolicy comparisonPolicy) {
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "apply"));
        }
        if (comparisonPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparisonPolicy", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "apply"));
        }
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                SimpleThreesideDiffViewer.this.myFoldingModel.updateContext((UserDataHolder)SimpleThreesideDiffViewer.this.myRequest, SimpleThreesideDiffViewer.this.getFoldingModelSettings());
                SimpleThreesideDiffViewer.this.clearDiffPresentation();
                SimpleThreesideDiffViewer.this.resetChangeCounters();
                for (MergeLineFragment fragment : fragments) {
                    SimpleThreesideDiffChange change = new SimpleThreesideDiffChange(fragment, SimpleThreesideDiffViewer.this.getEditors(), comparisonPolicy);
                    SimpleThreesideDiffViewer.this.myDiffChanges.add(change);
                    SimpleThreesideDiffViewer.this.onChangeAdded(change);
                }
                SimpleThreesideDiffViewer.this.myFoldingModel.install(fragments, (UserDataHolder)SimpleThreesideDiffViewer.this.myRequest, SimpleThreesideDiffViewer.this.getFoldingModelSettings());
                SimpleThreesideDiffViewer.this.myInitialScrollHelper.onRediff();
                SimpleThreesideDiffViewer.this.myContentPanel.repaintDividers();
                SimpleThreesideDiffViewer.this.myStatusPanel.update();
            }
        };
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "apply"));
        }
        return runnable2;
    }

    @Override
    protected void destroyChangedBlocks() {
        super.destroyChangedBlocks();
        for (SimpleThreesideDiffChange change : this.myDiffChanges) {
            change.destroyHighlighter();
        }
        this.myDiffChanges.clear();
        for (SimpleThreesideDiffChange change : this.myInvalidDiffChanges) {
            change.destroyHighlighter();
        }
        this.myInvalidDiffChanges.clear();
    }

    @Override
    protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "onBeforeDocumentChange"));
        }
        super.onBeforeDocumentChange(e);
        if (this.myDiffChanges.isEmpty()) {
            return;
        }
        ThreeSide side = null;
        if (e.getDocument() == this.getEditor(ThreeSide.LEFT).getDocument()) {
            side = ThreeSide.LEFT;
        }
        if (e.getDocument() == this.getEditor(ThreeSide.RIGHT).getDocument()) {
            side = ThreeSide.RIGHT;
        }
        if (e.getDocument() == this.getEditor(ThreeSide.BASE).getDocument()) {
            side = ThreeSide.BASE;
        }
        if (side == null) {
            LOG.warn("Unknown document changed");
            return;
        }
        int line1 = e.getDocument().getLineNumber(e.getOffset());
        int line2 = e.getDocument().getLineNumber(e.getOffset() + e.getOldLength()) + 1;
        int shift = DiffUtil.countLinesShift(e);
        ArrayList<SimpleThreesideDiffChange> invalid = new ArrayList<SimpleThreesideDiffChange>();
        for (SimpleThreesideDiffChange change : this.myDiffChanges) {
            if (!change.processChange(line1, line2, shift, side)) continue;
            invalid.add(change);
        }
        if (!invalid.isEmpty()) {
            this.myDiffChanges.removeAll(invalid);
            this.myInvalidDiffChanges.addAll(invalid);
        }
    }

    @NotNull
    private IgnorePolicy getIgnorePolicy() {
        IgnorePolicy policy = this.getTextSettings().getIgnorePolicy();
        if (policy == IgnorePolicy.IGNORE_WHITESPACES_CHUNKS) {
            IgnorePolicy ignorePolicy = IgnorePolicy.IGNORE_WHITESPACES;
            if (ignorePolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getIgnorePolicy"));
            }
            return ignorePolicy;
        }
        IgnorePolicy ignorePolicy = policy;
        if (ignorePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getIgnorePolicy"));
        }
        return ignorePolicy;
    }

    @NotNull
    private HighlightPolicy getHighlightPolicy() {
        HighlightPolicy policy = this.getTextSettings().getHighlightPolicy();
        if (policy == HighlightPolicy.BY_WORD_SPLIT) {
            HighlightPolicy highlightPolicy = HighlightPolicy.BY_WORD;
            if (highlightPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getHighlightPolicy"));
            }
            return highlightPolicy;
        }
        if (policy == HighlightPolicy.DO_NOT_HIGHLIGHT) {
            HighlightPolicy highlightPolicy = HighlightPolicy.BY_LINE;
            if (highlightPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getHighlightPolicy"));
            }
            return highlightPolicy;
        }
        HighlightPolicy highlightPolicy = policy;
        if (highlightPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getHighlightPolicy"));
        }
        return highlightPolicy;
    }

    @NotNull
    public List<SimpleThreesideDiffChange> getChanges() {
        List<SimpleThreesideDiffChange> list = this.myDiffChanges;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getChanges"));
        }
        return list;
    }

    @Override
    @NotNull
    protected DiffDividerDrawUtil.DividerPaintable getDividerPaintable(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getDividerPaintable"));
        }
        MyDividerPaintable myDividerPaintable = new MyDividerPaintable(side);
        if (myDividerPaintable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getDividerPaintable"));
        }
        return myDividerPaintable;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "canShowRequest"));
        }
        return ThreesideTextDiffViewer.canShowRequest(context, request);
    }

    private class MyDividerPaintable
    implements DiffDividerDrawUtil.DividerPaintable {
        @NotNull
        private final Side mySide;

        public MyDividerPaintable(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyDividerPaintable", "<init>"));
            }
            this.mySide = side;
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
            if (handler2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyDividerPaintable", "process"));
            }
            ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
            ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
            for (SimpleThreesideDiffChange diffChange : SimpleThreesideDiffViewer.this.myDiffChanges) {
                if (!diffChange.isChange(this.mySide) || handler2.process(diffChange.getStartLine(left), diffChange.getEndLine(left), diffChange.getStartLine(right), diffChange.getEndLine(right), diffChange.getDiffType().getColor(SimpleThreesideDiffViewer.this.getEditor(ThreeSide.BASE)))) continue;
                return;
            }
        }
    }

    protected class MyEditorReadOnlyLockAction
    extends TextDiffViewerUtil.EditorReadOnlyLockAction {
        public MyEditorReadOnlyLockAction() {
            super(SimpleThreesideDiffViewer.this.getContext(), SimpleThreesideDiffViewer.this.getEditableEditors());
        }
    }

    private class MyHighlightPolicySettingAction
    extends TextDiffViewerUtil.HighlightPolicySettingAction {
        public MyHighlightPolicySettingAction() {
            super(SimpleThreesideDiffViewer.this.getTextSettings());
        }

        @Override
        @NotNull
        protected HighlightPolicy getCurrentSetting() {
            HighlightPolicy highlightPolicy = SimpleThreesideDiffViewer.this.getHighlightPolicy();
            if (highlightPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyHighlightPolicySettingAction", "getCurrentSetting"));
            }
            return highlightPolicy;
        }

        @Override
        @NotNull
        protected List<HighlightPolicy> getAvailableSettings() {
            List list = ContainerUtil.list((Object[])new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD});
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyHighlightPolicySettingAction", "getAvailableSettings"));
            }
            return list;
        }

        @Override
        protected void onSettingsChanged() {
            SimpleThreesideDiffViewer.this.rediff();
        }
    }

    private class MyIgnorePolicySettingAction
    extends TextDiffViewerUtil.IgnorePolicySettingAction {
        public MyIgnorePolicySettingAction() {
            super(SimpleThreesideDiffViewer.this.getTextSettings());
        }

        @Override
        @NotNull
        protected IgnorePolicy getCurrentSetting() {
            IgnorePolicy ignorePolicy = SimpleThreesideDiffViewer.this.getIgnorePolicy();
            if (ignorePolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyIgnorePolicySettingAction", "getCurrentSetting"));
            }
            return ignorePolicy;
        }

        @Override
        @NotNull
        protected List<IgnorePolicy> getAvailableSettings() {
            ArrayList settings = ContainerUtil.newArrayList((Object[])IgnorePolicy.values());
            settings.remove((Object)IgnorePolicy.IGNORE_WHITESPACES_CHUNKS);
            ArrayList arrayList = settings;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyIgnorePolicySettingAction", "getAvailableSettings"));
            }
            return arrayList;
        }

        @Override
        protected void onSettingsChanged() {
            SimpleThreesideDiffViewer.this.rediff();
        }
    }
}

