/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffTool;
import com.intellij.diff.SuppressiveDiffTool;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Function;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffUtil {
    private static final Logger LOG = Logger.getInstance(DiffUtil.class);
    @NotNull
    public static final String DIFF_CONFIG = "$APP_CONFIG$/diff.xml";

    @Nullable
    public static EditorHighlighter initEditorHighlighter(@Nullable Project project, @NotNull DocumentContent content, @NotNull CharSequence text) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "initEditorHighlighter"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "initEditorHighlighter"));
        }
        EditorHighlighter highlighter = DiffUtil.createEditorHighlighter(project, content);
        if (highlighter == null) {
            return null;
        }
        highlighter.setText(text);
        return highlighter;
    }

    @NotNull
    public static EditorHighlighter initEmptyEditorHighlighter(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "initEmptyEditorHighlighter"));
        }
        EditorHighlighter highlighter = DiffUtil.createEmptyEditorHighlighter();
        highlighter.setText(text);
        EditorHighlighter editorHighlighter = highlighter;
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "initEmptyEditorHighlighter"));
        }
        return editorHighlighter;
    }

    @Nullable
    public static EditorHighlighter createEditorHighlighter(@Nullable Project project, @NotNull DocumentContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "createEditorHighlighter"));
        }
        FileType type = content.getContentType();
        VirtualFile file2 = content.getHighlightFile();
        if (file2 != null && file2.getFileType() == type || file2 instanceof LightVirtualFile) {
            return EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file2);
        }
        if (type != null) {
            return EditorHighlighterFactory.getInstance().createEditorHighlighter(project, type);
        }
        return null;
    }

    @NotNull
    public static EditorHighlighter createEmptyEditorHighlighter() {
        EmptyEditorHighlighter emptyEditorHighlighter = new EmptyEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme().getAttributes(HighlighterColors.TEXT));
        if (emptyEditorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createEmptyEditorHighlighter"));
        }
        return emptyEditorHighlighter;
    }

    public static void setEditorHighlighter(@Nullable Project project, @NotNull EditorEx editor, @NotNull DocumentContent content) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "setEditorHighlighter"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "setEditorHighlighter"));
        }
        EditorHighlighter highlighter = DiffUtil.createEditorHighlighter(project, content);
        if (highlighter != null) {
            editor.setHighlighter(highlighter);
        }
    }

    public static void setEditorCodeStyle(@Nullable Project project, @NotNull EditorEx editor, @Nullable FileType fileType) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "setEditorCodeStyle"));
        }
        if (project != null && fileType != null) {
            CodeStyleFacade codeStyleFacade = CodeStyleFacade.getInstance((Project)project);
            editor.getSettings().setTabSize(codeStyleFacade.getTabSize(fileType));
            editor.getSettings().setUseTabCharacter(codeStyleFacade.useTabCharacter(fileType));
        }
        editor.getSettings().setCaretRowShown(false);
        editor.reinitSettings();
    }

    public static void setFoldingModelSupport(@NotNull EditorEx editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "setFoldingModelSupport"));
        }
        editor.getSettings().setFoldingOutlineShown(true);
        editor.getSettings().setAutoCodeFoldingEnabled(false);
        editor.getColorsScheme().setAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES, null);
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document, @Nullable Project project, boolean isViewer) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "createEditor"));
        }
        EditorEx editorEx = DiffUtil.createEditor(document, project, isViewer, false);
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createEditor"));
        }
        return editorEx;
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document, @Nullable Project project, boolean isViewer, boolean enableFolding) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "createEditor"));
        }
        EditorFactory factory = EditorFactory.getInstance();
        EditorEx editor = (EditorEx)(isViewer ? factory.createViewer(document, project) : factory.createEditor(document, project));
        editor.putUserData(DiffManagerImpl.EDITOR_IS_DIFF_KEY, Boolean.TRUE);
        editor.getSettings().setShowIntentionBulb(false);
        ((EditorMarkupModel)((Object)editor.getMarkupModel())).setErrorStripeVisible(true);
        editor.getGutterComponentEx().setShowDefaultGutterPopup(false);
        if (enableFolding) {
            DiffUtil.setFoldingModelSupport(editor);
        } else {
            editor.getSettings().setFoldingOutlineShown(false);
            editor.getFoldingModel().setFoldingEnabled(false);
        }
        UIUtil.removeScrollBorder((Component)editor.getComponent());
        EditorEx editorEx = editor;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createEditor"));
        }
        return editorEx;
    }

    public static void configureEditor(@NotNull EditorEx editor, @NotNull DocumentContent content, @Nullable Project project) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "configureEditor"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "configureEditor"));
        }
        DiffUtil.setEditorHighlighter(project, editor, content);
        DiffUtil.setEditorCodeStyle(project, editor, content.getContentType());
        editor.reinitSettings();
    }

    public static boolean isMirrored(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "isMirrored"));
        }
        if (editor instanceof EditorEx) {
            return ((EditorEx)editor).getVerticalScrollbarOrientation() == 0;
        }
        return false;
    }

    public static void moveCaret(@Nullable Editor editor, int line) {
        if (editor == null) {
            return;
        }
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, 0));
    }

    public static void scrollEditor(@Nullable Editor editor, int line, boolean animated) {
        DiffUtil.scrollEditor(editor, line, 0, animated);
    }

    public static void scrollEditor(@Nullable Editor editor, int line, int column, boolean animated) {
        if (editor == null) {
            return;
        }
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, column));
        DiffUtil.scrollToCaret(editor, animated);
    }

    public static void scrollToPoint(@Nullable Editor editor, @NotNull Point point, boolean animated) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/diff/util/DiffUtil", "scrollToPoint"));
        }
        if (editor == null) {
            return;
        }
        if (!animated) {
            editor.getScrollingModel().disableAnimation();
        }
        editor.getScrollingModel().scrollHorizontally(point.x);
        editor.getScrollingModel().scrollVertically(point.y);
        if (!animated) {
            editor.getScrollingModel().enableAnimation();
        }
    }

    public static void scrollToCaret(@Nullable Editor editor, boolean animated) {
        if (editor == null) {
            return;
        }
        if (!animated) {
            editor.getScrollingModel().disableAnimation();
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        if (!animated) {
            editor.getScrollingModel().enableAnimation();
        }
    }

    @NotNull
    public static Point getScrollingPosition(@Nullable Editor editor) {
        if (editor == null) {
            Point point = new Point(0, 0);
            if (point == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getScrollingPosition"));
            }
            return point;
        }
        ScrollingModel model = editor.getScrollingModel();
        Point point = new Point(model.getHorizontalScrollOffset(), model.getVerticalScrollOffset());
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getScrollingPosition"));
        }
        return point;
    }

    @NotNull
    public static LogicalPosition getCaretPosition(@Nullable Editor editor) {
        LogicalPosition logicalPosition = editor != null ? editor.getCaretModel().getLogicalPosition() : new LogicalPosition(0, 0);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getCaretPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public static Icon getArrowIcon(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/util/DiffUtil", "getArrowIcon"));
        }
        Icon icon = (Icon)sourceSide.select((Object)AllIcons.Diff.ArrowRight, (Object)AllIcons.Diff.Arrow);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getArrowIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getArrowDownIcon(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/util/DiffUtil", "getArrowDownIcon"));
        }
        Icon icon = (Icon)sourceSide.select((Object)AllIcons.Diff.ArrowRightDown, (Object)AllIcons.Diff.ArrowLeftDown);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getArrowDownIcon"));
        }
        return icon;
    }

    public static void registerAction(@NotNull AnAction action, @NotNull JComponent component) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/diff/util/DiffUtil", "registerAction"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/diff/util/DiffUtil", "registerAction"));
        }
        action.registerCustomShortcutSet(action.getShortcutSet(), component);
    }

    @NotNull
    public static JPanel createMessagePanel(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/diff/util/DiffUtil", "createMessagePanel"));
        }
        Pair<JPanel, JLabel> pair = DiffUtil.createMessagePanel();
        ((JLabel)pair.getSecond()).setText(message);
        JPanel jPanel = (JPanel)pair.getFirst();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createMessagePanel"));
        }
        return jPanel;
    }

    @NotNull
    public static Pair<JPanel, JLabel> createMessagePanel() {
        JLabel label = new JLabel();
        label.setForeground(UIUtil.getInactiveTextColor());
        JPanel wrapper = DiffUtil.createMessagePanel(label);
        Pair pair = Pair.create((Object)wrapper, (Object)label);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createMessagePanel"));
        }
        return pair;
    }

    @NotNull
    public static JPanel createMessagePanel(@NotNull JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/diff/util/DiffUtil", "createMessagePanel"));
        }
        JPanel wrapper = new JPanel(new GridBagLayout());
        wrapper.add((Component)comp, new GridBag().insets((Insets)JBUI.insets((int)1)));
        JPanel jPanel = wrapper;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createMessagePanel"));
        }
        return jPanel;
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group, AnAction ... actions) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/diff/util/DiffUtil", "addActionBlock"));
        }
        if (actions.length == 0) {
            return;
        }
        if (group.getChildrenCount() != 0) {
            group.addSeparator();
        }
        for (AnAction action : actions) {
            if (action == null) continue;
            group.add(action);
        }
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group, @Nullable List<? extends AnAction> actions) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/diff/util/DiffUtil", "addActionBlock"));
        }
        if (actions == null || actions.isEmpty()) {
            return;
        }
        if (group.getChildrenCount() != 0) {
            group.addSeparator();
        }
        group.addAll(actions);
    }

    @NotNull
    public static String getSettingsConfigurablePath() {
        if ("Settings | Tools | Diff" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getSettingsConfigurablePath"));
        }
        return "Settings | Tools | Diff";
    }

    @NotNull
    public static String createTooltipText(@NotNull String text, @Nullable String appendix) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "createTooltipText"));
        }
        StringBuilder result2 = new StringBuilder();
        result2.append("<html><body>");
        result2.append(text);
        if (appendix != null) {
            result2.append("<br><div style='margin-top: 5px'><font size='2'>");
            result2.append(appendix);
            result2.append("</font></div>");
        }
        result2.append("</body></html>");
        String string = result2.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTooltipText"));
        }
        return string;
    }

    @NotNull
    public static String createNotificationText(@NotNull String text, @Nullable String appendix) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "createNotificationText"));
        }
        StringBuilder result2 = new StringBuilder();
        result2.append("<html><body>");
        result2.append(text);
        if (appendix != null) {
            result2.append("<br><span style='color:#").append(ColorUtil.toHex((Color)JBColor.gray)).append("'><small>");
            result2.append(appendix);
            result2.append("</small></span>");
        }
        result2.append("</body></html>");
        String string = result2.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createNotificationText"));
        }
        return string;
    }

    @NotNull
    public static List<JComponent> createSimpleTitles(@NotNull ContentDiffRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "createSimpleTitles"));
        }
        List titles = request.getContentTitles();
        if (!ContainerUtil.exists((Iterable)titles, (Condition)Condition.NOT_NULL)) {
            List<Object> list = Collections.nCopies(titles.size(), null);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createSimpleTitles"));
            }
            return list;
        }
        ArrayList<JComponent> components = new ArrayList<JComponent>(titles.size());
        for (String title : titles) {
            components.add(DiffUtil.createTitle(StringUtil.notNullize((String)title)));
        }
        ArrayList<JComponent> arrayList = components;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createSimpleTitles"));
        }
        return arrayList;
    }

    @NotNull
    public static List<JComponent> createTextTitles(@NotNull ContentDiffRequest request, @NotNull List<? extends Editor> editors) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "createTextTitles"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/util/DiffUtil", "createTextTitles"));
        }
        List contents = request.getContents();
        List titles = request.getContentTitles();
        List charsets = ContainerUtil.map((Collection)contents, (Function)new Function<DiffContent, Charset>(){

            public Charset fun(DiffContent content) {
                if (content instanceof EmptyContent) {
                    return null;
                }
                return ((DocumentContent)content).getCharset();
            }
        });
        List separators = ContainerUtil.map((Collection)contents, (Function)new Function<DiffContent, LineSeparator>(){

            public LineSeparator fun(DiffContent content) {
                if (content instanceof EmptyContent) {
                    return null;
                }
                return ((DocumentContent)content).getLineSeparator();
            }
        });
        boolean equalCharsets = DiffUtil.isEqualElements(charsets);
        boolean equalSeparators = DiffUtil.isEqualElements(separators);
        ArrayList<JComponent> result2 = new ArrayList<JComponent>(contents.size());
        if (equalCharsets && equalSeparators && !ContainerUtil.exists((Iterable)titles, (Condition)Condition.NOT_NULL)) {
            List<Object> list = Collections.nCopies(titles.size(), null);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTextTitles"));
            }
            return list;
        }
        for (int i = 0; i < contents.size(); ++i) {
            result2.add(DiffUtil.createTitle(StringUtil.notNullize((String)((String)titles.get(i))), (DiffContent)contents.get(i), equalCharsets, equalSeparators, editors.get(i)));
        }
        ArrayList<JComponent> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTextTitles"));
        }
        return arrayList;
    }

    private static boolean isEqualElements(@NotNull List elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/diff/util/DiffUtil", "isEqualElements"));
        }
        for (int i = 0; i < elements.size(); ++i) {
            for (int j = i + 1; j < elements.size(); ++j) {
                if (DiffUtil.isEqualElements(elements.get(i), elements.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isEqualElements(@Nullable Object element1, @Nullable Object element2) {
        if (element1 == null || element2 == null) {
            return true;
        }
        return element1.equals(element2);
    }

    @Nullable
    private static JComponent createTitle(@NotNull String title, @NotNull DiffContent content, boolean equalCharsets, boolean equalSeparators, @Nullable Editor editor) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        if (content instanceof EmptyContent) {
            return null;
        }
        Charset charset = equalCharsets ? null : ((DocumentContent)content).getCharset();
        LineSeparator separator = equalSeparators ? null : ((DocumentContent)content).getLineSeparator();
        boolean isReadOnly = editor == null || editor.isViewer() || !DiffUtil.canMakeWritable(editor.getDocument());
        return DiffUtil.createTitle(title, charset, separator, isReadOnly);
    }

    @NotNull
    public static JComponent createTitle(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        JComponent jComponent = DiffUtil.createTitle(title, null, null, true);
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        return jComponent;
    }

    @NotNull
    public static JComponent createTitle(@NotNull String title, @Nullable Charset charset, @Nullable LineSeparator separator, boolean readOnly) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        if (readOnly) {
            title = title + " " + DiffBundle.message((String)"diff.content.read.only.content.title.suffix", (Object[])new Object[0]);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)4, (int)0, (int)4));
        panel.add((Component)new JBLabel(title).setCopyable(true), "Center");
        if (charset != null && separator != null) {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 0));
            panel2.add(DiffUtil.createCharsetPanel(charset));
            panel2.add(Box.createRigidArea(new Dimension(4, 0)));
            panel2.add(DiffUtil.createSeparatorPanel(separator));
            panel.add((Component)panel2, "East");
        } else if (charset != null) {
            panel.add((Component)DiffUtil.createCharsetPanel(charset), "East");
        } else if (separator != null) {
            panel.add((Component)DiffUtil.createSeparatorPanel(separator), "East");
        }
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        return jPanel;
    }

    @NotNull
    private static JComponent createCharsetPanel(@NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/diff/util/DiffUtil", "createCharsetPanel"));
        }
        JLabel label = new JLabel(charset.displayName());
        if (charset.equals(Charset.forName("UTF-8"))) {
            label.setForeground((Color)JBColor.BLUE);
        } else if (charset.equals(Charset.forName("ISO-8859-1"))) {
            label.setForeground((Color)JBColor.RED);
        } else {
            label.setForeground((Color)JBColor.BLACK);
        }
        JLabel jLabel = label;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createCharsetPanel"));
        }
        return jLabel;
    }

    @NotNull
    private static JComponent createSeparatorPanel(@NotNull LineSeparator separator) {
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/diff/util/DiffUtil", "createSeparatorPanel"));
        }
        JLabel label = new JLabel(separator.name());
        Object color = separator == LineSeparator.CRLF ? JBColor.RED : (separator == LineSeparator.LF ? JBColor.BLUE : (separator == LineSeparator.CR ? JBColor.MAGENTA : JBColor.BLACK));
        label.setForeground((Color)color);
        JLabel jLabel = label;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createSeparatorPanel"));
        }
        return jLabel;
    }

    @NotNull
    public static List<JComponent> createSyncHeightComponents(@NotNull List<JComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/diff/util/DiffUtil", "createSyncHeightComponents"));
        }
        if (!ContainerUtil.exists(components, (Condition)Condition.NOT_NULL)) {
            List<JComponent> list = components;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createSyncHeightComponents"));
            }
            return list;
        }
        ArrayList<JComponent> result2 = new ArrayList<JComponent>();
        for (int i = 0; i < components.size(); ++i) {
            result2.add(new SyncHeightComponent(components, i));
        }
        ArrayList<JComponent> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createSyncHeightComponents"));
        }
        return arrayList;
    }

    public static boolean isFocusedComponent(@Nullable Component component) {
        return DiffUtil.isFocusedComponent(null, component);
    }

    public static boolean isFocusedComponent(@Nullable Project project, @Nullable Component component) {
        if (component == null) {
            return false;
        }
        return IdeFocusManager.getInstance((Project)project).getFocusedDescendantFor(component) != null;
    }

    public static void requestFocus(@Nullable Project project, @Nullable Component component) {
        if (component == null) {
            return;
        }
        IdeFocusManager.getInstance((Project)project).requestFocus(component, true);
    }

    @NotNull
    public static List<LineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull DiffConfig config, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/util/DiffUtil", "compare"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/util/DiffUtil", "compare"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/diff/util/DiffUtil", "compare"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/util/DiffUtil", "compare"));
        }
        indicator.checkCanceled();
        List fragments = config.innerFragments ? ComparisonManager.getInstance().compareLinesInner(text1, text2, config.policy, indicator) : ComparisonManager.getInstance().compareLines(text1, text2, config.policy, indicator);
        indicator.checkCanceled();
        List list = ComparisonManager.getInstance().processBlocks(fragments, text1, text2, config.policy, config.squashFragments, config.trimFragments);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "compare"));
        }
        return list;
    }

    @Nullable
    public static List<MergeWordFragment> compareThreesideInner(@NotNull CharSequence[] chunks, @NotNull ComparisonPolicy comparisonPolicy, @NotNull ProgressIndicator indicator) {
        if (chunks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunks", "com/intellij/diff/util/DiffUtil", "compareThreesideInner"));
        }
        if (comparisonPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparisonPolicy", "com/intellij/diff/util/DiffUtil", "compareThreesideInner"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/util/DiffUtil", "compareThreesideInner"));
        }
        if (chunks[0] == null && chunks[1] == null && chunks[2] == null) {
            return null;
        }
        if (comparisonPolicy == ComparisonPolicy.IGNORE_WHITESPACES && DiffUtil.isChunksEquals(chunks[0], chunks[1], comparisonPolicy) && DiffUtil.isChunksEquals(chunks[0], chunks[2], comparisonPolicy)) {
            return Collections.emptyList();
        }
        if (chunks[0] == null && chunks[1] == null || chunks[0] == null && chunks[2] == null || chunks[1] == null && chunks[2] == null) {
            return null;
        }
        if (chunks[0] != null && chunks[1] != null && chunks[2] != null) {
            return ByWord.compare(chunks[0], chunks[1], chunks[2], comparisonPolicy, indicator);
        }
        final ThreeSide side1 = chunks[0] != null ? ThreeSide.LEFT : ThreeSide.BASE;
        final ThreeSide side2 = chunks[2] != null ? ThreeSide.RIGHT : ThreeSide.BASE;
        CharSequence chunk1 = (CharSequence)side1.select((Object[])chunks);
        CharSequence chunk2 = (CharSequence)side2.select((Object[])chunks);
        if (chunks[1] != null && DiffUtil.isChunksEquals(chunk1, chunk2, comparisonPolicy)) {
            return null;
        }
        List<DiffFragment> wordConflicts = ByWord.compare(chunk1, chunk2, comparisonPolicy, indicator);
        return ContainerUtil.map(wordConflicts, (Function)new Function<DiffFragment, MergeWordFragment>(){

            public MergeWordFragment fun(DiffFragment fragment) {
                return new MyWordFragment(side1, side2, fragment);
            }
        });
    }

    private static boolean isChunksEquals(@Nullable CharSequence chunk1, @Nullable CharSequence chunk2, @NotNull ComparisonPolicy comparisonPolicy) {
        if (comparisonPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparisonPolicy", "com/intellij/diff/util/DiffUtil", "isChunksEquals"));
        }
        if (chunk1 == null) {
            chunk1 = "";
        }
        if (chunk2 == null) {
            chunk2 = "";
        }
        return ComparisonManager.getInstance().isEquals(chunk1, chunk2, comparisonPolicy);
    }

    @NotNull
    public static BitSet getSelectedLines(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "getSelectedLines"));
        }
        Document document = editor.getDocument();
        int totalLines = DiffUtil.getLineCount(document);
        BitSet lines = new BitSet(totalLines + 1);
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            if (caret.hasSelection()) {
                int line1 = editor.offsetToLogicalPosition((int)caret.getSelectionStart()).line;
                int line2 = editor.offsetToLogicalPosition((int)caret.getSelectionEnd()).line;
                lines.set(line1, line2 + 1);
                if (caret.getSelectionEnd() != document.getTextLength()) continue;
                lines.set(totalLines);
                continue;
            }
            lines.set(caret.getLogicalPosition().line);
            if (caret.getOffset() != document.getTextLength()) continue;
            lines.set(totalLines);
        }
        BitSet bitSet = lines;
        if (bitSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getSelectedLines"));
        }
        return bitSet;
    }

    public static boolean isSelectedByLine(int line, int line1, int line2) {
        if (line1 == line2 && line == line1) {
            return true;
        }
        return line >= line1 && line < line2;
    }

    public static boolean isSelectedByLine(@NotNull BitSet selected, int line1, int line2) {
        if (selected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selected", "com/intellij/diff/util/DiffUtil", "isSelectedByLine"));
        }
        if (line1 == line2) {
            return selected.get(line1);
        }
        int next = selected.nextSetBit(line1);
        return next != -1 && next < line2;
    }

    public static void deleteLines(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "deleteLines"));
        }
        TextRange range = DiffUtil.getLinesRange(document, line1, line2);
        int offset1 = range.getStartOffset();
        int offset2 = range.getEndOffset();
        if (offset1 > 0) {
            --offset1;
        } else if (offset2 < document.getTextLength()) {
            ++offset2;
        }
        document.deleteString(offset1, offset2);
    }

    public static void insertLines(@NotNull Document document, int line, @NotNull CharSequence text) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "insertLines"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "insertLines"));
        }
        if (line == DiffUtil.getLineCount(document)) {
            document.insertString(document.getTextLength(), (CharSequence)("\n" + text));
        } else {
            document.insertString(document.getLineStartOffset(line), (CharSequence)(text + "\n"));
        }
    }

    public static void replaceLines(@NotNull Document document, int line1, int line2, @NotNull CharSequence text) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "replaceLines"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "replaceLines"));
        }
        TextRange currentTextRange = DiffUtil.getLinesRange(document, line1, line2);
        int offset1 = currentTextRange.getStartOffset();
        int offset2 = currentTextRange.getEndOffset();
        document.replaceString(offset1, offset2, text);
    }

    public static void insertLines(@NotNull Document document1, int line, @NotNull Document document2, int otherLine1, int otherLine2) {
        if (document1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document1", "com/intellij/diff/util/DiffUtil", "insertLines"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document2", "com/intellij/diff/util/DiffUtil", "insertLines"));
        }
        DiffUtil.insertLines(document1, line, DiffUtil.getLinesContent(document2, otherLine1, otherLine2));
    }

    public static void replaceLines(@NotNull Document document1, int line1, int line2, @NotNull Document document2, int oLine1, int oLine2) {
        if (document1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document1", "com/intellij/diff/util/DiffUtil", "replaceLines"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document2", "com/intellij/diff/util/DiffUtil", "replaceLines"));
        }
        DiffUtil.replaceLines(document1, line1, line2, DiffUtil.getLinesContent(document2, oLine1, oLine2));
    }

    public static void applyModification(@NotNull Document document1, int line1, int line2, @NotNull Document document2, int oLine1, int oLine2) {
        if (document1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document1", "com/intellij/diff/util/DiffUtil", "applyModification"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document2", "com/intellij/diff/util/DiffUtil", "applyModification"));
        }
        if (line1 == line2 && oLine1 == oLine2) {
            return;
        }
        if (line1 == line2) {
            DiffUtil.insertLines(document1, line1, document2, oLine1, oLine2);
        } else if (oLine1 == oLine2) {
            DiffUtil.deleteLines(document1, line1, line2);
        } else {
            DiffUtil.replaceLines(document1, line1, line2, document2, oLine1, oLine2);
        }
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLinesContent"));
        }
        TextRange otherRange = DiffUtil.getLinesRange(document, line1, line2);
        CharSequence charSequence = document.getImmutableCharSequence().subSequence(otherRange.getStartOffset(), otherRange.getEndOffset());
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLinesContent"));
        }
        return charSequence;
    }

    public static TextRange getLinesRange(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
        }
        return DiffUtil.getLinesRange(document, line1, line2, false);
    }

    @NotNull
    public static TextRange getLinesRange(@NotNull Document document, int line1, int line2, boolean includeNewline) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
        }
        if (line1 == line2) {
            int lineStartOffset = line1 < DiffUtil.getLineCount(document) ? document.getLineStartOffset(line1) : document.getTextLength();
            TextRange textRange = new TextRange(lineStartOffset, lineStartOffset);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
            }
            return textRange;
        }
        int startOffset = document.getLineStartOffset(line1);
        int endOffset = document.getLineEndOffset(line2 - 1);
        if (includeNewline && endOffset < document.getTextLength()) {
            ++endOffset;
        }
        TextRange textRange = new TextRange(startOffset, endOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
        }
        return textRange;
    }

    public static int getOffset(@NotNull Document document, int line, int column) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getOffset"));
        }
        if (line < 0) {
            return 0;
        }
        if (line >= DiffUtil.getLineCount(document)) {
            return document.getTextLength();
        }
        int start = document.getLineStartOffset(line);
        int end = document.getLineEndOffset(line);
        return Math.min(start + column, end);
    }

    public static int getLineCount(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLineCount"));
        }
        return Math.max(document.getLineCount(), 1);
    }

    public static int countLinesShift(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/util/DiffUtil", "countLinesShift"));
        }
        return StringUtil.countNewLines((CharSequence)e.getNewFragment()) - StringUtil.countNewLines((CharSequence)e.getOldFragment());
    }

    @NotNull
    public static UpdatedLineRange updateRangeOnModification(int start, int end, int changeStart, int changeEnd, int shift) {
        UpdatedLineRange updatedLineRange = DiffUtil.updateRangeOnModification(start, end, changeStart, changeEnd, shift, false);
        if (updatedLineRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
        }
        return updatedLineRange;
    }

    @NotNull
    public static UpdatedLineRange updateRangeOnModification(int start, int end, int changeStart, int changeEnd, int shift, boolean greedy) {
        if (end <= changeStart) {
            UpdatedLineRange updatedLineRange = new UpdatedLineRange(start, end, false);
            if (updatedLineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
            }
            return updatedLineRange;
        }
        if (start >= changeEnd) {
            UpdatedLineRange updatedLineRange = new UpdatedLineRange(start + shift, end + shift, false);
            if (updatedLineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
            }
            return updatedLineRange;
        }
        if (start <= changeStart && end >= changeEnd) {
            UpdatedLineRange updatedLineRange = new UpdatedLineRange(start, end + shift, false);
            if (updatedLineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
            }
            return updatedLineRange;
        }
        int newChangeEnd = changeEnd + shift;
        if (start >= changeStart && end <= changeEnd) {
            UpdatedLineRange updatedLineRange = greedy ? new UpdatedLineRange(changeStart, newChangeEnd, true) : new UpdatedLineRange(newChangeEnd, newChangeEnd, true);
            if (updatedLineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
            }
            return updatedLineRange;
        }
        if (start < changeStart) {
            UpdatedLineRange updatedLineRange = greedy ? new UpdatedLineRange(start, newChangeEnd, true) : new UpdatedLineRange(start, changeStart, true);
            if (updatedLineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
            }
            return updatedLineRange;
        }
        UpdatedLineRange updatedLineRange = greedy ? new UpdatedLineRange(changeStart, end + shift, true) : new UpdatedLineRange(newChangeEnd, end + shift, true);
        if (updatedLineRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "updateRangeOnModification"));
        }
        return updatedLineRange;
    }

    @NotNull
    public static TextDiffType getLineDiffType(@NotNull LineFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "getLineDiffType"));
        }
        boolean left = fragment.getStartLine1() != fragment.getEndLine1();
        boolean right = fragment.getStartLine2() != fragment.getEndLine2();
        TextDiffType textDiffType = DiffUtil.getType(left, right);
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLineDiffType"));
        }
        return textDiffType;
    }

    @NotNull
    public static TextDiffType getDiffType(@NotNull DiffFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "getDiffType"));
        }
        boolean left = fragment.getEndOffset1() != fragment.getStartOffset1();
        boolean right = fragment.getEndOffset2() != fragment.getStartOffset2();
        TextDiffType textDiffType = DiffUtil.getType(left, right);
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDiffType"));
        }
        return textDiffType;
    }

    private static TextDiffType getType(boolean left, boolean right) {
        if (left && right) {
            return TextDiffType.MODIFIED;
        }
        if (left) {
            return TextDiffType.DELETED;
        }
        if (right) {
            return TextDiffType.INSERTED;
        }
        LOG.error("DiffFragment should not be empty");
        return TextDiffType.MODIFIED;
    }

    public static void executeWriteCommand(@NotNull Document document, @Nullable Project project, @Nullable String name, final @NotNull Runnable task) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "executeWriteCommand"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/diff/util/DiffUtil", "executeWriteCommand"));
        }
        new DiffCommandAction(project, document, name){

            @Override
            protected void execute() {
                task.run();
            }
        }.run();
    }

    public static boolean isEditable(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "isEditable"));
        }
        return !editor.isViewer() && DiffUtil.canMakeWritable(editor.getDocument());
    }

    public static boolean canMakeWritable(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "canMakeWritable"));
        }
        if (document.isWritable()) {
            return true;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null && file2.isValid() && file2.isInLocalFileSystem()) {
            return !file2.isWritable();
        }
        return false;
    }

    public static boolean makeWritable(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "makeWritable"));
        }
        if (document.isWritable()) {
            return true;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null || !file2.isValid()) {
            return false;
        }
        return DiffUtil.makeWritable(project, file2) && document.isWritable();
    }

    public static boolean makeWritable(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/util/DiffUtil", "makeWritable"));
        }
        if (file2.isWritable()) {
            return true;
        }
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        return !ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{file2}).hasReadonlyFiles();
    }

    @NotNull
    public static Dimension getDefaultDiffPanelSize() {
        Dimension dimension = new Dimension(400, 200);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDefaultDiffPanelSize"));
        }
        return dimension;
    }

    @NotNull
    public static Dimension getDefaultDiffWindowSize() {
        Rectangle screenBounds = ScreenUtil.getMainScreenBounds();
        int width = (int)((double)screenBounds.width * 0.8);
        int height = (int)((double)screenBounds.height * 0.8);
        Dimension dimension = new Dimension(width, height);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDefaultDiffWindowSize"));
        }
        return dimension;
    }

    @NotNull
    public static WindowWrapper.Mode getWindowMode(@NotNull DiffDialogHints hints) {
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/diff/util/DiffUtil", "getWindowMode"));
        }
        WindowWrapper.Mode mode = hints.getMode();
        if (mode == null) {
            boolean isUnderDialog = LaterInvocator.isInModalContext();
            mode = isUnderDialog ? WindowWrapper.Mode.MODAL : WindowWrapper.Mode.FRAME;
        }
        WindowWrapper.Mode mode2 = mode;
        if (mode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getWindowMode"));
        }
        return mode2;
    }

    public static void closeWindow(@Nullable Window window, boolean modalOnly, boolean recursive) {
        if (window == null) {
            return;
        }
        Container component = window;
        while (component != null) {
            if (component instanceof Window) {
                DiffUtil.closeWindow(component, modalOnly);
            }
            component = recursive ? component.getParent() : null;
        }
    }

    public static void closeWindow(@NotNull Window window, boolean modalOnly) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/diff/util/DiffUtil", "closeWindow"));
        }
        if (window instanceof IdeFrameImpl) {
            return;
        }
        if (modalOnly && window instanceof Frame) {
            return;
        }
        if (window instanceof DialogWrapperDialog) {
            ((DialogWrapperDialog)window).getDialogWrapper().doCancelAction();
            return;
        }
        window.setVisible(false);
        window.dispose();
    }

    public static <T> UserDataHolderBase createUserDataHolder(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/DiffUtil", "createUserDataHolder"));
        }
        UserDataHolderBase holder = new UserDataHolderBase();
        holder.putUserData(key, value);
        return holder;
    }

    public static boolean isUserDataFlagSet(@NotNull Key<Boolean> key, UserDataHolder ... holders) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/DiffUtil", "isUserDataFlagSet"));
        }
        for (UserDataHolder holder : holders) {
            Boolean data;
            if (holder == null || (data = (Boolean)holder.getUserData(key)) == null) continue;
            return data;
        }
        return false;
    }

    public static <T> T getUserData(@Nullable UserDataHolder first, @Nullable UserDataHolder second, @NotNull Key<T> key) {
        Object data;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/DiffUtil", "getUserData"));
        }
        if (first != null && (data = first.getUserData(key)) != null) {
            return (T)data;
        }
        if (second != null && (data = second.getUserData(key)) != null) {
            return (T)data;
        }
        return null;
    }

    public static void addNotification(@NotNull JComponent component, @NotNull UserDataHolder holder) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/diff/util/DiffUtil", "addNotification"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/diff/util/DiffUtil", "addNotification"));
        }
        List components = (List)holder.getUserData(DiffUserDataKeys.NOTIFICATIONS);
        if (components == null) {
            holder.putUserData(DiffUserDataKeys.NOTIFICATIONS, Collections.singletonList(component));
        } else {
            holder.putUserData(DiffUserDataKeys.NOTIFICATIONS, (Object)ContainerUtil.append((List)components, (Object[])new JComponent[]{component}));
        }
    }

    public static List<JComponent> getCustomNotifications(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/util/DiffUtil", "getCustomNotifications"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "getCustomNotifications"));
        }
        List requestComponents = (List)request.getUserData(DiffUserDataKeys.NOTIFICATIONS);
        List contextComponents = (List)context.getUserData(DiffUserDataKeys.NOTIFICATIONS);
        return ContainerUtil.concat((List)ContainerUtil.notNullize((List)contextComponents), (List)ContainerUtil.notNullize((List)requestComponents));
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull ContentDiffRequest request, @NotNull Side currentSide) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "getVirtualFile"));
        }
        if (currentSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSide", "com/intellij/diff/util/DiffUtil", "getVirtualFile"));
        }
        List contents = request.getContents();
        DiffContent content1 = (DiffContent)currentSide.select(contents);
        DiffContent content2 = (DiffContent)currentSide.other().select(contents);
        if (content1 instanceof FileContent) {
            return ((FileContent)content1).getFile();
        }
        if (content2 instanceof FileContent) {
            return ((FileContent)content2).getFile();
        }
        return null;
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull ContentDiffRequest request, @NotNull ThreeSide currentSide) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "getVirtualFile"));
        }
        if (currentSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSide", "com/intellij/diff/util/DiffUtil", "getVirtualFile"));
        }
        List contents = request.getContents();
        DiffContent content1 = (DiffContent)currentSide.select(contents);
        DiffContent content2 = (DiffContent)ThreeSide.BASE.select(contents);
        if (content1 instanceof FileContent) {
            return ((FileContent)content1).getFile();
        }
        if (content2 instanceof FileContent) {
            return ((FileContent)content2).getFile();
        }
        return null;
    }

    @Nullable
    public static Object getData(@Nullable DataProvider provider, @Nullable DataProvider fallbackProvider, @NonNls String dataId) {
        Object data;
        if (provider != null && (data = provider.getData(dataId)) != null) {
            return data;
        }
        if (fallbackProvider != null && (data = fallbackProvider.getData(dataId)) != null) {
            return data;
        }
        return null;
    }

    public static <T> void putDataKey(@NotNull UserDataHolder holder, @NotNull DataKey<T> key, @Nullable T value) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/diff/util/DiffUtil", "putDataKey"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/DiffUtil", "putDataKey"));
        }
        DataProvider dataProvider = (DataProvider)holder.getUserData(DiffUserDataKeys.DATA_PROVIDER);
        if (!(dataProvider instanceof GenericDataProvider)) {
            dataProvider = new GenericDataProvider(dataProvider);
            holder.putUserData(DiffUserDataKeys.DATA_PROVIDER, (Object)dataProvider);
        }
        ((GenericDataProvider)dataProvider).putData(key, value);
    }

    @NotNull
    public static <T extends DiffTool> List<T> filterSuppressedTools(@NotNull List<T> tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/intellij/diff/util/DiffUtil", "filterSuppressedTools"));
        }
        if (tools.size() < 2) {
            List list = tools;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "filterSuppressedTools"));
            }
            return list;
        }
        final ArrayList suppressedTools = new ArrayList();
        for (DiffTool tool : tools) {
            try {
                if (!(tool instanceof SuppressiveDiffTool)) continue;
                suppressedTools.addAll(((SuppressiveDiffTool)tool).getSuppressedTools());
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        if (suppressedTools.isEmpty()) {
            List list = tools;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "filterSuppressedTools"));
            }
            return list;
        }
        List filteredTools = ContainerUtil.filter(tools, (Condition)new Condition<T>(){

            public boolean value(T tool) {
                return !suppressedTools.contains(tool.getClass());
            }
        });
        List list = filteredTools.isEmpty() ? tools : filteredTools;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "filterSuppressedTools"));
        }
        return list;
    }

    private static class SyncHeightComponent
    extends JPanel {
        @NotNull
        private final List<JComponent> myComponents;

        public SyncHeightComponent(@NotNull List<JComponent> components, int index) {
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/diff/util/DiffUtil$SyncHeightComponent", "<init>"));
            }
            super(new BorderLayout());
            this.myComponents = components;
            JComponent delegate = components.get(index);
            if (delegate != null) {
                this.add((Component)delegate, "Center");
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = this.getPreferredHeight();
            return size;
        }

        private int getPreferredHeight() {
            int height = 0;
            for (JComponent component : this.myComponents) {
                if (component == null) continue;
                height = Math.max(height, component.getPreferredSize().height);
            }
            return height;
        }
    }

    private static class MyWordFragment
    implements MergeWordFragment {
        @NotNull
        private final ThreeSide mySide1;
        @NotNull
        private final ThreeSide mySide2;
        @NotNull
        private final DiffFragment myFragment;

        public MyWordFragment(@NotNull ThreeSide side1, @NotNull ThreeSide side2, @NotNull DiffFragment fragment) {
            if (side1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side1", "com/intellij/diff/util/DiffUtil$MyWordFragment", "<init>"));
            }
            if (side2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side2", "com/intellij/diff/util/DiffUtil$MyWordFragment", "<init>"));
            }
            if (fragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil$MyWordFragment", "<init>"));
            }
            assert (side1 != side2);
            this.mySide1 = side1;
            this.mySide2 = side2;
            this.myFragment = fragment;
        }

        @Override
        public int getStartOffset(@NotNull ThreeSide side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/util/DiffUtil$MyWordFragment", "getStartOffset"));
            }
            if (side == this.mySide1) {
                return this.myFragment.getStartOffset1();
            }
            if (side == this.mySide2) {
                return this.myFragment.getStartOffset2();
            }
            return 0;
        }

        @Override
        public int getEndOffset(@NotNull ThreeSide side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/util/DiffUtil$MyWordFragment", "getEndOffset"));
            }
            if (side == this.mySide1) {
                return this.myFragment.getEndOffset1();
            }
            if (side == this.mySide2) {
                return this.myFragment.getEndOffset2();
            }
            return 0;
        }
    }

    public static class DiffConfig {
        @NotNull
        public final ComparisonPolicy policy;
        public final boolean innerFragments;
        public final boolean squashFragments;
        public final boolean trimFragments;

        public DiffConfig(@NotNull ComparisonPolicy policy, boolean innerFragments, boolean squashFragments, boolean trimFragments) {
            if (policy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/util/DiffUtil$DiffConfig", "<init>"));
            }
            this.policy = policy;
            this.innerFragments = innerFragments;
            this.squashFragments = squashFragments;
            this.trimFragments = trimFragments;
        }

        public DiffConfig(@NotNull IgnorePolicy ignorePolicy, @NotNull HighlightPolicy highlightPolicy) {
            if (ignorePolicy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignorePolicy", "com/intellij/diff/util/DiffUtil$DiffConfig", "<init>"));
            }
            if (highlightPolicy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightPolicy", "com/intellij/diff/util/DiffUtil$DiffConfig", "<init>"));
            }
            this(ignorePolicy.getComparisonPolicy(), highlightPolicy.isFineFragments(), highlightPolicy.isShouldSquash(), ignorePolicy.isShouldTrimChunks());
        }
    }

    public static abstract class DiffCommandAction
    implements Runnable {
        @Nullable
        protected final Project myProject;
        @NotNull
        protected final Document myDocument;
        @Nullable
        private final String myCommandName;
        @Nullable
        private final String myCommandGroupId;
        @NotNull
        private final UndoConfirmationPolicy myConfirmationPolicy;
        private final boolean myUnderBulkUpdate;

        public DiffCommandAction(@Nullable Project project, @NotNull Document document, @Nullable String commandName) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil$DiffCommandAction", "<init>"));
            }
            this(project, document, commandName, null, UndoConfirmationPolicy.DEFAULT);
        }

        public DiffCommandAction(@Nullable Project project, @NotNull Document document, @Nullable String commandName, @Nullable String commandGroupId, @NotNull UndoConfirmationPolicy confirmationPolicy) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil$DiffCommandAction", "<init>"));
            }
            if (confirmationPolicy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "confirmationPolicy", "com/intellij/diff/util/DiffUtil$DiffCommandAction", "<init>"));
            }
            this(project, document, commandName, commandGroupId, confirmationPolicy, false);
        }

        public DiffCommandAction(@Nullable Project project, @NotNull Document document, @Nullable String commandName, @Nullable String commandGroupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean underBulkUpdate) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil$DiffCommandAction", "<init>"));
            }
            if (confirmationPolicy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "confirmationPolicy", "com/intellij/diff/util/DiffUtil$DiffCommandAction", "<init>"));
            }
            this.myDocument = document;
            this.myProject = project;
            this.myCommandName = commandName;
            this.myCommandGroupId = commandGroupId;
            this.myConfirmationPolicy = confirmationPolicy;
            this.myUnderBulkUpdate = underBulkUpdate;
        }

        @Override
        public final void run() {
            if (!DiffUtil.makeWritable(this.myProject, this.myDocument)) {
                VirtualFile file2 = FileDocumentManager.getInstance().getFile(this.myDocument);
                LOG.warn("Document is read-only" + (file2 != null ? ": " + file2.getPresentableName() : ""));
                return;
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    CommandProcessor.getInstance().executeCommand(DiffCommandAction.this.myProject, new Runnable(){

                        @Override
                        public void run() {
                            if (DiffCommandAction.this.myUnderBulkUpdate) {
                                DocumentUtil.executeInBulk(DiffCommandAction.this.myDocument, true, new Runnable(){

                                    @Override
                                    public void run() {
                                        DiffCommandAction.this.execute();
                                    }
                                });
                            } else {
                                DiffCommandAction.this.execute();
                            }
                        }
                    }, DiffCommandAction.this.myCommandName, (Object)DiffCommandAction.this.myCommandGroupId, DiffCommandAction.this.myConfirmationPolicy, DiffCommandAction.this.myDocument);
                }
            });
        }

        protected abstract void execute();
    }

    public static class UpdatedLineRange {
        public final int startLine;
        public final int endLine;
        public final boolean damaged;

        public UpdatedLineRange(int startLine, int endLine, boolean damaged) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.damaged = damaged;
        }
    }
}

