/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import javax.swing.Icon;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u000b\u0001!1\u0003\u0004\u0001\u001a\u0003a\u0005\u0011UA)\u0004\u0003!\tQ\u0005\u0003\u0003\f\u0011\u0007i\u0011\u0001\u0007\u0002\u001a\u0007!\u0015Q\"\u0001\r\u0004K\u0015!!\u0003c\u0002\u000e\u00051\u0005\u0001\u0004B\u0013\u0005\tIAI!D\u0001\u0019\u000b\u0015BAa\u0003E\u0006\u001b\u0005A\"!G\u0002\t\u00065\t\u0001d\u0001"}, strings={"Lcom/intellij/ide/actions/EditCustomSettingsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "file", "Ljava/io/File;", "template", "", "update"}, moduleName="platform-impl")
public abstract class EditCustomSettingsAction
extends DumbAwareAction {
    @Nullable
    protected abstract File file();

    @NotNull
    protected abstract String template();

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        e.getPresentation().setEnabled(e.getProject() != null && this.file() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile vFile;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        File file2 = this.file();
        if (file2 == null) {
            return;
        }
        File file3 = file2;
        if (!file3.exists()) {
            int result2;
            String message = IdeBundle.message((String)"edit.custom.settings.confirm", (Object[])new Object[]{FileUtil.getLocationRelativeToUserHome((String)file3.getPath())});
            String string = e.getPresentation().getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if ((result2 = Messages.showYesNoDialog((Project)project2, (String)message, (String)string, (Icon)Messages.getQuestionIcon())) == 1) {
                return;
            }
            FileUtil.writeToFile((File)file3, (String)this.template());
        }
        if ((vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file3)) != null) {
            vFile.refresh(false, false);
            new OpenFileDescriptor(project2, vFile, (int)vFile.getLength()).navigate(true);
        }
    }
}

