/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.ProjectViewNodeWithChildrenList;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.TreeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FavoritesListNode
extends AbstractTreeNode<String> {
    private static final Logger LOGGER = Logger.getInstance(FavoritesListNode.class);
    private final Project myProject;
    private final String myDescription;

    public FavoritesListNode(Project project, String listName, String description) {
        super(project, (Object)listName);
        this.myProject = project;
        this.myName = listName;
        this.myDescription = description;
    }

    public FavoritesListNode(Project project, String listName) {
        this(project, listName, null);
    }

    public FavoritesListProvider getProvider() {
        return null;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Collection<AbstractTreeNode> collection = FavoritesListNode.getFavoritesRoots(this.myProject, this.myName, this);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesListNode", "getChildren"));
        }
        return collection;
    }

    protected void update(PresentationData presentation) {
        presentation.setIcon(AllIcons.Toolwindows.ToolWindowFavorites);
        presentation.setPresentableText(this.myName);
        presentation.setLocationString(this.myDescription);
    }

    @NotNull
    public static Collection<AbstractTreeNode> getFavoritesRoots(Project project, String listName, FavoritesListNode listNode) {
        List<TreeItem<Pair<AbstractUrl, String>>> pairs = FavoritesManager.getInstance(project).getFavoritesListRootUrls(listName);
        if (pairs.isEmpty()) {
            List<AbstractTreeNode> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesListNode", "getFavoritesRoots"));
            }
            return list;
        }
        Collection<AbstractTreeNode> collection = FavoritesListNode.createFavoriteRoots(project, pairs, listNode);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesListNode", "getFavoritesRoots"));
        }
        return collection;
    }

    @NotNull
    private static Collection<AbstractTreeNode> createFavoriteRoots(Project project, @NotNull Collection<TreeItem<Pair<AbstractUrl, String>>> urls, AbstractTreeNode me) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/ide/favoritesTreeView/FavoritesListNode", "createFavoriteRoots"));
        }
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
        FavoritesListNode.processUrls(project, urls, result2, me);
        ArrayList<AbstractTreeNode> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesListNode", "createFavoriteRoots"));
        }
        return arrayList;
    }

    private static void processUrls(Project project, Collection<TreeItem<Pair<AbstractUrl, String>>> urls, Collection<AbstractTreeNode> result2, AbstractTreeNode me) {
        for (TreeItem<Pair<AbstractUrl, String>> pair : urls) {
            AbstractUrl abstractUrl = (AbstractUrl)((Pair)pair.getData()).getFirst();
            Object[] path = abstractUrl.createPath(project);
            if (path == null || path.length < 1 || path[0] == null) continue;
            try {
                List children2;
                String className = (String)((Pair)pair.getData()).getSecond();
                Class<?> nodeClass = Class.forName(className);
                AbstractTreeNode node = ProjectViewNode.createTreeNode(nodeClass, (Project)project, (Object)path[path.length - 1], (ViewSettings)FavoritesManager.getInstance(project).getViewSettings());
                node.setParent(me);
                node.setIndex(result2.size());
                result2.add(node);
                if (!(node instanceof ProjectViewNodeWithChildrenList) || (children2 = pair.getChildren()) == null || children2.isEmpty()) continue;
                ArrayList<AbstractTreeNode> childList = new ArrayList<AbstractTreeNode>();
                FavoritesListNode.processUrls(project, children2, childList, node);
                for (AbstractTreeNode treeNode : childList) {
                    ((ProjectViewNodeWithChildrenList)node).addChild(treeNode);
                }
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
            }
        }
    }
}

