/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class MarkSourceRootAction
extends MarkRootActionBase {
    private static final Logger LOG = Logger.getInstance(MarkSourceRootAction.class);
    private final JpsModuleSourceRootType<?> myRootType;

    public MarkSourceRootAction(@NotNull JpsModuleSourceRootType<?> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/ide/projectView/actions/MarkSourceRootAction", "<init>"));
        }
        this.myRootType = type;
        Presentation presentation = this.getTemplatePresentation();
        ModuleSourceRootEditHandler<?> editHandler = ModuleSourceRootEditHandler.getEditHandler(type);
        LOG.assertTrue(editHandler != null);
        presentation.setIcon(editHandler.getRootIcon());
        presentation.setText(editHandler.getFullRootTypeName());
        presentation.setDescription(ProjectBundle.message((String)"module.toggle.sources.action.description", (Object[])new Object[]{editHandler.getFullRootTypeName().toLowerCase(Locale.getDefault())}));
    }

    @Override
    protected void modifyRoots(@NotNull VirtualFile vFile, @NotNull ContentEntry entry) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/ide/projectView/actions/MarkSourceRootAction", "modifyRoots"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/ide/projectView/actions/MarkSourceRootAction", "modifyRoots"));
        }
        entry.addSourceFolder(vFile, this.myRootType);
    }

    @Override
    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/ide/projectView/actions/MarkSourceRootAction", "isEnabled"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ide/projectView/actions/MarkSourceRootAction", "isEnabled"));
        }
        if (!ModuleType.get((Module)module).isSupportedRootType(this.myRootType) || selection.myHaveSelectedFilesUnderSourceRoots || ModuleSourceRootEditHandler.getEditHandler(this.myRootType) == null) {
            return false;
        }
        if (!selection.mySelectedDirectories.isEmpty()) {
            return true;
        }
        for (SourceFolder root : selection.mySelectedRoots) {
            if (this.myRootType.equals((Object)root.getRootType())) continue;
            return true;
        }
        return false;
    }
}

