/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class NamedLibraryElementNode
extends ProjectViewNode<NamedLibraryElement>
implements NavigatableWithText {
    public NamedLibraryElementNode(Project project, NamedLibraryElement value, ViewSettings viewSettings) {
        super(project, (Object)value, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        ArrayList<AbstractTreeNode> children2 = new ArrayList<AbstractTreeNode>();
        NamedLibraryElement libraryElement = (NamedLibraryElement)this.getValue();
        if (libraryElement != null) {
            LibraryGroupNode.addLibraryChildren(libraryElement.getOrderEntry(), children2, this.getProject(), this);
        }
        ArrayList<AbstractTreeNode> arrayList = children2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/NamedLibraryElementNode", "getChildren"));
        }
        return arrayList;
    }

    private static Icon getJdkIcon(JdkOrderEntry entry) {
        Sdk sdk = entry.getJdk();
        if (sdk == null) {
            return AllIcons.General.Jdk;
        }
        SdkType sdkType = (SdkType)sdk.getSdkType();
        return sdkType.getIcon();
    }

    public String getName() {
        NamedLibraryElement library = (NamedLibraryElement)this.getValue();
        return library != null ? library.getName() : "";
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/nodes/NamedLibraryElementNode", "contains"));
        }
        NamedLibraryElement library = (NamedLibraryElement)this.getValue();
        if (library == null) {
            return false;
        }
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            LibraryOrSdkOrderEntry orderEntry = library.getOrderEntry();
            if (!orderEntry.isValid()) continue;
            for (VirtualFile virtualFile : orderEntry.getRootFiles(rootType)) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file2, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public void update(PresentationData presentation) {
        NamedLibraryElement library = (NamedLibraryElement)this.getValue();
        if (library == null) {
            return;
        }
        LibraryOrSdkOrderEntry orderEntry = library.getOrderEntry();
        presentation.setPresentableText(library.getName());
        Icon closedIcon = orderEntry instanceof JdkOrderEntry ? NamedLibraryElementNode.getJdkIcon((JdkOrderEntry)orderEntry) : AllIcons.Nodes.PpLibFolder;
        presentation.setIcon(closedIcon);
        if (orderEntry instanceof JdkOrderEntry) {
            String path;
            JdkOrderEntry jdkOrderEntry = (JdkOrderEntry)orderEntry;
            Sdk projectJdk = jdkOrderEntry.getJdk();
            if (projectJdk != null && (path = projectJdk.getHomePath()) != null) {
                presentation.setLocationString(FileUtil.toSystemDependentName((String)path));
            }
            presentation.setTooltip(null);
        } else {
            presentation.setTooltip(StringUtil.capitalize((String)IdeBundle.message((String)"node.projectview.library", (Object[])new Object[]{((LibraryOrderEntry)orderEntry).getLibraryLevel()})));
        }
    }

    public void navigate(boolean requestFocus) {
        NamedLibraryElement library = (NamedLibraryElement)this.getValue();
        if (library != null) {
            ProjectSettingsService.getInstance(this.myProject).openLibraryOrSdkSettings((OrderEntry)library.getOrderEntry());
        }
    }

    public boolean canNavigate() {
        NamedLibraryElement library = (NamedLibraryElement)this.getValue();
        return library != null && ProjectSettingsService.getInstance(this.myProject).canOpenLibraryOrSdkSettings((OrderEntry)library.getOrderEntry());
    }

    public String getNavigateActionText(boolean focusEditor) {
        return ActionsBundle.message((String)"action.LibrarySettings.navigate", (Object[])new Object[0]);
    }

    public String getTestPresentation() {
        NamedLibraryElement library = (NamedLibraryElement)this.getValue();
        return "Library: " + (library != null ? library.getName() : "(null)");
    }
}

