/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.FontUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;

public class ProjectViewDirectoryHelper {
    protected static final Logger LOG = Logger.getInstance((String)("#" + ProjectViewDirectoryHelper.class.getName()));
    private final Project myProject;
    private final DirectoryIndex myIndex;

    public static ProjectViewDirectoryHelper getInstance(Project project) {
        return (ProjectViewDirectoryHelper)ServiceManager.getService((Project)project, ProjectViewDirectoryHelper.class);
    }

    public ProjectViewDirectoryHelper(Project project, DirectoryIndex index) {
        this.myProject = project;
        this.myIndex = index;
    }

    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public String getLocationString(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDirectory", "com/intellij/ide/projectView/impl/nodes/ProjectViewDirectoryHelper", "getLocationString"));
        }
        boolean includeUrl = ProjectRootsUtil.isModuleContentRoot(psiDirectory);
        return this.getLocationString(psiDirectory, includeUrl, false);
    }

    @Nullable
    public String getLocationString(@NotNull PsiDirectory psiDirectory, boolean includeUrl, boolean includeRootType) {
        ModuleSourceRootEditHandler handler2;
        SourceFolder sourceRoot;
        if (psiDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDirectory", "com/intellij/ide/projectView/impl/nodes/ProjectViewDirectoryHelper", "getLocationString"));
        }
        StringBuilder result2 = new StringBuilder();
        VirtualFile directory = psiDirectory.getVirtualFile();
        if (ProjectRootsUtil.isLibraryRoot(directory, psiDirectory.getProject())) {
            result2.append(ProjectBundle.message((String)"module.paths.root.node", (Object[])new Object[]{"library"}).toLowerCase(Locale.getDefault()));
        } else if (includeRootType && (sourceRoot = ProjectRootsUtil.getModuleSourceRoot(psiDirectory.getVirtualFile(), psiDirectory.getProject())) != null && (handler2 = ModuleSourceRootEditHandler.getEditHandler(sourceRoot.getRootType())) != null) {
            JavaSourceRootProperties properties = (JavaSourceRootProperties)sourceRoot.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
            if (properties != null && properties.isForGeneratedSources()) {
                result2.append("generated ");
            }
            result2.append(handler2.getFullRootTypeName().toLowerCase(Locale.getDefault()));
        }
        if (includeUrl) {
            if (result2.length() > 0) {
                result2.append(",").append(FontUtil.spaceAndThinSpace());
            }
            result2.append(FileUtil.getLocationRelativeToUserHome((String)directory.getPresentableUrl()));
        }
        return result2.length() == 0 ? null : result2.toString();
    }

    public boolean isShowFQName(ViewSettings settings, Object parentValue, PsiDirectory value) {
        return false;
    }

    @Nullable
    public String getNodeName(ViewSettings settings, Object parentValue, PsiDirectory directory) {
        return directory.getName();
    }

    public boolean skipDirectory(PsiDirectory directory) {
        return true;
    }

    public boolean isEmptyMiddleDirectory(PsiDirectory directory, boolean strictlyEmpty) {
        return false;
    }

    public boolean supportsFlattenPackages() {
        return false;
    }

    public boolean supportsHideEmptyMiddlePackages() {
        return false;
    }

    public boolean canRepresent(Object element, PsiDirectory directory) {
        if (element instanceof VirtualFile) {
            VirtualFile vFile = (VirtualFile)element;
            return Comparing.equal((Object)directory.getVirtualFile(), (Object)vFile);
        }
        return false;
    }

    public Collection<AbstractTreeNode> getDirectoryChildren(PsiDirectory psiDirectory, ViewSettings settings, boolean withSubDirectories) {
        ModuleFileIndex moduleFileIndex;
        ArrayList<AbstractTreeNode> children2 = new ArrayList<AbstractTreeNode>();
        Project project = psiDirectory.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = fileIndex.getModuleForFile(psiDirectory.getVirtualFile());
        ModuleFileIndex moduleFileIndex2 = moduleFileIndex = module == null ? null : ModuleRootManager.getInstance((Module)module).getFileIndex();
        if (!settings.isFlattenPackages() || this.skipDirectory(psiDirectory)) {
            this.processPsiDirectoryChildren(psiDirectory, this.directoryChildrenInProject(psiDirectory, settings), children2, fileIndex, null, settings, withSubDirectories);
        } else {
            PsiDirectory parentDir = psiDirectory.getParentDirectory();
            if (parentDir == null || this.skipDirectory(parentDir) && withSubDirectories) {
                this.addAllSubpackages(children2, psiDirectory, moduleFileIndex, settings);
            }
            if (withSubDirectories) {
                PsiDirectory[] subdirs;
                for (PsiDirectory subdir : subdirs = psiDirectory.getSubdirectories()) {
                    if (!this.skipDirectory(subdir)) continue;
                    VirtualFile directoryFile = subdir.getVirtualFile();
                    if (Registry.is((String)"ide.hide.excluded.files") ? fileIndex.isExcluded(directoryFile) : FileTypeRegistry.getInstance().isFileIgnored(directoryFile)) continue;
                    children2.add((AbstractTreeNode)new PsiDirectoryNode(project, subdir, settings));
                }
            }
            this.processPsiDirectoryChildren(psiDirectory, (PsiElement[])psiDirectory.getFiles(), children2, fileIndex, moduleFileIndex, settings, withSubDirectories);
        }
        return children2;
    }

    public List<VirtualFile> getTopLevelRoots() {
        ArrayList<VirtualFile> topLevelContentRoots = new ArrayList<VirtualFile>();
        ProjectRootManager prm = ProjectRootManager.getInstance((Project)this.myProject);
        ProjectFileIndex index = prm.getFileIndex();
        for (VirtualFile root : prm.getContentRoots()) {
            VirtualFile parent = root.getParent();
            if (parent != null && index.isInContent(parent)) continue;
            topLevelContentRoots.add(root);
        }
        return topLevelContentRoots;
    }

    private PsiElement[] directoryChildrenInProject(PsiDirectory psiDirectory, final ViewSettings settings) {
        VirtualFile dir = psiDirectory.getVirtualFile();
        if (this.shouldBeShown(dir, settings)) {
            final ArrayList children2 = new ArrayList();
            psiDirectory.processChildren((PsiElementProcessor)new PsiElementProcessor<PsiFileSystemItem>(){

                public boolean execute(@NotNull PsiFileSystemItem element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/projectView/impl/nodes/ProjectViewDirectoryHelper$1", "execute"));
                    }
                    if (ProjectViewDirectoryHelper.this.shouldBeShown(element.getVirtualFile(), settings)) {
                        children2.add(element);
                    }
                    return true;
                }
            });
            return PsiUtilCore.toPsiElementArray(children2);
        }
        PsiManager manager = psiDirectory.getManager();
        THashSet directoriesOnTheWayToContentRoots = new THashSet();
        Iterator<VirtualFile> iterator = this.getTopLevelRoots().iterator();
        while (iterator.hasNext()) {
            VirtualFile root;
            VirtualFile current = root = iterator.next();
            while (current != null) {
                PsiDirectory psi;
                VirtualFile parent = current.getParent();
                if (Comparing.equal((Object)parent, (Object)dir) && (psi = manager.findDirectory(current)) != null) {
                    directoriesOnTheWayToContentRoots.add(psi);
                }
                current = parent;
            }
        }
        return PsiUtilCore.toPsiElementArray((Collection)directoriesOnTheWayToContentRoots);
    }

    private boolean shouldBeShown(VirtualFile dir, ViewSettings settings) {
        DirectoryInfo directoryInfo = this.myIndex.getInfoForFile(dir);
        if (directoryInfo.isInProject()) {
            return true;
        }
        if (!Registry.is((String)"ide.hide.excluded.files") && settings instanceof ProjectViewSettings && ((ProjectViewSettings)settings).isShowExcludedFiles()) {
            return directoryInfo.isExcluded();
        }
        return false;
    }

    public void processPsiDirectoryChildren(PsiDirectory psiDir, PsiElement[] children2, List<AbstractTreeNode> container, ProjectFileIndex projectFileIndex, @Nullable ModuleFileIndex moduleFileIndex, ViewSettings viewSettings, boolean withSubDirectories) {
        for (PsiElement child : children2) {
            LOG.assertTrue(child.isValid());
            if (!(child instanceof PsiFileSystemItem)) {
                LOG.error("Either PsiFile or PsiDirectory expected as a child of " + child.getParent() + ", but was " + child);
                continue;
            }
            VirtualFile vFile = ((PsiFileSystemItem)child).getVirtualFile();
            if (vFile == null || moduleFileIndex != null && !moduleFileIndex.isInContent(vFile)) continue;
            if (child instanceof PsiFile) {
                container.add((AbstractTreeNode)new PsiFileNode(child.getProject(), (PsiFile)child, viewSettings));
                continue;
            }
            if (!(child instanceof PsiDirectory) || !withSubDirectories) continue;
            PsiDirectory dir = (PsiDirectory)child;
            if (!vFile.equals(projectFileIndex.getSourceRootForFile(vFile)) && viewSettings.isHideEmptyMiddlePackages() && !this.skipDirectory(psiDir) && this.isEmptyMiddleDirectory(dir, true)) {
                this.processPsiDirectoryChildren(dir, this.directoryChildrenInProject(dir, viewSettings), container, projectFileIndex, moduleFileIndex, viewSettings, withSubDirectories);
                continue;
            }
            container.add((AbstractTreeNode)new PsiDirectoryNode(child.getProject(), (PsiDirectory)child, viewSettings));
        }
    }

    public void addAllSubpackages(List<AbstractTreeNode> container, PsiDirectory dir, @Nullable ModuleFileIndex moduleFileIndex, ViewSettings viewSettings) {
        PsiDirectory[] subdirs;
        Project project = dir.getProject();
        for (PsiDirectory subdir : subdirs = dir.getSubdirectories()) {
            if (this.skipDirectory(subdir)) continue;
            if (moduleFileIndex != null && !moduleFileIndex.isInContent(subdir.getVirtualFile())) {
                container.add((AbstractTreeNode)new PsiDirectoryNode(project, subdir, viewSettings));
                continue;
            }
            if (viewSettings.isHideEmptyMiddlePackages()) {
                if (!this.isEmptyMiddleDirectory(subdir, false)) {
                    container.add((AbstractTreeNode)new PsiDirectoryNode(project, subdir, viewSettings));
                }
            } else {
                container.add((AbstractTreeNode)new PsiDirectoryNode(project, subdir, viewSettings));
            }
            this.addAllSubpackages(container, subdir, moduleFileIndex, viewSettings);
        }
    }
}

