/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.JdkChooserPanel;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkListConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkForModuleStep
extends ModuleWizardStep {
    private final JdkChooserPanel myJdkChooser;
    @NotNull
    private final JPanel myPanel;
    private final WizardContext myContext;
    private final SdkType myType;
    private boolean myInitialized = false;
    private final JButton mySetAsDefaultButton;

    public ProjectJdkForModuleStep(final WizardContext context, final SdkType type) {
        this.myContext = context;
        this.myType = type;
        this.myJdkChooser = new JdkChooserPanel(ProjectJdkForModuleStep.getProject(context, type));
        this.myPanel = new JPanel(new GridBagLayout());
        this.myPanel.setBorder(BorderFactory.createEtchedBorder());
        JLabel label = new JLabel(IdeBundle.message((String)"prompt.please.select.module.jdk", (Object[])new Object[]{type.getPresentableName()}));
        label.setUI((LabelUI)new MultiLineLabelUI());
        this.myPanel.add((Component)label, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, new Insets(8, 10, 8, 10), 0, 0));
        JLabel jdklabel = new JLabel(IdeBundle.message((String)"label.project.jdk", (Object[])new Object[0]));
        jdklabel.setFont(UIUtil.getLabelFont().deriveFont(1));
        this.myPanel.add((Component)jdklabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 0, new Insets(8, 10, 0, 10), 0, 0));
        this.myPanel.add((Component)this.myJdkChooser, new GridBagConstraints(0, -1, 1, 2, 1.0, 1.0, 18, 1, new Insets(2, 10, 10, 5), 0, 0));
        JButton configureButton = new JButton(IdeBundle.message((String)"button.configure", (Object[])new Object[0]));
        this.myPanel.add((Component)configureButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 5, 5), 0, 0));
        this.mySetAsDefaultButton = new JButton("Set Default");
        this.mySetAsDefaultButton.setMnemonic('D');
        this.myPanel.add((Component)this.mySetAsDefaultButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 18, 0, new Insets(2, 0, 10, 5), 0, 0));
        configureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project = ProjectJdkForModuleStep.getProject(context, type);
                ProjectStructureConfigurable projectConfig = ProjectStructureConfigurable.getInstance(project);
                final JdkListConfigurable jdkConfig = JdkListConfigurable.getInstance(project);
                final ProjectSdksModel projectJdksModel = projectConfig.getProjectJdksModel();
                final boolean[] successfullyAdded = new boolean[1];
                projectJdksModel.reset(project);
                projectJdksModel.doAdd(ProjectJdkForModuleStep.this.myPanel, type, new Consumer<Sdk>(){

                    public void consume(Sdk jdk) {
                        successfullyAdded[0] = jdkConfig.addJdkNode(jdk, false);
                        ProjectJdkForModuleStep.this.myJdkChooser.updateList(jdk, type, projectJdksModel.getSdks());
                        if (!successfullyAdded[0]) {
                            try {
                                projectJdksModel.apply(jdkConfig);
                            }
                            catch (ConfigurationException configurationException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        });
        final Project defaultProject = ProjectManagerEx.getInstanceEx().getDefaultProject();
        this.mySetAsDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final Sdk jdk = ProjectJdkForModuleStep.this.getJdk();
                Runnable runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        ProjectRootManagerEx.getInstanceEx((Project)defaultProject).setProjectSdk(jdk);
                    }
                };
                ApplicationManager.getApplication().runWriteAction(runnable2);
                ProjectJdkForModuleStep.this.mySetAsDefaultButton.setEnabled(false);
            }
        });
        this.myJdkChooser.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProjectJdkForModuleStep.this.mySetAsDefaultButton.setEnabled(ProjectJdkForModuleStep.this.getJdk() != ProjectRootManagerEx.getInstanceEx((Project)defaultProject).getProjectSdk());
            }
        });
    }

    @Nullable
    private static Project getProject(WizardContext context, SdkType type) {
        Project project = context.getProject();
        if (type != null && project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        return project;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myJdkChooser.getPreferredFocusedComponent();
    }

    public String getHelpId() {
        return "project.new.page2";
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void updateDataModel() {
        this.myContext.setProjectJdk(this.getJdk());
    }

    public void updateStep() {
        if (!this.myInitialized) {
            this.myJdkChooser.fillList(this.myType, null);
            Sdk defaultJdk = ProjectJdkForModuleStep.getDefaultJdk(this.myContext);
            if (defaultJdk != null) {
                this.myJdkChooser.selectJdk(defaultJdk);
            }
            this.mySetAsDefaultButton.setEnabled(defaultJdk != null);
            this.myInitialized = true;
        }
    }

    public Sdk getJdk() {
        return this.myJdkChooser.getChosenJdk();
    }

    public Object[] getAllJdks() {
        return this.myJdkChooser.getAllJdks();
    }

    public Icon getIcon() {
        return this.myContext.getStepIcon();
    }

    @Nullable
    private static Sdk getDefaultJdk(WizardContext context) {
        Project defaultProject = ProjectManagerEx.getInstanceEx().getDefaultProject();
        Sdk sdk = ProjectRootManagerEx.getInstanceEx((Project)defaultProject).getProjectSdk();
        if (sdk == null) {
            return AddModuleWizard.getMostRecentSuitableSdk(context);
        }
        return sdk;
    }

    public boolean validate() {
        int result2;
        Sdk jdk = this.myJdkChooser.getChosenJdk();
        return jdk != null || (result2 = Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.confirm.project.no.jdk", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.no.jdk.specified", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) == 0;
    }
}

