/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.net.NetUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.MessageDecoder;

public final class SocketLock {
    private static final String PORT_FILE = "port";
    private static final String PORT_LOCK_FILE = "port.lock";
    private static final String ACTIVATE_COMMAND = "activate ";
    private static final String PATHS_EOT_RESPONSE = "---";
    private static final String OK_RESPONSE = "ok";
    private final String myConfigPath;
    private final String mySystemPath;
    private final AtomicReference<Consumer<List<String>>> myActivateListener;
    private BuiltInServer myServer;

    public SocketLock(@NotNull String configPath, @NotNull String systemPath) {
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/idea/SocketLock", "<init>"));
        }
        if (systemPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemPath", "com/intellij/idea/SocketLock", "<init>"));
        }
        this.myActivateListener = new AtomicReference();
        this.myConfigPath = SocketLock.canonicalPath(configPath);
        this.mySystemPath = SocketLock.canonicalPath(systemPath);
    }

    public void setExternalInstanceListener(@Nullable Consumer<List<String>> consumer) {
        this.myActivateListener.set(consumer);
    }

    public void dispose() {
        SocketLock.log("enter: dispose()", new Object[0]);
        BuiltInServer server = this.myServer;
        if (server == null) {
            return;
        }
        try {
            Disposer.dispose((Disposable)server);
        }
        catch (Throwable throwable) {
            try {
                this.underLocks(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        FileUtil.delete((File)new File(SocketLock.this.myConfigPath, SocketLock.PORT_FILE));
                        FileUtil.delete((File)new File(SocketLock.this.mySystemPath, SocketLock.PORT_FILE));
                        return null;
                    }
                });
            }
            catch (Exception e) {
                Logger.getInstance(SocketLock.class).warn((Throwable)e);
            }
            throw throwable;
        }
        try {
            this.underLocks(new /* invalid duplicate definition of identical inner class */);
        }
        catch (Exception e) {
            Logger.getInstance(SocketLock.class).warn((Throwable)e);
        }
    }

    @Nullable
    public BuiltInServer getServer() {
        return this.myServer;
    }

    @NotNull
    public ActivateStatus lock() throws Exception {
        ActivateStatus activateStatus = this.lock(ArrayUtil.EMPTY_STRING_ARRAY);
        if (activateStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "lock"));
        }
        return activateStatus;
    }

    @NotNull
    public ActivateStatus lock(final @NotNull String[] args) throws Exception {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/idea/SocketLock", "lock"));
        }
        SocketLock.log("enter: lock(config=%s system=%s)", this.myConfigPath, this.mySystemPath);
        ActivateStatus activateStatus = this.underLocks(new Callable<ActivateStatus>(){

            @Override
            public ActivateStatus call() throws Exception {
                File portMarkerC = new File(SocketLock.this.myConfigPath, SocketLock.PORT_FILE);
                File portMarkerS = new File(SocketLock.this.mySystemPath, SocketLock.PORT_FILE);
                MultiMap portToPath = MultiMap.createSmart();
                SocketLock.addExistingPort(portMarkerC, SocketLock.this.myConfigPath, (MultiMap<Integer, String>)portToPath);
                SocketLock.addExistingPort(portMarkerS, SocketLock.this.mySystemPath, (MultiMap<Integer, String>)portToPath);
                if (!portToPath.isEmpty()) {
                    for (Map.Entry entry : portToPath.entrySet()) {
                        ActivateStatus status = SocketLock.tryActivate((Integer)entry.getKey(), (Collection)entry.getValue(), args);
                        if (status == ActivateStatus.NO_INSTANCE) continue;
                        return status;
                    }
                }
                final String[] lockedPaths = new String[]{SocketLock.this.myConfigPath, SocketLock.this.mySystemPath};
                int workerCount = PlatformUtils.isIdeaCommunity() || PlatformUtils.isDatabaseIDE() || PlatformUtils.isCidr() ? 1 : 2;
                SocketLock.this.myServer = BuiltInServer.start(workerCount, 6942, 50, false, new NotNullProducer<ChannelHandler>(){

                    @NotNull
                    public ChannelHandler produce() {
                        MyChannelInboundHandler myChannelInboundHandler = new MyChannelInboundHandler(lockedPaths, SocketLock.this.myActivateListener);
                        if (myChannelInboundHandler == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock$2$1", "produce"));
                        }
                        return myChannelInboundHandler;
                    }
                });
                byte[] portBytes = Integer.toString(SocketLock.this.myServer.getPort()).getBytes(CharsetToolkit.UTF8_CHARSET);
                FileUtil.writeToFile((File)portMarkerC, (byte[])portBytes);
                FileUtil.writeToFile((File)portMarkerS, (byte[])portBytes);
                SocketLock.log("exit: lock(): succeed", new Object[0]);
                return ActivateStatus.NO_INSTANCE;
            }
        });
        if (activateStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "lock"));
        }
        return activateStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V underLocks(@NotNull Callable<V> action) throws Exception {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/idea/SocketLock", "underLocks"));
        }
        FileUtilRt.createDirectory((File)new File(this.myConfigPath));
        FileOutputStream lock1 = new FileOutputStream(new File(this.myConfigPath, PORT_LOCK_FILE), true);
        try {
            V v;
            FileUtilRt.createDirectory((File)new File(this.mySystemPath));
            FileOutputStream lock2 = new FileOutputStream(new File(this.mySystemPath, PORT_LOCK_FILE), true);
            try {
                v = action.call();
            }
            catch (Throwable throwable) {
                lock2.close();
                throw throwable;
            }
            lock2.close();
            return v;
        }
        finally {
            lock1.close();
        }
    }

    private static void addExistingPort(@NotNull File portMarker, @NotNull String path, @NotNull MultiMap<Integer, String> portToPath) {
        if (portMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "portMarker", "com/intellij/idea/SocketLock", "addExistingPort"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/idea/SocketLock", "addExistingPort"));
        }
        if (portToPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "portToPath", "com/intellij/idea/SocketLock", "addExistingPort"));
        }
        if (portMarker.exists()) {
            try {
                portToPath.putValue((Object)Integer.parseInt(FileUtilRt.loadFile((File)portMarker)), (Object)path);
            }
            catch (Exception e) {
                SocketLock.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static ActivateStatus tryActivate(int portNumber, @NotNull Collection<String> paths, @NotNull String[] args) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"paths", "com/intellij/idea/SocketLock", "tryActivate"}));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"args", "com/intellij/idea/SocketLock", "tryActivate"}));
        }
        SocketLock.log("trying: port=%s", new Object[]{portNumber});
        try {
            socket = new Socket(NetUtils.getLoopbackAddress(), portNumber);
            try {
                socket.setSoTimeout(1000);
                result = false;
                in = new DataInputStream(socket.getInputStream());
                ** try [egrp 2[TRYBLOCK] [0 : 131->183)] { 
lbl13:
                // 1 sources

                ** GOTO lbl-1000
            }
            catch (Throwable var9_13) {
                throw var9_13;
lbl-1000:
                // 1 sources

                {
                    while (true) {
                        path = in.readUTF();
                        SocketLock.log("read: path=%s", new Object[]{path});
                        if (!"---".equals(path)) {
                            if (!paths.contains(path)) continue;
                            result = true;
                            continue;
                        }
                        break;
                    }
                }
lbl24:
                // 1 sources

                catch (IOException e) {
                    SocketLock.log("read: %s", new Object[]{e.getMessage()});
                }
                if (result) {
                    block18: {
                        out = new DataOutputStream(socket.getOutputStream());
                        out.writeUTF("activate " + new File(".").getAbsolutePath() + "\u0000" + StringUtil.join((String[])args, (String)"\u0000"));
                        out.flush();
                        response = in.readUTF();
                        SocketLock.log("read: response=%s", new Object[]{response});
                        if (!response.equals("ok")) break block18;
                        var8_12 = ActivateStatus.ACTIVATED;
                        socket.close();
                        v0 = var8_12;
                        if (v0 != null) return v0;
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/idea/SocketLock", "tryActivate"}));
                    }
                    ** try [egrp 5[TRYBLOCK] [4 : 359->374)] { 
lbl41:
                    // 1 sources

                    return ActivateStatus.CANNOT_ACTIVATE;
                    catch (IOException e) {
                        SocketLock.log(e);
                    }
                    return ActivateStatus.CANNOT_ACTIVATE;
                }
                socket.close();
            }
lbl47:
            // 1 sources

            finally {
                socket.close();
            }
        }
        catch (ConnectException e) {
            SocketLock.log("%s (stale port file?)", new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            SocketLock.log(e);
        }
        v1 = ActivateStatus.NO_INSTANCE;
        if (v1 != null) return v1;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/idea/SocketLock", "tryActivate"}));
    }

    @NotNull
    private static String canonicalPath(@NotNull String configPath) {
        String string;
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/idea/SocketLock", "canonicalPath"));
        }
        try {
            string = new File(configPath).getCanonicalPath();
        }
        catch (IOException ignore) {
            String string2 = configPath;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "canonicalPath"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "canonicalPath"));
        }
        return string;
    }

    private static void log(Exception e) {
        Logger.getInstance(SocketLock.class).warn((Throwable)e);
    }

    private static void log(String format, Object ... args) {
        Logger logger = Logger.getInstance(SocketLock.class);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(format, args));
        }
    }

    private static class MyChannelInboundHandler
    extends MessageDecoder {
        private final String[] myLockedPaths;
        private final AtomicReference<Consumer<List<String>>> myActivateListener;
        private State myState;

        public MyChannelInboundHandler(@NotNull String[] lockedPaths, @NotNull AtomicReference<Consumer<List<String>>> activateListener) {
            if (lockedPaths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lockedPaths", "com/intellij/idea/SocketLock$MyChannelInboundHandler", "<init>"));
            }
            if (activateListener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activateListener", "com/intellij/idea/SocketLock$MyChannelInboundHandler", "<init>"));
            }
            this.myState = State.HEADER;
            this.myLockedPaths = lockedPaths;
            this.myActivateListener = activateListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelActive(ChannelHandlerContext context) throws Exception {
            ByteBuf buffer = context.alloc().ioBuffer(1024);
            boolean success = false;
            try {
                ByteBufOutputStream out = new ByteBufOutputStream(buffer);
                for (String path : this.myLockedPaths) {
                    out.writeUTF(path);
                }
                out.writeUTF(SocketLock.PATHS_EOT_RESPONSE);
                out.close();
                success = true;
            }
            finally {
                if (!success) {
                    buffer.release();
                }
            }
            context.writeAndFlush((Object)buffer);
        }

        @Override
        protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) throws Exception {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/idea/SocketLock$MyChannelInboundHandler", "messageReceived"));
            }
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/idea/SocketLock$MyChannelInboundHandler", "messageReceived"));
            }
            while (true) {
                switch (this.myState) {
                    case HEADER: {
                        ByteBuf buffer = this.getBufferIfSufficient(input, 2, context);
                        if (buffer == null) {
                            return;
                        }
                        this.contentLength = buffer.readUnsignedShort();
                        this.myState = State.CONTENT;
                        break;
                    }
                    case CONTENT: {
                        CharSequence command = this.readChars(input);
                        if (command == null) {
                            return;
                        }
                        if (StringUtil.startsWith((CharSequence)command, (CharSequence)SocketLock.ACTIVATE_COMMAND)) {
                            List args = StringUtil.split((String)command.subSequence(SocketLock.ACTIVATE_COMMAND.length(), command.length()).toString(), (String)"\u0000");
                            Consumer<List<String>> listener = this.myActivateListener.get();
                            if (listener != null) {
                                listener.consume((Object)args);
                            }
                            ByteBuf buffer = context.alloc().ioBuffer(4);
                            ByteBufOutputStream out = new ByteBufOutputStream(buffer);
                            out.writeUTF(SocketLock.OK_RESPONSE);
                            out.close();
                            context.writeAndFlush((Object)buffer);
                        }
                        context.close();
                    }
                }
            }
        }

        private static enum State {
            HEADER,
            CONTENT;

        }
    }

    public static enum ActivateStatus {
        ACTIVATED,
        NO_INSTANCE,
        CANNOT_ACTIVATE;

    }
}

