/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.moduleDependencies;

import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="DependenciesAnalyzeManager", storages={@Storage(file="$WORKSPACE_FILE$")})
public class DependenciesAnalyzeManager
implements PersistentStateComponent<State> {
    private final Project myProject;
    private ContentManager myContentManager;
    private State myState = new State();

    public DependenciesAnalyzeManager(final Project project) {
        this.myProject = project;
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                ToolWindowManager manager = ToolWindowManager.getInstance((Project)DependenciesAnalyzeManager.this.myProject);
                ToolWindow toolWindow = manager.registerToolWindow(ToolWindowId.MODULES_DEPENDENCIES, true, ToolWindowAnchor.RIGHT, (Disposable)project);
                DependenciesAnalyzeManager.this.myContentManager = toolWindow.getContentManager();
                toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowModuleDependencies);
                new ContentManagerWatcher(toolWindow, DependenciesAnalyzeManager.this.myContentManager);
            }
        });
    }

    public static DependenciesAnalyzeManager getInstance(Project project) {
        return (DependenciesAnalyzeManager)ServiceManager.getService((Project)project, DependenciesAnalyzeManager.class);
    }

    public void addContent(Content content) {
        this.myContentManager.addContent(content);
        this.myContentManager.setSelectedContent(content);
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.MODULES_DEPENDENCIES).activate(null);
    }

    public void closeContent(Content content) {
        this.myContentManager.removeContent(content, true);
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/moduleDependencies/DependenciesAnalyzeManager", "getState"));
        }
        return state;
    }

    public void loadState(State state) {
        this.myState = state != null ? state : new State();
    }

    public static class State {
        public boolean forwardDirection = true;
        public boolean includeTests = false;
    }
}

