/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.keymap.KeyboardSettingsExternalizable;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import java.awt.Component;
import java.awt.Window;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyboardInternationalizationNotificationManager {
    public static final String LOCALIZATION_GROUP_DISPLAY_ID = "Localization and Internationalization";
    public static boolean notificationHasBeenShown;

    private KeyboardInternationalizationNotificationManager() {
    }

    public static void showNotification() {
        if (notificationHasBeenShown || !KeyboardSettingsExternalizable.isSupportedKeyboardLayout((Component)WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow())) {
            return;
        }
        MyNotificationListener listener = new MyNotificationListener();
        Notifications.Bus.notify((Notification)KeyboardInternationalizationNotificationManager.createNotification(LOCALIZATION_GROUP_DISPLAY_ID, listener));
        notificationHasBeenShown = true;
    }

    public static Notification createNotification(@NotNull String groupDisplayId, @Nullable NotificationListener listener) {
        if (groupDisplayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayId", "com/intellij/openapi/editor/impl/KeyboardInternationalizationNotificationManager", "createNotification"));
        }
        String productName = ApplicationNamesInfo.getInstance().getProductName();
        Window recentFocusedWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        String text = "<html>We have found out that you are using a non-english keyboard layout. You can <a href='enable'>enable</a> smart layout support for " + KeyboardSettingsExternalizable.getDisplayLanguageNameForComponent((Component)recentFocusedWindow) + " language." + "You can change this option in the settings of " + productName + " <a href='settings'>more...</a></html>";
        String title = "Enable smart keyboard internationalization for " + productName + ".";
        return new Notification(groupDisplayId, title, text, NotificationType.INFORMATION, listener);
    }

    private static class MyNotificationListener
    implements NotificationListener {
        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/editor/impl/KeyboardInternationalizationNotificationManager$MyNotificationListener", "hyperlinkUpdate"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/KeyboardInternationalizationNotificationManager$MyNotificationListener", "hyperlinkUpdate"));
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String description = event.getDescription();
                if ("enable".equals(description)) {
                    KeyboardSettingsExternalizable.getInstance().setNonEnglishKeyboardSupportEnabled(true);
                } else if ("settings".equals(description)) {
                    ShowSettingsUtil util = ShowSettingsUtil.getInstance();
                    IdeFrame ideFrame = WindowManagerEx.getInstanceEx().findFrameFor(null);
                    util.showSettingsDialog(ideFrame.getProject(), KeymapPanel.class);
                }
                NotificationsConfiguration.getNotificationsConfiguration().changeSettings(KeyboardInternationalizationNotificationManager.LOCALIZATION_GROUP_DISPLAY_ID, NotificationDisplayType.NONE, false, false);
                notification.expire();
            }
        }
    }
}

