/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class DefaultExternalSystemExecutionConsoleManager
implements ExternalSystemExecutionConsoleManager<ExternalSystemRunConfiguration, ExecutionConsole, ProcessHandler> {
    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = ProjectSystemId.IDE;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/DefaultExternalSystemExecutionConsoleManager", "getExternalSystemId"));
        }
        return projectSystemId;
    }

    @NotNull
    public ExecutionConsole attachExecutionConsole(@NotNull ExternalSystemTask task, @NotNull Project project, @NotNull ExternalSystemRunConfiguration configuration, @NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler processHandler2) throws ExecutionException {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/service/execution/DefaultExternalSystemExecutionConsoleManager", "attachExecutionConsole"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/DefaultExternalSystemExecutionConsoleManager", "attachExecutionConsole"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/openapi/externalSystem/service/execution/DefaultExternalSystemExecutionConsoleManager", "attachExecutionConsole"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/openapi/externalSystem/service/execution/DefaultExternalSystemExecutionConsoleManager", "attachExecutionConsole"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/openapi/externalSystem/service/execution/DefaultExternalSystemExecutionConsoleManager", "attachExecutionConsole"));
        }
        if (processHandler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/openapi/externalSystem/service/execution/DefaultExternalSystemExecutionConsoleManager", "attachExecutionConsole"));
        }
        ConsoleView executionConsole = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        executionConsole.attachToProcess(processHandler2);
        ConsoleView consoleView = executionConsole;
        if (consoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/DefaultExternalSystemExecutionConsoleManager", "attachExecutionConsole"));
        }
        return consoleView;
    }

    public void onOutput(@NotNull ExecutionConsole executionConsole, @NotNull ProcessHandler processHandler2, @NotNull String text, @NotNull Key processOutputType) {
        if (executionConsole == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionConsole", "com/intellij/openapi/externalSystem/service/execution/DefaultExternalSystemExecutionConsoleManager", "onOutput"));
        }
        if (processHandler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/openapi/externalSystem/service/execution/DefaultExternalSystemExecutionConsoleManager", "onOutput"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/externalSystem/service/execution/DefaultExternalSystemExecutionConsoleManager", "onOutput"));
        }
        if (processOutputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processOutputType", "com/intellij/openapi/externalSystem/service/execution/DefaultExternalSystemExecutionConsoleManager", "onOutput"));
        }
        processHandler2.notifyTextAvailable(text, processOutputType);
    }

    public boolean isApplicableFor(@NotNull ExternalSystemTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/service/execution/DefaultExternalSystemExecutionConsoleManager", "isApplicableFor"));
        }
        return true;
    }

    public AnAction[] getRestartActions() {
        return new AnAction[0];
    }
}

