/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Order(value=-2147483647)
public class ModuleDataService
extends AbstractModuleDataService<ModuleData> {
    @NotNull
    public Key<ModuleData> getTargetDataKey() {
        Key key = ProjectKeys.MODULE;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "getTargetDataKey"));
        }
        return key;
    }

    @NotNull
    public Computable<Collection<Module>> computeOrphanData(final @NotNull Collection<DataNode<ModuleData>> toImport, final @NotNull ProjectData projectData, @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        Computable<Collection<Module>> computable = new Computable<Collection<Module>>(){

            public Collection<Module> compute() {
                List orphanIdeModules = ContainerUtil.newSmartList();
                for (Module module : modelsProvider.getModules()) {
                    if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module) || ExternalSystemApiUtil.getExternalModuleType((Module)module) != null) continue;
                    String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
                    if (!projectData.getLinkedExternalProjectPath().equals(rootProjectPath)) continue;
                    final String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
                    final String projectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
                    DataNode found = (DataNode)ContainerUtil.find((Iterable)toImport, (Condition)new Condition<DataNode<ModuleData>>(){

                        public boolean value(DataNode<ModuleData> node) {
                            ModuleData moduleData = (ModuleData)node.getData();
                            return moduleData.getId().equals(projectId) && moduleData.getLinkedExternalProjectPath().equals(projectPath);
                        }
                    });
                    if (found != null && FileUtil.pathsEqual((String)module.getModuleFilePath(), (String)((ModuleData)found.getData()).getModuleFilePath())) continue;
                    orphanIdeModules.add(module);
                }
                return orphanIdeModules;
            }
        };
        if (computable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        return computable;
    }
}

