/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorEmptyTextPainter {
    public void paintEmptyText(final @NotNull JComponent splitters, @NotNull Graphics g) {
        if (splitters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitters", "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter", "paintEmptyText"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter", "paintEmptyText"));
        }
        UISettings.setupAntialiasing((Graphics)g);
        g.setColor((Color)new JBColor((Color)Gray._80, (Color)Gray._160));
        g.setFont((Font)JBUI.Fonts.label((float)16.0f));
        UIUtil.TextPainter painter = new UIUtil.TextPainter().withLineSpacing(1.8f);
        this.advertiseActions(splitters, painter);
        painter.draw(g, (PairFunction)new PairFunction<Integer, Integer, Couple<Integer>>(){

            public Couple<Integer> fun(Integer width, Integer height) {
                Dimension s = splitters.getSize();
                int w = (s.width - width) / 2;
                int h = s.height * 3 / 8;
                return Couple.of((Object)w, (Object)h);
            }
        });
    }

    protected void advertiseActions(@NotNull JComponent splitters, @NotNull UIUtil.TextPainter painter) {
        if (splitters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitters", "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter", "advertiseActions"));
        }
        if (painter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter", "advertiseActions"));
        }
        this.appendSearchEverywhere(painter);
        this.appendToolWindow(painter, "Project View", ToolWindowId.PROJECT_VIEW, splitters);
        this.appendAction(painter, "Go to File", this.getActionShortcutText("GotoFile"));
        this.appendAction(painter, "Recent Files", this.getActionShortcutText("RecentFiles"));
        this.appendAction(painter, "Navigation Bar", this.getActionShortcutText("ShowNavBar"));
        this.appendDnd(painter);
    }

    protected void appendDnd(@NotNull UIUtil.TextPainter painter) {
        if (painter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter", "appendDnd"));
        }
        this.appendLine(painter, "Drop files here to open");
    }

    protected void appendSearchEverywhere(@NotNull UIUtil.TextPainter painter) {
        if (painter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter", "appendSearchEverywhere"));
        }
        Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("SearchEverywhere");
        this.appendAction(painter, "Search Everywhere", shortcuts.length == 0 ? "Double " + (SystemInfo.isMac ? "\u21e7" : "Shift") : KeymapUtil.getShortcutsText((Shortcut[])shortcuts));
    }

    protected void appendToolWindow(@NotNull UIUtil.TextPainter painter, @NotNull String action, @NotNull String toolWindowId, @NotNull JComponent splitters) {
        if (painter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter", "appendToolWindow"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter", "appendToolWindow"));
        }
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter", "appendToolWindow"));
        }
        if (splitters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitters", "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter", "appendToolWindow"));
        }
        if (!EditorEmptyTextPainter.isToolwindowVisible(splitters, toolWindowId)) {
            String activateActionId = ActivateToolWindowAction.getActionIdForToolWindow(toolWindowId);
            this.appendAction(painter, action, this.getActionShortcutText(activateActionId));
        }
    }

    protected void appendAction(@NotNull UIUtil.TextPainter painter, @NotNull String action, @Nullable String shortcut) {
        if (painter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter", "appendAction"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter", "appendAction"));
        }
        if (StringUtil.isEmpty((String)shortcut)) {
            return;
        }
        this.appendLine(painter, action + " " + "<shortcut>" + shortcut + "</shortcut>");
    }

    protected void appendLine(@NotNull UIUtil.TextPainter painter, String line) {
        if (painter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter", "appendLine"));
        }
        painter.appendLine(line);
    }

    @NotNull
    protected String getActionShortcutText(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter", "getActionShortcutText"));
        }
        String string = KeymapUtil.getFirstKeyboardShortcutText((String)actionId);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter", "getActionShortcutText"));
        }
        return string;
    }

    protected static boolean isToolwindowVisible(@NotNull JComponent splitters, @NotNull String toolwindowId) {
        Project project;
        if (splitters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitters", "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter", "isToolwindowVisible"));
        }
        if (toolwindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolwindowId", "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter", "isToolwindowVisible"));
        }
        Window frame = SwingUtilities.getWindowAncestor(splitters);
        if (frame instanceof IdeFrameImpl && (project = ((IdeFrameImpl)frame).getProject()) != null) {
            if (!project.isInitialized()) {
                return true;
            }
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(toolwindowId);
            return toolWindow != null && toolWindow.isVisible();
        }
        return false;
    }
}

