/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.LightFilePointer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HistoryEntry {
    @NonNls
    static final String TAG = "entry";
    private static final String FILE_ATTR = "file";
    @NonNls
    private static final String PROVIDER_ELEMENT = "provider";
    @NonNls
    private static final String EDITOR_TYPE_ID_ATTR = "editor-type-id";
    @NonNls
    private static final String SELECTED_ATTR_VALUE = "selected";
    @NonNls
    private static final String STATE_ELEMENT = "state";
    @NotNull
    private final VirtualFilePointer myFilePointer;
    @Nullable
    private FileEditorProvider mySelectedProvider;
    @NotNull
    private final HashMap<FileEditorProvider, FileEditorState> myProvider2State;
    @Nullable
    private final Disposable myDisposable;

    private HistoryEntry(@NotNull VirtualFilePointer filePointer, @Nullable FileEditorProvider selectedProvider, @Nullable Disposable disposable) {
        if (filePointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePointer", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "<init>"));
        }
        this.myFilePointer = filePointer;
        this.mySelectedProvider = selectedProvider;
        this.myDisposable = disposable;
        this.myProvider2State = new HashMap();
    }

    @NotNull
    public static HistoryEntry createLight(@NotNull VirtualFile file2, @NotNull FileEditorProvider[] providers, @NotNull FileEditorState[] states, @NotNull FileEditorProvider selectedProvider) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_ATTR, "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createLight"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createLight"));
        }
        if (states == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "states", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createLight"));
        }
        if (selectedProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedProvider", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createLight"));
        }
        LightFilePointer pointer = new LightFilePointer(file2);
        HistoryEntry entry = new HistoryEntry((VirtualFilePointer)pointer, selectedProvider, null);
        for (int i = 0; i < providers.length; ++i) {
            entry.putState(providers[i], states[i]);
        }
        HistoryEntry historyEntry = entry;
        if (historyEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createLight"));
        }
        return historyEntry;
    }

    @NotNull
    public static HistoryEntry createLight(@NotNull Project project, @NotNull Element e) throws InvalidDataException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createLight"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createLight"));
        }
        EntryData entryData = HistoryEntry.parseEntry(project, e);
        LightFilePointer pointer = new LightFilePointer(entryData.url);
        HistoryEntry entry = new HistoryEntry((VirtualFilePointer)pointer, entryData.selectedProvider, null);
        for (Pair<FileEditorProvider, FileEditorState> state : entryData.providerStates) {
            entry.putState((FileEditorProvider)state.first, (FileEditorState)state.second);
        }
        HistoryEntry historyEntry = entry;
        if (historyEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createLight"));
        }
        return historyEntry;
    }

    @NotNull
    public static HistoryEntry createHeavy(@NotNull Project project, @NotNull VirtualFile file2, @NotNull FileEditorProvider[] providers, @NotNull FileEditorState[] states, @NotNull FileEditorProvider selectedProvider) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createHeavy"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_ATTR, "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createHeavy"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createHeavy"));
        }
        if (states == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "states", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createHeavy"));
        }
        if (selectedProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedProvider", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createHeavy"));
        }
        if (project.isDisposed()) {
            HistoryEntry historyEntry = HistoryEntry.createLight(file2, providers, states, selectedProvider);
            if (historyEntry == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createHeavy"));
            }
            return historyEntry;
        }
        Disposable disposable = Disposer.newDisposable();
        VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(file2, disposable, null);
        HistoryEntry entry = new HistoryEntry(pointer, selectedProvider, disposable);
        for (int i = 0; i < providers.length; ++i) {
            entry.putState(providers[i], states[i]);
        }
        HistoryEntry historyEntry = entry;
        if (historyEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createHeavy"));
        }
        return historyEntry;
    }

    @NotNull
    public static HistoryEntry createHeavy(@NotNull Project project, @NotNull Element e) throws InvalidDataException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createHeavy"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createHeavy"));
        }
        if (project.isDisposed()) {
            HistoryEntry historyEntry = HistoryEntry.createLight(project, e);
            if (historyEntry == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createHeavy"));
            }
            return historyEntry;
        }
        EntryData entryData = HistoryEntry.parseEntry(project, e);
        Disposable disposable = Disposer.newDisposable();
        VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(entryData.url, disposable, null);
        HistoryEntry entry = new HistoryEntry(pointer, entryData.selectedProvider, disposable);
        for (Pair<FileEditorProvider, FileEditorState> state : entryData.providerStates) {
            entry.putState((FileEditorProvider)state.first, (FileEditorState)state.second);
        }
        HistoryEntry historyEntry = entry;
        if (historyEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "createHeavy"));
        }
        return historyEntry;
    }

    @NotNull
    public VirtualFilePointer getFilePointer() {
        VirtualFilePointer virtualFilePointer = this.myFilePointer;
        if (virtualFilePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "getFilePointer"));
        }
        return virtualFilePointer;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.myFilePointer.getFile();
    }

    public FileEditorState getState(@NotNull FileEditorProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PROVIDER_ELEMENT, "com/intellij/openapi/fileEditor/impl/HistoryEntry", "getState"));
        }
        return (FileEditorState)this.myProvider2State.get((Object)provider);
    }

    public void putState(@NotNull FileEditorProvider provider, @NotNull FileEditorState state) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PROVIDER_ELEMENT, "com/intellij/openapi/fileEditor/impl/HistoryEntry", "putState"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", STATE_ELEMENT, "com/intellij/openapi/fileEditor/impl/HistoryEntry", "putState"));
        }
        this.myProvider2State.put((Object)provider, (Object)state);
    }

    @Nullable
    public FileEditorProvider getSelectedProvider() {
        return this.mySelectedProvider;
    }

    public void setSelectedProvider(@Nullable FileEditorProvider value) {
        this.mySelectedProvider = value;
    }

    public void destroy() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    public Element writeExternal(Element element, Project project) {
        Element e = new Element(TAG);
        element.addContent(e);
        e.setAttribute(FILE_ATTR, this.myFilePointer.getUrl());
        for (Map.Entry entry : this.myProvider2State.entrySet()) {
            FileEditorProvider provider = (FileEditorProvider)entry.getKey();
            Element providerElement = new Element(PROVIDER_ELEMENT);
            if (provider.equals(this.mySelectedProvider)) {
                providerElement.setAttribute(SELECTED_ATTR_VALUE, Boolean.TRUE.toString());
            }
            providerElement.setAttribute(EDITOR_TYPE_ID_ATTR, provider.getEditorTypeId());
            Element stateElement = new Element(STATE_ELEMENT);
            providerElement.addContent(stateElement);
            provider.writeState((FileEditorState)entry.getValue(), project, stateElement);
            e.addContent(providerElement);
        }
        return e;
    }

    @NotNull
    private static EntryData parseEntry(@NotNull Project project, @NotNull Element e) throws InvalidDataException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "parseEntry"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "parseEntry"));
        }
        if (!e.getName().equals(TAG)) {
            throw new IllegalArgumentException("unexpected tag: " + e);
        }
        String url = e.getAttributeValue(FILE_ATTR);
        ArrayList<Pair<FileEditorProvider, FileEditorState>> providerStates = new ArrayList<Pair<FileEditorProvider, FileEditorState>>();
        FileEditorProvider selectedProvider = null;
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
        for (Element _e : e.getChildren(PROVIDER_ELEMENT)) {
            Element stateElement;
            String typeId = _e.getAttributeValue(EDITOR_TYPE_ID_ATTR);
            FileEditorProvider provider = FileEditorProviderManager.getInstance().getProvider(typeId);
            if (provider == null) continue;
            if (Boolean.valueOf(_e.getAttributeValue(SELECTED_ATTR_VALUE)).booleanValue()) {
                selectedProvider = provider;
            }
            if ((stateElement = _e.getChild(STATE_ELEMENT)) == null) {
                throw new InvalidDataException();
            }
            if (file2 == null) continue;
            FileEditorState state = provider.readState(stateElement, project, file2);
            providerStates.add((Pair<FileEditorProvider, FileEditorState>)Pair.create((Object)provider, (Object)state));
        }
        EntryData entryData = new EntryData(url, providerStates, selectedProvider);
        if (entryData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "parseEntry"));
        }
        return entryData;
    }

    private static class EntryData {
        @NotNull
        public final String url;
        @NotNull
        public final List<Pair<FileEditorProvider, FileEditorState>> providerStates;
        @Nullable
        public final FileEditorProvider selectedProvider;

        public EntryData(@NotNull String url, @NotNull List<Pair<FileEditorProvider, FileEditorState>> providerStates, @Nullable FileEditorProvider selectedProvider) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/fileEditor/impl/HistoryEntry$EntryData", "<init>"));
            }
            if (providerStates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerStates", "com/intellij/openapi/fileEditor/impl/HistoryEntry$EntryData", "<init>"));
            }
            this.url = url;
            this.providerStates = providerStates;
            this.selectedProvider = selectedProvider;
        }
    }
}

