/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExporter;
import com.intellij.openapi.util.LazyInstance;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemeExporterEP<S extends Scheme>
extends AbstractExtensionPointBean {
    public static final ExtensionPointName<SchemeExporterEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.schemeExporter");
    @Attribute(value="name")
    public String name;
    @Attribute(value="schemeClass")
    public String schemeClass;
    @Attribute(value="implementationClass")
    public String implementationClass;
    private final LazyInstance<SchemeExporter<S>> myExporterInstance = new LazyInstance<SchemeExporter<S>>(){

        protected Class<SchemeExporter<S>> getInstanceClass() throws ClassNotFoundException {
            return SchemeExporterEP.this.findClass(SchemeExporterEP.this.implementationClass);
        }
    };

    public SchemeExporter<S> getInstance() {
        return (SchemeExporter)this.myExporterInstance.getValue();
    }

    @NotNull
    public static <S extends Scheme> Collection<SchemeExporterEP<S>> getExtensions(Class<S> schemeClass) {
        ArrayList<SchemeExporterEP<S>> exporters = new ArrayList<SchemeExporterEP<S>>();
        for (SchemeExporterEP exporterEP : (SchemeExporterEP[])EP_NAME.getExtensions()) {
            if (!schemeClass.getName().equals(exporterEP.schemeClass)) continue;
            exporters.add(exporterEP);
        }
        ArrayList<SchemeExporterEP<S>> arrayList = exporters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemeExporterEP", "getExtensions"));
        }
        return arrayList;
    }

    @Nullable
    public static <S extends Scheme> SchemeExporter<S> getExporter(@NotNull String name, Class<S> schemeClass) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/options/SchemeExporterEP", "getExporter"));
        }
        for (SchemeExporterEP<S> exporterEP : SchemeExporterEP.getExtensions(schemeClass)) {
            if (!name.equals(exporterEP.name)) continue;
            return exporterEP.getInstance();
        }
        return null;
    }
}

