/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.ConfigurableFilter;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurablesGroupBase
implements ConfigurableGroup {
    private Configurable[] myChildren;
    private final ComponentManager myComponentManager;
    private final ExtensionPointName<ConfigurableEP<Configurable>> myConfigurablesExtensionPoint;

    protected ConfigurablesGroupBase(ComponentManager componentManager, ExtensionPointName<ConfigurableEP<Configurable>> configurablesExtensionPoint) {
        this.myComponentManager = componentManager;
        this.myConfigurablesExtensionPoint = configurablesExtensionPoint;
    }

    public Configurable[] getConfigurables() {
        if (this.myChildren == null) {
            if (this.myComponentManager.isDisposed()) {
                return new Configurable[0];
            }
            ConfigurableEP[] extensions = (ConfigurableEP[])this.myComponentManager.getExtensions(this.myConfigurablesExtensionPoint);
            List<Configurable> result2 = ConfigurableExtensionPointUtil.buildConfigurablesList(extensions, this.getConfigurableFilter());
            this.myChildren = result2.toArray(new Configurable[result2.size()]);
        }
        return this.myChildren;
    }

    @Nullable
    protected abstract ConfigurableFilter getConfigurableFilter();

    public String getShortName() {
        return null;
    }
}

