/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.NonProjectDirectoryInfo;
import com.intellij.openapi.roots.impl.RootIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Query;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class DirectoryIndexImpl
extends DirectoryIndex {
    private static final Logger LOG = Logger.getInstance(DirectoryIndexImpl.class);
    private final Project myProject;
    private final MessageBusConnection myConnection;
    private volatile boolean myDisposed;
    private volatile RootIndex myRootIndex;

    public DirectoryIndexImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "<init>"));
        }
        this.myProject = project;
        this.myConnection = project.getMessageBus().connect((Disposable)project);
        this.subscribeToFileChanges();
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                DirectoryIndexImpl.this.myDisposed = true;
                DirectoryIndexImpl.this.myRootIndex = null;
            }
        });
    }

    protected void subscribeToFileChanges() {
        this.myConnection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener.Adapter(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$2", "fileTypesChanged"));
                }
                DirectoryIndexImpl.this.myRootIndex = null;
            }
        });
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                DirectoryIndexImpl.this.myRootIndex = null;
            }
        });
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$4", "after"));
                }
                RootIndex rootIndex = DirectoryIndexImpl.this.myRootIndex;
                if (rootIndex != null && rootIndex.resetOnEvents(events)) {
                    DirectoryIndexImpl.this.myRootIndex = null;
                }
            }
        });
    }

    protected void dispatchPendingEvents() {
        this.myConnection.deliverImmediately();
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getDirectoriesByPackageName"));
        }
        Query<VirtualFile> query = this.getRootIndex().getDirectoriesByPackageName(packageName, includeLibrarySources);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getDirectoriesByPackageName"));
        }
        return query;
    }

    @NotNull
    private RootIndex getRootIndex() {
        RootIndex rootIndex = this.myRootIndex;
        if (rootIndex == null) {
            this.myRootIndex = rootIndex = new RootIndex(this.myProject, this.createRootInfoCache());
        }
        RootIndex rootIndex2 = rootIndex;
        if (rootIndex2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getRootIndex"));
        }
        return rootIndex2;
    }

    protected RootIndex.InfoCache createRootInfoCache() {
        return new RootIndex.InfoCache(){
            private final ConcurrentIntObjectMap<DirectoryInfo> myInfoCache = ContainerUtil.createConcurrentIntObjectMap();

            @Override
            public void cacheInfo(@NotNull VirtualFile dir, @NotNull DirectoryInfo info) {
                if (dir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$5", "cacheInfo"));
                }
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$5", "cacheInfo"));
                }
                this.myInfoCache.put(((NewVirtualFile)dir).getId(), (Object)info);
            }

            @Override
            public DirectoryInfo getCachedInfo(@NotNull VirtualFile dir) {
                if (dir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$5", "getCachedInfo"));
                }
                return (DirectoryInfo)this.myInfoCache.get(((NewVirtualFile)dir).getId());
            }
        };
    }

    @Override
    public DirectoryInfo getInfoForDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getInfoForDirectory"));
        }
        DirectoryInfo info = this.getInfoForFile(dir);
        return info.isInProject() ? info : null;
    }

    @Override
    @NotNull
    public DirectoryInfo getInfoForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getInfoForFile"));
        }
        this.checkAvailability();
        this.dispatchPendingEvents();
        if (!(file2 instanceof NewVirtualFile)) {
            NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.NOT_SUPPORTED_VIRTUAL_FILE_IMPLEMENTATION;
            if (nonProjectDirectoryInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getInfoForFile"));
            }
            return nonProjectDirectoryInfo;
        }
        DirectoryInfo directoryInfo = this.getRootIndex().getInfoForFile(file2);
        if (directoryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getInfoForFile"));
        }
        return directoryInfo;
    }

    @Override
    @Nullable
    public JpsModuleSourceRootType<?> getSourceRootType(@NotNull DirectoryInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getSourceRootType"));
        }
        if (info.isInModuleSource()) {
            return this.getRootIndex().getSourceRootType(info);
        }
        return null;
    }

    @Override
    public String getPackageName(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getPackageName"));
        }
        this.checkAvailability();
        if (!(dir instanceof NewVirtualFile)) {
            return null;
        }
        return this.getRootIndex().getPackageName(dir);
    }

    @Override
    @NotNull
    public List<OrderEntry> getOrderEntries(@NotNull DirectoryInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getOrderEntries"));
        }
        this.checkAvailability();
        List<OrderEntry> list = this.getRootIndex().getOrderEntries(info);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getOrderEntries"));
        }
        return list;
    }

    void assertConsistency(DirectoryInfo info) {
        List<OrderEntry> entries = this.getOrderEntries(info);
        for (int i = 1; i < entries.size(); ++i) {
            assert (RootIndex.BY_OWNER_MODULE.compare(entries.get(i - 1), entries.get(i)) <= 0);
        }
    }

    private void checkAvailability() {
        if (this.myDisposed) {
            ProgressManager.checkCanceled();
            LOG.error("Directory index is already disposed for " + this.myProject);
        }
    }
}

