/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class AddFacetOfTypeAction
extends DumbAwareAction {
    private final FacetType myFacetType;
    private final StructureConfigurableContext myContext;

    AddFacetOfTypeAction(FacetType type, StructureConfigurableContext context) {
        super(type.getPresentableName(), null, type.getIcon());
        this.myFacetType = type;
        this.myContext = context;
    }

    public void actionPerformed(AnActionEvent e) {
        FacetType type = this.myFacetType;
        if (type == null) {
            return;
        }
        FacetTypeId underlyingFacetType = type.getUnderlyingFacetType();
        if (underlyingFacetType == null) {
            this.addFacetToModule(type);
        } else {
            this.addSubFacet(type, underlyingFacetType);
        }
    }

    private void addSubFacet(FacetType type, FacetTypeId<?> underlyingType) {
        ProjectFacetsConfigurator facetsConfigurator = this.myContext.getModulesConfigurator().getFacetsConfigurator();
        ArrayList suitableParents = new ArrayList();
        for (Module module : this.myContext.getModules()) {
            if (!type.isSuitableModuleType(ModuleType.get((Module)module))) continue;
            suitableParents.addAll(facetsConfigurator.getFacetsByType(module, underlyingType));
        }
        Iterator iterator = suitableParents.iterator();
        while (iterator.hasNext()) {
            Facet parent = (Facet)iterator.next();
            if (!type.isOnlyOneFacetAllowed() || !facetsConfigurator.hasFacetOfType(parent.getModule(), parent, type.getId())) continue;
            iterator.remove();
        }
        Project project = this.myContext.getProject();
        if (suitableParents.isEmpty()) {
            String parentType = FacetTypeRegistry.getInstance().findFacetType(underlyingType).getPresentableName();
            Messages.showErrorDialog((Project)project, (String)("No suitable parent " + parentType + " facets found"), (String)("Cannot Create " + type.getPresentableName() + " Facet"));
            return;
        }
        ChooseParentFacetDialog dialog = new ChooseParentFacetDialog(project, suitableParents);
        dialog.show();
        List chosen = dialog.getChosenElements();
        if (!dialog.isOK() || chosen.size() != 1) {
            return;
        }
        Facet parent = (Facet)chosen.get(0);
        Facet facet = ModuleStructureConfigurable.getInstance(project).getFacetEditorFacade().createAndAddFacet(type, parent.getModule(), parent);
        ProjectStructureConfigurable.getInstance(project).select(facet, true);
    }

    private void addFacetToModule(@NotNull FacetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/ui/configuration/projectRoot/AddFacetOfTypeAction", "addFacetToModule"));
        }
        ProjectFacetsConfigurator facetsConfigurator = this.myContext.getModulesConfigurator().getFacetsConfigurator();
        ArrayList<Module> suitableModules = new ArrayList<Module>(Arrays.asList(this.myContext.getModules()));
        Iterator iterator = suitableModules.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            if (type.isSuitableModuleType(ModuleType.get((Module)module)) && (!type.isOnlyOneFacetAllowed() || !facetsConfigurator.hasFacetOfType(module, null, type.getId()))) continue;
            iterator.remove();
        }
        Project project = this.myContext.getProject();
        if (suitableModules.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)("No suitable modules for " + type.getPresentableName() + " facet found."), (String)"Cannot Create Facet");
            return;
        }
        ChooseModulesDialog dialog = new ChooseModulesDialog(project, (List<? extends Module>)suitableModules, "Choose Module", type.getPresentableName() + " facet will be added to selected module");
        dialog.setSingleSelectionMode();
        dialog.show();
        List elements = dialog.getChosenElements();
        if (!dialog.isOK() || elements.size() != 1) {
            return;
        }
        Module module = (Module)elements.get(0);
        Facet facet = ModuleStructureConfigurable.getInstance(project).getFacetEditorFacade().createAndAddFacet(type, module, null);
        ProjectStructureConfigurable.getInstance(project).select(facet, true);
    }

    public static AnAction[] createAddFacetActions(FacetStructureConfigurable configurable) {
        ArrayList<AddFacetOfTypeAction> result2 = new ArrayList<AddFacetOfTypeAction>();
        StructureConfigurableContext context = configurable.myContext;
        for (FacetType type : FacetTypeRegistry.getInstance().getSortedFacetTypes()) {
            if (!AddFacetOfTypeAction.hasSuitableModules(context, type)) continue;
            result2.add(new AddFacetOfTypeAction(type, context));
        }
        return result2.toArray(new AnAction[result2.size()]);
    }

    private static boolean hasSuitableModules(StructureConfigurableContext context, FacetType type) {
        for (Module module : context.getModules()) {
            if (!type.isSuitableModuleType(ModuleType.get((Module)module))) continue;
            return true;
        }
        return false;
    }

    private static class ChooseParentFacetDialog
    extends ChooseElementsDialog<Facet> {
        private ChooseParentFacetDialog(Project project, List<? extends Facet> items) {
            super(project, items, "Select Parent Facet", null, true);
            this.myChooser.setSingleSelectionMode();
        }

        @Override
        protected String getItemText(Facet item) {
            return item.getName() + " (module " + item.getModule().getName() + ")";
        }

        @Override
        protected Icon getItemIcon(Facet item) {
            return item.getType().getIcon();
        }
    }
}

