/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.CheckForUpdateResult;
import com.intellij.openapi.updateSettings.impl.NewChannelDialog;
import com.intellij.openapi.updateSettings.impl.NoUpdatesDialog;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateChecker$PATCHES_URL$1;
import com.intellij.openapi.updateSettings.impl.UpdateChecker$UPDATE_URL$1;
import com.intellij.openapi.updateSettings.impl.UpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.swing.event.HyperlinkEvent;
import kotlin.CollectionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.SetsKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"Y\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q!\u0001\u0003\u0002\u000b\u0005Aq!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011-Q!\u0001\u0005\u0012\u000b\u0005!!!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t$\u0015\u0001Q!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u000b)\u0011\u0001C\u0001\u0006\u0003\u0011\u0015Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001#\n\u0006\u00031\tQ\u0001A\u0003\u0002\u0011?)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!yQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\r\u0003\u0015\tA\u0011B\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0004\u000b\u0005a\u0011!B\u0001\u0005\n\u0011\u0019\u0017\u0001\u0004\u0001\u001a\u0003a\u0005Q\u0014!\u001e\"\b\u0011\t\u0011kA\u0001\t\u0003\u0015bAq\u0001\u0005\u0017\u001b\u0005Aj#G\u0002\t/5\t\u0001DA\r\u0004\u0011_i\u0011\u0001\u0007\u0002&G\u0011\u001d\u0001\u0002G\u0007\u00021[I2\u0001#\r\u000e\u0003a\u001d\u0012d\u0001\u0005\u001a\u001b\u0005A\u001a$G\u0005\t559\u0011BA\u0005\u00021mI!!C\u0001\u0019(aU\u0012d\u0002E\u001c\u001b\u0015I!!C\u0001\u0019:1\u0005\u0001\u0004H\r\u0005\u0011ui!\u0001$\u0001\u0019<\u0015BAq\u0001\u0005\u001f\u001b\u0005Aj#G\u0002\t>5\t\u0001dH\u0013\t\t\u0005Ay$D\u0001\u0019Ae\u0019\u0001\u0012I\u0007\u00021\u0005*c\u0004B\u0001\tD5)\u0011BA\u0005\u00021Oa\t\u0001\u0007\u0012\u001a\u0007!\u0015S\"\u0001\r\"3\u0011AQ$\u0004\u0002\r\u0002am\u0012d\u0002E\u001c\u001b\u0015I!!C\u0001\u0019:1\u0005\u0001\u0004H\r\u0005\u0011\rj!\u0001$\u0001\u0019H\u0015RA!\u0001\u0005%\u001b\u001dI!!C\u0001\u00197%\u0011\u0011\"\u0001M\u001d1k)s\u0004B\u0001\tJ5\t\u0001TF\r\u0005\u0011\u0015j!\u0001$\u0001\u0019Le\u0019\u0001BJ\u0007\u00021GI2\u0001#\u0014\u000e\u0003a\r\u0012d\u0001E#\u001b\u0005A\u0012%\u0007\u0003\t;5\u0011A\u0012\u0001M\u001e3\u0011Aq%\u0004\u0002\r\u0002a=S\u0005\u0006\u0003\u0002\u0011!j\u0011\u0001'\f\u001a\u0007!ES\"\u0001\r*3\rA\u0019&D\u0001\u0019He\u0019\u0001BK\u0007\u00021GI2\u0001C\u000f\u000e\u0003amR\u0005\u0002\u0003\u0002\u0011+j\u0011\u0001\u0007\u0002&\u0011\u0011\u001d\u0001bK\u0007\u00021\tI2\u0001c\u0016\u000e\u0003aaS%\u0003\u0003\u0002\u00113j!\u0001$\u0001\u0019\u0005e\u0019\u0001rK\u0007\u000211*\u0003\u0003b\u0002\t[5\t\u0001TF\r\u0004\u0011#j\u0011\u0001G\u0015\u001a\u0007!MS\"\u0001M$3\rA!&D\u0001\u0019$\u0015zAq\u0001E.\u001b\u0005A\u001a#\u0007\u0004\t]5!\u0011BA\u0005\u00021OA\"%G\u0002\t;5\t\u00014H\u0013\t\t\u0005Ai&D\u0001\u0019$e\u0019\u0001bL\u0007\u00021\t)C\u0002B\u0001\t`5\t\u00014E\r\u0004\u0011\u0015j\u0011\u0001g\u0013\u001a\u0007!yS\"\u0001\r\u0003K%!\u0019\u0001\u0003\u0019\u000e\u0003a\r\u0012\u0004\u0002E1\u001b\ta\t\u0001G\u0019&\u0011\u0011\t\u00012M\u0007\u00021[I2\u0001\u0003\u001a\u000e\u0003a\u0015T\u0005\u0002C\u0004\u0011Mj\u0011\u0001'\f&\u0019\u0011\t\u0001rM\u0007\u00021[I2\u0001\u0003\u001b\u000e\u0003a\r\u0012d\u0001E5\u001b\u0005A\"!\n\u000e\u0005\u0003!)T\"\u0001M\u00173\u0011AQ%\u0004\u0002\r\u0002a-\u0013d\u0001E5\u001b\u0005A\"!G\u0004\tl5)\u0011BA\u0005\u00021[a\t\u0001\u0007\u001c\u001a\t!5TB\u0001G\u00011K)\u0013\u0006B\u0001\to5\t\u0001TF\r\u0005\u0011\u0015j!\u0001$\u0001\u0019Le\u0019\u0001rN\u0007\u00021\u0001J2\u0001#\u0012\u000e\u0003a\t\u0013d\u0002\u00059\u001b\u0015I!!C\u0001\u0019(1\u0005\u0001DI\r\b\u0011oiQ!\u0003\u0002\n\u0003aeB\u0012\u0001\r#3\rA\t(D\u0001\u0019$e\u0019\u0001\"O\u0007\u00021G)C\u0001b\u0002\tt5\t\u0001tJ\u0013\u000f\t\u000fA\u0019(D\u0001\u0019.e!\u0001\"J\u0007\u0003\u0019\u0003AZ%\u0007\u0003\tu5\u0011A\u0012\u0001\r\"S\u001f!\u0011\tS\u0001\t\u00045\t\u0001DA)\u0004\u0003\u0015\u0001\u0011v\u0002\u0003B\u0011\u0006A)!D\u0001\u0019\u0005E\u001b\u0011!\u0002\u0001*\u0017\u0011\t\u0005\u0002C\u0002\u000e\u000bA!QC\u0001G\u00011\u000fA:!U\u0002\u0002\u000b\u0001I\u0003\u0002b\"\t\u0011\u0013i\u0011\u0001G\u0003\u001d\u0007E\u001b\u0011!\u0002\u0001*\u0016\u0011\u0019\u0005*\u0001E\u0006\u001b\u0005A\"!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0004\t\u000e%\nB!\u0011\u0005\t\u000f5)\u0001\u0003B\u000b\u0003\u0019\u0003A\"\u0001\u0007\u0002\u001dCE\u001ba!\u0002\u0002\u0005\u0011!EQB\u0001C\b\u0011\u001bI\u0013\u0003B!\t\u0011%iQ\u0001\u0005\u0003\u0016\u00051\u0005\u0001D\u0001\r\u00039\u0005\n6AB\u0003\u0003\t)A\t\"\u0004\u0002\u0005\u0014!5\u0011\u0006\u0005CD\u0011!UQ\u0002B\u0005\u0003\u0013\u0005A\"\u0001G\u0006\u001dGE\u001ba!\u0003\u0002\u0005\u0018!\tQB\u0001\u0003\r\u00113IS\u0002B\"\t\u00115iA!\u0003\u0002\n\u0003a\u0011\u00014D)\u0004\t\u0015\u0001QB\u0001\u0003\u000f\u0011;IS\u0002B!\t\u0011=iq!\u0003\u0002\n\u0003a\u0011\u0011BA\u0005\u00021\tAz\"U\u0002\u0002\u000b\u0001I3\u0002B!\u001d\u0011AiQ!\u0003\u0002\n\u0003a\u0011A\u0012\u0001M\u0011#\u000e\tQ\u0001A\u0015\b\t\u0005c\u0002\"E\u0007\u00021G\t6!A\u0003\u0001Se!\u0011\t\u0003\u0005\u0013\u001bMIa!C\u0003\u0011\tU\u0011A\u0012\u0001M\u00131K\u0001B!F\u0005\n\r%)\u0001\u0003B\u000b\u0003\u0019\u0003A*\u0003'\n\r\u0002aY\u0001\u0014E)\u0004\u0003\u0015\u0001\u0011&\u0004\u0003B\u0011!\u0019RbB\u0005\u0003\u0013\u0005A\"!\u0003\u0002\n\u0003a\u001d\u0002tD)\u0004\u0003\u0015\u0001\u0011F\u0003\u0003B\u0011!!R\"\u0001\r\u00039\u0005\n6aA\u0007\u0003\tSAi!\u000b\u0006\u0005\u0003\"AQ#D\u0001\u0019\u0005q\t\u0013kA\u0002\u000e\u0005\u0011-\u0002R\u0002"}, strings={"Lcom/intellij/openapi/updateSettings/impl/UpdateChecker;", "", "()V", "DISABLED_UPDATE", "", "INSTALLATION_UID", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.jvm.PlatformType", "NOTIFICATIONS", "Lcom/intellij/notification/NotificationGroup;", "NO_PLATFORM_UPDATE", "getNO_PLATFORM_UPDATE", "()Ljava/lang/String;", "PATCHES_URL", "getPATCHES_URL", "PATCHES_URL$delegate", "Lkotlin/Lazy;", "UPDATE_URL", "getUPDATE_URL", "UPDATE_URL$delegate", "disabledToUpdatePlugins", "", "disabledToUpdatePlugins$annotations", "getDisabledToUpdatePlugins", "()Ljava/util/Set;", "excludedFromUpdateCheckPlugins", "Ljava/util/HashSet;", "getExcludedFromUpdateCheckPlugins", "()Ljava/util/HashSet;", "ourAdditionalRequestOptions", "Ljava/util/HashMap;", "ourDisabledToUpdatePlugins", "", "ourHasFailedPlugins", "", "ourShownNotificationTypes", "Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$NotificationUniqueType;", "ourUpdatedPlugins", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "patchesUrl", "getPatchesUrl", "updateUrl", "getUpdateUrl", "addUpdateRequestParameter", "", "name", "value", "checkAndPrepareToInstall", "downloader", "state", "Lcom/intellij/ide/plugins/InstalledPluginsState;", "toUpdate", "", "Lcom/intellij/openapi/extensions/PluginId;", "incompatiblePlugins", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "checkForUpdate", "event", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "checkPlatformUpdate", "Lcom/intellij/openapi/updateSettings/impl/CheckForUpdateResult;", "settings", "Lcom/intellij/openapi/updateSettings/impl/UpdateSettings;", "checkPluginsUpdate", "", "updateSettings", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "collectUpdateablePlugins", "doUpdateAndShowResult", "project", "Lcom/intellij/openapi/project/Project;", "fromSettings", "manualCheck", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "downloadAndInstallPatch", "patch", "Lcom/intellij/openapi/updateSettings/impl/PatchInfo;", "toBuild", "forceHttps", "generateUUID", "getInstallationUID", "propertiesComponent", "Lcom/intellij/ide/util/PropertiesComponent;", "getInstallationUIDOnWindows", "installPlatformUpdate", "installPluginUpdates", "downloaders", "isRequiredForAnyOpenProject", "pluginId", "isRequiredForProject", "newChannelReady", "channelToPropose", "Lcom/intellij/openapi/updateSettings/impl/UpdateChannel;", "prepareUpdateCheckArgs", "uriBuilder", "Lorg/apache/http/client/utils/URIBuilder;", "saveDisabledToUpdatePlugins", "showErrorMessage", "showDialog", "message", "showNotification", "runnable", "Lkotlin/Function0;", "notificationType", "showUpdateResult", "checkForUpdateResult", "updatedPlugins", "enableLink", "alwaysShowResults", "updateAndShowResult", "customSettings", "NotificationUniqueType"}, moduleName="platform-impl")
public final class UpdateChecker {
    private static final Logger LOG;
    @NotNull
    public static final String NO_PLATFORM_UPDATE = "ide.no.platform.update";
    @JvmField
    @NotNull
    public static final NotificationGroup NOTIFICATIONS;
    private static final String INSTALLATION_UID = "installation.uid";
    private static final String DISABLED_UPDATE = "disabled_update.txt";
    private static Set<String> ourDisabledToUpdatePlugins;
    private static final HashMap<String, String> ourAdditionalRequestOptions;
    private static final HashMap<String, PluginDownloader> ourUpdatedPlugins;
    private static final Set<NotificationUniqueType> ourShownNotificationTypes;
    private static final Lazy<? extends String> UPDATE_URL$delegate;
    private static final Lazy<? extends String> PATCHES_URL$delegate;
    @NotNull
    public static final HashSet<String> excludedFromUpdateCheckPlugins;
    private static boolean ourHasFailedPlugins;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final UpdateChecker INSTANCE;
    public static final UpdateChecker INSTANCE$;

    @NotNull
    public final String getNO_PLATFORM_UPDATE() {
        return NO_PLATFORM_UPDATE;
    }

    private final String getUPDATE_URL() {
        return (String)LazyKt.getValue(UPDATE_URL$delegate, (Object)this, (KProperty)$$delegatedProperties[0]);
    }

    private final String getPATCHES_URL() {
        return (String)LazyKt.getValue(PATCHES_URL$delegate, (Object)this, (KProperty)$$delegatedProperties[1]);
    }

    @NotNull
    public final HashSet<String> getExcludedFromUpdateCheckPlugins() {
        return excludedFromUpdateCheckPlugins;
    }

    private final String getUpdateUrl() {
        String string = System.getProperty("idea.updates.url");
        if (string == null) {
            String string2 = this.getUPDATE_URL();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"UPDATE_URL");
        }
        return string;
    }

    private final String getPatchesUrl() {
        String string = System.getProperty("idea.patches.url");
        if (string == null) {
            String string2 = this.getPATCHES_URL();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PATCHES_URL");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final ActionCallback updateAndShowResult() {
        ActionCallback callback = new ActionCallback();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(callback){
            final /* synthetic */ ActionCallback $callback;

            public final void run() {
                Project project = null;
                UpdateSettings updateSettings = UpdateSettings.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)updateSettings, (String)"UpdateSettings.getInstance()");
                UpdateChecker.access$doUpdateAndShowResult(UpdateChecker.INSTANCE, project, true, false, updateSettings, null, this.$callback);
            }
            {
                this.$callback = actionCallback;
            }
        });
        return callback;
    }

    @JvmStatic
    public static final void updateAndShowResult(@Nullable Project project, @Nullable UpdateSettings customSettings) {
        UpdateSettings updateSettings = customSettings;
        if (updateSettings == null) {
            updateSettings = UpdateSettings.getInstance();
        }
        UpdateSettings settings = updateSettings;
        boolean fromSettings = customSettings != null;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(fromSettings, settings, project, IdeBundle.message((String)"updates.checking.progress", (Object[])new Object[0]), true){
            final /* synthetic */ boolean $fromSettings;
            final /* synthetic */ UpdateSettings $settings;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                Project project = this.getProject();
                UpdateSettings updateSettings = this.$settings;
                Intrinsics.checkExpressionValueIsNotNull((Object)updateSettings, (String)"settings");
                UpdateChecker.access$doUpdateAndShowResult(UpdateChecker.INSTANCE, project, this.$fromSettings, true, updateSettings, indicator, null);
            }

            public boolean isConditionalModal() {
                return this.$fromSettings;
            }

            public boolean shouldStartInBackground() {
                return !this.$fromSettings;
            }
            {
                this.$fromSettings = $captured_local_variable$0;
                this.$settings = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
    }

    private final void doUpdateAndShowResult(Project project, boolean fromSettings, boolean manualCheck, UpdateSettings updateSettings, ProgressIndicator indicator, ActionCallback callback) {
        Collection incompatiblePlugins;
        Collection<PluginDownloader> updatedPlugins;
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setText(IdeBundle.message((String)"updates.checking.platform", (Object[])new Object[0]));
        }
        CheckForUpdateResult result2 = this.checkPlatformUpdate(updateSettings);
        if (manualCheck && Intrinsics.areEqual((Object)((Object)result2.getState()), (Object)((Object)UpdateStrategy.State.LOADED))) {
            UpdateSettings settings = UpdateSettings.getInstance();
            settings.saveLastCheckedInfo();
            settings.setKnownChannelIds(result2.getAllChannelsIds());
        } else if (Intrinsics.areEqual((Object)((Object)result2.getState()), (Object)((Object)UpdateStrategy.State.CONNECTION_ERROR))) {
            Object object;
            Exception e = result2.getError();
            if (e != null) {
                LOG.debug((Throwable)e);
            }
            if ((object = e) == null || (object = ((Throwable)object).getMessage()) == null) {
                object = "internal error";
            }
            Object cause = object;
            String string = IdeBundle.message((String)"updates.error.connection.failed", (Object[])new Object[]{cause});
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IdeBundle.message(\"updat\u2026onnection.failed\", cause)");
            this.showErrorMessage(manualCheck, string);
            return;
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(IdeBundle.message((String)"updates.checking.plugins", (Object[])new Object[0]));
        }
        if (this.newChannelReady(result2.getChannelToPropose())) {
            updatedPlugins = null;
            incompatiblePlugins = null;
        } else {
            Object object = result2.getUpdatedChannel();
            BuildNumber buildNumber = object != null && (object = ((UpdateChannel)object).getLatestBuild()) != null ? ((BuildInfo)object).getApiVersion() : null;
            incompatiblePlugins = buildNumber != null ? new HashSet() : (HashSet)null;
            try {
                updatedPlugins = this.checkPluginsUpdate(updateSettings, indicator, incompatiblePlugins, buildNumber);
            }
            catch (IOException e) {
                String string = IdeBundle.message((String)"updates.error.connection.failed", (Object[])new Object[]{e.getMessage()});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IdeBundle.message(\"updat\u2026ction.failed\", e.message)");
                this.showErrorMessage(manualCheck, string);
                return;
            }
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(project, result2, updateSettings, updatedPlugins, incompatiblePlugins, fromSettings, manualCheck, callback){
            final /* synthetic */ Project $project;
            final /* synthetic */ CheckForUpdateResult $result;
            final /* synthetic */ UpdateSettings $updateSettings;
            final /* synthetic */ Collection $updatedPlugins;
            final /* synthetic */ Collection $incompatiblePlugins;
            final /* synthetic */ boolean $fromSettings;
            final /* synthetic */ boolean $manualCheck;
            final /* synthetic */ ActionCallback $callback;

            public final void run() {
                Unit unit;
                UpdateChecker.access$showUpdateResult(UpdateChecker.INSTANCE, this.$project, this.$result, this.$updateSettings, this.$updatedPlugins, this.$incompatiblePlugins, !this.$fromSettings, this.$manualCheck);
                ActionCallback actionCallback = this.$callback;
                if (actionCallback != null) {
                    actionCallback.setDone();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            {
                this.$project = project;
                this.$result = checkForUpdateResult;
                this.$updateSettings = updateSettings;
                this.$updatedPlugins = collection;
                this.$incompatiblePlugins = collection2;
                this.$fromSettings = bl;
                this.$manualCheck = bl2;
                this.$callback = actionCallback;
            }
        }, fromSettings ? ModalityState.any() : ModalityState.NON_MODAL);
    }

    private final CheckForUpdateResult checkPlatformUpdate(UpdateSettings settings) {
        UpdatesInfo updateInfo;
        if (StringsKt.toBoolean((String)System.getProperty(NO_PLATFORM_UPDATE, "false"))) {
            return new CheckForUpdateResult(UpdateStrategy.State.NOTHING_LOADED, null);
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(this.getUpdateUrl());
            if (Intrinsics.areEqual((Object)"file", (Object)uriBuilder.getScheme()) ^ true) {
                this.prepareUpdateCheckArgs(uriBuilder);
            }
            String updateUrl = uriBuilder.build().toString();
            LogUtil.debug((Logger)LOG, (String)"load update xml (UPDATE_URL='%s')", (Object[])new Object[]{updateUrl});
            updateInfo = (UpdatesInfo)HttpRequests.request((String)updateUrl).forceHttps(settings.canUseSecureConnection()).connect((HttpRequests.RequestProcessor)checkPlatformUpdate.1.INSTANCE);
        }
        catch (URISyntaxException e) {
            return new CheckForUpdateResult(UpdateStrategy.State.CONNECTION_ERROR, e);
        }
        catch (IOException e) {
            return new CheckForUpdateResult(UpdateStrategy.State.CONNECTION_ERROR, e);
        }
        if (updateInfo == null) {
            return new CheckForUpdateResult(UpdateStrategy.State.NOTHING_LOADED, null);
        }
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        int majorVersion = Integer.parseInt(appInfo.getMajorVersion());
        UpdateStrategyCustomization customization = UpdateStrategyCustomization.getInstance();
        UpdateStrategy strategy = new UpdateStrategy(majorVersion, appInfo.getBuild(), updateInfo, settings, customization);
        CheckForUpdateResult checkForUpdateResult = strategy.checkForUpdates();
        Intrinsics.checkExpressionValueIsNotNull((Object)checkForUpdateResult, (String)"strategy.checkForUpdates()");
        return checkForUpdateResult;
    }

    private final Collection<PluginDownloader> checkPluginsUpdate(UpdateSettings updateSettings, ProgressIndicator indicator, Collection<IdeaPluginDescriptor> incompatiblePlugins, BuildNumber buildNumber) {
        Map<PluginId, IdeaPluginDescriptor> updateable = this.collectUpdateablePlugins();
        if (updateable.isEmpty()) {
            return null;
        }
        THashMap toUpdate = ContainerUtil.newTroveMap();
        List<String> hosts = RepositoryHelper.getPluginHosts();
        InstalledPluginsState state = InstalledPluginsState.getInstance();
        block2: for (String host : hosts) {
            try {
                boolean forceHttps = host == null && updateSettings.canUseSecureConnection();
                List<IdeaPluginDescriptor> list = RepositoryHelper.loadPlugins(host, buildNumber, forceHttps, indicator);
                for (IdeaPluginDescriptor descriptor : list) {
                    PluginId id = descriptor.getPluginId();
                    if (!updateable.containsKey(id)) continue;
                    updateable.remove(id);
                    state.onDescriptorDownload(descriptor);
                    PluginDownloader downloader = PluginDownloader.createDownloader(descriptor, host, buildNumber);
                    downloader.setForceHttps(forceHttps);
                    PluginDownloader pluginDownloader = downloader;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pluginDownloader, (String)"downloader");
                    InstalledPluginsState installedPluginsState = state;
                    Intrinsics.checkExpressionValueIsNotNull((Object)installedPluginsState, (String)"state");
                    Map map = (Map)toUpdate;
                    Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"toUpdate");
                    UpdateChecker.checkAndPrepareToInstall(pluginDownloader, installedPluginsState, map, incompatiblePlugins, indicator);
                    if (!updateable.isEmpty()) continue;
                    break block2;
                }
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
                if (host != null) {
                    LOG.info("failed to load plugin descriptions from " + host + ": " + e.getMessage());
                    continue;
                }
                throw (Throwable)e;
            }
        }
        return toUpdate.isEmpty() ? (Collection)null : toUpdate.values();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<PluginId, IdeaPluginDescriptor> collectUpdateablePlugins() {
        void destination;
        Object it;
        Object element2;
        void $receiver;
        Iterable $receiver2;
        THashMap updateable = ContainerUtil.newTroveMap();
        Object[] objectArray = PluginManagerCore.getPlugins();
        Map map = (Map)updateable;
        void var3_4 = $receiver2;
        Iterator iterator = new ArrayList();
        for (int i = 0; i < ((void)$receiver).length; ++i) {
            element2 = $receiver[i];
            it = (IdeaPluginDescriptor)element2;
            if (!(!it.isBundled())) continue;
            destination.add(element2);
        }
        LinkedHashMap linkedHashMap = (List)destination;
        $receiver2 = (Iterable)((Object)linkedHashMap);
        float capacity = (float)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10) / 0.75f + 1.0f;
        LinkedHashMap result2 = new LinkedHashMap(Math.max((int)capacity, 16));
        for (Object element2 : $receiver2) {
            it = (IdeaPluginDescriptor)element2;
            linkedHashMap = result2;
            PluginId pluginId = it.getPluginId();
            linkedHashMap.put(pluginId, element2);
        }
        linkedHashMap = result2;
        MapsKt.plusAssign((Map)map, (Map)linkedHashMap);
        File onceInstalled = PluginManager.getOnceInstalledIfExists();
        if (onceInstalled != null) {
            try {
                for (String line : FileUtil.loadLines((File)onceInstalled)) {
                    PluginId id;
                    void $receiver3;
                    void $receiver4;
                    element2 = line;
                    void v0 = $receiver4;
                    if (v0 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    it = (CharSequence)v0;
                    int startIndex = 0;
                    int endIndex = $receiver3.length() - 1;
                    boolean startFound = false;
                    while (startIndex <= endIndex) {
                        boolean match;
                        int index = !startFound ? startIndex : endIndex;
                        char it2 = $receiver3.charAt(index);
                        boolean bl = match = it2 <= ' ';
                        if (!startFound) {
                            if (!match) {
                                startFound = true;
                                continue;
                            }
                            ++startIndex;
                            continue;
                        }
                        if (!match) break;
                        --endIndex;
                    }
                    if (!(updateable.contains((Object)(id = PluginId.getId((String)((Object)$receiver3.subSequence(startIndex, endIndex + 1)).toString()))) ^ true)) continue;
                    updateable.put((Object)id, null);
                }
            }
            catch (IOException e) {
                LOG.error(onceInstalled.getPath(), (Throwable)e);
            }
            onceInstalled.deleteOnExit();
        }
        iterator = excludedFromUpdateCheckPlugins.iterator();
        while (iterator.hasNext()) {
            String excludedPluginId;
            String string = excludedPluginId = (String)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"excludedPluginId");
            if (this.isRequiredForAnyOpenProject(string)) continue;
            updateable.remove((Object)PluginId.getId((String)excludedPluginId));
        }
        Map map2 = (Map)updateable;
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"updateable");
        return map2;
    }

    private final boolean isRequiredForAnyOpenProject(String pluginId) {
        boolean bl;
        block1: {
            Object[] $receiver = ProjectManager.getInstance().getOpenProjects();
            for (int i = 0; i < $receiver.length; ++i) {
                Project it;
                Object element = $receiver[i];
                Project project = it = (Project)element;
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it");
                if (!UpdateChecker.INSTANCE.isRequiredForProject(project, pluginId)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isRequiredForProject(Project project, String pluginId) {
        boolean bl;
        block1: {
            Iterable $receiver = ExternalDependenciesManager.getInstance(project).getDependencies(DependencyOnPlugin.class);
            for (Object element : $receiver) {
                DependencyOnPlugin it = (DependencyOnPlugin)element;
                if (!Intrinsics.areEqual((Object)it.getPluginId(), (Object)pluginId)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final void checkAndPrepareToInstall(@NotNull PluginDownloader downloader, @NotNull InstalledPluginsState state, @NotNull Map<PluginId, PluginDownloader> toUpdate, @Nullable Collection<IdeaPluginDescriptor> incompatiblePlugins, @Nullable ProgressIndicator indicator) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull(toUpdate, (String)"toUpdate");
        PluginDownloader downloader2 = downloader;
        String pluginId = downloader2.getPluginId();
        if (PluginManagerCore.getDisabledPlugins().contains(pluginId)) {
            return;
        }
        String pluginVersion = downloader2.getPluginVersion();
        IdeaPluginDescriptor installedPlugin = PluginManager.getPlugin(PluginId.getId((String)pluginId));
        if (installedPlugin == null || pluginVersion == null || PluginDownloader.compareVersionsSkipBrokenAndIncompatible(installedPlugin, pluginVersion) > 0) {
            IdeaPluginDescriptor descriptor;
            PluginDownloader oldDownloader = ourUpdatedPlugins.get(pluginId);
            if (oldDownloader == null || StringUtil.compareVersionNumbers((String)pluginVersion, (String)oldDownloader.getPluginVersion()) > 0) {
                descriptor = downloader2.getDescriptor();
                if (descriptor instanceof PluginNode && ((PluginNode)descriptor).isIncomplete()) {
                    ProgressIndicator progressIndicator = indicator;
                    if (progressIndicator == null) {
                        progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
                    }
                    if (downloader2.prepareToInstall(progressIndicator)) {
                        descriptor = downloader2.getDescriptor();
                    }
                    ourUpdatedPlugins.put(pluginId, downloader2);
                }
            } else {
                downloader2 = oldDownloader;
                descriptor = oldDownloader.getDescriptor();
            }
            if (descriptor != null && PluginManagerCore.isCompatible(descriptor, downloader2.getBuildNumber()) && !state.wasUpdated(descriptor.getPluginId())) {
                PluginId pluginId2 = PluginId.getId((String)pluginId);
                Intrinsics.checkExpressionValueIsNotNull((Object)pluginId2, (String)"PluginId.getId(pluginId)");
                toUpdate.put(pluginId2, downloader2);
            }
        }
        if (incompatiblePlugins != null && installedPlugin != null && installedPlugin.isEnabled() && !toUpdate.containsKey(installedPlugin.getPluginId()) && PluginManagerCore.isIncompatible(installedPlugin, downloader2.getBuildNumber())) {
            incompatiblePlugins.add(installedPlugin);
        }
    }

    private final void showErrorMessage(boolean showDialog, String message) {
        LOG.info(message);
        if (showDialog) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(message){
                final /* synthetic */ String $message;

                public final void run() {
                    Messages.showErrorDialog((String)this.$message, (String)IdeBundle.message((String)"updates.error.connection.title", (Object[])new Object[0]));
                }
                {
                    this.$message = string;
                }
            });
        }
    }

    @Contract(value="null -> false")
    private final boolean newChannelReady(UpdateChannel channelToPropose) {
        UpdateChannel updateChannel = channelToPropose;
        return (updateChannel != null ? updateChannel.getLatestBuild() : null) != null;
    }

    private final void showUpdateResult(Project project, CheckForUpdateResult checkForUpdateResult, UpdateSettings updateSettings, Collection<? extends PluginDownloader> updatedPlugins, Collection<? extends IdeaPluginDescriptor> incompatiblePlugins, boolean enableLink, boolean alwaysShowResults) {
        UpdateChannel channelToPropose = checkForUpdateResult.getChannelToPropose();
        UpdateChannel updatedChannel = checkForUpdateResult.getUpdatedChannel();
        if (updatedChannel != null) {
            Function0 runnable2 = (Function0)new Function0<Unit>(updatedChannel, enableLink, updateSettings, updatedPlugins, incompatiblePlugins){
                final /* synthetic */ UpdateChannel $updatedChannel;
                final /* synthetic */ boolean $enableLink;
                final /* synthetic */ UpdateSettings $updateSettings;
                final /* synthetic */ Collection $updatedPlugins;
                final /* synthetic */ Collection $incompatiblePlugins;

                public final void invoke() {
                    new UpdateInfoDialog(this.$updatedChannel, this.$enableLink, this.$updateSettings.canUseSecureConnection(), this.$updatedPlugins, this.$incompatiblePlugins).show();
                }
                {
                    this.$updatedChannel = updateChannel;
                    this.$enableLink = bl;
                    this.$updateSettings = updateSettings;
                    this.$updatedPlugins = collection;
                    this.$incompatiblePlugins = collection2;
                    super(0);
                }
            };
            if (alwaysShowResults) {
                runnable2.invoke();
            } else {
                String message;
                String string = message = IdeBundle.message((String)"updates.ready.message", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
                this.showNotification(project, string, (Function0<? extends Unit>)runnable2, NotificationUniqueType.UPDATE_IN_CHANNEL);
            }
        } else if (this.newChannelReady(channelToPropose)) {
            Function0 runnable3 = (Function0)new Function0<Unit>(channelToPropose, checkForUpdateResult, updateSettings){
                final /* synthetic */ UpdateChannel $channelToPropose;
                final /* synthetic */ CheckForUpdateResult $checkForUpdateResult;
                final /* synthetic */ UpdateSettings $updateSettings;

                public final void invoke() {
                    UpdateChannel updateChannel = this.$channelToPropose;
                    if (updateChannel == null) {
                        Intrinsics.throwNpe();
                    }
                    NewChannelDialog dialog = new NewChannelDialog(updateChannel);
                    dialog.show();
                    if (dialog.getExitCode() == 1 && Intrinsics.areEqual((Object)((Object)this.$checkForUpdateResult.getState()), (Object)((Object)UpdateStrategy.State.LOADED)) && !this.$updateSettings.getKnownChannelsIds().contains(this.$channelToPropose.getId())) {
                        ArrayList<String> newIds = new ArrayList<String>((Collection)this.$updateSettings.getKnownChannelsIds());
                        newIds.add(this.$channelToPropose.getId());
                        this.$updateSettings.setKnownChannelIds((List<String>)newIds);
                    }
                }
                {
                    this.$channelToPropose = updateChannel;
                    this.$checkForUpdateResult = checkForUpdateResult;
                    this.$updateSettings = updateSettings;
                    super(0);
                }
            };
            if (alwaysShowResults) {
                runnable3.invoke();
            } else {
                String message;
                String string = message = IdeBundle.message((String)"updates.new.version.available", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
                this.showNotification(project, string, (Function0<? extends Unit>)runnable3, NotificationUniqueType.NEW_CHANNEL);
            }
        } else if (updatedPlugins != null && !updatedPlugins.isEmpty()) {
            Function0 runnable4 = (Function0)new Function0<Unit>(updatedPlugins, enableLink){
                final /* synthetic */ Collection $updatedPlugins;
                final /* synthetic */ boolean $enableLink;

                public final void invoke() {
                    new PluginUpdateInfoDialog(this.$updatedPlugins, this.$enableLink).show();
                }
                {
                    this.$updatedPlugins = collection;
                    this.$enableLink = bl;
                    super(0);
                }
            };
            if (alwaysShowResults) {
                runnable4.invoke();
            } else {
                String message;
                String plugins2 = CollectionsKt.joinToString$default((Iterable)updatedPlugins, null, null, null, (int)0, null, (Function1)showUpdateResult.plugins.1.INSTANCE, (int)31);
                String string = message = IdeBundle.message((String)"updates.plugins.ready.message", (Object[])new Object[]{updatedPlugins.size(), plugins2});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
                this.showNotification(project, string, (Function0<? extends Unit>)runnable4, NotificationUniqueType.PLUGINS_UPDATE);
            }
        } else if (alwaysShowResults) {
            new NoUpdatesDialog(enableLink).show();
        }
    }

    private final void showNotification(Project project, String message, Function0<? extends Unit> runnable2, NotificationUniqueType notificationType) {
        if (notificationType != null && !ourShownNotificationTypes.add(notificationType)) {
            return;
        }
        NotificationListener listener = null;
        if (runnable2 != null) {
            listener = new NotificationListener(runnable2){
                final /* synthetic */ Function0 $runnable;

                public final void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    notification.expire();
                    this.$runnable.invoke();
                }
                {
                    this.$runnable = function0;
                }
            };
        }
        String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
        NOTIFICATIONS.createNotification(title, XmlStringUtil.wrapInHtml((CharSequence)message), NotificationType.INFORMATION, listener).whenExpired(new Runnable(notificationType){
            final /* synthetic */ NotificationUniqueType $notificationType;

            public final void run() {
                UpdateChecker.access$getOurShownNotificationTypes$p(UpdateChecker.INSTANCE).remove((Object)((Object)this.$notificationType));
            }
            {
                this.$notificationType = notificationUniqueType;
            }
        }).notify(project);
    }

    @JvmStatic
    public static final void addUpdateRequestParameter(@NotNull String name, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        ourAdditionalRequestOptions.put(name, value);
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareUpdateCheckArgs(URIBuilder uriBuilder) {
        String string = ApplicationInfo.getInstance().getBuild().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ApplicationInfo.getInstance().build.asString()");
        UpdateChecker.addUpdateRequestParameter("build", string);
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)propertiesComponent, (String)"PropertiesComponent.getInstance()");
        UpdateChecker.addUpdateRequestParameter("uid", UpdateChecker.getInstallationUID(propertiesComponent));
        UpdateChecker.addUpdateRequestParameter("os", SystemInfo.OS_NAME + ' ' + SystemInfo.OS_VERSION);
        if (ApplicationInfoEx.getInstanceEx().isEAP()) {
            UpdateChecker.addUpdateRequestParameter("eap", "");
        }
        Iterator iterator = MapsKt.mutableIterator((Map)ourAdditionalRequestOptions);
        while (iterator.hasNext()) {
            void $receiver;
            void $receiver2;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator.next();
            String name = (String)$receiver2.getKey();
            Map.Entry $i$f$component1 = entry;
            String value = (String)$receiver.getValue();
            uriBuilder.addParameter(name, StringUtil.isEmpty((String)value) ? (String)null : value);
        }
    }

    @JvmStatic
    @NotNull
    public static final String getInstallationUID(@NotNull PropertiesComponent propertiesComponent) {
        String uid;
        Intrinsics.checkParameterIsNotNull((Object)propertiesComponent, (String)"propertiesComponent");
        if (SystemInfo.isWindows && (uid = INSTANCE.getInstallationUIDOnWindows(propertiesComponent)) != null) {
            return uid;
        }
        uid = propertiesComponent.getValue(INSTALLATION_UID);
        if (uid == null) {
            uid = INSTANCE.generateUUID();
            propertiesComponent.setValue(INSTALLATION_UID, uid);
        }
        return uid;
    }

    /*
     * WARNING - void declaration
     */
    private final String getInstallationUIDOnWindows(PropertiesComponent propertiesComponent) {
        File jetBrainsDir;
        String appdata = System.getenv("APPDATA");
        if (appdata != null && ((jetBrainsDir = new File(appdata, "JetBrains")).exists() || jetBrainsDir.mkdirs())) {
            File permanentIdFile = new File(jetBrainsDir, "PermanentUserId");
            try {
                if (permanentIdFile.exists()) {
                    void $receiver;
                    void $receiver2;
                    String string = FileUtil.loadFile((File)permanentIdFile);
                    void v0 = $receiver2;
                    if (v0 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    CharSequence charSequence = (CharSequence)v0;
                    int startIndex = 0;
                    int endIndex = $receiver.length() - 1;
                    boolean startFound = false;
                    while (startIndex <= endIndex) {
                        boolean match;
                        int index = !startFound ? startIndex : endIndex;
                        char it = $receiver.charAt(index);
                        boolean bl = match = it <= ' ';
                        if (!startFound) {
                            if (!match) {
                                startFound = true;
                                continue;
                            }
                            ++startIndex;
                            continue;
                        }
                        if (!match) break;
                        --endIndex;
                    }
                    return ((Object)$receiver.subSequence(startIndex, endIndex + 1)).toString();
                }
                String uuid = propertiesComponent.getValue(INSTALLATION_UID);
                if (uuid == null) {
                    uuid = this.generateUUID();
                }
                FileUtil.writeToFile((File)permanentIdFile, (String)uuid);
                return uuid;
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    private final String generateUUID() {
        String string;
        try {
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"UUID.randomUUID().toString()");
            string = string2;
        }
        catch (Exception ignored) {
            string = "";
        }
        catch (InternalError ignored) {
            string = "";
        }
        return string;
    }

    @JvmStatic
    public static final void installPlatformUpdate(@NotNull PatchInfo patch, @NotNull BuildNumber toBuild, boolean forceHttps) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)patch, (String)"patch");
        Intrinsics.checkParameterIsNotNull((Object)toBuild, (String)"toBuild");
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(patch, toBuild, forceHttps){
            final /* synthetic */ PatchInfo $patch;
            final /* synthetic */ BuildNumber $toBuild;
            final /* synthetic */ boolean $forceHttps;

            public final void run() {
                ProgressIndicator indicator;
                ProgressIndicator progressIndicator = indicator = ProgressManager.getInstance().getProgressIndicator();
                Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator, (String)"indicator");
                UpdateChecker.access$downloadAndInstallPatch(UpdateChecker.INSTANCE, this.$patch, this.$toBuild, this.$forceHttps, progressIndicator);
            }
            {
                this.$patch = patchInfo;
                this.$toBuild = buildNumber;
                this.$forceHttps = bl;
            }
        }, IdeBundle.message((String)"update.downloading.patch.progress.title", (Object[])new Object[0]), true, (Project)null);
    }

    private final void downloadAndInstallPatch(PatchInfo patch, BuildNumber toBuild, boolean forceHttps, ProgressIndicator indicator) {
        String productCode = ApplicationInfo.getInstance().getBuild().getProductCode();
        String fromBuildNumber = patch.getFromBuild().asStringWithoutProductCode();
        String toBuildNumber = toBuild.asStringWithoutProductCode();
        String bundledJdk = "";
        String jdkRedist = System.getProperty("idea.java.redist");
        if (jdkRedist != null && StringsKt.lastIndexOf$default((CharSequence)jdkRedist, (String)"NoJavaDistribution", (int)0, (boolean)false, (int)6) >= 0) {
            bundledJdk = "-no-jdk";
        }
        String osSuffix = "-" + patch.getOsSuffix();
        String fileName = productCode + "-" + fromBuildNumber + "-" + toBuildNumber + "-patch" + bundledJdk + osSuffix + ".jar";
        String url = new URL(new URL(this.getPatchesUrl()), fileName).toString();
        File tempFile2 = (File)HttpRequests.request((String)url).gzip(false).forceHttps(forceHttps).connect(new HttpRequests.RequestProcessor<T>(indicator){
            final /* synthetic */ ProgressIndicator $indicator;

            @NotNull
            public final File process(@NotNull HttpRequests.Request request) {
                return request.saveToFile(FileUtil.createTempFile((String)"ij.platform.", (String)".patch", (boolean)true), this.$indicator);
            }
            {
                this.$indicator = progressIndicator;
            }
        });
        String string = "jetbrains.patch.jar." + PlatformUtils.getPlatformPrefix();
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
        String patchFileName = StringsKt.toLowerCase((String)string, (Locale)locale);
        File patchFile = new File(FileUtil.getTempDirectory(), patchFileName);
        FileUtil.copy((File)tempFile2, (File)patchFile);
        FileUtil.delete((File)tempFile2);
    }

    @JvmStatic
    public static final boolean installPluginUpdates(@NotNull Collection<? extends PluginDownloader> downloaders, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull(downloaders, (String)"downloaders");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        boolean installed = false;
        Set<String> disabledToUpdate = UpdateChecker.getDisabledToUpdatePlugins();
        for (PluginDownloader pluginDownloader : downloaders) {
            if (disabledToUpdate.contains(pluginDownloader.getPluginId())) continue;
            try {
                IdeaPluginDescriptor descriptor;
                if (!pluginDownloader.prepareToInstall(indicator) || (descriptor = pluginDownloader.getDescriptor()) == null) continue;
                pluginDownloader.install();
                installed = true;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return installed;
    }

    @JvmStatic
    private static final /* synthetic */ void disabledToUpdatePlugins$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> getDisabledToUpdatePlugins() {
        if (ourDisabledToUpdatePlugins == null) {
            ourDisabledToUpdatePlugins = new TreeSet();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    File file2 = new File(PathManager.getConfigPath(), DISABLED_UPDATE);
                    if (file2.isFile()) {
                        Iterator iterator;
                        void $receiver;
                        Iterable $receiver2 = StringsKt.split$default((CharSequence)FileUtil.loadFile((File)file2), (Regex)StringsKt.toRegex((String)"[\\s]"), (int)0, (int)2);
                        Iterable iterable = $receiver2;
                        Collection destination = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
                        for (Object item : $receiver) {
                            void it;
                            String string = (String)item;
                            Collection collection = destination;
                            String string2 = StringsKt.trim((String)it);
                            collection.add(string2);
                        }
                        $receiver2 = (List)((Object)iterator);
                        Set<String> set = ourDisabledToUpdatePlugins;
                        if (set == null) {
                            Intrinsics.throwNpe();
                        }
                        Collection destination2 = set;
                        for (Object element : $receiver2) {
                            String it = (String)element;
                            if (!StringsKt.isNotEmpty((CharSequence)it)) continue;
                            destination2.add(element);
                        }
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        Set<String> set = ourDisabledToUpdatePlugins;
        if (set == null) {
            Intrinsics.throwNpe();
        }
        return set;
    }

    @JvmStatic
    public static final void saveDisabledToUpdatePlugins() {
        File plugins2 = new File(PathManager.getConfigPath(), DISABLED_UPDATE);
        try {
            PluginManagerCore.savePluginsList((Collection<String>)UpdateChecker.getDisabledToUpdatePlugins(), false, plugins2);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @JvmStatic
    public static final void checkForUpdate(@NotNull IdeaLoggingEvent event) {
        Throwable throwable;
        IdeaPluginDescriptor pluginDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!ourHasFailedPlugins && UpdateSettings.getInstance().isCheckNeeded() && (pluginDescriptor = PluginManager.getPlugin(IdeErrorsDialog.findPluginId(throwable = event.getThrowable()))) != null && !pluginDescriptor.isBundled()) {
            ourHasFailedPlugins = true;
            UpdateChecker.updateAndShowResult();
        }
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)UpdateChecker$UPDATE_URL$1.INSTANCE, (KProperty)UpdateChecker$PATCHES_URL$1.INSTANCE};
        new UpdateChecker();
    }

    private UpdateChecker() {
        INSTANCE = this;
        INSTANCE$ = this;
        LOG = Logger.getInstance((String)"#com.intellij.openapi.updateSettings.impl.UpdateChecker");
        NO_PLATFORM_UPDATE = NO_PLATFORM_UPDATE;
        NOTIFICATIONS = new NotificationGroup(IdeBundle.message((String)"update.notifications.group", (Object[])new Object[0]), NotificationDisplayType.STICKY_BALLOON, true);
        INSTALLATION_UID = INSTALLATION_UID;
        DISABLED_UPDATE = DISABLED_UPDATE;
        ourAdditionalRequestOptions = MapsKt.hashMapOf((Pair[])new Pair[0]);
        ourUpdatedPlugins = MapsKt.hashMapOf((Pair[])new Pair[0]);
        ourShownNotificationTypes = Collections.synchronizedSet((Set)EnumSet.noneOf(NotificationUniqueType.class));
        UPDATE_URL$delegate = LazyKt.lazy((Function0)UPDATE_URL.2.INSTANCE);
        PATCHES_URL$delegate = LazyKt.lazy((Function0)PATCHES_URL.2.INSTANCE);
        excludedFromUpdateCheckPlugins = SetsKt.hashSetOf((Object[])new String[0]);
    }

    public static final /* synthetic */ Logger access$getLOG$p(UpdateChecker $this) {
        UpdateChecker updateChecker = $this;
        return LOG;
    }

    public static final /* synthetic */ Set access$getOurShownNotificationTypes$p(UpdateChecker $this) {
        UpdateChecker updateChecker = $this;
        return ourShownNotificationTypes;
    }

    public static final /* synthetic */ void access$doUpdateAndShowResult(UpdateChecker $this, @Nullable Project project, boolean fromSettings, boolean manualCheck, @NotNull UpdateSettings updateSettings, @Nullable ProgressIndicator indicator, @Nullable ActionCallback callback) {
        $this.doUpdateAndShowResult(project, fromSettings, manualCheck, updateSettings, indicator, callback);
    }

    public static final /* synthetic */ void access$showUpdateResult(UpdateChecker $this, @Nullable Project project, @NotNull CheckForUpdateResult checkForUpdateResult, @NotNull UpdateSettings updateSettings, @Nullable Collection updatedPlugins, @Nullable Collection incompatiblePlugins, boolean enableLink, boolean alwaysShowResults) {
        $this.showUpdateResult(project, checkForUpdateResult, updateSettings, updatedPlugins, incompatiblePlugins, enableLink, alwaysShowResults);
    }

    public static final /* synthetic */ void access$downloadAndInstallPatch(UpdateChecker $this, @NotNull PatchInfo patch, @NotNull BuildNumber toBuild, boolean forceHttps, @NotNull ProgressIndicator indicator) {
        $this.downloadAndInstallPatch(patch, toBuild, forceHttps, indicator);
    }

    public static final /* synthetic */ String access$getUPDATE_URL$p(UpdateChecker $this) {
        return $this.getUPDATE_URL();
    }

    public static final /* synthetic */ String access$getPATCHES_URL$p(UpdateChecker $this) {
        return $this.getPATCHES_URL();
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\r\u0015\tA\"A\u0003\u0002\u0011!)\u0011\u0001\u0002\u0002\u0005\u0003\u0004a\u0001!\u0007\u0003\n\u0005%\t\u0001\u0004\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005\t\u001c1\u0001B\u0003"}, strings={"Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$NotificationUniqueType;", "", "(Ljava/lang/String;I)V", "NEW_CHANNEL", "UPDATE_IN_CHANNEL", "PLUGINS_UPDATE"}, moduleName="platform-impl")
    private static final class NotificationUniqueType
    extends Enum<NotificationUniqueType> {
        public static final /* enum */ NotificationUniqueType NEW_CHANNEL;
        public static final /* enum */ NotificationUniqueType UPDATE_IN_CHANNEL;
        public static final /* enum */ NotificationUniqueType PLUGINS_UPDATE;
        private static final /* synthetic */ NotificationUniqueType[] $VALUES;

        static {
            NotificationUniqueType[] notificationUniqueTypeArray = new NotificationUniqueType[3];
            NotificationUniqueType[] notificationUniqueTypeArray2 = notificationUniqueTypeArray;
            notificationUniqueTypeArray[0] = NEW_CHANNEL = new NotificationUniqueType();
            notificationUniqueTypeArray[1] = UPDATE_IN_CHANNEL = new NotificationUniqueType();
            notificationUniqueTypeArray[2] = PLUGINS_UPDATE = new NotificationUniqueType();
            $VALUES = notificationUniqueTypeArray;
        }

        public static NotificationUniqueType[] values() {
            return (NotificationUniqueType[])$VALUES.clone();
        }

        public static NotificationUniqueType valueOf(String string) {
            return Enum.valueOf(NotificationUniqueType.class, string);
        }
    }
}

