/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.DiffManager;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.ImportToShelfExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.patch.ApplyPatchAction");

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (ApplyPatchAction.isProjectOrScopeView(e.getPlace())) {
            VirtualFile vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            e.getPresentation().setEnabledAndVisible(project != null && ApplyPatchAction.isPatchFile(vFile));
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(project != null);
        }
    }

    private static boolean isPatchFile(@Nullable VirtualFile vFile) {
        return vFile != null && vFile.getFileType() == StdFileTypes.PATCH;
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification("Can not apply patch now")) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile vFile = null;
        String place = e.getPlace();
        if (ApplyPatchAction.isProjectOrScopeView(place) || "MainMenu".equals(place)) {
            vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        }
        if (ApplyPatchAction.isPatchFile(vFile)) {
            ApplyPatchAction.showApplyPatch(project, vFile);
        } else {
            FileChooserDescriptor descriptor = ApplyPatchDifferentiatedDialog.createSelectPatchDescriptor();
            final VcsApplicationSettings settings = VcsApplicationSettings.getInstance();
            VirtualFile toSelect = settings.PATCH_STORAGE_LOCATION == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(settings.PATCH_STORAGE_LOCATION));
            FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)toSelect, (Consumer)new Consumer<VirtualFile>(){

                public void consume(VirtualFile file2) {
                    VirtualFile parent = file2.getParent();
                    if (parent != null) {
                        settings.PATCH_STORAGE_LOCATION = FileUtil.toSystemDependentName((String)parent.getPath());
                    }
                    ApplyPatchAction.showApplyPatch(project, file2);
                }
            });
        }
    }

    private static boolean isProjectOrScopeView(@NotNull String place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "isProjectOrScopeView"));
        }
        return place.equals("ProjectViewPopup") || place.equals("ScopeViewPopup");
    }

    public static void showApplyPatch(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "showApplyPatch"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "showApplyPatch"));
        }
        ApplyPatchDifferentiatedDialog dialog = new ApplyPatchDifferentiatedDialog(project, new ApplyPatchDefaultExecutor(project), Collections.singletonList(new ImportToShelfExecutor(project)), ApplyPatchMode.APPLY, file2);
        dialog.show();
    }

    public static void applySkipDirs(List<FilePatch> patches, int skipDirs) {
        if (skipDirs < 1) {
            return;
        }
        for (FilePatch patch : patches) {
            patch.setBeforeName(ApplyPatchAction.skipN(patch.getBeforeName(), skipDirs));
            patch.setAfterName(ApplyPatchAction.skipN(patch.getAfterName(), skipDirs));
        }
    }

    private static String skipN(String path, int num) {
        String[] pieces = path.split("/");
        StringBuilder sb = new StringBuilder();
        for (int i = num; i < pieces.length; ++i) {
            String piece = pieces[i];
            sb.append('/').append(piece);
        }
        return sb.toString();
    }

    @NotNull
    public static ApplyPatchStatus applyOnly(@Nullable Project project, @NotNull ApplyFilePatchBase patch, @Nullable ApplyPatchContext context, @NotNull VirtualFile file2, @Nullable CommitContext commitContext, boolean reverse, @Nullable String leftPanelTitle, @Nullable String rightPanelTitle) {
        ApplyPatchStatus applyPatchStatus;
        if (patch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "applyOnly"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "applyOnly"));
        }
        ApplyFilePatch.Result result2 = ApplyPatchAction.tryApplyPatch(project, patch, context, file2, commitContext);
        ApplyPatchStatus status = result2.getStatus();
        if (ApplyPatchStatus.ALREADY_APPLIED.equals((Object)status) || ApplyPatchStatus.SUCCESS.equals((Object)status)) {
            ApplyPatchStatus applyPatchStatus2 = status;
            if (applyPatchStatus2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "applyOnly"));
            }
            return applyPatchStatus2;
        }
        ApplyPatchForBaseRevisionTexts mergeData = result2.getMergeData();
        if (mergeData == null) {
            ApplyPatchStatus applyPatchStatus3 = status;
            if (applyPatchStatus3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "applyOnly"));
            }
            return applyPatchStatus3;
        }
        final Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            ApplyPatchStatus applyPatchStatus4 = ApplyPatchStatus.FAILURE;
            if (applyPatchStatus4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "applyOnly"));
            }
            return applyPatchStatus4;
        }
        String baseContent = ApplyPatchAction.toString(mergeData.getBase());
        String localContent = ApplyPatchAction.toString(mergeData.getLocal());
        String patchedContent = mergeData.getPatched();
        if (localContent == null) {
            ApplyPatchStatus applyPatchStatus5 = ApplyPatchStatus.FAILURE;
            if (applyPatchStatus5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "applyOnly"));
            }
            return applyPatchStatus5;
        }
        final Ref applyPatchStatusReference = new Ref();
        Consumer<MergeResult> callback = new Consumer<MergeResult>(){

            public void consume(MergeResult result2) {
                FileDocumentManager.getInstance().saveDocument(document);
                applyPatchStatusReference.setIfNull((Object)(result2 != MergeResult.CANCEL ? ApplyPatchStatus.SUCCESS : ApplyPatchStatus.FAILURE));
            }
        };
        try {
            MergeRequest request;
            if (baseContent != null) {
                if (reverse) {
                    if (leftPanelTitle == null) {
                        leftPanelTitle = VcsBundle.message((String)"patch.apply.conflict.patched.version", (Object[])new Object[0]);
                    }
                    if (rightPanelTitle == null) {
                        rightPanelTitle = VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]);
                    }
                    List contents = ContainerUtil.list((Object[])new String[]{patchedContent, baseContent, localContent});
                    List titles = ContainerUtil.list((Object[])new String[]{leftPanelTitle, null, rightPanelTitle});
                    request = PatchDiffRequestFactory.createMergeRequest(project, document, file2, contents, null, titles, callback);
                } else {
                    request = PatchDiffRequestFactory.createMergeRequest(project, document, file2, baseContent, localContent, patchedContent, callback);
                }
            } else {
                request = PatchDiffRequestFactory.createBadMergeRequest(project, document, file2, localContent, patchedContent, callback);
            }
            request.putUserData(DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS, (Object)new Function<MergeResult, String>(){

                public String fun(MergeResult result2) {
                    return result2.equals((Object)MergeResult.CANCEL) ? "Abort..." : null;
                }
            });
            request.putUserData(DiffUserDataKeysEx.MERGE_CANCEL_HANDLER, (Object)new Condition<MergeTool.MergeViewer>(){

                public boolean value(MergeTool.MergeViewer viewer) {
                    int result2 = Messages.showYesNoCancelDialog((Component)viewer.getComponent().getRootPane(), (String)"Would you like to abort applying patch action?", (String)"Close Merge", (String)"Abort", (String)"Skip File", (String)"Cancel", (Icon)Messages.getQuestionIcon());
                    if (result2 == 0) {
                        applyPatchStatusReference.set((Object)ApplyPatchStatus.ABORT);
                    } else if (result2 == 1) {
                        applyPatchStatusReference.set((Object)ApplyPatchStatus.SKIP);
                    }
                    return result2 != 2;
                }
            });
            DiffManager.getInstance().showMerge(project, request);
            applyPatchStatus = (ApplyPatchStatus)((Object)applyPatchStatusReference.get());
        }
        catch (InvalidDiffRequestException e) {
            LOG.warn((Throwable)e);
            ApplyPatchStatus applyPatchStatus6 = ApplyPatchStatus.FAILURE;
            if (applyPatchStatus6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "applyOnly"));
            }
            return applyPatchStatus6;
        }
        if (applyPatchStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "applyOnly"));
        }
        return applyPatchStatus;
    }

    @NotNull
    private static ApplyFilePatch.Result tryApplyPatch(final @Nullable Project project, final @NotNull ApplyFilePatchBase patch, final @Nullable ApplyPatchContext context, final @NotNull VirtualFile file2, final @Nullable CommitContext commitContext) {
        if (patch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "tryApplyPatch"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "tryApplyPatch"));
        }
        final Object patchBase = patch.getPatch();
        ApplyFilePatch.Result result2 = (ApplyFilePatch.Result)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<ApplyFilePatch.Result>(){

            public ApplyFilePatch.Result compute() {
                try {
                    return patch.apply(file2, context, project, VcsUtil.getFilePath((VirtualFile)file2), new Getter<CharSequence>(){

                        public CharSequence get() {
                            BaseRevisionTextPatchEP baseRevisionTextPatchEP = (BaseRevisionTextPatchEP)Extensions.findExtension((ExtensionPointName)PatchEP.EP_NAME, (AreaInstance)project, BaseRevisionTextPatchEP.class);
                            String path = (String)ObjectUtils.chooseNotNull((Object)patchBase.getBeforeName(), (Object)patchBase.getAfterName());
                            return baseRevisionTextPatchEP.provideContent(path, commitContext);
                        }
                    }, commitContext);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return ApplyFilePatch.Result.createThrow(e);
                }
            }
        });
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "tryApplyPatch"));
        }
        return result2;
    }

    @Nullable
    private static String toString(@Nullable CharSequence charSequence) {
        return charSequence != null ? StringUtil.convertLineSeparators((String)charSequence.toString()) : null;
    }
}

