/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchDefaultExecutor
implements ApplyPatchExecutor<AbstractFilePatchInProgress> {
    protected final Project myProject;

    public ApplyPatchDefaultExecutor(Project project) {
        this.myProject = project;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void apply(@NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> patchGroups, @Nullable LocalChangeList localList, @Nullable String fileName, @Nullable TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
        if (patchGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchGroups", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDefaultExecutor", "apply"));
        }
        CommitContext commitContext = new CommitContext();
        ApplyPatchDefaultExecutor.applyAdditionalInfoBefore(this.myProject, additionalInfo, commitContext);
        Collection<PatchApplier> appliers = this.getPatchAppliers(patchGroups, localList, commitContext);
        this.executeAndApplyAdditionalInfo(localList, additionalInfo, commitContext, appliers);
    }

    protected void executeAndApplyAdditionalInfo(@Nullable LocalChangeList localList, @Nullable TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo, @NotNull CommitContext commitContext, @NotNull Collection<PatchApplier> appliers) {
        if (commitContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitContext", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDefaultExecutor", "executeAndApplyAdditionalInfo"));
        }
        if (appliers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appliers", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDefaultExecutor", "executeAndApplyAdditionalInfo"));
        }
        if (PatchApplier.executePatchGroup(appliers, localList) != ApplyPatchStatus.ABORT) {
            ApplyPatchDefaultExecutor.applyAdditionalInfo(this.myProject, additionalInfo, commitContext);
        }
    }

    @NotNull
    protected Collection<PatchApplier> getPatchAppliers(@NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> patchGroups, @Nullable LocalChangeList localList, @NotNull CommitContext commitContext) {
        if (patchGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchGroups", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDefaultExecutor", "getPatchAppliers"));
        }
        if (commitContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitContext", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDefaultExecutor", "getPatchAppliers"));
        }
        LinkedList<PatchApplier> appliers = new LinkedList<PatchApplier>();
        for (VirtualFile base : patchGroups.keySet()) {
            appliers.add(new PatchApplier(this.myProject, base, ContainerUtil.map((Collection)patchGroups.get((Object)base), (Function)new Function<AbstractFilePatchInProgress, FilePatch>(){

                public FilePatch fun(AbstractFilePatchInProgress patchInProgress) {
                    return patchInProgress.getPatch();
                }
            }), localList, null, commitContext));
        }
        LinkedList<PatchApplier> linkedList = appliers;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDefaultExecutor", "getPatchAppliers"));
        }
        return linkedList;
    }

    public static void applyAdditionalInfoBefore(Project project, TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo, CommitContext commitContext) {
        ApplyPatchDefaultExecutor.applyAdditionalInfoImpl(project, additionalInfo, commitContext, new Consumer<InfoGroup>(){

            public void consume(InfoGroup infoGroup) {
                infoGroup.myPatchEP.consumeContentBeforePatchApplied(infoGroup.myPath, infoGroup.myContent, infoGroup.myCommitContext);
            }
        });
    }

    private static void applyAdditionalInfo(Project project, TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo, CommitContext commitContext) {
        ApplyPatchDefaultExecutor.applyAdditionalInfoImpl(project, additionalInfo, commitContext, new Consumer<InfoGroup>(){

            public void consume(InfoGroup infoGroup) {
                infoGroup.myPatchEP.consumeContent(infoGroup.myPath, infoGroup.myContent, infoGroup.myCommitContext);
            }
        });
    }

    private static void applyAdditionalInfoImpl(Project project, TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo, CommitContext commitContext, Consumer<InfoGroup> worker) {
        PatchEP[] extensions = (PatchEP[])Extensions.getExtensions((ExtensionPointName)PatchEP.EP_NAME, (AreaInstance)project);
        if (extensions.length == 0) {
            return;
        }
        if (additionalInfo != null) {
            try {
                Map map = (Map)additionalInfo.get();
                for (Map.Entry entry : map.entrySet()) {
                    String path = (String)entry.getKey();
                    Map innerMap = (Map)entry.getValue();
                    for (PatchEP extension : extensions) {
                        CharSequence charSequence = (CharSequence)innerMap.get(extension.getName());
                        if (charSequence == null) continue;
                        worker.consume((Object)new InfoGroup(extension, path, charSequence, commitContext));
                    }
                }
            }
            catch (PatchSyntaxException e) {
                VcsBalloonProblemNotifier.showOverChangesView(project, "Can not apply additional patch info: " + e.getMessage(), MessageType.ERROR, new NamedRunnable[0]);
            }
        }
    }

    public static Set<String> pathsFromGroups(MultiMap<VirtualFile, AbstractFilePatchInProgress> patchGroups) {
        HashSet selectedPaths = new HashSet();
        Collection values = patchGroups.values();
        for (AbstractFilePatchInProgress value : values) {
            String path = value.getPatch().getBeforeName() == null ? value.getPatch().getAfterName() : value.getPatch().getBeforeName();
            selectedPaths.add(path);
        }
        return selectedPaths;
    }

    private static class InfoGroup {
        private final PatchEP myPatchEP;
        private final String myPath;
        private final CharSequence myContent;
        private final CommitContext myCommitContext;

        private InfoGroup(PatchEP patchEP, String path, CharSequence content, CommitContext commitContext) {
            this.myPatchEP = patchEP;
            this.myPath = path;
            this.myContent = content;
            this.myCommitContext = commitContext;
        }
    }
}

