/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.UnknownFileTypeDiffRequest;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeGoToChangePopupAction;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffShelvedChangesAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(DiffShelvedChangesAction.isEnabled(e.getDataContext()));
    }

    public void actionPerformed(AnActionEvent e) {
        DiffShelvedChangesAction.showShelvedChangesDiff(e.getDataContext());
    }

    public static boolean isEnabled(DataContext dc) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null) {
            return false;
        }
        ShelvedChangeList[] changeLists = (ShelvedChangeList[])ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY.getData(dc);
        if (changeLists == null) {
            changeLists = (ShelvedChangeList[])ShelvedChangesViewManager.SHELVED_RECYCLED_CHANGELIST_KEY.getData(dc);
        }
        return changeLists != null && changeLists.length == 1;
    }

    public static void showShelvedChangesDiff(DataContext dc) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null) {
            return;
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        ShelvedChangeList[] changeLists = (ShelvedChangeList[])ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY.getData(dc);
        if (changeLists == null) {
            changeLists = (ShelvedChangeList[])ShelvedChangesViewManager.SHELVED_RECYCLED_CHANGELIST_KEY.getData(dc);
        }
        if (changeLists == null || changeLists.length != 1) {
            return;
        }
        List<ShelvedChange> textChanges = changeLists[0].getChanges(project);
        List<ShelvedBinaryFile> binaryChanges = changeLists[0].getBinaryFiles();
        ArrayList<MyDiffRequestProducer> diffRequestProducers = new ArrayList<MyDiffRequestProducer>();
        DiffShelvedChangesAction.processTextChanges(project, textChanges, diffRequestProducers);
        DiffShelvedChangesAction.processBinaryFiles(project, binaryChanges, diffRequestProducers);
        Collections.sort(diffRequestProducers, ChangeDiffRequestComparator.getInstance());
        HashSet selectedChanges = new HashSet();
        selectedChanges.addAll(ContainerUtil.notNullize((List)((List)ShelvedChangesViewManager.SHELVED_CHANGE_KEY.getData(dc))));
        selectedChanges.addAll(ContainerUtil.notNullize((List)((List)ShelvedChangesViewManager.SHELVED_BINARY_FILE_KEY.getData(dc))));
        int index = 0;
        for (int i = 0; i < diffRequestProducers.size(); ++i) {
            MyDiffRequestProducer producer = (MyDiffRequestProducer)diffRequestProducers.get(i);
            if (!selectedChanges.contains(producer.getBinaryChange()) && !selectedChanges.contains(producer.getTextChange())) continue;
            index = i;
            break;
        }
        MyDiffRequestChain chain = new MyDiffRequestChain(diffRequestProducers, index);
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)chain, DiffDialogHints.FRAME);
    }

    private static void processBinaryFiles(final @NotNull Project project, @NotNull List<ShelvedBinaryFile> files, @NotNull List<MyDiffRequestProducer> diffRequestProducers) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction", "processBinaryFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction", "processBinaryFiles"));
        }
        if (diffRequestProducers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffRequestProducers", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction", "processBinaryFiles"));
        }
        String base = project.getBaseDir().getPath();
        for (final ShelvedBinaryFile shelvedChange : files) {
            File file2 = new File(base, shelvedChange.AFTER_PATH == null ? shelvedChange.BEFORE_PATH : shelvedChange.AFTER_PATH);
            FilePath filePath = VcsUtil.getFilePath((File)file2);
            diffRequestProducers.add(new MyDiffRequestProducer(shelvedChange, filePath){

                @NotNull
                public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$1", "process"));
                    }
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$1", "process"));
                    }
                    Change change = shelvedChange.createChange(project);
                    DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(project, change, this.getName(), context, indicator);
                    if (diffRequest == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$1", "process"));
                    }
                    return diffRequest;
                }
            });
        }
    }

    private static void processTextChanges(final @NotNull Project project, @NotNull List<ShelvedChange> changesFromFirstList, @NotNull List<MyDiffRequestProducer> diffRequestProducers) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction", "processTextChanges"));
        }
        if (changesFromFirstList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changesFromFirstList", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction", "processTextChanges"));
        }
        if (diffRequestProducers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffRequestProducers", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction", "processTextChanges"));
        }
        String base = project.getBasePath();
        final ApplyPatchContext patchContext = new ApplyPatchContext(project.getBaseDir(), 0, false, false);
        final PatchesPreloader preloader = new PatchesPreloader(project);
        for (final ShelvedChange shelvedChange : changesFromFirstList) {
            VirtualFile file2;
            final String beforePath = shelvedChange.getBeforePath();
            final String afterPath = shelvedChange.getAfterPath();
            FilePath filePath = VcsUtil.getFilePath((File)new File(base, afterPath == null ? beforePath : afterPath));
            final boolean isNewFile = FileStatus.ADDED.equals(shelvedChange.getFileStatus());
            try {
                file2 = ApplyFilePatchBase.findPatchTarget(patchContext, beforePath, afterPath, isNewFile);
                if (!(isNewFile || file2 != null && file2.exists())) {
                    throw new FileNotFoundException(beforePath);
                }
            }
            catch (IOException e) {
                diffRequestProducers.add(new MyDiffRequestProducer(shelvedChange, filePath){

                    @NotNull
                    public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                        if (context == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$2", "process"));
                        }
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$2", "process"));
                        }
                        throw new DiffRequestProducerException("Cannot find base for '" + (beforePath != null ? beforePath : afterPath) + "'");
                    }
                });
                continue;
            }
            diffRequestProducers.add(new MyDiffRequestProducer(shelvedChange, filePath){

                @NotNull
                public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$3", "process"));
                    }
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$3", "process"));
                    }
                    if (!isNewFile && file2.getFileType() == UnknownFileType.INSTANCE) {
                        UnknownFileTypeDiffRequest unknownFileTypeDiffRequest = new UnknownFileTypeDiffRequest(file2, this.getName());
                        if (unknownFileTypeDiffRequest == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$3", "process"));
                        }
                        return unknownFileTypeDiffRequest;
                    }
                    if (shelvedChange.isConflictingChange(project)) {
                        DiffRequest diffRequest;
                        try {
                            final CommitContext commitContext = new CommitContext();
                            final TextFilePatch patch = preloader.getPatch(shelvedChange, commitContext);
                            final FilePath pathBeforeRename = patchContext.getPathBeforeRename(file2);
                            final String relativePath = patch.getAfterName() == null ? patch.getBeforeName() : patch.getAfterName();
                            Getter<CharSequence> baseContentGetter = new Getter<CharSequence>(){

                                public CharSequence get() {
                                    BaseRevisionTextPatchEP baseRevisionTextPatchEP = (BaseRevisionTextPatchEP)Extensions.findExtension((ExtensionPointName)PatchEP.EP_NAME, (AreaInstance)project, BaseRevisionTextPatchEP.class);
                                    return baseRevisionTextPatchEP.provideContent(relativePath, commitContext);
                                }
                            };
                            Getter<ApplyPatchForBaseRevisionTexts> getter = new Getter<ApplyPatchForBaseRevisionTexts>((Getter)baseContentGetter){
                                final /* synthetic */ Getter val$baseContentGetter;
                                {
                                    this.val$baseContentGetter = getter;
                                }

                                public ApplyPatchForBaseRevisionTexts get() {
                                    return ApplyPatchForBaseRevisionTexts.create(project, file2, pathBeforeRename, patch, (Getter<CharSequence>)this.val$baseContentGetter);
                                }
                            };
                            diffRequest = PatchDiffRequestFactory.createConflictDiffRequest(project, file2, "Shelved Version", getter, this.getName(), context, indicator);
                        }
                        catch (VcsException e) {
                            throw new DiffRequestProducerException("Can't show diff for '" + this.getName() + "'", (Throwable)e);
                        }
                        if (diffRequest == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$3", "process"));
                        }
                        return diffRequest;
                    }
                    Change change = shelvedChange.getChange(project);
                    DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(project, change, this.getName(), context, indicator);
                    if (diffRequest == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$3", "process"));
                    }
                    return diffRequest;
                }
            });
        }
    }

    private static abstract class MyDiffRequestProducer
    implements DiffRequestProducer {
        @Nullable
        private final ShelvedChange myTextChange;
        @Nullable
        private final ShelvedBinaryFile myBinaryChange;
        @NotNull
        private final FilePath myFilePath;

        public MyDiffRequestProducer(@NotNull ShelvedChange textChange, @NotNull FilePath filePath) {
            if (textChange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textChange", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$MyDiffRequestProducer", "<init>"));
            }
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$MyDiffRequestProducer", "<init>"));
            }
            this.myBinaryChange = null;
            this.myTextChange = textChange;
            this.myFilePath = filePath;
        }

        public MyDiffRequestProducer(@NotNull ShelvedBinaryFile binaryChange, @NotNull FilePath filePath) {
            if (binaryChange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryChange", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$MyDiffRequestProducer", "<init>"));
            }
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$MyDiffRequestProducer", "<init>"));
            }
            this.myBinaryChange = binaryChange;
            this.myTextChange = null;
            this.myFilePath = filePath;
        }

        @Nullable
        public ShelvedChange getTextChange() {
            return this.myTextChange;
        }

        @Nullable
        public ShelvedBinaryFile getBinaryChange() {
            return this.myBinaryChange;
        }

        @NotNull
        public String getName() {
            String string = FileUtil.toSystemDependentName((String)this.getFilePath().getPath());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$MyDiffRequestProducer", "getName"));
            }
            return string;
        }

        @NotNull
        protected FileStatus getFileStatus() {
            if (this.myTextChange != null) {
                FileStatus fileStatus = this.myTextChange.getFileStatus();
                if (fileStatus == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$MyDiffRequestProducer", "getFileStatus"));
                }
                return fileStatus;
            }
            assert (this.myBinaryChange != null);
            FileStatus fileStatus = this.myBinaryChange.getFileStatus();
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$MyDiffRequestProducer", "getFileStatus"));
            }
            return fileStatus;
        }

        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$MyDiffRequestProducer", "getFilePath"));
            }
            return filePath;
        }
    }

    private static class MyDiffRequestChain
    extends UserDataHolderBase
    implements DiffRequestChain,
    GoToChangePopupBuilder.Chain {
        @NotNull
        private final List<MyDiffRequestProducer> myProducers;
        private int myIndex;

        public MyDiffRequestChain(@NotNull List<MyDiffRequestProducer> producers, int index) {
            if (producers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producers", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$MyDiffRequestChain", "<init>"));
            }
            this.myIndex = 0;
            this.myProducers = producers;
            this.myIndex = index;
        }

        @NotNull
        public List<? extends DiffRequestProducer> getRequests() {
            List<MyDiffRequestProducer> list = this.myProducers;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$MyDiffRequestChain", "getRequests"));
            }
            return list;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public void setIndex(int index) {
            assert (index >= 0 && index < this.myProducers.size());
            this.myIndex = index;
        }

        @Override
        @NotNull
        public AnAction createGoToChangeAction(@NotNull Consumer<Integer> onSelected) {
            if (onSelected == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSelected", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$MyDiffRequestChain", "createGoToChangeAction"));
            }
            ChangeGoToChangePopupAction.Fake<MyDiffRequestChain> fake = new ChangeGoToChangePopupAction.Fake<MyDiffRequestChain>(this, this.myIndex, onSelected){

                @Override
                @NotNull
                protected FilePath getFilePath(int index) {
                    FilePath filePath = ((MyDiffRequestProducer)MyDiffRequestChain.this.myProducers.get(index)).getFilePath();
                    if (filePath == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$MyDiffRequestChain$1", "getFilePath"));
                    }
                    return filePath;
                }

                @Override
                @NotNull
                protected FileStatus getFileStatus(int index) {
                    FileStatus fileStatus = ((MyDiffRequestProducer)MyDiffRequestChain.this.myProducers.get(index)).getFileStatus();
                    if (fileStatus == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$MyDiffRequestChain$1", "getFileStatus"));
                    }
                    return fileStatus;
                }
            };
            if (fake == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$MyDiffRequestChain", "createGoToChangeAction"));
            }
            return fake;
        }
    }

    private static class PatchesPreloader {
        private final Map<String, List<TextFilePatch>> myFilePatchesMap;
        private final Project myProject;

        private PatchesPreloader(Project project) {
            this.myProject = project;
            this.myFilePatchesMap = new HashMap<String, List<TextFilePatch>>();
        }

        @NotNull
        public TextFilePatch getPatch(ShelvedChange shelvedChange, CommitContext commitContext) throws VcsException {
            List<TextFilePatch> textFilePatches = this.myFilePatchesMap.get(shelvedChange.getPatchPath());
            if (textFilePatches == null) {
                try {
                    textFilePatches = ShelveChangesManager.loadPatches(this.myProject, shelvedChange.getPatchPath(), commitContext);
                }
                catch (IOException e) {
                    throw new VcsException((Throwable)e);
                }
                catch (PatchSyntaxException e) {
                    throw new VcsException((Throwable)e);
                }
                this.myFilePatchesMap.put(shelvedChange.getPatchPath(), textFilePatches);
            }
            for (TextFilePatch textFilePatch : textFilePatches) {
                if (!shelvedChange.getBeforePath().equals(textFilePatch.getBeforeName())) continue;
                TextFilePatch textFilePatch2 = textFilePatch;
                if (textFilePatch2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$PatchesPreloader", "getPatch"));
                }
                return textFilePatch2;
            }
            throw new VcsException("Can not find patch for " + shelvedChange.getBeforePath() + " in patch file.");
        }
    }

    private static class ChangeDiffRequestComparator
    implements Comparator<DiffRequestProducer> {
        private static final ChangeDiffRequestComparator ourInstance = new ChangeDiffRequestComparator();

        private ChangeDiffRequestComparator() {
        }

        public static ChangeDiffRequestComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(DiffRequestProducer o1, DiffRequestProducer o2) {
            return FilePathsHelper.convertPath((String)o1.getName()).compareTo(FilePathsHelper.convertPath((String)o2.getName()));
        }
    }
}

