/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import org.jetbrains.annotations.NotNull;

public class ShowHideRecycledAction
extends ToggleAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/shelf/ShowHideRecycledAction", "update"));
        }
        super.update(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(project != null);
        if (project != null) {
            presentation.setText(ShelveChangesManager.getInstance(project).isShowRecycled() ? "Hide Already Unshelved" : "Show Already Unshelved");
            presentation.setIcon("Vcs.Shelf.ContextMenu".equals(e.getPlace()) ? null : AllIcons.Nodes.DisabledPointcut);
        }
    }

    public boolean isSelected(AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ShelveChangesManager manager = ShelveChangesManager.getInstance(project);
        return manager.isShowRecycled();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ShelveChangesManager.getInstance(project).setShowRecycled(state);
    }
}

