/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserFileNode
extends ChangesBrowserNode<VirtualFile>
implements Comparable<ChangesBrowserFileNode> {
    private final Project myProject;
    private final String myName;

    public ChangesBrowserFileNode(Project project, @NotNull VirtualFile userObject) {
        if (userObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userObject", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserFileNode", "<init>"));
        }
        super(userObject);
        this.myName = StringUtil.toLowerCase((String)userObject.getName());
        this.myProject = project;
        if (userObject.isDirectory()) {
            this.myDirectoryCount = 1;
        } else {
            this.myCount = 1;
        }
    }

    @Override
    protected boolean isDirectory() {
        return ((VirtualFile)this.getUserObject()).isDirectory() && FileStatusManager.getInstance((Project)this.myProject).getStatus((VirtualFile)this.getUserObject()) != FileStatus.NOT_CHANGED;
    }

    @Override
    public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        VirtualFile file2 = (VirtualFile)this.getUserObject();
        renderer.appendFileName(file2, file2.getName(), ChangeListManager.getInstance((Project)this.myProject).getStatus(file2).getColor());
        if (renderer.isShowFlatten() && file2.isValid()) {
            VirtualFile parentFile = file2.getParent();
            assert (parentFile != null);
            renderer.append(FontUtil.spaceAndThinSpace() + FileUtil.getLocationRelativeToUserHome((String)parentFile.getPresentableUrl()), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (this.getCount() != 1 || this.getDirectoryCount() != 0) {
            this.appendCount(renderer);
        }
        if (file2.isDirectory()) {
            renderer.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
        } else {
            renderer.setIcon(file2.getFileType().getIcon());
        }
    }

    @Override
    public String getTextPresentation() {
        return ((VirtualFile)this.getUserObject()).getName();
    }

    @Override
    public String toString() {
        return ((VirtualFile)this.getUserObject()).getPresentableUrl();
    }

    @Override
    public int getSortWeight() {
        return 7;
    }

    @Override
    public int compareTo(ChangesBrowserFileNode o) {
        return this.myName.compareTo(o.myName);
    }

    @Override
    public int compareUserObjects(Object o2) {
        if (o2 instanceof VirtualFile) {
            return ((VirtualFile)this.getUserObject()).getName().compareToIgnoreCase(((VirtualFile)o2).getName());
        }
        return 0;
    }
}

