/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.ex.DocumentWrapper;
import com.intellij.openapi.vcs.ex.LineStatusTrackerDrawing;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineStatusTracker {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.ex.LineStatusTracker");
    private static final Key<CanNotCalculateDiffPanel> PANEL_KEY = new Key("LineStatusTracker.CanNotCalculateDiffPanel");
    private final Object myLock;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Document myDocument;
    @NotNull
    private final Document myVcsDocument;
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final Application myApplication;
    @NotNull
    private final FileEditorManager myFileEditorManager;
    @NotNull
    private final VcsDirtyScopeManager myVcsDirtyScopeManager;
    @NotNull
    private final MyDocumentListener myDocumentListener;
    @NotNull
    private final ApplicationAdapter myApplicationListener;
    @Nullable
    private RevisionPack myBaseRevisionNumber;
    private boolean myInitialized;
    private boolean myDuringRollback;
    private boolean myBulkUpdate;
    private boolean myAnathemaThrown;
    private boolean myReleased;
    @NotNull
    private Mode myMode;
    @NotNull
    private List<Range> myRanges;
    @Nullable
    private DirtyRange myDirtyRange;

    private LineStatusTracker(@NotNull Document document, @NotNull Document vcsDocument, @NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull Mode mode) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/ex/LineStatusTracker", "<init>"));
        }
        if (vcsDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsDocument", "com/intellij/openapi/vcs/ex/LineStatusTracker", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ex/LineStatusTracker", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/ex/LineStatusTracker", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/vcs/ex/LineStatusTracker", "<init>"));
        }
        this.myLock = new Object();
        this.myDocument = document;
        this.myVcsDocument = vcsDocument;
        this.myProject = project;
        this.myVirtualFile = virtualFile;
        this.myApplication = ApplicationManager.getApplication();
        this.myFileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        this.myVcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        this.myDocumentListener = new MyDocumentListener();
        this.myDocument.addDocumentListener((DocumentListener)this.myDocumentListener);
        this.myApplicationListener = new MyApplicationListener();
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)this.myApplicationListener);
        this.myMode = mode;
        this.myRanges = new ArrayList<Range>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(@NotNull String vcsContent, @NotNull RevisionPack baseRevisionNumber) {
        if (vcsContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsContent", "com/intellij/openapi/vcs/ex/LineStatusTracker", "initialize"));
        }
        if (baseRevisionNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseRevisionNumber", "com/intellij/openapi/vcs/ex/LineStatusTracker", "initialize"));
        }
        this.myApplication.assertIsDispatchThread();
        Object object = this.myLock;
        synchronized (object) {
            try {
                if (this.myInitialized) return;
                if (this.myReleased) {
                    return;
                }
                if (this.myBaseRevisionNumber != null && this.myBaseRevisionNumber.contains(baseRevisionNumber)) {
                    return;
                }
                this.myBaseRevisionNumber = baseRevisionNumber;
                this.myVcsDocument.setReadOnly(false);
                this.myVcsDocument.setText((CharSequence)vcsContent);
                this.myVcsDocument.setReadOnly(true);
            }
            finally {
                this.myInitialized = true;
            }
            this.reinstallRanges();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinstallRanges() {
        this.myApplication.assertIsDispatchThread();
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myInitialized || this.myReleased || this.myBulkUpdate) {
                return;
            }
            this.destroyRanges();
            try {
                this.myRanges = new RangesBuilder(this.myDocument, this.myVcsDocument, this.myMode).getRanges();
                for (Range range : this.myRanges) {
                    this.createHighlighter(range);
                }
            }
            catch (FilesTooBigForDiffException e) {
                this.installAnathema();
            }
        }
    }

    private void destroyRanges() {
        this.removeAnathema();
        this.removeHighlightersFromMarkupModel();
    }

    private void installAnathema() {
        FileEditor[] editors;
        this.myAnathemaThrown = true;
        for (FileEditor editor : editors = this.myFileEditorManager.getAllEditors(this.myVirtualFile)) {
            CanNotCalculateDiffPanel panel = (CanNotCalculateDiffPanel)((Object)editor.getUserData(PANEL_KEY));
            if (panel != null) continue;
            CanNotCalculateDiffPanel newPanel = new CanNotCalculateDiffPanel();
            editor.putUserData(PANEL_KEY, (Object)newPanel);
            this.myFileEditorManager.addTopComponent(editor, (JComponent)((Object)newPanel));
        }
    }

    private void removeAnathema() {
        FileEditor[] editors;
        if (!this.myAnathemaThrown) {
            return;
        }
        this.myAnathemaThrown = false;
        for (FileEditor editor : editors = this.myFileEditorManager.getEditors(this.myVirtualFile)) {
            CanNotCalculateDiffPanel panel = (CanNotCalculateDiffPanel)((Object)editor.getUserData(PANEL_KEY));
            if (panel == null) continue;
            this.myFileEditorManager.removeTopComponent(editor, (JComponent)((Object)panel));
            editor.putUserData(PANEL_KEY, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(@NotNull Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/vcs/ex/LineStatusTracker", "setMode"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myMode == mode) {
                return;
            }
            this.myMode = mode;
            this.reinstallRanges();
        }
    }

    private void disposeHighlighter(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "disposeHighlighter"));
        }
        try {
            range.invalidate();
            RangeHighlighter highlighter = range.getHighlighter();
            if (highlighter != null) {
                range.setHighlighter(null);
                highlighter.dispose();
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void createHighlighter(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "createHighlighter"));
        }
        this.myApplication.assertIsDispatchThread();
        LOG.assertTrue(!this.myReleased, (Object)"Already released");
        if (range.getHighlighter() != null) {
            LOG.error("Multiple highlighters registered for the same Range");
            return;
        }
        if (this.myMode == Mode.SILENT) {
            return;
        }
        int first = range.getLine1() >= DiffUtil.getLineCount(this.myDocument) ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(range.getLine1());
        int second = range.getLine2() >= DiffUtil.getLineCount(this.myDocument) ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(range.getLine2());
        TextAttributes attr = LineStatusTrackerDrawing.getAttributesFor(range);
        RangeHighlighter highlighter = DocumentMarkupModel.forDocument(this.myDocument, this.myProject, true).addRangeHighlighter(first, second, 999, attr, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setThinErrorStripeMark(true);
        highlighter.setGreedyToLeft(true);
        highlighter.setGreedyToRight(true);
        highlighter.setLineMarkerRenderer(LineStatusTrackerDrawing.createRenderer(range, this));
        highlighter.setEditorFilter(MarkupEditorFilterFactory.createIsNotDiffFilter());
        String tooltip = range.getLine1() == range.getLine2() ? (range.getVcsLine1() + 1 == range.getVcsLine2() ? VcsBundle.message((String)"tooltip.text.line.before.deleted", (Object[])new Object[]{range.getLine1() + 1}) : VcsBundle.message((String)"tooltip.text.lines.before.deleted", (Object[])new Object[]{range.getLine1() + 1, range.getVcsLine2() - range.getVcsLine1()})) : (range.getLine1() + 1 == range.getLine2() ? VcsBundle.message((String)"tooltip.text.line.changed", (Object[])new Object[]{range.getLine1() + 1}) : VcsBundle.message((String)"tooltip.text.lines.changed", (Object[])new Object[]{range.getLine1() + 1, range.getLine2()}));
        highlighter.setErrorStripeTooltip((Object)tooltip);
        range.setHighlighter(highlighter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReleased() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myReleased;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myInitialized && !this.myReleased && !this.myAnathemaThrown && !this.myBulkUpdate && !this.myDuringRollback && this.myDirtyRange == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.myLock;
        synchronized (object) {
            this.myReleased = true;
            this.myDocument.removeDocumentListener((DocumentListener)this.myDocumentListener);
            ApplicationManager.getApplication().removeApplicationListener((ApplicationListener)this.myApplicationListener);
            if (this.myApplication.isDispatchThread()) {
                this.destroyRanges();
            } else {
                this.invalidateRanges();
                this.myApplication.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LineStatusTracker.this.destroyRanges();
                    }
                });
            }
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getProject"));
        }
        return project;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getDocument"));
        }
        return document;
    }

    @NotNull
    public Document getVcsDocument() {
        Document document = this.myVcsDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getVcsDocument"));
        }
        return document;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getVirtualFile"));
        }
        return virtualFile;
    }

    @NotNull
    public Mode getMode() {
        Mode mode = this.myMode;
        if (mode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getMode"));
        }
        return mode;
    }

    public boolean isSilentMode() {
        return this.myMode == Mode.SILENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<Range> getRanges() {
        Object object = this.myLock;
        // MONITORENTER : object
        List<Range> list = Collections.unmodifiableList(this.myRanges);
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getRanges"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBulkUpdate() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myReleased) {
                return;
            }
            this.myBulkUpdate = true;
            this.destroyRanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBulkUpdate() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myReleased) {
                return;
            }
            this.myBulkUpdate = false;
            this.reinstallRanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHighlightersFromMarkupModel() {
        this.myApplication.assertIsDispatchThread();
        Object object = this.myLock;
        synchronized (object) {
            for (Range range : this.myRanges) {
                this.disposeHighlighter(range);
            }
            this.myRanges = Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateRanges() {
        Object object = this.myLock;
        synchronized (object) {
            for (Range range : this.myRanges) {
                range.invalidate();
            }
        }
    }

    private void markFileUnchanged() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean stillEmpty;
                FileDocumentManager.getInstance().saveDocument(LineStatusTracker.this.myDocument);
                Object object = LineStatusTracker.this.myLock;
                synchronized (object) {
                    stillEmpty = LineStatusTracker.this.myRanges.isEmpty();
                }
                if (stillEmpty) {
                    LineStatusTracker.this.myVcsDirtyScopeManager.fileDirty(LineStatusTracker.this.myVirtualFile);
                }
            }
        });
    }

    @NotNull
    private int[] fixRanges(@NotNull DocumentEvent e, int line1, int line2) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/ex/LineStatusTracker", "fixRanges"));
        }
        CharSequence document = this.myDocument.getCharsSequence();
        int offset = e.getOffset();
        if (e.getOldLength() == 0 && e.getNewLength() != 0) {
            if (StringUtil.endsWithChar((CharSequence)e.getNewFragment(), (char)'\n') && LineStatusTracker.isNewline(offset - 1, document)) {
                int[] nArray = new int[]{line1, line2 - 1};
                if (nArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "fixRanges"));
                }
                return nArray;
            }
            if (StringUtil.startsWithChar((CharSequence)e.getNewFragment(), (char)'\n') && LineStatusTracker.isNewline(offset + e.getNewLength(), document)) {
                int[] nArray = new int[]{line1 + 1, line2};
                if (nArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "fixRanges"));
                }
                return nArray;
            }
        }
        if (e.getOldLength() != 0 && e.getNewLength() == 0) {
            if (StringUtil.endsWithChar((CharSequence)e.getOldFragment(), (char)'\n') && LineStatusTracker.isNewline(offset - 1, document)) {
                int[] nArray = new int[]{line1, line2 - 1};
                if (nArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "fixRanges"));
                }
                return nArray;
            }
            if (StringUtil.startsWithChar((CharSequence)e.getOldFragment(), (char)'\n') && LineStatusTracker.isNewline(offset + e.getNewLength(), document)) {
                int[] nArray = new int[]{line1 + 1, line2};
                if (nArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "fixRanges"));
                }
                return nArray;
            }
        }
        int[] nArray = new int[]{line1, line2};
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "fixRanges"));
        }
        return nArray;
    }

    private static boolean isNewline(int offset, @NotNull CharSequence sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/openapi/vcs/ex/LineStatusTracker", "isNewline"));
        }
        if (offset < 0) {
            return false;
        }
        if (offset >= sequence.length()) {
            return false;
        }
        return sequence.charAt(offset) == '\n';
    }

    private void doUpdateRanges(int beforeChangedLine1, int beforeChangedLine2, int linesShift, int beforeTotalLines) {
        ArrayList<Range> rangesBeforeChange = new ArrayList<Range>();
        ArrayList<Range> rangesAfterChange = new ArrayList<Range>();
        ArrayList<Range> changedRanges = new ArrayList<Range>();
        this.sortRanges(beforeChangedLine1, beforeChangedLine2, linesShift, rangesBeforeChange, changedRanges, rangesAfterChange);
        Range firstChangedRange = (Range)ContainerUtil.getFirstItem(changedRanges);
        Range lastChangedRange = (Range)ContainerUtil.getLastItem(changedRanges);
        if (firstChangedRange != null && firstChangedRange.getLine1() < beforeChangedLine1) {
            beforeChangedLine1 = firstChangedRange.getLine1();
        }
        if (lastChangedRange != null && lastChangedRange.getLine2() > beforeChangedLine2) {
            beforeChangedLine2 = lastChangedRange.getLine2();
        }
        this.doUpdateRanges(beforeChangedLine1, beforeChangedLine2, linesShift, beforeTotalLines, rangesBeforeChange, changedRanges, rangesAfterChange);
    }

    private void doUpdateRanges(int beforeChangedLine1, int beforeChangedLine2, int linesShift, int beforeTotalLines, @NotNull List<Range> rangesBefore, @NotNull List<Range> changedRanges, @NotNull List<Range> rangesAfter) {
        if (rangesBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangesBefore", "com/intellij/openapi/vcs/ex/LineStatusTracker", "doUpdateRanges"));
        }
        if (changedRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedRanges", "com/intellij/openapi/vcs/ex/LineStatusTracker", "doUpdateRanges"));
        }
        if (rangesAfter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangesAfter", "com/intellij/openapi/vcs/ex/LineStatusTracker", "doUpdateRanges"));
        }
        try {
            int vcsTotalLines = DiffUtil.getLineCount(this.myVcsDocument);
            Range lastRangeBefore = (Range)ContainerUtil.getLastItem(rangesBefore);
            Range firstRangeAfter = (Range)ContainerUtil.getFirstItem(rangesAfter);
            int afterChangedLine1 = beforeChangedLine1;
            int afterChangedLine2 = beforeChangedLine2 + linesShift;
            int vcsLine1 = LineStatusTracker.getVcsLine1(lastRangeBefore, beforeChangedLine1);
            int vcsLine2 = LineStatusTracker.getVcsLine2(firstRangeAfter, beforeChangedLine2, beforeTotalLines, vcsTotalLines);
            List<Range> newChangedRanges = this.getNewChangedRanges(afterChangedLine1, afterChangedLine2, vcsLine1, vcsLine2);
            LineStatusTracker.shiftRanges(rangesAfter, linesShift);
            if (!changedRanges.equals(newChangedRanges)) {
                this.myRanges = new ArrayList<Range>(rangesBefore.size() + newChangedRanges.size() + rangesAfter.size());
                this.myRanges.addAll(rangesBefore);
                this.myRanges.addAll(newChangedRanges);
                this.myRanges.addAll(rangesAfter);
                for (Range range : changedRanges) {
                    this.disposeHighlighter(range);
                }
                for (Range range : newChangedRanges) {
                    this.createHighlighter(range);
                }
                if (this.myRanges.isEmpty()) {
                    this.markFileUnchanged();
                }
            }
        }
        catch (ProcessCanceledException vcsTotalLines) {
        }
        catch (FilesTooBigForDiffException e1) {
            this.destroyRanges();
            this.installAnathema();
        }
    }

    private static int getVcsLine1(@Nullable Range range, int line) {
        return range == null ? line : line + range.getVcsLine2() - range.getLine2();
    }

    private static int getVcsLine2(@Nullable Range range, int line, int totalLinesBefore, int totalLinesAfter) {
        return range == null ? totalLinesAfter - totalLinesBefore + line : line + range.getVcsLine1() - range.getLine1();
    }

    private List<Range> getNewChangedRanges(int changedLine1, int changedLine2, int vcsLine1, int vcsLine2) throws FilesTooBigForDiffException {
        if (changedLine1 == changedLine2 && vcsLine1 == vcsLine2) {
            return Collections.emptyList();
        }
        if (changedLine1 == changedLine2) {
            return Collections.singletonList(new Range(changedLine1, changedLine2, vcsLine1, vcsLine2));
        }
        if (vcsLine1 == vcsLine2) {
            return Collections.singletonList(new Range(changedLine1, changedLine2, vcsLine1, vcsLine2));
        }
        List<String> lines = new DocumentWrapper(this.myDocument).getLines(changedLine1, changedLine2 - 1);
        List<String> vcsLines = new DocumentWrapper(this.myVcsDocument).getLines(vcsLine1, vcsLine2 - 1);
        return new RangesBuilder(lines, vcsLines, changedLine1, vcsLine1, this.myMode).getRanges();
    }

    private static void shiftRanges(@NotNull List<Range> rangesAfterChange, int shift) {
        if (rangesAfterChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangesAfterChange", "com/intellij/openapi/vcs/ex/LineStatusTracker", "shiftRanges"));
        }
        for (Range range : rangesAfterChange) {
            range.shift(shift);
        }
    }

    private void sortRanges(int beforeChangedLine1, int beforeChangedLine2, int linesShift, @NotNull List<Range> rangesBeforeChange, @NotNull List<Range> changedRanges, @NotNull List<Range> rangesAfterChange) {
        Range range;
        int i;
        if (rangesBeforeChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangesBeforeChange", "com/intellij/openapi/vcs/ex/LineStatusTracker", "sortRanges"));
        }
        if (changedRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedRanges", "com/intellij/openapi/vcs/ex/LineStatusTracker", "sortRanges"));
        }
        if (rangesAfterChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangesAfterChange", "com/intellij/openapi/vcs/ex/LineStatusTracker", "sortRanges"));
        }
        int lastBefore = -1;
        int firstAfter = this.myRanges.size();
        for (i = 0; i < this.myRanges.size(); ++i) {
            range = this.myRanges.get(i);
            if (range.getLine2() < beforeChangedLine1) {
                lastBefore = i;
                continue;
            }
            if (range.getLine1() <= beforeChangedLine2) continue;
            firstAfter = i;
            break;
        }
        if (Registry.is((String)"diff.status.tracker.skip.spaces")) {
            while (lastBefore != -1) {
                int firstChangedLine = beforeChangedLine1;
                if (lastBefore + 1 < this.myRanges.size()) {
                    Range firstChanged = this.myRanges.get(lastBefore + 1);
                    firstChangedLine = Math.min(firstChangedLine, firstChanged.getLine1());
                }
                if (!LineStatusTracker.isLineRangeEmpty(this.myDocument, this.myRanges.get(lastBefore).getLine2(), firstChangedLine)) break;
                --lastBefore;
            }
            while (firstAfter != this.myRanges.size()) {
                int firstUnchangedLineAfter = beforeChangedLine2 + linesShift;
                if (firstAfter > 0) {
                    Range lastChanged = this.myRanges.get(firstAfter - 1);
                    firstUnchangedLineAfter = Math.max(firstUnchangedLineAfter, lastChanged.getLine2() + linesShift);
                }
                if (!LineStatusTracker.isLineRangeEmpty(this.myDocument, firstUnchangedLineAfter, this.myRanges.get(firstAfter).getLine1() + linesShift)) break;
                ++firstAfter;
            }
        }
        for (i = 0; i < this.myRanges.size(); ++i) {
            range = this.myRanges.get(i);
            if (i <= lastBefore) {
                rangesBeforeChange.add(range);
                continue;
            }
            if (i >= firstAfter) {
                rangesAfterChange.add(range);
                continue;
            }
            changedRanges.add(range);
        }
    }

    private static boolean isLineRangeEmpty(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/ex/LineStatusTracker", "isLineRangeEmpty"));
        }
        int lineCount = DiffUtil.getLineCount(document);
        int startOffset = line1 == lineCount ? document.getTextLength() : document.getLineStartOffset(line1);
        int endOffset = line2 == lineCount ? document.getTextLength() : document.getLineStartOffset(line2);
        CharSequence interval = document.getImmutableCharSequence().subSequence(startOffset, endOffset);
        return StringUtil.isEmptyOrSpaces((CharSequence)interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getNextRange(Range range) {
        Object object = this.myLock;
        synchronized (object) {
            int index = this.myRanges.indexOf(range);
            if (index == this.myRanges.size() - 1) {
                return null;
            }
            return this.myRanges.get(index + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getPrevRange(Range range) {
        Object object = this.myLock;
        synchronized (object) {
            int index = this.myRanges.indexOf(range);
            if (index <= 0) {
                return null;
            }
            return this.myRanges.get(index - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getNextRange(int line) {
        Object object = this.myLock;
        synchronized (object) {
            for (Range range : this.myRanges) {
                if (line >= range.getLine2() || range.isSelectedByLine(line)) continue;
                return range;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getPrevRange(int line) {
        Object object = this.myLock;
        synchronized (object) {
            for (int i = this.myRanges.size() - 1; i >= 0; --i) {
                Range range = this.myRanges.get(i);
                if (line <= range.getLine1() || range.isSelectedByLine(line)) continue;
                return range;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getRangeForLine(int line) {
        Object object = this.myLock;
        synchronized (object) {
            for (Range range : this.myRanges) {
                if (!range.isSelectedByLine(line)) continue;
                return range;
            }
            return null;
        }
    }

    private void doRollbackRange(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "doRollbackRange"));
        }
        DiffUtil.applyModification(this.myDocument, range.getLine1(), range.getLine2(), this.myVcsDocument, range.getVcsLine1(), range.getVcsLine2());
        this.markLinesUnchanged(range.getLine1(), range.getLine1() + range.getVcsLine2() - range.getVcsLine1());
    }

    private void markLinesUnchanged(int startLine, int endLine) {
        if (this.myDocument.getTextLength() == 0) {
            return;
        }
        if (startLine == endLine) {
            return;
        }
        ((DocumentImpl)this.myDocument).clearLineModificationFlags(startLine, endLine);
    }

    public void rollbackChanges(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "rollbackChanges"));
        }
        this.rollbackChanges(Collections.singletonList(range));
    }

    public void rollbackChanges(@NotNull BitSet lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/openapi/vcs/ex/LineStatusTracker", "rollbackChanges"));
        }
        ArrayList<Range> toRollback = new ArrayList<Range>();
        for (Range range : this.myRanges) {
            boolean check = DiffUtil.isSelectedByLine(lines, range.getLine1(), range.getLine2());
            if (!check) continue;
            toRollback.add(range);
        }
        this.rollbackChanges(toRollback);
    }

    private void rollbackChanges(final @NotNull List<Range> ranges) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/openapi/vcs/ex/LineStatusTracker", "rollbackChanges"));
        }
        this.runBulkRollback(new Runnable(){

            @Override
            public void run() {
                Range first = null;
                Range last = null;
                int shift = 0;
                for (Range range : ranges) {
                    if (!range.isValid()) {
                        LOG.warn("Rollback of invalid range");
                        break;
                    }
                    if (first == null) {
                        first = range;
                    }
                    last = range;
                    Range shiftedRange = new Range(range);
                    shiftedRange.shift(shift);
                    LineStatusTracker.this.doRollbackRange(shiftedRange);
                    shift += range.getVcsLine2() - range.getVcsLine1() - (range.getLine2() - range.getLine1());
                }
                if (first != null) {
                    int beforeChangedLine1 = first.getLine1();
                    int beforeChangedLine2 = last.getLine2();
                    int beforeTotalLines = DiffUtil.getLineCount(LineStatusTracker.this.myDocument) - shift;
                    LineStatusTracker.this.doUpdateRanges(beforeChangedLine1, beforeChangedLine2, shift, beforeTotalLines);
                }
            }
        });
    }

    public void rollbackAllChanges() {
        this.runBulkRollback(new Runnable(){

            @Override
            public void run() {
                LineStatusTracker.this.myDocument.setText((CharSequence)LineStatusTracker.this.myVcsDocument.getText());
                LineStatusTracker.this.destroyRanges();
                LineStatusTracker.this.markFileUnchanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBulkRollback(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/vcs/ex/LineStatusTracker", "runBulkRollback"));
        }
        this.myApplication.assertWriteAccessAllowed();
        Object object = this.myLock;
        synchronized (object) {
            if (!this.isValid()) {
                return;
            }
            try {
                this.myDuringRollback = true;
                task.run();
            }
            catch (Error e) {
                this.reinstallRanges();
                throw e;
            }
            catch (RuntimeException e) {
                this.reinstallRanges();
                throw e;
            }
            finally {
                this.myDuringRollback = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CharSequence getCurrentContent(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getCurrentContent"));
        }
        Object object = this.myLock;
        // MONITORENTER : object
        TextRange textRange = this.getCurrentTextRange(range);
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        CharSequence charSequence = this.myDocument.getImmutableCharSequence().subSequence(startOffset, endOffset);
        // MONITOREXIT : object
        if (charSequence != null) return charSequence;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getCurrentContent"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CharSequence getVcsContent(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getVcsContent"));
        }
        Object object = this.myLock;
        // MONITORENTER : object
        TextRange textRange = this.getVcsTextRange(range);
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        CharSequence charSequence = this.myVcsDocument.getImmutableCharSequence().subSequence(startOffset, endOffset);
        // MONITOREXIT : object
        if (charSequence != null) return charSequence;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getVcsContent"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public TextRange getCurrentTextRange(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getCurrentTextRange"));
        }
        Object object = this.myLock;
        // MONITORENTER : object
        if (!range.isValid()) {
            LOG.warn("Current TextRange of invalid range");
        }
        TextRange textRange = DiffUtil.getLinesRange(this.myDocument, range.getLine1(), range.getLine2());
        // MONITOREXIT : object
        if (textRange != null) return textRange;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getCurrentTextRange"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public TextRange getVcsTextRange(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getVcsTextRange"));
        }
        Object object = this.myLock;
        // MONITORENTER : object
        if (!range.isValid()) {
            LOG.warn("Vcs TextRange of invalid range");
        }
        TextRange textRange = DiffUtil.getLinesRange(this.myVcsDocument, range.getVcsLine1(), range.getVcsLine2());
        // MONITOREXIT : object
        if (textRange != null) return textRange;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getVcsTextRange"));
    }

    public static LineStatusTracker createOn(@NotNull VirtualFile virtualFile, @NotNull Document document, Project project, @NotNull Mode mode) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/ex/LineStatusTracker", "createOn"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/ex/LineStatusTracker", "createOn"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/vcs/ex/LineStatusTracker", "createOn"));
        }
        DocumentImpl vcsDocument = new DocumentImpl("", true);
        vcsDocument.putUserData(UndoConstants.DONT_RECORD_UNDO, Boolean.TRUE);
        return new LineStatusTracker(document, vcsDocument, project, virtualFile, mode);
    }

    private static class CanNotCalculateDiffPanel
    extends EditorNotificationPanel {
        public CanNotCalculateDiffPanel() {
            this.myLabel.setText("Can not highlight changed lines. File is too big and there are too many changes.");
        }
    }

    private static class DirtyRange {
        public final int line1;
        public final int line2;
        public final int lineShift;
        public final int beforeTotalLines;

        public DirtyRange(int line1, int line2, int lineShift, int beforeTotalLines) {
            this.line1 = line1;
            this.line2 = line2;
            this.lineShift = lineShift;
            this.beforeTotalLines = beforeTotalLines;
        }
    }

    public static class RevisionPack {
        private final long myNumber;
        private final VcsRevisionNumber myRevision;

        public RevisionPack(long number, VcsRevisionNumber revision) {
            this.myNumber = number;
            this.myRevision = revision;
        }

        public long getNumber() {
            return this.myNumber;
        }

        public VcsRevisionNumber getRevision() {
            return this.myRevision;
        }

        public boolean contains(RevisionPack previous) {
            if (this.myRevision.equals(previous.getRevision()) && !this.myRevision.equals(VcsRevisionNumber.NULL)) {
                return true;
            }
            return this.myNumber >= previous.getNumber();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RevisionPack that = (RevisionPack)o;
            return this.myRevision.equals(that.getRevision());
        }

        public int hashCode() {
            return this.myRevision.hashCode();
        }
    }

    private class MyDocumentListener
    extends DocumentAdapter {
        private int myLine1;
        private int myLine2;
        private int myBeforeTotalLines;

        private MyDocumentListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeDocumentChange(DocumentEvent e) {
            LineStatusTracker.this.myApplication.assertIsDispatchThread();
            Object object = LineStatusTracker.this.myLock;
            synchronized (object) {
                if (!LineStatusTracker.this.myInitialized || LineStatusTracker.this.myReleased) {
                    return;
                }
                if (LineStatusTracker.this.myBulkUpdate || LineStatusTracker.this.myDuringRollback || LineStatusTracker.this.myAnathemaThrown) {
                    return;
                }
                assert (LineStatusTracker.this.myDocument == e.getDocument());
                this.myLine1 = LineStatusTracker.this.myDocument.getLineNumber(e.getOffset());
                this.myLine2 = e.getOldLength() == 0 ? this.myLine1 + 1 : LineStatusTracker.this.myDocument.getLineNumber(e.getOffset() + e.getOldLength()) + 1;
                this.myBeforeTotalLines = DiffUtil.getLineCount(LineStatusTracker.this.myDocument);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentChanged(DocumentEvent e) {
            LineStatusTracker.this.myApplication.assertIsDispatchThread();
            Object object = LineStatusTracker.this.myLock;
            synchronized (object) {
                if (!LineStatusTracker.this.myInitialized || LineStatusTracker.this.myReleased) {
                    return;
                }
                if (LineStatusTracker.this.myBulkUpdate || LineStatusTracker.this.myDuringRollback || LineStatusTracker.this.myAnathemaThrown) {
                    return;
                }
                assert (LineStatusTracker.this.myDocument == e.getDocument());
                int newLine1 = this.myLine1;
                int newLine2 = e.getNewLength() == 0 ? newLine1 + 1 : LineStatusTracker.this.myDocument.getLineNumber(e.getOffset() + e.getNewLength()) + 1;
                int linesShift = newLine2 - newLine1 - (this.myLine2 - this.myLine1);
                int[] fixed = LineStatusTracker.this.fixRanges(e, this.myLine1, this.myLine2);
                int line1 = fixed[0];
                int line2 = fixed[1];
                if (LineStatusTracker.this.myDirtyRange == null) {
                    LineStatusTracker.this.myDirtyRange = new DirtyRange(line1, line2, linesShift, this.myBeforeTotalLines);
                } else {
                    int oldLine1 = ((LineStatusTracker)LineStatusTracker.this).myDirtyRange.line1;
                    int oldLine2 = ((LineStatusTracker)LineStatusTracker.this).myDirtyRange.line2 + ((LineStatusTracker)LineStatusTracker.this).myDirtyRange.lineShift;
                    int updatedLine1 = ((LineStatusTracker)LineStatusTracker.this).myDirtyRange.line1 - Math.max(oldLine1 - line1, 0);
                    int updatedLine2 = ((LineStatusTracker)LineStatusTracker.this).myDirtyRange.line2 + Math.max(line2 - oldLine2, 0);
                    LineStatusTracker.this.myDirtyRange = new DirtyRange(updatedLine1, updatedLine2, linesShift + ((LineStatusTracker)LineStatusTracker.this).myDirtyRange.lineShift, ((LineStatusTracker)LineStatusTracker.this).myDirtyRange.beforeTotalLines);
                }
            }
        }
    }

    private class MyApplicationListener
    extends ApplicationAdapter {
        private MyApplicationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeActionFinished(Object action) {
            Object object = LineStatusTracker.this.myLock;
            synchronized (object) {
                if (!LineStatusTracker.this.myInitialized || LineStatusTracker.this.myReleased || LineStatusTracker.this.myBulkUpdate || LineStatusTracker.this.myDuringRollback || LineStatusTracker.this.myAnathemaThrown) {
                    return;
                }
                if (LineStatusTracker.this.myDirtyRange != null) {
                    LineStatusTracker.this.doUpdateRanges(((LineStatusTracker)LineStatusTracker.this).myDirtyRange.line1, ((LineStatusTracker)LineStatusTracker.this).myDirtyRange.line2, ((LineStatusTracker)LineStatusTracker.this).myDirtyRange.lineShift, ((LineStatusTracker)LineStatusTracker.this).myDirtyRange.beforeTotalLines);
                    LineStatusTracker.this.myDirtyRange = null;
                }
            }
        }
    }

    public static enum Mode {
        DEFAULT,
        SMART,
        SILENT;

    }
}

