/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.differ;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.extractor.differ.Differ;
import com.intellij.psi.codeStyle.extractor.differ.DifferBase;
import com.intellij.psi.codeStyle.extractor.differ.LangCodeStyleExtractor;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import java.util.Collection;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class JavaExtractor
implements LangCodeStyleExtractor {
    @NotNull
    public Differ getDiffer(final Project project, PsiFile psiFile, CodeStyleSettings settings) {
        DifferBase differBase = new DifferBase(project, psiFile, settings){

            public String reformattedText() {
                final JavaCodeFragment file2 = JavaCodeFragmentFactory.getInstance((Project)project).createCodeBlockCodeFragment(this.myOrigText, (PsiElement)this.myFile, false);
                WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)"CodeStyleSettings extractor", (String)"CodeStyleSettings extractor", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)file2);
                        assert (treeElement != null);
                        SourceTreeToPsiMap.treeElementToPsi(new CodeFormatterFacade(mySettings, file2.getLanguage()).processElement(treeElement));
                    }
                }, (PsiFile[])new PsiFile[]{file2});
                return file2.getText();
            }
        };
        if (differBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/extractor/differ/JavaExtractor", "getDiffer"));
        }
        return differBase;
    }

    @NotNull
    public Collection<Value.VAR_KIND> getCustomVarKinds() {
        LinkedList<Value.VAR_KIND> linkedList = new LinkedList<Value.VAR_KIND>();
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/extractor/differ/JavaExtractor", "getCustomVarKinds"));
        }
        return linkedList;
    }
}

