/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.infos.CandidateInfo;

public class ElementExtractorFilter
implements ElementFilter {
    private final ElementFilter myFilter;

    public ElementExtractorFilter(ElementFilter filter) {
        this.myFilter = filter;
    }

    public ElementFilter getFilter() {
        return this.myFilter;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return this.myFilter.isClassAcceptable(hintClass);
    }

    public boolean isAcceptable(Object element, PsiElement context) {
        if (element instanceof CandidateInfo) {
            CandidateInfo candidateInfo = (CandidateInfo)element;
            PsiElement psiElement = candidateInfo.getElement();
            return this.myFilter.isAcceptable((Object)psiElement, context);
        }
        if (element instanceof PsiElement) {
            return this.myFilter.isAcceptable(element, context);
        }
        return false;
    }

    public String toString() {
        return this.getFilter().toString();
    }
}

