/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InitialInferenceState;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSessionContainer {
    private static final Logger LOG = Logger.getInstance((String)("#" + InferenceSessionContainer.class.getName()));
    private final Map<PsiElement, InferenceSession> myNestedSessions = new HashMap<PsiElement, InferenceSession>();

    public void registerNestedSession(InferenceSession session) {
        this.myNestedSessions.put(session.getContext(), session);
        this.myNestedSessions.putAll(session.getInferenceSessionContainer().myNestedSessions);
    }

    @Contract(value="_, !null -> !null")
    public InferenceSession findNestedCallSession(PsiElement arg, @Nullable InferenceSession defaultSession) {
        InferenceSession session = this.myNestedSessions.get(PsiTreeUtil.getParentOfType((PsiElement)arg, PsiCall.class));
        return session == null ? defaultSession : session;
    }

    public void registerNestedSession(InferenceSession session, PsiType returnType, PsiExpression returnExpression) {
        InferenceSession inferenceSession;
        InferenceSession callSession = this.findNestedCallSession((PsiElement)((PsiCallExpression)returnExpression).getArgumentList(), null);
        if (callSession == null && (inferenceSession = ExpressionCompatibilityConstraint.reduceExpressionCompatibilityConstraint(session, returnExpression, returnType)) != null && inferenceSession != session) {
            this.registerNestedSession(inferenceSession);
        }
    }

    static PsiSubstitutor infer(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, final @NotNull PsiElement parent) {
        InitialInferenceState initialInferenceState;
        Pair session;
        PsiExpressionList argumentList;
        MethodCandidateInfo.CurrentCandidateProperties properties;
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (parent instanceof PsiCall && (properties = MethodCandidateInfo.getCurrentMethod((PsiElement)(argumentList = ((PsiCall)parent).getArgumentList()))) != null && !properties.isApplicabilityCheck() && (session = (Pair)PsiResolveHelper.ourGraphGuard.doPreventingRecursion((Object)parent, false, (Computable)new Computable<Pair<PsiSubstitutor, Map<PsiElement, InitialInferenceState>>>(){

            public Pair<PsiSubstitutor, Map<PsiElement, InitialInferenceState>> compute() {
                return InferenceSessionContainer.createValue(parent);
            }
        })) != null && (initialInferenceState = (InitialInferenceState)((Map)session.second).get(PsiTreeUtil.getParentOfType((PsiElement)argumentList, PsiCall.class))) != null) {
            return new InferenceSession(initialInferenceState).collectAdditionalAndInfer(parameters, arguments, properties, (PsiSubstitutor)session.first);
        }
        InferenceSession inferenceSession = new InferenceSession(typeParameters, partialSubstitutor, parent.getManager(), parent);
        inferenceSession.initExpressionConstraints(parameters, arguments, parent, null);
        return inferenceSession.infer(parameters, arguments, parent);
    }

    private static Pair<PsiSubstitutor, Map<PsiElement, InitialInferenceState>> createValue(final @NotNull PsiElement parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "createValue"));
        }
        if (MethodCandidateInfo.isOverloadCheck()) {
            return InferenceSessionContainer.startTopLevelInference(parent);
        }
        return (Pair)CachedValuesManager.getCachedValue((PsiElement)parent, (CachedValueProvider)new CachedValueProvider<Pair<PsiSubstitutor, Map<PsiElement, InitialInferenceState>>>(){

            @Nullable
            public CachedValueProvider.Result<Pair<PsiSubstitutor, Map<PsiElement, InitialInferenceState>>> compute() {
                return new CachedValueProvider.Result((Object)InferenceSessionContainer.startTopLevelInference(parent), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
    }

    private static Pair<PsiSubstitutor, Map<PsiElement, InitialInferenceState>> startTopLevelInference(@NotNull PsiElement parent) {
        JavaResolveResult result2;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "startTopLevelInference"));
        }
        PsiCall topLevelCall = InferenceSessionContainer.treeWalkUp(parent);
        if (topLevelCall != null && (result2 = topLevelCall.resolveMethodGenerics()) instanceof MethodCandidateInfo) {
            PsiMethod method = ((MethodCandidateInfo)result2).getElement();
            PsiParameter[] topLevelParameters = method.getParameterList().getParameters();
            PsiExpressionList topLevelCallArgumentList = topLevelCall.getArgumentList();
            LOG.assertTrue(topLevelCallArgumentList != null, (Object)topLevelCall);
            PsiExpression[] topLevelArguments = topLevelCallArgumentList.getExpressions();
            InferenceSession topLevelSession = new InferenceSession(method.getTypeParameters(), ((MethodCandidateInfo)result2).getSiteSubstitutor(), topLevelCall.getManager(), (PsiElement)topLevelCall);
            topLevelSession.initExpressionConstraints(topLevelParameters, topLevelArguments, (PsiElement)topLevelCall, method, ((MethodCandidateInfo)result2).isVarargs());
            topLevelSession.infer(topLevelParameters, topLevelArguments, (PsiElement)topLevelCall, ((MethodCandidateInfo)result2).createProperties());
            Map<PsiElement, InferenceSession> nestedSessions = topLevelSession.getInferenceSessionContainer().myNestedSessions;
            LinkedHashMap<PsiElement, InitialInferenceState> nestedStates = new LinkedHashMap<PsiElement, InitialInferenceState>();
            for (Map.Entry<PsiElement, InferenceSession> entry : nestedSessions.entrySet()) {
                nestedStates.put(entry.getKey(), entry.getValue().createInitialState());
            }
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            for (InferenceVariable variable : topLevelSession.getInferenceVariables()) {
                PsiType instantiation = variable.getInstantiation();
                if (instantiation == PsiType.NULL) continue;
                substitutor = substitutor.put((PsiTypeParameter)variable, instantiation);
            }
            return Pair.create((Object)substitutor, nestedStates);
        }
        return null;
    }

    @Nullable
    private static PsiCall treeWalkUp(PsiElement context) {
        if (context instanceof PsiExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)context)) {
            return null;
        }
        PsiCall top = null;
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{PsiExpressionList.class, PsiLambdaExpression.class, PsiCodeBlock.class, PsiCall.class});
        while (!(parent instanceof PsiCall || parent instanceof PsiCodeBlock && PsiTreeUtil.getParentOfType((PsiElement)parent, PsiLambdaExpression.class) == null)) {
            MethodCandidateInfo.CurrentCandidateProperties properties;
            PsiCall psiCall;
            if (parent instanceof PsiLambdaExpression) {
                boolean inReturnExpressions = false;
                for (PsiExpression expression : LambdaUtil.getReturnExpressions((PsiLambdaExpression)((PsiLambdaExpression)parent))) {
                    inReturnExpressions |= PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)context, (boolean)false);
                }
                if (!inReturnExpressions) break;
            }
            if ((psiCall = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiCall.class)) == null || (properties = MethodCandidateInfo.getCurrentMethod((PsiElement)psiCall.getArgumentList())) != null && properties.isApplicabilityCheck() || !((top = psiCall) instanceof PsiExpression) || !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)top)) break;
            parent = PsiTreeUtil.getParentOfType((PsiElement)parent.getParent(), (Class[])new Class[]{PsiExpressionList.class, PsiLambdaExpression.class, PsiCodeBlock.class});
        }
        if (top == null) {
            return null;
        }
        PsiExpressionList argumentList = top.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        LOG.assertTrue(MethodCandidateInfo.getCurrentMethod((PsiElement)argumentList) == null);
        return top;
    }
}

