/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSessionContainer;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class InitialInferenceState {
    private final Set<InferenceVariable> myInferenceVariables;
    private final PsiElement myContext;
    private final PsiSubstitutor myInferenceSubstitutor;
    private final PsiSubstitutor mySiteSubstitutor;
    private final List<Pair<PsiTypeParameter[], PsiClassType>> myCaptures;
    private final InferenceSessionContainer myInferenceSessionContainer;

    public InitialInferenceState(Set<InferenceVariable> inferenceVariables, PsiElement context, PsiSubstitutor inferenceSubstitutor, PsiSubstitutor siteSubstitutor, List<Pair<PsiTypeParameter[], PsiClassType>> captures, InferenceSessionContainer inferenceSessionContainer) {
        this.myInferenceVariables = inferenceVariables;
        this.myContext = context;
        this.myInferenceSubstitutor = inferenceSubstitutor;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myCaptures = captures;
        this.myInferenceSessionContainer = inferenceSessionContainer;
    }

    @NotNull
    static PsiSubstitutor copyVariables(List<InferenceVariable> targetVars, Set<InferenceVariable> inferenceVariables, PsiElement context) {
        InferenceVariable[] oldVars;
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : oldVars = inferenceVariables.toArray(new InferenceVariable[inferenceVariables.size()])) {
            InferenceVariable newVariable = new InferenceVariable(context, variable.getParameter());
            substitutor = substitutor.put((PsiTypeParameter)variable, (PsiType)JavaPsiFacade.getElementFactory((Project)variable.getProject()).createType((PsiClass)newVariable));
            targetVars.add(newVariable);
        }
        for (int i = 0; i < targetVars.size(); ++i) {
            InferenceVariable var = targetVars.get(i);
            for (InferenceBound boundType : InferenceBound.values()) {
                for (PsiType bound : oldVars[i].getBounds(boundType)) {
                    var.addBound(substitutor.substitute(bound), boundType);
                }
            }
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InitialInferenceState", "copyVariables"));
        }
        return psiSubstitutor;
    }

    public InferenceSessionContainer getInferenceSessionContainer() {
        return this.myInferenceSessionContainer;
    }

    public Set<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables;
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public PsiSubstitutor getInferenceSubstitutor() {
        return this.myInferenceSubstitutor;
    }

    public PsiSubstitutor getSiteSubstitutor() {
        return this.mySiteSubstitutor;
    }

    public List<Pair<PsiTypeParameter[], PsiClassType>> getCaptures() {
        return this.myCaptures;
    }
}

