/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.ui.JavaComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.ParameterTablePanel;
import com.intellij.refactoring.util.VariableData;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.SeparatorFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractMethodDialog
extends DialogWrapper
implements AbstractExtractDialog {
    private static final String EXTRACT_METHOD_DEFAULT_VISIBILITY = "extract.method.default.visibility";
    public static final String EXTRACT_METHOD_GENERATE_ANNOTATIONS = "extractMethod.generateAnnotations";
    private final Project myProject;
    private final PsiType myReturnType;
    private final PsiTypeParameterList myTypeParameterList;
    private final PsiType[] myExceptions;
    private final boolean myStaticFlag;
    private final boolean myCanBeStatic;
    private final Nullness myNullness;
    private final PsiElement[] myElementsToExtract;
    private final String myHelpId;
    private final NameSuggestionsField myNameField;
    private final MethodSignatureComponent mySignature;
    private final JCheckBox myMakeStatic;
    protected JCheckBox myMakeVarargs;
    protected JCheckBox myGenerateAnnotations;
    private JCheckBox myCbChainedConstructor;
    private final InputVariables myVariableData;
    private final PsiClass myTargetClass;
    private ComboBoxVisibilityPanel<String> myVisibilityPanel;
    private boolean myDefaultVisibility = true;
    private boolean myChangingVisibility;
    private final JCheckBox myFoldParameters = new NonFocusableCheckBox(RefactoringBundle.message((String)"declare.folded.parameters"));
    public JPanel myCenterPanel;
    public JPanel myParamTable;
    private VariableData[] myInputVariables;
    private TypeSelector mySelector;

    public ExtractMethodDialog(Project project, PsiClass targetClass, InputVariables inputVariables, PsiType returnType, PsiTypeParameterList typeParameterList, PsiType[] exceptions, boolean isStatic, boolean canBeStatic, boolean canBeChainedConstructor, String title, String helpId, Nullness nullness, PsiElement[] elementsToExtract) {
        super(project, true);
        this.myProject = project;
        this.myTargetClass = targetClass;
        this.myReturnType = returnType;
        this.myTypeParameterList = typeParameterList;
        this.myExceptions = exceptions;
        this.myStaticFlag = isStatic;
        this.myCanBeStatic = canBeStatic;
        this.myNullness = nullness;
        this.myElementsToExtract = elementsToExtract;
        this.myVariableData = inputVariables;
        this.myHelpId = helpId;
        this.mySignature = new MethodSignatureComponent("", project, (FileType)JavaFileType.INSTANCE);
        this.mySignature.setPreferredSize((Dimension)JBUI.size((int)500, (int)100));
        this.mySignature.setMinimumSize((Dimension)JBUI.size((int)500, (int)100));
        this.setTitle(title);
        this.myNameField = new NameSuggestionsField(this.suggestMethodNames(), this.myProject);
        this.myMakeStatic = new NonFocusableCheckBox();
        this.myMakeStatic.setText(RefactoringBundle.message((String)"declare.static.checkbox"));
        if (canBeChainedConstructor) {
            this.myCbChainedConstructor = new NonFocusableCheckBox(RefactoringBundle.message((String)"extract.chained.constructor.checkbox"));
        }
        this.init();
    }

    protected String[] suggestMethodNames() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    protected boolean areTypesDirected() {
        return true;
    }

    @Override
    public boolean isMakeStatic() {
        if (this.myStaticFlag) {
            return true;
        }
        return this.myCanBeStatic && this.myMakeStatic.isSelected();
    }

    @Override
    public boolean isChainedConstructor() {
        return this.myCbChainedConstructor != null && this.myCbChainedConstructor.isSelected();
    }

    @NotNull
    protected Action[] createActions() {
        if (this.myHelpId != null) {
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/extractMethod/ExtractMethodDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/extractMethod/ExtractMethodDialog", "createActions"));
        }
        return actionArray;
    }

    @Override
    public String getChosenMethodName() {
        return this.myNameField.getEnteredName();
    }

    @Override
    public VariableData[] getChosenParameters() {
        return this.myInputVariables;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected String getHelpId() {
        return this.myHelpId;
    }

    protected void doOKAction() {
        PsiMethod containingMethod;
        ConflictsDialog conflictsDialog;
        MultiMap conflicts = new MultiMap();
        this.checkMethodConflicts((MultiMap<PsiElement, String>)conflicts);
        if (!conflicts.isEmpty() && !(conflictsDialog = new ConflictsDialog(this.myProject, (MultiMap<PsiElement, String>)conflicts)).showAndGet()) {
            if (conflictsDialog.isShowConflicts()) {
                this.close(1);
            }
            return;
        }
        if (this.myMakeVarargs != null && this.myMakeVarargs.isSelected()) {
            VariableData data = this.myInputVariables[this.myInputVariables.length - 1];
            if (data.type instanceof PsiArrayType) {
                data.type = new PsiEllipsisType(((PsiArrayType)data.type).getComponentType());
            }
        }
        if ((containingMethod = this.getContainingMethod()) != null && containingMethod.hasModifierProperty("public")) {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(EXTRACT_METHOD_DEFAULT_VISIBILITY, this.getVisibility());
        }
        if (this.myGenerateAnnotations != null && this.myGenerateAnnotations.isEnabled()) {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(EXTRACT_METHOD_GENERATE_ANNOTATIONS, this.myGenerateAnnotations.isSelected(), true);
        }
        super.doOKAction();
    }

    protected JComponent createNorthPanel() {
        JPanel returnTypePanel;
        JPanel main = new JPanel(new BorderLayout());
        JPanel namePanel = new JPanel(new BorderLayout(0, 2));
        JLabel nameLabel = new JLabel();
        nameLabel.setText(RefactoringBundle.message((String)"changeSignature.name.prompt"));
        namePanel.add((Component)nameLabel, "North");
        namePanel.add((Component)this.myNameField, "South");
        nameLabel.setLabelFor(this.myNameField);
        this.myNameField.addDataChangedListener(new NameSuggestionsField.DataChanged(){

            @Override
            public void dataChanged() {
                ExtractMethodDialog.this.update();
            }
        });
        this.myVisibilityPanel = this.createVisibilityPanel();
        this.myVisibilityPanel.registerUpDownActionsFor(this.myNameField);
        JPanel visibilityAndReturnType = new JPanel(new BorderLayout(2, 0));
        if (!this.myTargetClass.isInterface()) {
            visibilityAndReturnType.add(this.myVisibilityPanel, "West");
        }
        if ((returnTypePanel = this.createReturnTypePanel()) != null) {
            visibilityAndReturnType.add((Component)returnTypePanel, "East");
        }
        JPanel visibilityAndName = new JPanel(new BorderLayout(2, 0));
        visibilityAndName.add((Component)visibilityAndReturnType, "West");
        visibilityAndName.add((Component)namePanel, "Center");
        main.add((Component)visibilityAndName, "Center");
        this.setOKActionEnabled(false);
        this.setOKActionEnabled(PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(this.myNameField.getEnteredName()));
        JPanel options = new JPanel(new BorderLayout());
        options.add((Component)this.createOptionsPanel(), "West");
        main.add((Component)options, "South");
        return main;
    }

    protected boolean isVoidReturn() {
        return false;
    }

    @Nullable
    private JPanel createReturnTypePanel() {
        if (TypeConversionUtil.isPrimitiveWrapper((PsiType)this.myReturnType) && this.myNullness == Nullness.NULLABLE) {
            return null;
        }
        TypeSelectorManagerImpl manager = new TypeSelectorManagerImpl(this.myProject, this.myReturnType, this.findOccurrences(), this.areTypesDirected()){

            @Override
            public PsiType[] getTypesForAll(boolean direct) {
                Object[] types = super.getTypesForAll(direct);
                return !ExtractMethodDialog.this.isVoidReturn() ? types : (PsiType[])ArrayUtil.prepend((Object)PsiType.VOID, (Object[])types);
            }
        };
        this.mySelector = manager.getTypeSelector();
        final JComponent component = this.mySelector.getComponent();
        if (component instanceof ComboBox) {
            if (this.isVoidReturn()) {
                this.mySelector.selectType((PsiType)PsiType.VOID);
            }
            final JPanel returnTypePanel = new JPanel(new BorderLayout(2, 0));
            JLabel label = new JLabel(RefactoringBundle.message((String)"changeSignature.return.type.prompt"));
            returnTypePanel.add((Component)label, "North");
            returnTypePanel.add((Component)component, "South");
            DialogUtil.registerMnemonic((JLabel)label, (JComponent)component);
            ((JComboBox)component).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PsiType selectedType = ExtractMethodDialog.this.mySelector.getSelectedType();
                    if (ExtractMethodDialog.this.myGenerateAnnotations != null) {
                        boolean enabled;
                        boolean bl = enabled = PsiUtil.resolveClassInType((PsiType)selectedType) != null;
                        if (!enabled) {
                            ExtractMethodDialog.this.myGenerateAnnotations.setSelected(false);
                        }
                        ExtractMethodDialog.this.myGenerateAnnotations.setEnabled(enabled);
                    }
                    ExtractMethodDialog.resizeReturnCombo(component, selectedType);
                    returnTypePanel.revalidate();
                    returnTypePanel.repaint();
                    ExtractMethodDialog.this.updateSignature();
                }
            });
            ExtractMethodDialog.resizeReturnCombo(component, this.mySelector.getSelectedType());
            return returnTypePanel;
        }
        return null;
    }

    private static void resizeReturnCombo(JComponent component, PsiType selectedType) {
        if (selectedType != null) {
            String presentableText = selectedType.getPresentableText();
            int presentableTextWidth = component.getFontMetrics(component.getFont()).stringWidth(presentableText);
            ((ComboBox)component).setMinimumAndPreferredWidth(presentableTextWidth);
        }
    }

    protected PsiExpression[] findOccurrences() {
        return PsiExpression.EMPTY_ARRAY;
    }

    protected JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new FlowLayout(0, 0, 5));
        if (this.myStaticFlag || this.myCanBeStatic) {
            this.myMakeStatic.setEnabled(!this.myStaticFlag);
            this.myMakeStatic.setSelected(this.myStaticFlag);
            if (this.myVariableData.hasInstanceFields()) {
                this.myMakeStatic.setText(RefactoringBundle.message((String)"declare.static.pass.fields.checkbox"));
            }
            this.myMakeStatic.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (ExtractMethodDialog.this.myVariableData.hasInstanceFields()) {
                        ExtractMethodDialog.this.myVariableData.setPassFields(ExtractMethodDialog.this.myMakeStatic.isSelected());
                        ExtractMethodDialog.access$502(ExtractMethodDialog.this, ExtractMethodDialog.this.myVariableData.getInputVariables().toArray(new VariableData[ExtractMethodDialog.this.myVariableData.getInputVariables().size()]));
                        ExtractMethodDialog.this.updateVarargsEnabled();
                        ExtractMethodDialog.this.createParametersPanel();
                    }
                    ExtractMethodDialog.this.updateSignature();
                }
            });
            optionsPanel.add(this.myMakeStatic);
        } else {
            this.myMakeStatic.setSelected(false);
            this.myMakeStatic.setEnabled(false);
        }
        Border emptyBorder = IdeBorderFactory.createEmptyBorder((int)5, (int)0, (int)5, (int)4);
        this.myMakeStatic.setBorder(emptyBorder);
        this.myFoldParameters.setSelected(this.myVariableData.isFoldingSelectedByDefault());
        this.myFoldParameters.setVisible(this.myVariableData.isFoldable());
        this.myVariableData.setFoldingAvailable(this.myFoldParameters.isSelected());
        this.myInputVariables = this.myVariableData.getInputVariables().toArray(new VariableData[this.myVariableData.getInputVariables().size()]);
        this.myFoldParameters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractMethodDialog.this.myVariableData.setFoldingAvailable(ExtractMethodDialog.this.myFoldParameters.isSelected());
                ExtractMethodDialog.access$502(ExtractMethodDialog.this, ExtractMethodDialog.this.myVariableData.getInputVariables().toArray(new VariableData[ExtractMethodDialog.this.myVariableData.getInputVariables().size()]));
                ExtractMethodDialog.this.updateVarargsEnabled();
                ExtractMethodDialog.this.createParametersPanel();
                ExtractMethodDialog.this.updateSignature();
            }
        });
        optionsPanel.add(this.myFoldParameters);
        this.myFoldParameters.setBorder(emptyBorder);
        boolean canBeVarargs = false;
        for (VariableData data : this.myInputVariables) {
            canBeVarargs |= data.type instanceof PsiArrayType;
        }
        if (this.myVariableData.isFoldable()) {
            canBeVarargs |= this.myVariableData.isFoldingSelectedByDefault();
        }
        if (canBeVarargs) {
            this.myMakeVarargs = new NonFocusableCheckBox(RefactoringBundle.message((String)"declare.varargs.checkbox"));
            this.myMakeVarargs.setBorder(emptyBorder);
            this.updateVarargsEnabled();
            this.myMakeVarargs.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ExtractMethodDialog.this.updateSignature();
                }
            });
            this.myMakeVarargs.setSelected(false);
            optionsPanel.add(this.myMakeVarargs);
        }
        if (this.myNullness != null && this.myNullness != Nullness.UNKNOWN) {
            boolean isSelected = PropertiesComponent.getInstance((Project)this.myProject).getBoolean(EXTRACT_METHOD_GENERATE_ANNOTATIONS, true);
            this.myGenerateAnnotations = new JCheckBox(RefactoringBundle.message((String)"declare.generated.annotations"), isSelected);
            this.myGenerateAnnotations.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ExtractMethodDialog.this.updateSignature();
                }
            });
            optionsPanel.add(this.myGenerateAnnotations);
        }
        if (this.myCbChainedConstructor != null) {
            optionsPanel.add(this.myCbChainedConstructor);
            this.myCbChainedConstructor.setBorder(emptyBorder);
            this.myCbChainedConstructor.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (ExtractMethodDialog.this.myDefaultVisibility) {
                        ExtractMethodDialog.this.myChangingVisibility = true;
                        try {
                            if (ExtractMethodDialog.this.isChainedConstructor()) {
                                ExtractMethodDialog.this.myVisibilityPanel.setVisibility(VisibilityUtil.getVisibilityModifier((PsiModifierList)ExtractMethodDialog.this.myTargetClass.getModifierList()));
                            } else {
                                ExtractMethodDialog.this.myVisibilityPanel.setVisibility("private");
                            }
                        }
                        finally {
                            ExtractMethodDialog.this.myChangingVisibility = false;
                        }
                    }
                    ExtractMethodDialog.this.update();
                }
            });
        }
        return optionsPanel;
    }

    private ComboBoxVisibilityPanel<String> createVisibilityPanel() {
        JavaComboBoxVisibilityPanel panel = new JavaComboBoxVisibilityPanel();
        PsiMethod containingMethod = this.getContainingMethod();
        panel.setVisibility(containingMethod != null && containingMethod.hasModifierProperty("public") ? PropertiesComponent.getInstance((Project)this.myProject).getValue(EXTRACT_METHOD_DEFAULT_VISIBILITY, "private") : "private");
        panel.addListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExtractMethodDialog.this.updateSignature();
                if (!ExtractMethodDialog.this.myChangingVisibility) {
                    ExtractMethodDialog.this.myDefaultVisibility = false;
                }
            }
        });
        return panel;
    }

    private PsiMethod getContainingMethod() {
        return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.findCommonParent((PsiElement[])this.myElementsToExtract), PsiMethod.class);
    }

    private void updateVarargsEnabled() {
        if (this.myMakeVarargs != null) {
            this.myMakeVarargs.setEnabled(this.myInputVariables[this.myInputVariables.length - 1].type instanceof PsiArrayType);
        }
    }

    private void update() {
        this.myNameField.setEnabled(!this.isChainedConstructor());
        if (this.myMakeStatic != null) {
            this.myMakeStatic.setEnabled(!this.myStaticFlag && this.myCanBeStatic && !this.isChainedConstructor());
        }
        this.updateSignature();
        this.setOKActionEnabled(PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(this.myNameField.getEnteredName()) || this.isChainedConstructor());
    }

    @Override
    public String getVisibility() {
        return this.myTargetClass.isInterface() ? "public" : this.myVisibilityPanel.getVisibility();
    }

    protected JComponent createCenterPanel() {
        this.myCenterPanel = new JPanel(new BorderLayout());
        this.createParametersPanel();
        Splitter splitter = new Splitter(true);
        splitter.setShowDividerIcon(false);
        splitter.setFirstComponent((JComponent)this.myCenterPanel);
        splitter.setSecondComponent(this.createSignaturePanel());
        return splitter;
    }

    protected boolean isOutputVariable(PsiVariable var) {
        return false;
    }

    protected void createParametersPanel() {
        if (this.myParamTable != null) {
            this.myCenterPanel.remove(this.myParamTable);
        }
        this.myParamTable = this.createParameterTableComponent();
        this.myParamTable.setMinimumSize((Dimension)JBUI.size((int)500, (int)100));
        this.myCenterPanel.add((Component)this.myParamTable, "Center");
        final JTable table = (JTable)UIUtil.findComponentOfType((JComponent)this.myParamTable, JTable.class);
        this.myCenterPanel.add((Component)SeparatorFactory.createSeparator((String)"&Parameters", (JComponent)table), "North");
        if (table != null) {
            table.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (table.getRowCount() > 0) {
                        int col = table.getSelectedColumn();
                        int row = table.getSelectedRow();
                        if (col == -1 || row == -1) {
                            table.getSelectionModel().setSelectionInterval(0, 0);
                            table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
                        }
                    }
                }
            });
        }
    }

    protected ParameterTablePanel createParameterTableComponent() {
        return new ParameterTablePanel(this.myProject, this.myInputVariables, this.myElementsToExtract){

            @Override
            protected void updateSignature() {
                ExtractMethodDialog.this.updateVarargsEnabled();
                ExtractMethodDialog.this.updateSignature();
            }

            @Override
            protected void doEnterAction() {
                ExtractMethodDialog.this.clickDefaultButton();
            }

            @Override
            protected void doCancelAction() {
                ExtractMethodDialog.this.doCancelAction();
            }

            @Override
            protected boolean areTypesDirected() {
                return ExtractMethodDialog.this.areTypesDirected();
            }

            @Override
            protected boolean isUsedAfter(PsiVariable variable) {
                return ExtractMethodDialog.this.isOutputVariable(variable);
            }
        };
    }

    protected JComponent createSignaturePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)SeparatorFactory.createSeparator((String)RefactoringBundle.message((String)"signature.preview.border.title"), null), "North");
        panel.add((Component)((Object)this.mySignature), "Center");
        this.updateSignature();
        return panel;
    }

    protected void updateSignature() {
        if (this.mySignature != null) {
            this.mySignature.setSignature(this.getSignature());
        }
    }

    protected String getSignature() {
        String typeParamsText;
        StringBuilder buffer = new StringBuilder();
        if (this.myGenerateAnnotations != null && this.myGenerateAnnotations.isSelected()) {
            NullableNotNullManager nullManager = NullableNotNullManager.getInstance((Project)this.myProject);
            buffer.append("@");
            buffer.append(StringUtil.getShortName((String)(this.myNullness == Nullness.NULLABLE ? nullManager.getDefaultNullable() : nullManager.getDefaultNotNull())));
            buffer.append("\n");
        }
        String visibilityString = VisibilityUtil.getVisibilityString((String)this.getVisibility());
        buffer.append(visibilityString);
        if (buffer.length() > 0) {
            buffer.append(" ");
        }
        if (this.isMakeStatic() && !this.isChainedConstructor()) {
            buffer.append("static ");
        }
        if (this.myTypeParameterList != null && !(typeParamsText = this.myTypeParameterList.getText()).isEmpty()) {
            buffer.append(typeParamsText);
            buffer.append(" ");
        }
        if (this.isChainedConstructor()) {
            buffer.append(this.myTargetClass.getName());
        } else {
            buffer.append(PsiFormatUtil.formatType((PsiType)(this.mySelector != null ? this.mySelector.getSelectedType() : this.myReturnType), (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
            buffer.append(" ");
            buffer.append(this.myNameField.getEnteredName());
        }
        buffer.append("(");
        String INDENT = StringUtil.repeatSymbol((char)' ', (int)buffer.length());
        VariableData[] datas = this.myInputVariables;
        int count = 0;
        for (int i = 0; i < datas.length; ++i) {
            VariableData data = datas[i];
            if (!data.passAsParameter) continue;
            PsiType type = data.type;
            if (i == datas.length - 1 && type instanceof PsiArrayType && this.myMakeVarargs != null && this.myMakeVarargs.isSelected()) {
                type = new PsiEllipsisType(((PsiArrayType)type).getComponentType());
            }
            String typeText = type.getPresentableText();
            if (count > 0) {
                buffer.append(",\n");
                buffer.append(INDENT);
            }
            buffer.append(typeText);
            buffer.append(" ");
            buffer.append(data.name);
            ++count;
        }
        buffer.append(")");
        if (this.myExceptions.length > 0) {
            buffer.append("\n");
            buffer.append("throws\n");
            for (PsiType exception : this.myExceptions) {
                buffer.append(INDENT);
                buffer.append(PsiFormatUtil.formatType((PsiType)exception, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    protected String getDimensionServiceKey() {
        return "extract.method.dialog";
    }

    protected void checkMethodConflicts(MultiMap<PsiElement, String> conflicts) {
        PsiMethod prototype;
        try {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
            prototype = factory.createMethod(this.myNameField.getEnteredName().trim(), this.myReturnType);
            if (this.myTypeParameterList != null) {
                prototype.getTypeParameterList().replace((PsiElement)this.myTypeParameterList);
            }
            for (VariableData data : this.myInputVariables) {
                if (!data.passAsParameter) continue;
                prototype.getParameterList().add((PsiElement)factory.createParameter(data.name, data.type));
            }
            PsiUtil.setModifierProperty((PsiModifierListOwner)prototype, (String)"private", (boolean)true);
        }
        catch (IncorrectOperationException e) {
            return;
        }
        ConflictsUtil.checkMethodConflicts(this.myTargetClass, null, prototype, conflicts);
    }

    @Override
    public PsiType getReturnType() {
        return this.mySelector != null ? this.mySelector.getSelectedType() : this.myReturnType;
    }

    static /* synthetic */ VariableData[] access$502(ExtractMethodDialog x0, VariableData[] x1) {
        x0.myInputVariables = x1;
        return x1;
    }
}

