/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AnonymousTargetClassPreselectionUtil;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.impl.AddNullableNotNullAnnotationFix;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.source.codeStyle.JavaCodeStyleManagerImpl;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.ControlFlowWrapper;
import com.intellij.refactoring.extractMethod.ExtractMethodDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodSignatureSuggester;
import com.intellij.refactoring.extractMethod.ExtractMethodUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectHandler;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.classMembers.ElementNeedsThis;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MatchProvider;
import com.intellij.refactoring.util.duplicates.MatchUtil;
import com.intellij.refactoring.util.duplicates.VariableReturnValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractMethodProcessor
implements MatchProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.extractMethod.ExtractMethodProcessor");
    protected final Project myProject;
    private final Editor myEditor;
    protected final PsiElement[] myElements;
    private final PsiBlockStatement myEnclosingBlockStatement;
    private final PsiType myForcedReturnType;
    private final String myRefactoringName;
    protected final String myInitialMethodName;
    private final String myHelpId;
    private final PsiManager myManager;
    private final PsiElementFactory myElementFactory;
    private final CodeStyleManager myStyleManager;
    private PsiExpression myExpression;
    private PsiElement myCodeFragmentMember;
    protected String myMethodName;
    protected PsiType myReturnType;
    protected PsiTypeParameterList myTypeParameterList;
    private VariableData[] myVariableDatum;
    protected PsiClassType[] myThrownExceptions;
    protected boolean myStatic;
    protected PsiClass myTargetClass;
    private PsiElement myAnchor;
    protected ControlFlowWrapper myControlFlowWrapper;
    protected InputVariables myInputVariables;
    protected PsiVariable[] myOutputVariables;
    protected PsiVariable myOutputVariable;
    private PsiVariable myArtificialOutputVariable;
    private Collection<PsiStatement> myExitStatements;
    private boolean myHasReturnStatement;
    private boolean myHasReturnStatementOutput;
    protected boolean myHasExpressionOutput;
    private boolean myNeedChangeContext;
    private boolean myShowErrorDialogs = true;
    protected boolean myCanBeStatic;
    protected boolean myCanBeChainedConstructor;
    protected boolean myIsChainedConstructor;
    private List<Match> myDuplicates;
    @PsiModifier.ModifierConstant
    private String myMethodVisibility = "private";
    protected boolean myGenerateConditionalExit;
    protected PsiStatement myFirstExitStatementCopy;
    private PsiMethod myExtractedMethod;
    private PsiMethodCallExpression myMethodCall;
    protected boolean myNullConditionalCheck = false;
    protected boolean myNotNullConditionalCheck = false;
    private Nullness myNullness;

    public ExtractMethodProcessor(Project project, Editor editor, PsiElement[] elements, PsiType forcedReturnType, String refactoringName, String initialMethodName, String helpId) {
        this.myProject = project;
        this.myEditor = editor;
        if (elements.length != 1 || !(elements[0] instanceof PsiBlockStatement)) {
            PsiElement[] psiElementArray;
            if (elements.length == 1 && elements[0] instanceof PsiParenthesizedExpression) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)elements[0]));
            } else {
                psiElementArray = elements;
            }
            this.myElements = psiElementArray;
            this.myEnclosingBlockStatement = null;
        } else {
            this.myEnclosingBlockStatement = (PsiBlockStatement)elements[0];
            PsiElement[] codeBlockChildren = this.myEnclosingBlockStatement.getCodeBlock().getChildren();
            this.myElements = ExtractMethodProcessor.processCodeBlockChildren(codeBlockChildren);
        }
        this.myForcedReturnType = forcedReturnType;
        this.myRefactoringName = refactoringName;
        this.myInitialMethodName = initialMethodName;
        this.myHelpId = helpId;
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.myElementFactory = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory();
        this.myStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
    }

    private static PsiElement[] processCodeBlockChildren(PsiElement[] codeBlockChildren) {
        PsiElement last;
        int resultLast = codeBlockChildren.length;
        if (codeBlockChildren.length == 0) {
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement first = codeBlockChildren[0];
        int resultStart = 0;
        if (first instanceof PsiJavaToken && ((PsiJavaToken)first).getTokenType() == JavaTokenType.LBRACE) {
            ++resultStart;
        }
        if ((last = codeBlockChildren[codeBlockChildren.length - 1]) instanceof PsiJavaToken && ((PsiJavaToken)last).getTokenType() == JavaTokenType.RBRACE) {
            --resultLast;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (int i = resultStart; i < resultLast; ++i) {
            PsiElement element = codeBlockChildren[i];
            if (element instanceof PsiWhiteSpace) continue;
            result2.add(element);
        }
        return PsiUtilCore.toPsiElementArray(result2);
    }

    public void setShowErrorDialogs(boolean showErrorDialogs) {
        this.myShowErrorDialogs = showErrorDialogs;
    }

    public void setChainedConstructor(boolean isChainedConstructor) {
        this.myIsChainedConstructor = isChainedConstructor;
    }

    public boolean prepare() throws PrepareFailedException {
        return this.prepare(null);
    }

    public boolean prepare(@Nullable Pass<ExtractMethodProcessor> pass) throws PrepareFailedException {
        PsiElement codeFragment;
        block9: {
            this.myExpression = null;
            if (this.myElements.length == 1 && this.myElements[0] instanceof PsiExpression) {
                PsiExpression expression = (PsiExpression)this.myElements[0];
                if (expression instanceof PsiAssignmentExpression && expression.getParent() instanceof PsiExpressionStatement) {
                    this.myElements[0] = expression.getParent();
                } else {
                    this.myExpression = expression;
                }
            }
            codeFragment = ControlFlowUtil.findCodeFragment(this.myElements[0]);
            this.myCodeFragmentMember = (PsiElement)codeFragment.getUserData(ElementToWorkOn.PARENT);
            if (this.myCodeFragmentMember == null) {
                this.myCodeFragmentMember = codeFragment.getParent();
            }
            if (this.myCodeFragmentMember == null) {
                this.myCodeFragmentMember = ControlFlowUtil.findCodeFragment(codeFragment.getContext()).getParent();
            }
            this.myControlFlowWrapper = new ControlFlowWrapper(this.myProject, codeFragment, this.myElements);
            try {
                this.myExitStatements = this.myControlFlowWrapper.prepareExitStatements(this.myElements);
                if (this.myControlFlowWrapper.isGenerateConditionalExit()) {
                    this.myGenerateConditionalExit = true;
                } else {
                    this.myHasReturnStatement = this.myExpression == null && this.myControlFlowWrapper.isReturnPresentBetween();
                }
                this.myFirstExitStatementCopy = this.myControlFlowWrapper.getFirstExitStatementCopy();
            }
            catch (ControlFlowWrapper.ExitStatementsNotSameException e) {
                this.myExitStatements = this.myControlFlowWrapper.getExitStatements();
                this.myNotNullConditionalCheck = this.areAllExitPointsAreNotNull(this.getExpectedReturnType());
                if (this.myNotNullConditionalCheck) break block9;
                this.showMultipleExitPointsMessage();
                return false;
            }
        }
        this.myOutputVariables = this.myControlFlowWrapper.getOutputVariables();
        return this.chooseTargetClass(codeFragment, pass);
    }

    private boolean checkExitPoints() throws PrepareFailedException {
        PsiPrimitiveType expressionType = null;
        if (this.myExpression != null) {
            if (this.myForcedReturnType != null) {
                expressionType = this.myForcedReturnType;
            } else {
                expressionType = RefactoringUtil.getTypeByExpressionWithExpectedType(this.myExpression);
                if (expressionType == null && !(this.myExpression.getParent() instanceof PsiExpressionStatement)) {
                    expressionType = PsiType.getJavaLangObject((PsiManager)this.myExpression.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
                }
            }
        }
        if (expressionType == null) {
            expressionType = PsiType.VOID;
        }
        this.myHasExpressionOutput = !PsiType.VOID.equals((Object)expressionType);
        PsiType returnStatementType = this.getExpectedReturnType();
        boolean bl = this.myHasReturnStatementOutput = this.myHasReturnStatement && returnStatementType != null && !PsiType.VOID.equals((Object)returnStatementType);
        if (this.myGenerateConditionalExit && this.myOutputVariables.length == 1) {
            if (!(this.myOutputVariables[0].getType() instanceof PsiPrimitiveType)) {
                this.myNullConditionalCheck = true;
                for (PsiStatement exitStatement : this.myExitStatements) {
                    if (!(exitStatement instanceof PsiReturnStatement)) continue;
                    PsiExpression returnValue = ((PsiReturnStatement)exitStatement).getReturnValue();
                    this.myNullConditionalCheck &= returnValue == null || this.isNullInferred(returnValue.getText(), true);
                }
                this.myNullConditionalCheck &= this.isNullInferred(this.myOutputVariables[0].getName(), false);
            }
            this.myNotNullConditionalCheck = this.areAllExitPointsAreNotNull(returnStatementType);
        }
        if (!this.myHasReturnStatementOutput && this.checkOutputVariablesCount() && !this.myNullConditionalCheck && !this.myNotNullConditionalCheck) {
            this.showMultipleOutputMessage((PsiType)expressionType);
            return false;
        }
        PsiVariable psiVariable = this.myOutputVariable = this.myOutputVariables.length > 0 ? this.myOutputVariables[0] : null;
        this.myReturnType = this.myNotNullConditionalCheck ? (returnStatementType instanceof PsiPrimitiveType ? ((PsiPrimitiveType)returnStatementType).getBoxedType(this.myCodeFragmentMember) : returnStatementType) : (this.myHasReturnStatementOutput ? returnStatementType : (this.myOutputVariable != null ? this.myOutputVariable.getType() : (this.myGenerateConditionalExit ? PsiType.BOOLEAN : expressionType)));
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)this.myElements[0], (Class[])new Class[]{PsiClass.class, PsiMethod.class});
        while (container instanceof PsiMethod && ((PsiMethod)container).getContainingClass() != this.myTargetClass) {
            container = PsiTreeUtil.getParentOfType((PsiElement)container, PsiMethod.class, (boolean)true);
        }
        if (container instanceof PsiMethod) {
            PsiElement[] elements = this.myElements;
            if (this.myExpression == null) {
                if (this.myOutputVariable != null) {
                    elements = (PsiElement[])ArrayUtil.append((Object[])this.myElements, (Object)this.myOutputVariable, PsiElement.class);
                }
                if (this.myCodeFragmentMember instanceof PsiMethod && this.myReturnType == ((PsiMethod)this.myCodeFragmentMember).getReturnType()) {
                    elements = (PsiElement[])ArrayUtil.append((Object[])this.myElements, (Object)((PsiMethod)this.myCodeFragmentMember).getReturnTypeElement(), PsiElement.class);
                }
            }
            this.myTypeParameterList = RefactoringUtil.createTypeParameterListWithUsedTypeParameters(((PsiMethod)container).getTypeParameterList(), elements);
        }
        List<PsiClassType> exceptions = ExceptionUtil.getThrownCheckedExceptions(this.myElements);
        this.myThrownExceptions = exceptions.toArray(new PsiClassType[exceptions.size()]);
        if (container instanceof PsiMethod) {
            this.checkLocalClasses((PsiMethod)container);
        }
        return true;
    }

    private PsiType getExpectedReturnType() {
        return this.myCodeFragmentMember instanceof PsiMethod ? ((PsiMethod)this.myCodeFragmentMember).getReturnType() : (this.myCodeFragmentMember instanceof PsiLambdaExpression ? LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)this.myCodeFragmentMember)) : null);
    }

    @Nullable
    private PsiVariable getArtificialOutputVariable() {
        if (this.myOutputVariables.length == 0 && this.myExitStatements.isEmpty()) {
            if (this.myCanBeChainedConstructor) {
                final HashSet fields = new HashSet();
                for (PsiElement element : this.myElements) {
                    element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitReferenceExpression(PsiReferenceExpression expression) {
                            super.visitReferenceExpression(expression);
                            PsiElement resolve = expression.resolve();
                            if (resolve instanceof PsiField && ((PsiField)resolve).hasModifierProperty("final") && PsiUtil.isAccessedForWriting((PsiExpression)expression)) {
                                fields.add((PsiField)resolve);
                            }
                        }
                    });
                }
                if (!fields.isEmpty()) {
                    return fields.size() == 1 ? (PsiField)fields.iterator().next() : null;
                }
            }
            VariablesProcessor processor2 = new VariablesProcessor(true){

                @Override
                protected boolean check(PsiVariable var, ResolveState state) {
                    return ExtractMethodProcessor.this.isDeclaredInside(var);
                }
            };
            PsiScopesUtil.treeWalkUp(processor2, this.myElements[this.myElements.length - 1], this.myCodeFragmentMember);
            if (processor2.size() == 1) {
                return processor2.getResult(0);
            }
        }
        return null;
    }

    private boolean areAllExitPointsAreNotNull(PsiType returnStatementType) {
        if (this.insertNotNullCheckIfPossible() && this.myControlFlowWrapper.getOutputVariables(false).length == 0) {
            boolean isNotNull = returnStatementType != null && !PsiType.VOID.equals((Object)returnStatementType);
            for (PsiStatement statement : this.myExitStatements) {
                if (!(statement instanceof PsiReturnStatement)) continue;
                PsiExpression returnValue = ((PsiReturnStatement)statement).getReturnValue();
                isNotNull &= returnValue != null && !this.isNullInferred(returnValue.getText(), true);
            }
            return isNotNull;
        }
        return false;
    }

    protected boolean insertNotNullCheckIfPossible() {
        return true;
    }

    private boolean isNullInferred(String exprText, boolean trueSet) {
        PsiCodeBlock block = this.myElementFactory.createCodeBlockFromText("{}", this.myElements[0]);
        for (PsiElement element : this.myElements) {
            block.add(element);
        }
        PsiIfStatement statementFromText = (PsiIfStatement)this.myElementFactory.createStatementFromText("if (" + exprText + " == null);", null);
        block.add((PsiElement)statementFromText);
        StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner();
        StandardInstructionVisitor visitor = new StandardInstructionVisitor();
        RunnerResult rc = dfaRunner.analyzeMethod((PsiElement)block, visitor);
        if (rc == RunnerResult.OK) {
            Pair<Set<Instruction>, Set<Instruction>> expressions = dfaRunner.getConstConditionalExpressions();
            Set set = trueSet ? (Set)expressions.getFirst() : (Set)expressions.getSecond();
            for (Instruction instruction : set) {
                if (!(instruction instanceof BranchingInstruction) || !((BranchingInstruction)instruction).getPsiAnchor().getText().equals(statementFromText.getCondition().getText())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkOutputVariablesCount() {
        int outputCount = (this.myHasExpressionOutput ? 1 : 0) + (this.myGenerateConditionalExit ? 1 : 0) + this.myOutputVariables.length;
        return outputCount > 1;
    }

    private void checkCanBeChainedConstructor() {
        if (!(this.myCodeFragmentMember instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)this.myCodeFragmentMember;
        if (!method.isConstructor() || !PsiType.VOID.equals((Object)this.myReturnType)) {
            return;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return;
        }
        PsiStatement[] psiStatements = body.getStatements();
        if (psiStatements.length > 0 && this.myElements[0] == psiStatements[0]) {
            this.myCanBeChainedConstructor = true;
        }
    }

    private void checkLocalClasses(PsiMethod container) throws PrepareFailedException {
        final ArrayList localClasses = new ArrayList();
        container.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(PsiClass aClass) {
                localClasses.add(aClass);
            }

            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                this.visitElement((PsiElement)aClass);
            }

            public void visitTypeParameter(PsiTypeParameter classParameter) {
                this.visitElement((PsiElement)classParameter);
            }
        });
        for (PsiClass localClass : localClasses) {
            final boolean classExtracted = this.isExtractedElement((PsiElement)localClass);
            final List extractedReferences = Collections.synchronizedList(new ArrayList());
            final List remainingReferences = Collections.synchronizedList(new ArrayList());
            ReferencesSearch.search((PsiElement)localClass).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference psiReference) {
                    PsiElement element = psiReference.getElement();
                    boolean elementExtracted = ExtractMethodProcessor.this.isExtractedElement(element);
                    if (elementExtracted && !classExtracted) {
                        extractedReferences.add(element);
                        return false;
                    }
                    if (!elementExtracted && classExtracted) {
                        remainingReferences.add(element);
                        return false;
                    }
                    return true;
                }
            });
            if (!extractedReferences.isEmpty()) {
                throw new PrepareFailedException("Cannot extract method because the selected code fragment uses local classes defined outside of the fragment", (PsiElement)extractedReferences.get(0));
            }
            if (!remainingReferences.isEmpty()) {
                throw new PrepareFailedException("Cannot extract method because the selected code fragment defines local classes used outside of the fragment", (PsiElement)remainingReferences.get(0));
            }
            if (!classExtracted) continue;
            for (PsiVariable variable : this.myControlFlowWrapper.getUsedVariables()) {
                if (!this.isDeclaredInside(variable) || variable.equals(this.myOutputVariable) || PsiUtil.resolveClassInType((PsiType)variable.getType()) != localClass) continue;
                throw new PrepareFailedException("Cannot extract method because the selected code fragment defines variable of local class type used outside of the fragment", (PsiElement)variable);
            }
        }
    }

    private boolean isExtractedElement(PsiElement element) {
        boolean isExtracted = false;
        for (PsiElement psiElement : this.myElements) {
            if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)element, (boolean)false)) continue;
            isExtracted = true;
            break;
        }
        return isExtracted;
    }

    private boolean shouldBeStatic() {
        for (PsiElement element : this.myElements) {
            PsiExpressionStatement statement = (PsiExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpressionStatement.class);
            if (statement == null || !JavaHighlightUtil.isSuperOrThisCall((PsiStatement)statement, true, true)) continue;
            return true;
        }
        PsiElement codeFragmentMember = this.myCodeFragmentMember;
        while (codeFragmentMember != null && PsiTreeUtil.isAncestor((PsiElement)this.myTargetClass, (PsiElement)codeFragmentMember, (boolean)true)) {
            if (codeFragmentMember instanceof PsiModifierListOwner && ((PsiModifierListOwner)codeFragmentMember).hasModifierProperty("static")) {
                return true;
            }
            codeFragmentMember = PsiTreeUtil.getParentOfType((PsiElement)codeFragmentMember, PsiModifierListOwner.class, (boolean)true);
        }
        return false;
    }

    public boolean showDialog(boolean direct) {
        AbstractExtractDialog dialog = this.createExtractMethodDialog(direct);
        dialog.show();
        if (!dialog.isOK()) {
            return false;
        }
        this.apply(dialog);
        return true;
    }

    protected void apply(AbstractExtractDialog dialog) {
        this.myMethodName = dialog.getChosenMethodName();
        this.myVariableDatum = dialog.getChosenParameters();
        this.myStatic = this.isStatic() | dialog.isMakeStatic();
        this.myIsChainedConstructor = dialog.isChainedConstructor();
        this.myMethodVisibility = dialog.getVisibility();
        PsiType returnType = dialog.getReturnType();
        if (returnType != null) {
            this.myReturnType = returnType;
        }
    }

    protected AbstractExtractDialog createExtractMethodDialog(final boolean direct) {
        List<VariableData> variables = this.myInputVariables.getInputVariables();
        this.myVariableDatum = variables.toArray(new VariableData[variables.size()]);
        this.myNullness = this.initNullness();
        this.myArtificialOutputVariable = PsiType.VOID.equals((Object)this.myReturnType) ? this.getArtificialOutputVariable() : null;
        PsiType returnType = this.myArtificialOutputVariable != null ? this.myArtificialOutputVariable.getType() : this.myReturnType;
        return new ExtractMethodDialog(this.myProject, this.myTargetClass, this.myInputVariables, returnType, this.getTypeParameterList(), (PsiType[])this.getThrownExceptions(), this.isStatic(), this.isCanBeStatic(), this.myCanBeChainedConstructor, this.myRefactoringName, this.myHelpId, this.myNullness, this.myElements){

            @Override
            protected boolean areTypesDirected() {
                return direct;
            }

            @Override
            protected String[] suggestMethodNames() {
                return ExtractMethodProcessor.this.suggestInitialMethodName();
            }

            @Override
            protected PsiExpression[] findOccurrences() {
                return ExtractMethodProcessor.this.findOccurrences();
            }

            @Override
            protected boolean isOutputVariable(PsiVariable var) {
                return ExtractMethodProcessor.this.isOutputVariable(var);
            }

            @Override
            protected boolean isVoidReturn() {
                return ExtractMethodProcessor.this.myArtificialOutputVariable != null && !(ExtractMethodProcessor.this.myArtificialOutputVariable instanceof PsiField);
            }

            @Override
            protected void checkMethodConflicts(MultiMap<PsiElement, String> conflicts) {
                super.checkMethodConflicts(conflicts);
                VariableData[] parameters = this.getChosenParameters();
                final HashMap vars = new HashMap();
                for (PsiElement psiElement : ExtractMethodProcessor.this.myElements) {
                    psiElement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitLocalVariable(PsiLocalVariable variable) {
                            super.visitLocalVariable(variable);
                            vars.put(variable.getName(), variable);
                        }

                        public void visitClass(PsiClass aClass) {
                        }
                    });
                }
                for (VariableData variableData : parameters) {
                    String paramName = variableData.name;
                    PsiLocalVariable variable = (PsiLocalVariable)vars.get(paramName);
                    if (variable == null) continue;
                    conflicts.putValue((Object)variable, (Object)("Variable with name " + paramName + " is already defined in the selected scope"));
                }
            }
        };
    }

    public PsiExpression[] findOccurrences() {
        if (this.myExpression != null) {
            return new PsiExpression[]{this.myExpression};
        }
        if (this.myOutputVariable != null) {
            PsiElement scope = this.myOutputVariable instanceof PsiLocalVariable ? RefactoringUtil.getVariableScope((PsiLocalVariable)this.myOutputVariable) : PsiTreeUtil.findCommonParent((PsiElement[])this.myElements);
            return CodeInsightUtil.findReferenceExpressions(scope, (PsiElement)this.myOutputVariable);
        }
        List filter = ContainerUtil.filter(this.myExitStatements, (Condition)new Condition<PsiStatement>(){

            public boolean value(PsiStatement statement) {
                return statement instanceof PsiReturnStatement && ((PsiReturnStatement)statement).getReturnValue() != null;
            }
        });
        List map = ContainerUtil.map((Collection)filter, (Function)new Function<PsiStatement, PsiExpression>(){

            public PsiExpression fun(PsiStatement statement) {
                return ((PsiReturnStatement)statement).getReturnValue();
            }
        });
        return map.toArray(new PsiExpression[map.size()]);
    }

    private Nullness initNullness() {
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)this.myElements[0]) || PsiUtil.resolveClassInType((PsiType)this.myReturnType) == null) {
            return null;
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)this.myProject);
        PsiClass nullableAnnotationClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(manager.getDefaultNullable(), this.myElements[0].getResolveScope());
        if (nullableAnnotationClass != null) {
            PsiElement elementInCopy = this.myTargetClass.getContainingFile().copy().findElementAt(this.myTargetClass.getTextOffset());
            PsiClass classCopy = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)elementInCopy, PsiClass.class);
            if (classCopy == null) {
                return null;
            }
            PsiMethod emptyMethod = (PsiMethod)classCopy.addAfter((PsiElement)this.generateEmptyMethod("name"), classCopy.getLBrace());
            this.prepareMethodBody(emptyMethod, false);
            if (this.myNotNullConditionalCheck || this.myNullConditionalCheck) {
                return Nullness.NULLABLE;
            }
            return DfaUtil.inferMethodNullity(emptyMethod);
        }
        return null;
    }

    protected String[] suggestInitialMethodName() {
        if (StringUtil.isEmpty((String)this.myInitialMethodName)) {
            LinkedHashSet<String> initialMethodNames = new LinkedHashSet<String>();
            JavaCodeStyleManagerImpl codeStyleManager = (JavaCodeStyleManagerImpl)JavaCodeStyleManager.getInstance((Project)this.myProject);
            if (this.myExpression != null || !(this.myReturnType instanceof PsiPrimitiveType)) {
                String[] names;
                for (String name : names = codeStyleManager.suggestVariableName((VariableKind)VariableKind.FIELD, null, (PsiExpression)this.myExpression, (PsiType)this.myReturnType).names) {
                    initialMethodNames.add(codeStyleManager.variableNameToPropertyName(name, VariableKind.FIELD));
                }
            }
            if (this.myOutputVariable != null) {
                VariableKind outKind = codeStyleManager.getVariableKind(this.myOutputVariable);
                SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.FIELD, codeStyleManager.variableNameToPropertyName(this.myOutputVariable.getName(), outKind), null, this.myOutputVariable.getType());
                for (String name : nameInfo.names) {
                    initialMethodNames.add(codeStyleManager.variableNameToPropertyName(name, VariableKind.FIELD));
                }
            }
            String nameByComment = this.getNameByComment();
            final PsiField field = JavaPsiFacade.getElementFactory((Project)this.myProject).createField("fieldNameToReplace", this.myReturnType instanceof PsiEllipsisType ? ((PsiEllipsisType)this.myReturnType).toArrayType() : this.myReturnType);
            ArrayList getters = new ArrayList(ContainerUtil.map(initialMethodNames, (Function)new Function<String, String>(){

                public String fun(String propertyName) {
                    if (!PsiNameHelper.getInstance((Project)ExtractMethodProcessor.this.myProject).isIdentifier(propertyName)) {
                        LOG.info(propertyName + "; " + ExtractMethodProcessor.this.myExpression);
                        return null;
                    }
                    field.setName(propertyName);
                    return GenerateMembersUtil.suggestGetterName(field);
                }
            }));
            ContainerUtil.addIfNotNull((Object)nameByComment, getters);
            return ArrayUtil.toStringArray(getters);
        }
        return new String[]{this.myInitialMethodName};
    }

    private String getNameByComment() {
        PsiElement prevSibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)this.myElements[0], (Class[])new Class[]{PsiWhiteSpace.class});
        if (prevSibling instanceof PsiComment && ((PsiComment)prevSibling).getTokenType() == JavaTokenType.END_OF_LINE_COMMENT) {
            String text = StringUtil.decapitalize((String)StringUtil.capitalizeWords((String)prevSibling.getText().trim().substring(2), (boolean)true)).replaceAll(" ", "");
            if (PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(text) && text.length() < 20) {
                return text;
            }
        }
        return null;
    }

    public boolean isOutputVariable(PsiVariable var) {
        return ArrayUtil.find((Object[])this.myOutputVariables, (Object)var) != -1;
    }

    public boolean showDialog() {
        return this.showDialog(true);
    }

    public void testRun() throws IncorrectOperationException {
        this.testPrepare();
        this.testNullness();
        ExtractMethodHandler.run(this.myProject, this.myEditor, this);
    }

    public void testNullness() {
        this.myNullness = this.initNullness();
    }

    public void testPrepare() {
        this.myInputVariables.setFoldingAvailable(this.myInputVariables.isFoldingSelectedByDefault());
        this.myMethodName = this.myInitialMethodName;
        this.myVariableDatum = new VariableData[this.myInputVariables.getInputVariables().size()];
        for (int i = 0; i < this.myInputVariables.getInputVariables().size(); ++i) {
            this.myVariableDatum[i] = this.myInputVariables.getInputVariables().get(i);
        }
    }

    public void testPrepare(PsiType returnType, boolean makeStatic) throws PrepareFailedException {
        if (makeStatic) {
            if (!this.isCanBeStatic()) {
                throw new PrepareFailedException("Failed to make static", this.myElements[0]);
            }
            this.myInputVariables.setPassFields(true);
            this.myStatic = true;
        }
        if (PsiType.VOID.equals((Object)this.myReturnType)) {
            this.myArtificialOutputVariable = this.getArtificialOutputVariable();
        }
        this.testPrepare();
        if (returnType != null) {
            this.myReturnType = returnType;
        }
    }

    public void doNotPassParameter(int i) {
        this.myVariableDatum[i].passAsParameter = false;
    }

    public void changeParamName(int i, String param) {
        this.myVariableDatum[i].name = param;
    }

    public void doRefactoring() throws IncorrectOperationException {
        LogicalPosition pos1;
        this.initDuplicates();
        this.chooseAnchor();
        if (this.myEditor != null) {
            int col = this.myEditor.getCaretModel().getLogicalPosition().column;
            int line = this.myEditor.getCaretModel().getLogicalPosition().line;
            pos1 = new LogicalPosition(line, col);
            LogicalPosition pos = new LogicalPosition(0, 0);
            this.myEditor.getCaretModel().moveToLogicalPosition(pos);
        } else {
            pos1 = null;
        }
        LocalSearchScope processConflictsScope = this.myMethodVisibility.equals("private") ? new LocalSearchScope((PsiElement)this.myTargetClass) : GlobalSearchScope.projectScope((Project)this.myProject);
        final HashMap overloadsResolveMap = new HashMap();
        Runnable collectOverloads = new Runnable((SearchScope)processConflictsScope, overloadsResolveMap){
            final /* synthetic */ SearchScope val$processConflictsScope;
            final /* synthetic */ Map val$overloadsResolveMap;
            {
                this.val$processConflictsScope = searchScope;
                this.val$overloadsResolveMap = map;
            }

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        Map<PsiMethodCallExpression, PsiMethod> overloads = ExtractMethodUtil.encodeOverloadTargets(ExtractMethodProcessor.this.myTargetClass, val$processConflictsScope, ExtractMethodProcessor.this.myMethodName, ExtractMethodProcessor.this.myCodeFragmentMember);
                        val$overloadsResolveMap.putAll(overloads);
                    }
                });
            }
        };
        Runnable extract = new Runnable(){

            @Override
            public void run() {
                ExtractMethodProcessor.this.doExtract();
                ExtractMethodUtil.decodeOverloadTargets(overloadsResolveMap, ExtractMethodProcessor.this.myExtractedMethod, ExtractMethodProcessor.this.myCodeFragmentMember);
            }
        };
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            collectOverloads.run();
            extract.run();
        } else {
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(collectOverloads, "Collect overloads...", true, this.myProject)) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(extract);
        }
        if (this.myEditor != null) {
            this.myEditor.getCaretModel().moveToLogicalPosition(pos1);
            int offset = this.myMethodCall.getMethodExpression().getTextRange().getStartOffset();
            this.myEditor.getCaretModel().moveToOffset(offset);
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            this.myEditor.getSelectionModel().removeSelection();
        }
    }

    @Nullable
    private DuplicatesFinder initDuplicates() {
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (PsiElement element : this.myElements) {
            if (element instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
            elements.add(element);
        }
        if (this.myExpression != null) {
            DuplicatesFinder finder = new DuplicatesFinder(PsiUtilCore.toPsiElementArray(elements), this.myInputVariables.copy(), new ArrayList());
            this.myDuplicates = finder.findDuplicates((PsiElement)this.myTargetClass);
            return finder;
        }
        if (elements.size() > 0) {
            DuplicatesFinder myDuplicatesFinder = new DuplicatesFinder(PsiUtilCore.toPsiElementArray(elements), this.myInputVariables.copy(), this.myOutputVariable != null ? new VariableReturnValue(this.myOutputVariable) : null, Arrays.asList(this.myOutputVariables));
            this.myDuplicates = myDuplicatesFinder.findDuplicates((PsiElement)this.myTargetClass);
            return myDuplicatesFinder;
        }
        this.myDuplicates = new ArrayList<Match>();
        return null;
    }

    public void doExtract() throws IncorrectOperationException {
        PsiMethod newMethod = this.generateEmptyMethod();
        this.myExpression = this.myInputVariables.replaceWrappedReferences(this.myElements, this.myExpression);
        this.renameInputVariables();
        LOG.assertTrue(this.myElements[0].isValid());
        PsiCodeBlock body = newMethod.getBody();
        this.myMethodCall = this.generateMethodCall(null, true);
        LOG.assertTrue(this.myElements[0].isValid());
        PsiStatement exitStatementCopy = this.prepareMethodBody(newMethod, true);
        if (this.myExpression == null) {
            PsiStatement statement;
            String varName;
            if (this.myNeedChangeContext && this.isNeedToChangeCallContext()) {
                for (PsiElement element : this.myElements) {
                    ChangeContextUtil.encodeContextInfo(element, false);
                }
            }
            if (this.myNullConditionalCheck) {
                varName = this.myOutputVariable.getName();
                if (this.isDeclaredInside(this.myOutputVariable)) {
                    this.declareVariableAtMethodCallLocation(varName);
                } else {
                    PsiExpressionStatement assignmentExpression = (PsiExpressionStatement)this.myElementFactory.createStatementFromText(varName + "=x;", null);
                    assignmentExpression = (PsiExpressionStatement)this.addToMethodCallLocation((PsiStatement)assignmentExpression);
                    this.myMethodCall = (PsiMethodCallExpression)((PsiAssignmentExpression)assignmentExpression.getExpression()).getRExpression().replace((PsiElement)this.myMethodCall);
                }
                this.declareNecessaryVariablesAfterCall(this.myOutputVariable);
                PsiIfStatement ifStatement = this.myHasReturnStatementOutput ? (PsiIfStatement)this.myElementFactory.createStatementFromText("if (" + varName + "==null) return null;", null) : (this.myGenerateConditionalExit ? (this.myFirstExitStatementCopy instanceof PsiReturnStatement && ((PsiReturnStatement)this.myFirstExitStatementCopy).getReturnValue() != null ? (PsiIfStatement)this.myElementFactory.createStatementFromText("if (" + varName + "==null) return null;", null) : (PsiIfStatement)this.myElementFactory.createStatementFromText("if (" + varName + "==null) " + this.myFirstExitStatementCopy.getText(), null)) : (PsiIfStatement)this.myElementFactory.createStatementFromText("if (" + varName + "==null) return;", null));
                ifStatement = (PsiIfStatement)this.addToMethodCallLocation((PsiStatement)ifStatement);
                CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)ifStatement);
            } else if (this.myNotNullConditionalCheck) {
                varName = this.myOutputVariable != null ? this.myOutputVariable.getName() : "x";
                varName = this.declareVariableAtMethodCallLocation(varName, (PsiType)(this.myReturnType instanceof PsiPrimitiveType ? ((PsiPrimitiveType)this.myReturnType).getBoxedType(this.myCodeFragmentMember) : this.myReturnType));
                this.addToMethodCallLocation(this.myElementFactory.createStatementFromText("if (" + varName + " != null) return " + varName + ";", null));
            } else if (this.myGenerateConditionalExit) {
                PsiIfStatement ifStatement = (PsiIfStatement)this.myElementFactory.createStatementFromText("if (a) b;", null);
                ifStatement = (PsiIfStatement)this.addToMethodCallLocation((PsiStatement)ifStatement);
                this.myMethodCall = (PsiMethodCallExpression)ifStatement.getCondition().replace((PsiElement)this.myMethodCall);
                this.myFirstExitStatementCopy = (PsiStatement)ifStatement.getThenBranch().replace((PsiElement)this.myFirstExitStatementCopy);
                CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)ifStatement);
            } else if (this.myOutputVariable != null || this.isArtificialOutputUsed()) {
                String name;
                boolean toDeclare = this.isArtificialOutputUsed() ? !(this.myArtificialOutputVariable instanceof PsiField) : this.isDeclaredInside(this.myOutputVariable);
                String string = name = this.isArtificialOutputUsed() ? this.myArtificialOutputVariable.getName() : this.myOutputVariable.getName();
                if (!toDeclare) {
                    PsiExpressionStatement statement2 = (PsiExpressionStatement)this.myElementFactory.createStatementFromText(name + "=x;", null);
                    statement2 = (PsiExpressionStatement)this.myStyleManager.reformat((PsiElement)statement2);
                    statement2 = (PsiExpressionStatement)this.addToMethodCallLocation((PsiStatement)statement2);
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)statement2.getExpression();
                    this.myMethodCall = (PsiMethodCallExpression)assignment.getRExpression().replace((PsiElement)this.myMethodCall);
                } else {
                    this.declareVariableAtMethodCallLocation(name);
                }
            } else if (this.myHasReturnStatementOutput) {
                statement = this.myElementFactory.createStatementFromText("return x;", null);
                statement = (PsiStatement)this.addToMethodCallLocation(statement);
                this.myMethodCall = (PsiMethodCallExpression)((PsiReturnStatement)statement).getReturnValue().replace((PsiElement)this.myMethodCall);
            } else {
                statement = this.myElementFactory.createStatementFromText("x();", null);
                statement = (PsiStatement)this.addToMethodCallLocation(statement);
                this.myMethodCall = (PsiMethodCallExpression)((PsiExpressionStatement)statement).getExpression().replace((PsiElement)this.myMethodCall);
            }
            if (this.myHasReturnStatement && !this.myHasReturnStatementOutput && !this.hasNormalExit()) {
                PsiStatement statement3 = this.myElementFactory.createStatementFromText("return;", null);
                this.addToMethodCallLocation(statement3);
            } else if (!this.myGenerateConditionalExit && exitStatementCopy != null) {
                this.addToMethodCallLocation(exitStatementCopy);
            }
            if (!this.myNullConditionalCheck && !this.myNotNullConditionalCheck) {
                this.declareNecessaryVariablesAfterCall(this.myOutputVariable);
            }
            this.deleteExtracted();
        } else {
            PsiExpression expression2Replace = this.myExpression;
            if (this.myExpression instanceof PsiAssignmentExpression) {
                expression2Replace = ((PsiAssignmentExpression)this.myExpression).getRExpression();
            } else if (this.myExpression instanceof PsiPostfixExpression || this.myExpression instanceof PsiPrefixExpression) {
                IElementType elementType;
                IElementType iElementType = elementType = this.myExpression instanceof PsiPostfixExpression ? ((PsiPostfixExpression)this.myExpression).getOperationTokenType() : ((PsiPrefixExpression)this.myExpression).getOperationTokenType();
                if (elementType == JavaTokenType.PLUSPLUS || elementType == JavaTokenType.MINUSMINUS) {
                    PsiExpression operand = this.myExpression instanceof PsiPostfixExpression ? ((PsiPostfixExpression)this.myExpression).getOperand() : ((PsiPrefixExpression)this.myExpression).getOperand();
                    expression2Replace = ((PsiBinaryExpression)this.myExpression.replace((PsiElement)this.myElementFactory.createExpressionFromText(operand.getText() + " + x", (PsiElement)operand))).getROperand();
                }
            }
            this.myExpression = (PsiExpression)IntroduceVariableBase.replace(expression2Replace, (PsiExpression)this.myMethodCall, this.myProject);
            this.myMethodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myExpression.findElementAt(this.myExpression.getText().indexOf(this.myMethodCall.getText())), PsiMethodCallExpression.class);
            this.declareNecessaryVariablesAfterCall(this.myOutputVariable);
        }
        if (this.myAnchor instanceof PsiField) {
            ((PsiField)this.myAnchor).normalizeDeclaration();
        }
        this.adjustFinalParameters(newMethod);
        int i = 0;
        for (VariableData data : this.myVariableDatum) {
            if (!data.passAsParameter) continue;
            PsiParameter psiParameter = newMethod.getParameterList().getParameters()[i++];
            PsiType paramType = psiParameter.getType();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)psiParameter, (SearchScope)new LocalSearchScope((PsiElement)body))) {
                PsiTypeCastExpression typeCastExpression;
                PsiTypeElement castType;
                PsiElement parent;
                PsiElement element = reference.getElement();
                if (element == null || !((parent = element.getParent()) instanceof PsiTypeCastExpression) || (castType = (typeCastExpression = (PsiTypeCastExpression)parent).getCastType()) == null || !Comparing.equal((Object)castType.getType(), (Object)paramType)) continue;
                RedundantCastUtil.removeCast((PsiTypeCastExpression)typeCastExpression);
            }
        }
        if (this.myNullness != null && PsiUtil.resolveClassInType((PsiType)newMethod.getReturnType()) != null && PropertiesComponent.getInstance((Project)this.myProject).getBoolean("extractMethod.generateAnnotations", true)) {
            AddNullableNotNullAnnotationFix annotationFix;
            NullableNotNullManager notNullManager = NullableNotNullManager.getInstance((Project)this.myProject);
            switch (this.myNullness) {
                case NOT_NULL: {
                    annotationFix = new AddNullableNotNullAnnotationFix(notNullManager.getDefaultNotNull(), (PsiModifierListOwner)newMethod, new String[0]);
                    break;
                }
                case NULLABLE: {
                    annotationFix = new AddNullableNotNullAnnotationFix(notNullManager.getDefaultNullable(), (PsiModifierListOwner)newMethod, new String[0]);
                    break;
                }
                default: {
                    annotationFix = null;
                }
            }
            if (annotationFix != null) {
                annotationFix.invoke(this.myProject, this.myTargetClass.getContainingFile(), (PsiElement)newMethod, (PsiElement)newMethod);
            }
        }
        this.myExtractedMethod = (PsiMethod)this.myTargetClass.addAfter((PsiElement)newMethod, this.myAnchor);
        if (this.isNeedToChangeCallContext() && this.myNeedChangeContext) {
            ChangeContextUtil.decodeContextInfo((PsiElement)this.myExtractedMethod, this.myTargetClass, (PsiExpression)RefactoringChangeUtil.createThisExpression(this.myManager, null));
            if (this.myMethodCall.resolveMethod() != this.myExtractedMethod) {
                PsiReferenceExpression methodExpression = this.myMethodCall.getMethodExpression();
                methodExpression.setQualifierExpression((PsiExpression)RefactoringChangeUtil.createThisExpression(this.myManager, this.myTargetClass));
            }
        }
    }

    @Nullable
    private PsiStatement prepareMethodBody(PsiMethod newMethod, boolean doExtract) {
        String outVariableName;
        PsiCodeBlock body = newMethod.getBody();
        if (this.myExpression != null) {
            this.declareNecessaryVariablesInsideBody(body);
            if (this.myHasExpressionOutput) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)this.myElementFactory.createStatementFromText("return x;", null);
                PsiExpression returnValue = RefactoringUtil.convertInitializerToNormalExpression(this.myExpression, this.myForcedReturnType);
                returnStatement.getReturnValue().replace((PsiElement)returnValue);
                body.add((PsiElement)returnStatement);
            } else {
                PsiExpressionStatement statement = (PsiExpressionStatement)this.myElementFactory.createStatementFromText("x;", null);
                statement.getExpression().replace((PsiElement)this.myExpression);
                body.add((PsiElement)statement);
            }
            return null;
        }
        boolean hasNormalExit = this.hasNormalExit();
        String string = outVariableName = this.myOutputVariable != null ? this.getNewVariableName(this.myOutputVariable) : null;
        PsiReturnStatement returnStatement = this.myNullConditionalCheck ? (PsiReturnStatement)this.myElementFactory.createStatementFromText("return null;", null) : (this.myOutputVariable != null ? (PsiReturnStatement)this.myElementFactory.createStatementFromText("return " + outVariableName + ";", null) : (this.myGenerateConditionalExit ? (PsiReturnStatement)this.myElementFactory.createStatementFromText("return true;", null) : (PsiReturnStatement)this.myElementFactory.createStatementFromText("return;", null)));
        PsiStatement exitStatementCopy = !doExtract || this.myNotNullConditionalCheck ? null : this.myControlFlowWrapper.getExitStatementCopy((PsiElement)returnStatement, this.myElements);
        this.declareNecessaryVariablesInsideBody(body);
        body.addRange(this.myElements[0], this.myElements[this.myElements.length - 1]);
        if (this.myNullConditionalCheck) {
            body.add((PsiElement)this.myElementFactory.createStatementFromText("return " + this.myOutputVariable.getName() + ";", null));
        } else if (this.myNotNullConditionalCheck) {
            body.add((PsiElement)this.myElementFactory.createStatementFromText("return null;", null));
        } else if (this.myGenerateConditionalExit) {
            body.add((PsiElement)this.myElementFactory.createStatementFromText("return false;", null));
        } else if (!this.myHasReturnStatement && hasNormalExit && this.myOutputVariable != null) {
            Object[] declaredElements;
            PsiStatement statement;
            PsiElement resolved;
            PsiExpression returnValue;
            PsiReturnStatement insertedReturnStatement = (PsiReturnStatement)body.add((PsiElement)returnStatement);
            if (this.myOutputVariables.length == 1 && (returnValue = insertedReturnStatement.getReturnValue()) instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)returnValue).resolve()) instanceof PsiLocalVariable && Comparing.strEqual((String)((PsiVariable)resolved).getName(), (String)outVariableName) && (statement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)insertedReturnStatement, PsiStatement.class)) instanceof PsiDeclarationStatement && ArrayUtil.find((Object[])(declaredElements = ((PsiDeclarationStatement)statement).getDeclaredElements()), (Object)resolved) != -1) {
                InlineUtil.inlineVariable((PsiVariable)resolved, ((PsiVariable)resolved).getInitializer(), (PsiJavaCodeReferenceElement)((PsiReferenceExpression)returnValue));
                resolved.delete();
            }
        } else if (this.isArtificialOutputUsed()) {
            body.add((PsiElement)this.myElementFactory.createStatementFromText("return " + this.myArtificialOutputVariable.getName() + ";", null));
        }
        return exitStatementCopy;
    }

    private boolean isArtificialOutputUsed() {
        return this.myArtificialOutputVariable != null && !PsiType.VOID.equals((Object)this.myReturnType) && !this.myIsChainedConstructor;
    }

    private boolean hasNormalExit() {
        boolean hasNormalExit = false;
        PsiElement lastElement = this.myElements[this.myElements.length - 1];
        if (!(lastElement instanceof PsiReturnStatement || lastElement instanceof PsiBreakStatement || lastElement instanceof PsiContinueStatement)) {
            hasNormalExit = true;
        }
        return hasNormalExit;
    }

    protected boolean isNeedToChangeCallContext() {
        return true;
    }

    private void declareVariableAtMethodCallLocation(String name) {
        this.declareVariableAtMethodCallLocation(name, this.myReturnType);
    }

    private String declareVariableAtMethodCallLocation(String name, PsiType type) {
        PsiElement lastStatement;
        if (this.myControlFlowWrapper.getOutputVariables(false).length == 0 && (lastStatement = PsiTreeUtil.getNextSiblingOfType((PsiElement)(this.myEnclosingBlockStatement != null ? this.myEnclosingBlockStatement : this.myElements[this.myElements.length - 1]), PsiStatement.class)) != null) {
            name = JavaCodeStyleManager.getInstance((Project)this.myProject).suggestUniqueVariableName(name, lastStatement, true);
        }
        PsiDeclarationStatement statement = this.myElementFactory.createVariableDeclarationStatement(name, type, (PsiExpression)this.myMethodCall);
        statement = (PsiDeclarationStatement)this.addToMethodCallLocation((PsiStatement)statement);
        PsiVariable var = (PsiVariable)statement.getDeclaredElements()[0];
        this.myMethodCall = (PsiMethodCallExpression)var.getInitializer();
        if (this.myOutputVariable != null) {
            var.getModifierList().replace((PsiElement)this.myOutputVariable.getModifierList());
        }
        return name;
    }

    private void adjustFinalParameters(final PsiMethod method) throws IncorrectOperationException {
        final IncorrectOperationException[] exc = new IncorrectOperationException[]{null};
        final PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length > 0) {
            if (CodeStyleSettingsManager.getSettings((Project)this.myProject).GENERATE_FINAL_PARAMETERS) {
                method.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                    public void visitReferenceExpression(PsiReferenceExpression expression) {
                        PsiParameter param;
                        int index;
                        PsiElement resolved = expression.resolve();
                        if (resolved != null && (index = ArrayUtil.find((Object[])parameters, (Object)resolved)) >= 0 && (param = parameters[index]).hasModifierProperty("final") && PsiUtil.isAccessedForWriting((PsiExpression)expression)) {
                            try {
                                PsiUtil.setModifierProperty((PsiModifierListOwner)param, (String)"final", (boolean)false);
                            }
                            catch (IncorrectOperationException e) {
                                exc[0] = e;
                            }
                        }
                        super.visitReferenceExpression(expression);
                    }
                });
            } else {
                method.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                    public void visitReferenceExpression(PsiReferenceExpression expression) {
                        PsiParameter param;
                        PsiElement resolved = expression.resolve();
                        int index = ArrayUtil.find((Object[])parameters, (Object)resolved);
                        if (index >= 0 && !(param = parameters[index]).hasModifierProperty("final") && RefactoringUtil.isInsideAnonymousOrLocal((PsiElement)expression, (PsiElement)method)) {
                            try {
                                PsiUtil.setModifierProperty((PsiModifierListOwner)param, (String)"final", (boolean)true);
                            }
                            catch (IncorrectOperationException e) {
                                exc[0] = e;
                            }
                        }
                        super.visitReferenceExpression(expression);
                    }
                });
            }
            if (exc[0] != null) {
                throw exc[0];
            }
        }
    }

    @Override
    public List<Match> getDuplicates() {
        if (this.myIsChainedConstructor) {
            return ExtractMethodProcessor.filterChainedConstructorDuplicates(this.myDuplicates);
        }
        return this.myDuplicates;
    }

    private static List<Match> filterChainedConstructorDuplicates(List<Match> duplicates) {
        ArrayList<Match> result2 = new ArrayList<Match>();
        for (Match duplicate : duplicates) {
            PsiStatement[] psiStatements;
            PsiCodeBlock body;
            PsiElement matchStart = duplicate.getMatchStart();
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)matchStart, PsiMethod.class);
            if (method == null || !method.isConstructor() || (body = method.getBody()) == null || (psiStatements = body.getStatements()).length <= 0 || matchStart != psiStatements[0]) continue;
            result2.add(duplicate);
        }
        return result2;
    }

    @Override
    public PsiElement processMatch(Match match) throws IncorrectOperationException {
        MatchUtil.changeSignature(match, this.myExtractedMethod);
        if (RefactoringUtil.isInStaticContext(match.getMatchStart(), this.myExtractedMethod.getContainingClass())) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)this.myExtractedMethod, (String)"static", (boolean)true);
        }
        PsiMethodCallExpression methodCallExpression = this.generateMethodCall(match.getInstanceExpression(), false);
        ArrayList<VariableData> datas = new ArrayList<VariableData>();
        for (VariableData variableData : this.myVariableDatum) {
            if (!variableData.passAsParameter) continue;
            datas.add(variableData);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        for (VariableData data : datas) {
            List<PsiElement> parameterValue = match.getParameterValues(data.variable);
            if (parameterValue != null) {
                for (PsiElement val : parameterValue) {
                    PsiType exprType;
                    if (val instanceof PsiExpression && (exprType = ((PsiExpression)val).getType()) != null && !TypeConversionUtil.isAssignable((PsiType)data.type, (PsiType)exprType)) {
                        PsiTypeCastExpression cast = (PsiTypeCastExpression)elementFactory.createExpressionFromText("(A)a", val);
                        cast.getCastType().replace((PsiElement)elementFactory.createTypeElement(data.type));
                        cast.getOperand().replace(val.copy());
                        val = cast;
                    }
                    methodCallExpression.getArgumentList().add(val);
                }
                continue;
            }
            methodCallExpression.getArgumentList().add((PsiElement)this.myElementFactory.createExpressionFromText(data.variable.getName(), (PsiElement)methodCallExpression));
        }
        return match.replace(this.myExtractedMethod, methodCallExpression, this.myOutputVariable);
    }

    protected void deleteExtracted() throws IncorrectOperationException {
        if (this.myEnclosingBlockStatement == null) {
            this.myElements[0].getParent().deleteChildRange(this.myElements[0], this.myElements[this.myElements.length - 1]);
        } else {
            this.myEnclosingBlockStatement.delete();
        }
    }

    protected PsiElement addToMethodCallLocation(PsiStatement statement) throws IncorrectOperationException {
        if (this.myEnclosingBlockStatement == null) {
            PsiElement containingStatement;
            PsiElement psiElement = this.myElements[0] instanceof PsiComment ? this.myElements[0] : (containingStatement = PsiTreeUtil.getParentOfType((PsiElement)(this.myExpression != null ? this.myExpression : this.myElements[0]), PsiStatement.class, (boolean)false));
            if (containingStatement == null) {
                containingStatement = PsiTreeUtil.getParentOfType((PsiElement)(this.myExpression != null ? this.myExpression : this.myElements[0]), PsiComment.class, (boolean)false);
            }
            return containingStatement.getParent().addBefore((PsiElement)statement, containingStatement);
        }
        return this.myEnclosingBlockStatement.getParent().addBefore((PsiElement)statement, (PsiElement)this.myEnclosingBlockStatement);
    }

    private void renameInputVariables() throws IncorrectOperationException {
        for (int i = this.myVariableDatum.length - 1; i >= 0; --i) {
            VariableData data = this.myVariableDatum[i];
            PsiVariable variable = data.variable;
            if (data.name.equals(variable.getName())) continue;
            for (PsiElement element : this.myElements) {
                RefactoringUtil.renameVariableReferences(variable, data.name, (SearchScope)new LocalSearchScope(element));
            }
        }
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    public PsiType getReturnType() {
        return this.myReturnType;
    }

    private PsiMethod generateEmptyMethod() throws IncorrectOperationException {
        return this.generateEmptyMethod(this.myMethodName);
    }

    public PsiMethod generateEmptyMethod(String methodName) throws IncorrectOperationException {
        PsiMethod containingMethod;
        PsiCodeBlock body;
        PsiMethod newMethod;
        if (this.myIsChainedConstructor) {
            newMethod = this.myElementFactory.createConstructor();
        } else {
            newMethod = this.myElementFactory.createMethod(methodName, this.myReturnType);
            PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)"static", (boolean)this.isStatic());
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)this.myMethodVisibility, (boolean)true);
        if (this.getTypeParameterList() != null) {
            newMethod.getTypeParameterList().replace((PsiElement)this.getTypeParameterList());
        }
        LOG.assertTrue((body = newMethod.getBody()) != null);
        boolean isFinal = CodeStyleSettingsManager.getSettings((Project)this.myProject).GENERATE_FINAL_PARAMETERS;
        PsiParameterList list = newMethod.getParameterList();
        for (VariableData data : this.myVariableDatum) {
            if (data.passAsParameter) {
                PsiParameter parm = this.myElementFactory.createParameter(data.name, data.type);
                this.copyParamAnnotations(parm);
                if (isFinal) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)parm, (String)"final", (boolean)true);
                }
                list.add((PsiElement)parm);
                continue;
            }
            StringBuilder buffer = new StringBuilder();
            if (isFinal) {
                buffer.append("final ");
            }
            buffer.append("int ");
            buffer.append(data.name);
            buffer.append("=;");
            String text = buffer.toString();
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)this.myElementFactory.createStatementFromText(text, null);
            declaration = (PsiDeclarationStatement)this.myStyleManager.reformat((PsiElement)declaration);
            PsiTypeElement typeElement = this.myElementFactory.createTypeElement(data.type);
            ((PsiVariable)declaration.getDeclaredElements()[0]).getTypeElement().replace((PsiElement)typeElement);
            body.add((PsiElement)declaration);
        }
        PsiReferenceList throwsList = newMethod.getThrowsList();
        for (PsiClassType exception : this.getThrownExceptions()) {
            throwsList.add((PsiElement)JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory().createReferenceElementByType(exception));
        }
        if (this.myTargetClass.isInterface() && PsiUtil.isLanguageLevel8OrHigher((PsiElement)this.myTargetClass) && (containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myCodeFragmentMember, PsiMethod.class, (boolean)false)) != null && containingMethod.hasModifierProperty("default")) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)"default", (boolean)true);
        }
        return (PsiMethod)this.myStyleManager.reformat((PsiElement)newMethod);
    }

    private void copyParamAnnotations(PsiParameter parm) {
        PsiModifierList modifierList;
        PsiVariable variable = PsiResolveHelper.SERVICE.getInstance((Project)this.myProject).resolveReferencedVariable(parm.getName(), this.myElements[0]);
        if (variable instanceof PsiParameter && (modifierList = variable.getModifierList()) != null) {
            for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                if (SuppressWarnings.class.getName().equals(annotation.getQualifiedName())) continue;
                PsiModifierList parmModifierList = parm.getModifierList();
                LOG.assertTrue(parmModifierList != null, (Object)parm);
                parmModifierList.add((PsiElement)annotation);
            }
        }
    }

    @NotNull
    protected PsiMethodCallExpression generateMethodCall(PsiExpression instanceQualifier, boolean generateArgs) throws IncorrectOperationException {
        boolean skipInstanceQualifier;
        StringBuilder buffer = new StringBuilder();
        if (this.myIsChainedConstructor) {
            skipInstanceQualifier = true;
            buffer.append("this");
        } else {
            boolean bl = skipInstanceQualifier = instanceQualifier == null || instanceQualifier instanceof PsiThisExpression;
            if (skipInstanceQualifier) {
                if (this.isNeedToChangeCallContext() && this.myNeedChangeContext) {
                    boolean needsThisQualifier = false;
                    PsiElement parent = this.myCodeFragmentMember;
                    while (!this.myTargetClass.equals(parent)) {
                        String methodName;
                        if (parent instanceof PsiMethod && (methodName = ((PsiMethod)parent).getName()).equals(this.myMethodName)) {
                            needsThisQualifier = true;
                            break;
                        }
                        parent = parent.getParent();
                    }
                    if (needsThisQualifier) {
                        buffer.append(this.myTargetClass.getName());
                        buffer.append(".this.");
                    }
                }
            } else {
                buffer.append("qqq.");
            }
            buffer.append(this.myMethodName);
        }
        buffer.append("(");
        if (generateArgs) {
            int count = 0;
            for (PsiElement data : this.myVariableDatum) {
                if (!data.passAsParameter) continue;
                if (count > 0) {
                    buffer.append(",");
                }
                this.myInputVariables.appendCallArguments((VariableData)data, buffer);
                ++count;
            }
        }
        buffer.append(")");
        String text = buffer.toString();
        PsiMethodCallExpression expr = (PsiMethodCallExpression)this.myElementFactory.createExpressionFromText(text, null);
        expr = (PsiMethodCallExpression)this.myStyleManager.reformat((PsiElement)expr);
        if (!skipInstanceQualifier) {
            PsiExpression qualifierExpression = expr.getMethodExpression().getQualifierExpression();
            LOG.assertTrue(qualifierExpression != null);
            qualifierExpression.replace((PsiElement)instanceQualifier);
        }
        PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)expr);
        if (psiMethodCallExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/extractMethod/ExtractMethodProcessor", "generateMethodCall"));
        }
        return psiMethodCallExpression;
    }

    private boolean chooseTargetClass(PsiElement codeFragment, final Pass<ExtractMethodProcessor> extractPass) throws PrepareFailedException {
        final List<PsiVariable> inputVariables = this.myControlFlowWrapper.getInputVariables(codeFragment, this.myElements, this.myOutputVariables);
        this.myNeedChangeContext = false;
        PsiClass psiClass = this.myTargetClass = this.myCodeFragmentMember instanceof PsiMember ? ((PsiMember)this.myCodeFragmentMember).getContainingClass() : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.myCodeFragmentMember, PsiClass.class);
        if (!ExtractMethodProcessor.shouldAcceptCurrentTarget(extractPass, (PsiElement)this.myTargetClass)) {
            final LinkedHashMap<PsiClass, ArrayList<PsiVariable>> classes = new LinkedHashMap<PsiClass, ArrayList<PsiVariable>>();
            PsiElementProcessor<PsiClass> processor2 = new PsiElementProcessor<PsiClass>(){

                public boolean execute(@NotNull PsiClass selectedClass) {
                    if (selectedClass == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedClass", "com/intellij/refactoring/extractMethod/ExtractMethodProcessor$13", "execute"));
                    }
                    AnonymousTargetClassPreselectionUtil.rememberSelection(selectedClass, ExtractMethodProcessor.this.myTargetClass);
                    List array = (List)classes.get(selectedClass);
                    ExtractMethodProcessor.this.myNeedChangeContext = ExtractMethodProcessor.this.myTargetClass != selectedClass;
                    ExtractMethodProcessor.this.myTargetClass = selectedClass;
                    if (array != null) {
                        for (PsiVariable variable : array) {
                            if (inputVariables.contains(variable)) continue;
                            inputVariables.addAll(array);
                        }
                    }
                    try {
                        return ExtractMethodProcessor.this.applyChosenClassAndExtract(inputVariables, (Pass<ExtractMethodProcessor>)extractPass);
                    }
                    catch (PrepareFailedException e) {
                        if (ExtractMethodProcessor.this.myShowErrorDialogs) {
                            CommonRefactoringUtil.showErrorHint((Project)ExtractMethodProcessor.this.myProject, (Editor)ExtractMethodProcessor.this.myEditor, (String)e.getMessage(), (String)ExtractMethodHandler.REFACTORING_NAME, (String)"refactoring.extractMethod");
                            ExtractMethodHandler.highlightPrepareError(e, e.getFile(), ExtractMethodProcessor.this.myEditor, ExtractMethodProcessor.this.myProject);
                        }
                        return false;
                    }
                }
            };
            classes.put(this.myTargetClass, null);
            PsiElement target = this.myTargetClass.getParent();
            PsiClass targetMember = this.myTargetClass;
            while (!(target instanceof PsiFile)) {
                if (target instanceof PsiClass) {
                    boolean success = true;
                    ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
                    for (PsiElement el : this.myElements) {
                        if (ControlFlowUtil.collectOuterLocals(array, el, this.myCodeFragmentMember, (PsiElement)targetMember)) continue;
                        success = false;
                        break;
                    }
                    if (success) {
                        classes.put((PsiClass)target, array);
                        if (ExtractMethodProcessor.shouldAcceptCurrentTarget(extractPass, target)) {
                            return processor2.execute((PsiElement)((PsiClass)target));
                        }
                    }
                }
                targetMember = target;
                target = target.getParent();
            }
            if (classes.size() > 1) {
                PsiClass[] psiClasses = classes.keySet().toArray(new PsiClass[classes.size()]);
                PsiClass preselection = AnonymousTargetClassPreselectionUtil.getPreselection(classes.keySet(), psiClasses[0]);
                NavigationUtil.getPsiElementPopup((PsiElement[])psiClasses, (PsiElementListCellRenderer)new PsiClassListCellRenderer(), (String)"Choose Destination Class", (PsiElementProcessor)processor2, (PsiElement)preselection).showInBestPositionFor(this.myEditor);
                return true;
            }
        }
        return this.applyChosenClassAndExtract(inputVariables, extractPass);
    }

    private void declareNecessaryVariablesInsideBody(PsiCodeBlock body) throws IncorrectOperationException {
        List<PsiVariable> usedVariables = this.myControlFlowWrapper.getUsedVariablesInBody(ControlFlowUtil.findCodeFragment(this.myElements[0]), this.myOutputVariables);
        for (PsiVariable variable : usedVariables) {
            boolean toDeclare = !this.isDeclaredInside(variable) && this.myInputVariables.toDeclareInsideBody(variable);
            if (!toDeclare) continue;
            String name = variable.getName();
            PsiDeclarationStatement statement = this.myElementFactory.createVariableDeclarationStatement(name, variable.getType(), null);
            body.add((PsiElement)statement);
        }
        if (this.myArtificialOutputVariable instanceof PsiField && !this.myIsChainedConstructor) {
            body.add((PsiElement)this.myElementFactory.createVariableDeclarationStatement(this.myArtificialOutputVariable.getName(), this.myArtificialOutputVariable.getType(), null));
        }
    }

    protected void declareNecessaryVariablesAfterCall(PsiVariable outputVariable) throws IncorrectOperationException {
        if (this.myHasExpressionOutput) {
            return;
        }
        List<PsiVariable> usedVariables = this.myControlFlowWrapper.getUsedVariables();
        Collection<ControlFlowUtil.VariableInfo> reassigned = this.myControlFlowWrapper.getInitializedTwice();
        for (PsiVariable variable : usedVariables) {
            boolean toDeclare = this.isDeclaredInside(variable) && !variable.equals(outputVariable);
            if (!toDeclare) continue;
            String name = variable.getName();
            PsiDeclarationStatement statement = this.myElementFactory.createVariableDeclarationStatement(name, variable.getType(), null);
            if (reassigned.contains(new ControlFlowUtil.VariableInfo(variable, null))) {
                PsiElement[] psiElements = statement.getDeclaredElements();
                assert (psiElements.length > 0);
                PsiVariable var = (PsiVariable)psiElements[0];
                PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)false);
            }
            this.addToMethodCallLocation((PsiStatement)statement);
        }
    }

    public PsiMethodCallExpression getMethodCall() {
        return this.myMethodCall;
    }

    public void setMethodCall(PsiMethodCallExpression methodCall) {
        this.myMethodCall = methodCall;
    }

    public boolean isDeclaredInside(PsiVariable variable) {
        int endOffset;
        int startOffset;
        if (variable instanceof ImplicitVariable) {
            return false;
        }
        if (this.myExpression != null) {
            TextRange range = this.myExpression.getTextRange();
            startOffset = range.getStartOffset();
            endOffset = range.getEndOffset();
        } else {
            startOffset = this.myElements[0].getTextRange().getStartOffset();
            endOffset = this.myElements[this.myElements.length - 1].getTextRange().getEndOffset();
        }
        PsiIdentifier nameIdentifier = variable.getNameIdentifier();
        if (nameIdentifier == null) {
            return false;
        }
        TextRange range = nameIdentifier.getTextRange();
        if (range == null) {
            return false;
        }
        int offset = range.getStartOffset();
        return startOffset <= offset && offset <= endOffset;
    }

    private String getNewVariableName(PsiVariable variable) {
        for (VariableData data : this.myVariableDatum) {
            if (!data.variable.equals(variable)) continue;
            return data.name;
        }
        return variable.getName();
    }

    private static boolean shouldAcceptCurrentTarget(Pass<ExtractMethodProcessor> extractPass, PsiElement target) {
        return extractPass == null && !(target instanceof PsiAnonymousClass);
    }

    private boolean applyChosenClassAndExtract(List<PsiVariable> inputVariables, @Nullable Pass<ExtractMethodProcessor> extractPass) throws PrepareFailedException {
        this.myStatic = this.shouldBeStatic();
        final LinkedHashSet<PsiField> fields = new LinkedHashSet<PsiField>();
        if (!PsiUtil.isLocalOrAnonymousClass((PsiClass)this.myTargetClass) && (this.myTargetClass.getContainingClass() == null || this.myTargetClass.hasModifierProperty("static"))) {
            boolean canBeStatic = true;
            if (this.myTargetClass.isInterface()) {
                PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myCodeFragmentMember, PsiMethod.class, (boolean)false);
                boolean bl = canBeStatic = containingMethod == null || containingMethod.hasModifierProperty("static");
            }
            if (canBeStatic) {
                ElementNeedsThis needsThis = new ElementNeedsThis(this.myTargetClass){

                    @Override
                    protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
                        PsiExpression expression;
                        if (!(!(classMember instanceof PsiField) || classMember.hasModifierProperty("static") || (expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)classMemberReference, PsiExpression.class, (boolean)false)) != null && PsiUtil.isAccessedForWriting((PsiExpression)expression))) {
                            fields.add((PsiField)classMember);
                            return;
                        }
                        super.visitClassMemberReferenceElement(classMember, classMemberReference);
                    }
                };
                for (int i = 0; i < this.myElements.length && !needsThis.usesMembers(); ++i) {
                    PsiElement element = this.myElements[i];
                    element.accept((PsiElementVisitor)needsThis);
                }
                this.myCanBeStatic = !needsThis.usesMembers();
            } else {
                this.myCanBeStatic = false;
            }
        } else {
            this.myCanBeStatic = false;
        }
        this.myInputVariables = new InputVariables(inputVariables, this.myProject, new LocalSearchScope(this.myElements), this.isFoldingApplicable());
        this.myInputVariables.setUsedInstanceFields(fields);
        if (!this.checkExitPoints()) {
            return false;
        }
        this.checkCanBeChainedConstructor();
        if (extractPass != null) {
            extractPass.pass((Object)this);
        }
        return true;
    }

    protected boolean isFoldingApplicable() {
        return true;
    }

    private void chooseAnchor() {
        this.myAnchor = this.myCodeFragmentMember;
        while (!this.myAnchor.getParent().equals(this.myTargetClass)) {
            this.myAnchor = this.myAnchor.getParent();
        }
    }

    private void showMultipleExitPointsMessage() {
        if (this.myShowErrorDialogs) {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
            PsiStatement[] exitStatementsArray = this.myExitStatements.toArray(new PsiStatement[this.myExitStatements.size()]);
            EditorColorsManager manager = EditorColorsManager.getInstance();
            TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            highlightManager.addOccurrenceHighlights(this.myEditor, (PsiElement[])exitStatementsArray, attributes, true, null);
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"there.are.multiple.exit.points.in.the.selected.code.fragment"));
            CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)this.myEditor, (String)message, (String)this.myRefactoringName, (String)this.myHelpId);
            WindowManager.getInstance().getStatusBar(this.myProject).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
        }
    }

    private void showMultipleOutputMessage(PsiType expressionType) {
        if (this.myShowErrorDialogs) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"there.are.multiple.output.values.for.the.selected.code.fragment")));
            buffer.append("\n");
            if (this.myHasExpressionOutput) {
                buffer.append("    ").append(RefactoringBundle.message((String)"expression.result")).append(": ");
                buffer.append(PsiFormatUtil.formatType((PsiType)expressionType, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
                buffer.append(",\n");
            }
            if (this.myGenerateConditionalExit) {
                buffer.append("    ").append(RefactoringBundle.message((String)"boolean.method.result"));
                buffer.append(",\n");
            }
            for (int i = 0; i < this.myOutputVariables.length; ++i) {
                PsiVariable var = this.myOutputVariables[i];
                buffer.append("    ");
                buffer.append(var.getName());
                buffer.append(" : ");
                buffer.append(PsiFormatUtil.formatType((PsiType)var.getType(), (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
                if (i < this.myOutputVariables.length - 1) {
                    buffer.append(",\n");
                    continue;
                }
                buffer.append(".");
            }
            buffer.append("\nWould you like to Extract Method Object?");
            String message = buffer.toString();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new RuntimeException(message);
            }
            RefactoringMessageDialog dialog = new RefactoringMessageDialog(this.myRefactoringName, message, this.myHelpId, "OptionPane.errorIcon", true, this.myProject);
            if (dialog.showAndGet()) {
                new ExtractMethodObjectHandler().invoke(this.myProject, this.myEditor, this.myTargetClass.getContainingFile(), DataManager.getInstance().getDataContext());
            }
        }
    }

    public PsiMethod getExtractedMethod() {
        return this.myExtractedMethod;
    }

    @Override
    public Boolean hasDuplicates() {
        ExtractMethodSignatureSuggester suggester;
        List<Match> duplicates = this.getDuplicates();
        if (duplicates != null && !duplicates.isEmpty()) {
            return true;
        }
        if (this.myExtractedMethod != null && (duplicates = (suggester = new ExtractMethodSignatureSuggester(this.myProject, this.myExtractedMethod, this.myMethodCall, this.myVariableDatum)).getDuplicates(this.myExtractedMethod, this.myMethodCall, this.myInputVariables.getFolding())) != null && !duplicates.isEmpty()) {
            this.myDuplicates = duplicates;
            this.myExtractedMethod = suggester.getExtractedMethod();
            this.myMethodCall = suggester.getMethodCall();
            this.myVariableDatum = suggester.getVariableData();
            return null;
        }
        return false;
    }

    public boolean hasDuplicates(Set<VirtualFile> files) {
        DuplicatesFinder finder = this.initDuplicates();
        Boolean hasDuplicates = this.hasDuplicates();
        if (hasDuplicates == null || hasDuplicates.booleanValue()) {
            return true;
        }
        if (finder != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            for (VirtualFile file2 : files) {
                if (finder.findDuplicates((PsiElement)psiManager.findFile(file2)).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public String getConfirmDuplicatePrompt(Match match) {
        boolean needToBeStatic = RefactoringUtil.isInStaticContext(match.getMatchStart(), this.myExtractedMethod.getContainingClass());
        String changedSignature = MatchUtil.getChangedSignature(match, this.myExtractedMethod, needToBeStatic, VisibilityUtil.getVisibilityStringToDisplay((PsiMember)this.myExtractedMethod));
        if (changedSignature != null) {
            return RefactoringBundle.message((String)"replace.this.code.fragment.and.change.signature", (Object[])new Object[]{changedSignature});
        }
        if (needToBeStatic && !this.myExtractedMethod.hasModifierProperty("static")) {
            return RefactoringBundle.message((String)"replace.this.code.fragment.and.make.method.static");
        }
        return null;
    }

    @Override
    public String getReplaceDuplicatesTitle(int idx, int size) {
        return RefactoringBundle.message((String)"process.duplicates.title", (Object[])new Object[]{idx, size});
    }

    public InputVariables getInputVariables() {
        return this.myInputVariables;
    }

    public PsiTypeParameterList getTypeParameterList() {
        return this.myTypeParameterList;
    }

    public PsiClassType[] getThrownExceptions() {
        return this.myThrownExceptions;
    }

    public boolean isStatic() {
        return this.myStatic;
    }

    public boolean isCanBeStatic() {
        return this.myCanBeStatic;
    }

    public PsiElement[] getElements() {
        return this.myElements;
    }

    public PsiVariable[] getOutputVariables() {
        return this.myOutputVariables;
    }
}

