/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationReplacementUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.BaseGuavaTypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaFluentIterableConversionRule;
import com.intellij.reference.SoftLazyValue;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaInspection
extends BaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(GuavaInspection.class);
    public static final String PROBLEM_DESCRIPTION_FOR_VARIABLE = "Guava's functional primitives can be replaced by Java API";
    public static final String PROBLEM_DESCRIPTION_FOR_METHOD_CHAIN = "Guava's FluentIterable method chain can be replaced by Java API";
    private static final SoftLazyValue<Set<String>> FLUENT_ITERABLE_STOP_METHODS = new SoftLazyValue<Set<String>>(){

        @NotNull
        protected Set<String> compute() {
            HashSet hashSet = ContainerUtil.newHashSet((Object[])new String[]{"append", "cycle", "uniqueIndex", "index"});
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$1", "compute"));
            }
            return hashSet;
        }
    };
    public boolean checkVariables = true;
    public boolean checkChains = true;
    public boolean checkReturnTypes = true;

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox("Report variables", "checkVariables");
        panel.addCheckbox("Report method chains", "checkChains");
        panel.addCheckbox("Report return types", "checkReturnTypes");
        return panel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){
            private final AtomicNotNullLazyValue<Map<String, PsiClass>> myGuavaClassConversions = new AtomicNotNullLazyValue<Map<String, PsiClass>>(){

                @NotNull
                protected Map<String, PsiClass> compute() {
                    HashMap map = new HashMap();
                    for (TypeConversionRule rule : (TypeConversionRule[])TypeConversionRule.EP_NAME.getExtensions()) {
                        if (!(rule instanceof BaseGuavaTypeConversionRule)) continue;
                        String fromClass = ((BaseGuavaTypeConversionRule)rule).ruleFromClass();
                        String toClass = ((BaseGuavaTypeConversionRule)rule).ruleToClass();
                        Project project = holder.getProject();
                        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
                        PsiClass targetClass = javaPsiFacade.findClass(toClass, GlobalSearchScope.allScope((Project)project));
                        if (targetClass == null) continue;
                        map.put(fromClass, targetClass);
                    }
                    HashMap hashMap = map;
                    if (hashMap == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$2$1", "compute"));
                    }
                    return hashMap;
                }
            };

            public void visitVariable(PsiVariable variable) {
                if (!GuavaInspection.this.checkVariables) {
                    return;
                }
                PsiType type = variable.getType();
                PsiType targetType = this.getConversionClassType(type);
                if (targetType != null) {
                    holder.registerProblem((PsiElement)variable, GuavaInspection.PROBLEM_DESCRIPTION_FOR_VARIABLE, new LocalQuickFix[]{new MigrateGuavaTypeFix((PsiElement)variable, targetType, null)});
                }
            }

            public void visitMethod(PsiMethod method) {
                PsiTypeElement typeElement;
                super.visitMethod(method);
                if (!GuavaInspection.this.checkReturnTypes) {
                    return;
                }
                PsiType targetType = this.getConversionClassType(method.getReturnType());
                if (targetType != null && (typeElement = method.getReturnTypeElement()) != null) {
                    holder.registerProblem((PsiElement)typeElement, GuavaInspection.PROBLEM_DESCRIPTION_FOR_VARIABLE, new LocalQuickFix[]{new MigrateGuavaTypeFix((PsiElement)method, targetType, null)});
                }
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiClass target;
                PsiClass aClass;
                if (!GuavaInspection.this.checkChains) {
                    return;
                }
                if (!this.isFluentIterableFromCall(expression)) {
                    return;
                }
                PsiMethodCallExpression chain = this.findGuavaMethodChain(expression);
                if (chain == null) {
                    return;
                }
                PsiElement maybeLocalVariable = chain.getParent();
                if (maybeLocalVariable instanceof PsiLocalVariable && (aClass = PsiUtil.resolveClassInType((PsiType)((PsiLocalVariable)maybeLocalVariable).getType())) != null && ("com.google.common.collect.FluentIterable".equals(aClass.getQualifiedName()) || "com.google.common.base.Optional".equals(aClass.getQualifiedName()))) {
                    return;
                }
                PsiClassType initialType = (PsiClassType)expression.getType();
                LOG.assertTrue(initialType != null);
                PsiClass resolvedClass = initialType.resolve();
                if (resolvedClass == null || (target = (PsiClass)((Map)this.myGuavaClassConversions.getValue()).get(resolvedClass.getQualifiedName())) == null) {
                    return;
                }
                PsiClassType targetType = this.addTypeParameters((PsiType)initialType, initialType.resolveGenerics(), target);
                holder.registerProblem((PsiElement)chain, GuavaInspection.PROBLEM_DESCRIPTION_FOR_METHOD_CHAIN, new LocalQuickFix[]{new MigrateGuavaTypeFix((PsiElement)chain, (PsiType)targetType, (PsiType)initialType)});
            }

            private PsiType getConversionClassType(PsiType initialType) {
                PsiClassType.ClassResolveResult resolveResult;
                PsiClass psiClass;
                if (initialType == null) {
                    return null;
                }
                PsiType type = initialType.getDeepComponentType();
                if (type instanceof PsiClassType && (psiClass = (resolveResult = ((PsiClassType)type).resolveGenerics()).getElement()) != null) {
                    String qName = psiClass.getQualifiedName();
                    PsiClass targetClass = (PsiClass)((Map)this.myGuavaClassConversions.getValue()).get(qName);
                    if (targetClass != null) {
                        PsiClassType createdType = this.addTypeParameters(type, resolveResult, targetClass);
                        return initialType instanceof PsiArrayType ? this.wrapAsArray((PsiArrayType)initialType, (PsiType)createdType) : createdType;
                    }
                }
                return null;
            }

            private PsiType wrapAsArray(PsiArrayType initial, PsiType created) {
                PsiArrayType result2 = new PsiArrayType(created);
                while (initial.getComponentType() instanceof PsiArrayType) {
                    initial = (PsiArrayType)initial.getComponentType();
                    result2 = new PsiArrayType((PsiType)result2);
                }
                return result2;
            }

            private boolean isFluentIterableFromCall(PsiMethodCallExpression expression) {
                PsiMethod method = expression.resolveMethod();
                if (method == null || !GuavaFluentIterableConversionRule.CHAIN_HEAD_METHODS.contains(method.getName())) {
                    return false;
                }
                PsiClass aClass = method.getContainingClass();
                return aClass != null && "com.google.common.collect.FluentIterable".equals(aClass.getQualifiedName());
            }

            private PsiMethodCallExpression findGuavaMethodChain(PsiMethodCallExpression expression) {
                PsiMethodCallExpression chain = expression;
                while (true) {
                    PsiMethodCallExpression current;
                    if ((current = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)chain, PsiMethodCallExpression.class)) != null && current.getMethodExpression().getQualifierExpression() == chain) {
                        PsiMethod method = current.resolveMethod();
                        if (method == null) {
                            return chain;
                        }
                        if (((Set)FLUENT_ITERABLE_STOP_METHODS.getValue()).contains(method.getName())) {
                            return null;
                        }
                        PsiClass containingClass = method.getContainingClass();
                        if (containingClass == null || !"com.google.common.collect.FluentIterable".equals(containingClass.getQualifiedName()) && !"com.google.common.base.Optional".equals(containingClass.getQualifiedName())) {
                            return chain;
                        }
                    } else {
                        return chain;
                    }
                    chain = current;
                }
            }

            @NotNull
            private PsiClassType addTypeParameters(PsiType currentType, PsiClassType.ClassResolveResult currentTypeResolveResult, PsiClass targetClass) {
                Map substitutionMap = currentTypeResolveResult.getSubstitutor().getSubstitutionMap();
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)holder.getProject());
                if (substitutionMap.size() == 1) {
                    PsiClassType psiClassType = elementFactory.createType(targetClass, (PsiType)ContainerUtil.getFirstItem(substitutionMap.values()));
                    if (psiClassType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$2", "addTypeParameters"));
                    }
                    return psiClassType;
                }
                LOG.assertTrue(substitutionMap.size() == 2);
                LOG.assertTrue("java.util.function.Function".equals(targetClass.getQualifiedName()));
                PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)currentType);
                ArrayList types = new ArrayList(substitutionMap.values());
                types.remove(returnType);
                PsiType parameterType = (PsiType)types.get(0);
                PsiClassType psiClassType = elementFactory.createType(targetClass, new PsiType[]{parameterType, returnType});
                if (psiClassType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$2", "addTypeParameters"));
                }
                return psiClassType;
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    public static class MigrateGuavaTypeFix
    extends LocalQuickFixAndIntentionActionOnPsiElement
    implements BatchQuickFix<ProblemDescriptor> {
        @Nullable
        private final PsiType myInitialType;
        private final PsiType myTargetType;

        private MigrateGuavaTypeFix(@NotNull PsiElement element, PsiType targetType, @Nullable PsiType initialType) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$MigrateGuavaTypeFix", "<init>"));
            }
            super(element);
            this.myTargetType = targetType;
            this.myInitialType = initialType;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$MigrateGuavaTypeFix", "invoke"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$MigrateGuavaTypeFix", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$MigrateGuavaTypeFix", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$MigrateGuavaTypeFix", "invoke"));
            }
            if (this.myInitialType == null) {
                MigrateGuavaTypeFix.performTypeMigration(Collections.singletonList(startElement), Collections.singletonList(this.myTargetType));
            } else {
                MigrateGuavaTypeFix.performChainTypeMigration(project, Collections.singletonList(startElement), Collections.singletonList(this.myInitialType), Collections.singletonList(this.myTargetType));
            }
        }

        protected boolean isAvailable() {
            return super.isAvailable() && this.myTargetType.isValid();
        }

        @NotNull
        public String getText() {
            PsiElement element = this.getStartElement();
            if (!this.myTargetType.isValid() || !element.isValid()) {
                String string = this.getFamilyName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$MigrateGuavaTypeFix", "getText"));
                }
                return string;
            }
            String presentation = TypeMigrationProcessor.getPresentation(element);
            String string = "Migrate " + presentation + " type to '" + this.myTargetType.getCanonicalText(false) + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$MigrateGuavaTypeFix", "getText"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Migrate Guava's type to Java" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$MigrateGuavaTypeFix", "getFamilyName"));
            }
            return "Migrate Guava's type to Java";
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor[] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$MigrateGuavaTypeFix", "applyFix"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$MigrateGuavaTypeFix", "applyFix"));
            }
            if (psiElementsToIgnore == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElementsToIgnore", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$MigrateGuavaTypeFix", "applyFix"));
            }
            ArrayList<PsiElement> elementsToFix = new ArrayList<PsiElement>();
            ArrayList<PsiType> migrationTypes = new ArrayList<PsiType>();
            ArrayList<PsiElement> chainsToFix = new ArrayList<PsiElement>();
            ArrayList<PsiType> chainsMigrationTypes = new ArrayList<PsiType>();
            ArrayList<PsiType> chainsInitialTypes = new ArrayList<PsiType>();
            for (ProblemDescriptor descriptor : descriptors) {
                MigrateGuavaTypeFix fix = MigrateGuavaTypeFix.getFix(descriptor);
                if (fix.myInitialType == null) {
                    elementsToFix.add(fix.getStartElement());
                    migrationTypes.add(fix.myTargetType);
                    continue;
                }
                chainsToFix.add(fix.getStartElement());
                chainsMigrationTypes.add(fix.myTargetType);
                chainsInitialTypes.add(fix.myInitialType);
            }
            if (!elementsToFix.isEmpty() && !MigrateGuavaTypeFix.performTypeMigration(elementsToFix, migrationTypes)) {
                return;
            }
            if (!chainsToFix.isEmpty()) {
                MigrateGuavaTypeFix.performChainTypeMigration(project, chainsToFix, chainsInitialTypes, chainsMigrationTypes);
            }
        }

        private static void performChainTypeMigration(final @NotNull Project project, List<PsiElement> elements, List<PsiType> initialTypes, List<PsiType> targetTypes) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$MigrateGuavaTypeFix", "performChainTypeMigration"));
            }
            Iterator<PsiType> initialTypeIterator = initialTypes.iterator();
            Iterator<PsiType> targetTypeIterator = targetTypes.iterator();
            final ArrayList<PsiElement> validElement = new ArrayList<PsiElement>();
            final ArrayList<Boolean> isIterableList = new ArrayList<Boolean>(elements.size());
            final ArrayList<TypeConversionDescriptorBase> conversionList = new ArrayList<TypeConversionDescriptorBase>(elements.size());
            for (PsiElement element : elements) {
                PsiType initialType = initialTypeIterator.next();
                PsiType targetType = targetTypeIterator.next();
                if (!element.isValid()) continue;
                PsiMethodCallExpression expr = (PsiMethodCallExpression)element;
                TypeMigrationRules rules = new TypeMigrationRules();
                rules.setBoundScope(element.getUseScope());
                conversionList.add(rules.findConversion(initialType, targetType, (PsiMember)expr.resolveMethod(), (PsiExpression)expr, new TypeMigrationLabeler(rules, targetType)));
                isIterableList.add(MigrateGuavaTypeFix.isIterable(expr));
                validElement.add(element);
            }
            if (!validElement.isEmpty()) {
                final PsiFile file2 = ((PsiElement)validElement.get(0)).getContainingFile();
                if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                    return;
                }
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        Iterator isIterableIterator = isIterableList.iterator();
                        Iterator conversionIterator = conversionList.iterator();
                        for (PsiElement element : validElement) {
                            PsiElement replacedExpression = TypeMigrationReplacementUtil.replaceExpression((PsiExpression)element, project, conversionIterator.next());
                            if (((Boolean)isIterableIterator.next()).booleanValue()) {
                                String expressionText = replacedExpression.getText() + ".collect(java.util.stream.Collectors.toList())";
                                replacedExpression = replacedExpression.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(expressionText, replacedExpression));
                            }
                            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replacedExpression);
                        }
                        UndoUtil.markPsiFileForUndo((PsiFile)file2);
                    }
                });
            }
        }

        private static boolean isIterable(PsiMethodCallExpression expression) {
            PsiClass returnClass;
            PsiElement parent = expression.getParent();
            PsiMethod method = expression.resolveMethod();
            if (!(method == null || (returnClass = PsiTypesUtil.getPsiClass((PsiType)method.getReturnType())) != null && "com.google.common.collect.FluentIterable".equals(returnClass.getQualifiedName()))) {
                return false;
            }
            if (parent instanceof PsiLocalVariable) {
                return MigrateGuavaTypeFix.isIterable(((PsiLocalVariable)parent).getType());
            }
            if (parent instanceof PsiReturnStatement) {
                PsiElement methodOrLambda = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
                PsiType methodReturnType = null;
                if (methodOrLambda instanceof PsiMethod) {
                    methodReturnType = ((PsiMethod)methodOrLambda).getReturnType();
                } else if (methodOrLambda instanceof PsiLambdaExpression) {
                    methodReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiFunctionalExpression)methodOrLambda));
                }
                return MigrateGuavaTypeFix.isIterable(methodReturnType);
            }
            return false;
        }

        private static boolean isIterable(@Nullable PsiType type) {
            PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type);
            return aClass != null && "java.lang.Iterable".equals(aClass.getQualifiedName());
        }

        private static MigrateGuavaTypeFix getFix(ProblemDescriptor descriptor) {
            QuickFix[] fixes = descriptor.getFixes();
            LOG.assertTrue(fixes != null);
            for (QuickFix fix : fixes) {
                if (!(fix instanceof MigrateGuavaTypeFix)) continue;
                return (MigrateGuavaTypeFix)fix;
            }
            throw new AssertionError();
        }

        private static boolean performTypeMigration(List<PsiElement> elements, List<PsiType> types) {
            PsiFile containingFile = null;
            GlobalSearchScope typeMigrationScope = GlobalSearchScope.EMPTY_SCOPE;
            for (PsiElement element : elements) {
                PsiFile currentContainingFile = element.getContainingFile();
                if (containingFile == null) {
                    containingFile = currentContainingFile;
                } else {
                    LOG.assertTrue(containingFile.isEquivalentTo((PsiElement)currentContainingFile));
                }
                typeMigrationScope = typeMigrationScope.union(element.getUseScope());
            }
            LOG.assertTrue(containingFile != null);
            if (!FileModificationService.getInstance().prepareFileForWrite(containingFile)) {
                return false;
            }
            try {
                TypeMigrationRules rules = new TypeMigrationRules();
                rules.setBoundScope((SearchScope)typeMigrationScope);
                TypeMigrationProcessor.runHighlightingTypeMigration(containingFile.getProject(), null, rules, elements.toArray(new PsiElement[elements.size()]), MigrateGuavaTypeFix.createMigrationTypeFunction(elements, types), true);
                UndoUtil.markPsiFileForUndo((PsiFile)containingFile);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            return true;
        }

        private static Function<PsiElement, PsiType> createMigrationTypeFunction(@NotNull List<PsiElement> elements, @NotNull List<PsiType> types) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$MigrateGuavaTypeFix", "createMigrationTypeFunction"));
            }
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$MigrateGuavaTypeFix", "createMigrationTypeFunction"));
            }
            LOG.assertTrue(elements.size() == types.size());
            HashMap mappings = new HashMap();
            Iterator<PsiType> typeIterator = types.iterator();
            for (PsiElement element : elements) {
                PsiType type = typeIterator.next();
                mappings.put(element, type);
            }
            return new Function<PsiElement, PsiType>((Map)mappings){
                final /* synthetic */ Map val$mappings;
                {
                    this.val$mappings = map;
                }

                public PsiType fun(PsiElement element) {
                    return (PsiType)this.val$mappings.get(element);
                }
            };
        }
    }
}

