/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import org.jetbrains.annotations.NotNull;

public class FunctionalInterfaceTypeConversionDescriptor
extends TypeConversionDescriptor {
    @NotNull
    private final String myMethodName;
    @NotNull
    private final String myTargetMethodName;

    public FunctionalInterfaceTypeConversionDescriptor(@NotNull String methodName, @NotNull String targetMethodName) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/refactoring/typeMigration/rules/guava/FunctionalInterfaceTypeConversionDescriptor", "<init>"));
        }
        if (targetMethodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetMethodName", "com/intellij/refactoring/typeMigration/rules/guava/FunctionalInterfaceTypeConversionDescriptor", "<init>"));
        }
        super(null, null);
        this.myMethodName = methodName;
        this.myTargetMethodName = targetMethodName;
    }

    @Override
    public PsiExpression replace(PsiExpression expression) {
        if (expression instanceof PsiMethodReferenceExpression) {
            this.setAsMethodReference();
        } else {
            this.setAsMethodCall();
        }
        return super.replace(expression);
    }

    private void setAsMethodReference() {
        this.setStringToReplace("$qualifier$::" + this.myMethodName);
        this.setReplaceByString("$qualifier$");
    }

    private void setAsMethodCall() {
        this.setStringToReplace("$qualifier$." + this.myMethodName + "($param$)");
        this.setReplaceByString("$qualifier$." + this.myTargetMethodName + "($param$)");
    }
}

