/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.guava.BaseGuavaTypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.FunctionalInterfaceTypeConversionDescriptor;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaPredicateConversionRule
extends BaseGuavaTypeConversionRule {
    public static final String GUAVA_PREDICATE = "com.google.common.base.Predicate";
    public static final String JAVA_PREDICATE = "java.util.function.Predicate";

    @Override
    @NotNull
    protected Set<String> getAdditionalUtilityClasses() {
        Set<String> set = Collections.singleton("com.google.common.base.Predicates");
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicateConversionRule", "getAdditionalUtilityClasses"));
        }
        return set;
    }

    @Override
    protected void fillSimpleDescriptors(Map<String, TypeConversionDescriptorBase> descriptorsMap) {
        descriptorsMap.put("apply", new FunctionalInterfaceTypeConversionDescriptor("apply", "test"));
    }

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForVariableReference(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiVariable psiVariable, PsiExpression context) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicateConversionRule", "findConversionForVariableReference"));
        }
        if (psiVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicateConversionRule", "findConversionForVariableReference"));
        }
        return new TypeConversionDescriptor("$p$", "$p$::test");
    }

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForMethod(PsiType from, PsiType to, @NotNull PsiMethod method, @NotNull String methodName, PsiExpression context, TypeMigrationLabeler labeler) {
        PsiParameter parameter;
        PsiClass psiClass;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicateConversionRule", "findConversionForMethod"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicateConversionRule", "findConversionForMethod"));
        }
        if (!(context instanceof PsiMethodCallExpression)) {
            return null;
        }
        if (method.getParameterList().getParametersCount() == 1 && ((psiClass = PsiTypesUtil.getPsiClass((PsiType)(parameter = method.getParameterList().getParameters()[0]).getType().getDeepComponentType())) == null || "java.lang.Iterable".equals(psiClass.getQualifiedName()))) {
            return null;
        }
        if (methodName.equals("or")) {
            return null;
        }
        if (methodName.equals("and")) {
            return null;
        }
        if (methodName.equals("not")) {
            return null;
        }
        return null;
    }

    @Override
    @NotNull
    public String ruleFromClass() {
        if (GUAVA_PREDICATE == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicateConversionRule", "ruleFromClass"));
        }
        return GUAVA_PREDICATE;
    }

    @Override
    @NotNull
    public String ruleToClass() {
        if (JAVA_PREDICATE == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicateConversionRule", "ruleToClass"));
        }
        return JAVA_PREDICATE;
    }
}

