/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.rules.guava.BaseGuavaTypeConversionRule;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaSupplierConversionRule
extends BaseGuavaTypeConversionRule {
    public static final String GUAVA_SUPPLIER = "com.google.common.base.Supplier";
    public static final String JAVA_SUPPLIER = "java.util.function.Supplier";

    @Override
    protected void fillSimpleDescriptors(Map<String, TypeConversionDescriptorBase> descriptorsMap) {
        descriptorsMap.put("get", new TypeConversionDescriptor("$val$.get()", "$val$.get()"));
    }

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForVariableReference(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiVariable psiVariable, PsiExpression context) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/refactoring/typeMigration/rules/guava/GuavaSupplierConversionRule", "findConversionForVariableReference"));
        }
        if (psiVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/refactoring/typeMigration/rules/guava/GuavaSupplierConversionRule", "findConversionForVariableReference"));
        }
        return new TypeConversionDescriptor("$f$", "$f$::get");
    }

    @Override
    @NotNull
    public String ruleFromClass() {
        if (GUAVA_SUPPLIER == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/GuavaSupplierConversionRule", "ruleFromClass"));
        }
        return GUAVA_SUPPLIER;
    }

    @Override
    @NotNull
    public String ruleToClass() {
        if (JAVA_SUPPLIER == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/GuavaSupplierConversionRule", "ruleToClass"));
        }
        return JAVA_SUPPLIER;
    }
}

