/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import org.jetbrains.annotations.NonNls;

public class LambdaParametersTypeConversionDescriptor
extends TypeConversionDescriptor {
    private static final Logger LOG = Logger.getInstance(LambdaParametersTypeConversionDescriptor.class);

    public LambdaParametersTypeConversionDescriptor(@NonNls String stringToReplace, @NonNls String replaceByString) {
        super(stringToReplace, replaceByString);
    }

    @Override
    public PsiExpression replace(PsiExpression expression) {
        LOG.assertTrue(expression instanceof PsiMethodCallExpression);
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression;
        PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
        if (arguments.length == 1) {
            PsiExpression functionArg = arguments[0];
            this.customizeParameter(LambdaParametersTypeConversionDescriptor.convertParameter(functionArg));
        }
        return super.replace(expression);
    }

    protected void customizeParameter(PsiExpression parameter) {
    }

    private static PsiExpression addApplyReference(PsiExpression expression) {
        PsiClass resolvedClass;
        boolean isSupplier = false;
        PsiType type = expression.getType();
        if (type instanceof PsiClassType && (resolvedClass = ((PsiClassType)type).resolve()) != null && "com.google.common.base.Supplier".equals(resolvedClass.getQualifiedName())) {
            isSupplier = true;
        }
        return (PsiExpression)expression.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(expression.getText() + "::" + (isSupplier ? "get" : "apply"), null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PsiExpression convertParameter(PsiExpression expression) {
        if (expression instanceof PsiNewExpression) {
            PsiAnonymousClass anonymousClass = ((PsiNewExpression)expression).getAnonymousClass();
            if (anonymousClass == null) return LambdaParametersTypeConversionDescriptor.addApplyReference(expression);
            if (!AnonymousCanBeLambdaInspection.canBeConvertedToLambda(anonymousClass, true)) return expression;
            AnonymousCanBeLambdaInspection.replacePsiElementWithLambda((PsiElement)expression, true, true);
            return expression;
        } else {
            PsiClass qualifierClass;
            PsiType qualifierType;
            PsiElement qualifier;
            if (!(expression instanceof PsiFunctionalExpression)) {
                return LambdaParametersTypeConversionDescriptor.addApplyReference(expression);
            }
            if (!(expression instanceof PsiMethodReferenceExpression) || !((qualifier = ((PsiMethodReferenceExpression)expression).getQualifier()) instanceof PsiExpression) || (qualifierType = ((PsiExpression)qualifier).getType()) == null || (qualifierClass = PsiTypesUtil.getPsiClass((PsiType)qualifierType)) == null || !Comparing.equal((String)qualifierClass.getQualifiedName(), (String)"java.util.function.Function") && !Comparing.equal((String)qualifierClass.getQualifiedName(), (String)"java.util.Optional") && !Comparing.equal((String)qualifierClass.getQualifiedName(), (String)"java.util.function.Supplier") && !Comparing.equal((String)qualifierClass.getQualifiedName(), (String)"java.util.function.Predicate")) return expression;
            return (PsiExpression)expression.replace(qualifier);
        }
    }
}

