/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementContext;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StructuralSearchProfile {
    public static final ExtensionPointName<StructuralSearchProfile> EP_NAME = ExtensionPointName.create((String)"com.intellij.structuralsearch.profile");

    public abstract void compile(PsiElement[] var1, @NotNull GlobalCompilingVisitor var2);

    @NotNull
    public abstract PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor var1);

    @NotNull
    public abstract PsiElementVisitor getLexicalNodesFilter(@NotNull LexicalNodesFilter var1);

    @NotNull
    public abstract CompiledPattern createCompiledPattern();

    public static String getTypeName(FileType fileType) {
        return fileType.getName().toLowerCase();
    }

    public final boolean canProcess(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/structuralsearch/StructuralSearchProfile", "canProcess"));
        }
        return fileType instanceof LanguageFileType && this.isMyLanguage(((LanguageFileType)fileType).getLanguage());
    }

    public abstract boolean isMyLanguage(@NotNull Language var1);

    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull FileType fileType, @Nullable Language language, @Nullable String contextName, @Nullable String extension, @NotNull Project project, boolean physical) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/structuralsearch/StructuralSearchProfile", "createPatternTree"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/structuralsearch/StructuralSearchProfile", "createPatternTree"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/structuralsearch/StructuralSearchProfile", "createPatternTree"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/StructuralSearchProfile", "createPatternTree"));
        }
        String ext = extension != null ? extension : fileType.getDefaultExtension();
        String name = "__dummy." + ext;
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
        PsiFile file2 = language == null ? factory.createFileFromText(name, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), physical, true) : factory.createFileFromText(name, language, (CharSequence)text, physical, true);
        PsiElement[] psiElementArray = file2 != null ? file2.getChildren() : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchProfile", "createPatternTree"));
        }
        return psiElementArray;
    }

    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull FileType fileType, @NotNull Project project, boolean physical) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/structuralsearch/StructuralSearchProfile", "createPatternTree"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/structuralsearch/StructuralSearchProfile", "createPatternTree"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/structuralsearch/StructuralSearchProfile", "createPatternTree"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/StructuralSearchProfile", "createPatternTree"));
        }
        PsiElement[] psiElementArray = this.createPatternTree(text, context, fileType, null, null, null, project, physical);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchProfile", "createPatternTree"));
        }
        return psiElementArray;
    }

    @NotNull
    public Editor createEditor(@NotNull SearchContext searchContext, @NotNull FileType fileType, Language dialect, String text, boolean useLastConfiguration) {
        if (searchContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchContext", "com/intellij/structuralsearch/StructuralSearchProfile", "createEditor"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/structuralsearch/StructuralSearchProfile", "createEditor"));
        }
        PsiCodeFragment codeFragment = this.createCodeFragment(searchContext.getProject(), text, null);
        if (codeFragment == null) {
            codeFragment = StructuralSearchProfile.createFileFragment(searchContext, fileType, dialect, text);
        }
        if (codeFragment != null) {
            Document doc = PsiDocumentManager.getInstance((Project)searchContext.getProject()).getDocument((PsiFile)codeFragment);
            assert (doc != null) : "code fragment element should be physical";
            DaemonCodeAnalyzer.getInstance((Project)searchContext.getProject()).setHighlightingEnabled((PsiFile)codeFragment, false);
            Editor editor = UIUtil.createEditor(doc, searchContext.getProject(), true, true, this.getTemplateContextType());
            if (editor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchProfile", "createEditor"));
            }
            return editor;
        }
        EditorFactory factory = EditorFactory.getInstance();
        Document document = factory.createDocument((CharSequence)text);
        EditorEx editor = (EditorEx)factory.createEditor(document, searchContext.getProject());
        editor.getSettings().setFoldingOutlineShown(false);
        EditorEx editorEx = editor;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchProfile", "createEditor"));
        }
        return editorEx;
    }

    private static PsiFile createFileFragment(SearchContext searchContext, FileType fileType, Language dialect, String text) {
        String name = "__dummy." + fileType.getDefaultExtension();
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)searchContext.getProject());
        return dialect == null ? factory.createFileFromText(name, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true, true) : factory.createFileFromText(name, dialect, (CharSequence)text, true, true);
    }

    @Nullable
    public PsiCodeFragment createCodeFragment(Project project, String text, @Nullable PsiElement context) {
        return null;
    }

    @Nullable
    public abstract Class<? extends TemplateContextType> getTemplateContextTypeClass();

    public final TemplateContextType getTemplateContextType() {
        Class<? extends TemplateContextType> clazz = this.getTemplateContextTypeClass();
        return clazz != null ? (TemplateContextType)ContainerUtil.findInstance((Object[])TemplateContextType.EP_NAME.getExtensions(), clazz) : null;
    }

    @Nullable
    public FileType detectFileType(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/structuralsearch/StructuralSearchProfile", "detectFileType"));
        }
        return null;
    }

    @Nullable
    public StructuralReplaceHandler getReplaceHandler(@NotNull ReplacementContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/structuralsearch/StructuralSearchProfile", "getReplaceHandler"));
        }
        return null;
    }

    public void checkSearchPattern(Project project, MatchOptions options) {
    }

    public void checkReplacementPattern(Project project, ReplaceOptions options) {
        String fileType = StructuralSearchProfile.getTypeName(options.getMatchOptions().getFileType());
        throw new UnsupportedPatternException(SSRBundle.message("replacement.not.supported.for.filetype", fileType));
    }

    @NotNull
    public Language getLanguage(PsiElement element) {
        Language language = element.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchProfile", "getLanguage"));
        }
        return language;
    }

    public boolean canBeVarDelimeter(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/StructuralSearchProfile", "canBeVarDelimeter"));
        }
        return false;
    }

    public String getText(PsiElement match, int start, int end) {
        String matchText = match.getText();
        if (start == 0 && end == -1) {
            return matchText;
        }
        return matchText.substring(start, end == -1 ? matchText.length() : end);
    }

    public Class getElementContextByPsi(PsiElement element) {
        return element.getClass();
    }

    @NotNull
    public String getTypedVarString(PsiElement element) {
        String name;
        if (element instanceof PsiNamedElement && (name = ((PsiNamedElement)element).getName()) != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchProfile", "getTypedVarString"));
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchProfile", "getTypedVarString"));
        }
        return string;
    }

    public String getMeaningfulText(PsiElement element) {
        return this.getTypedVarString(element);
    }

    public PsiElement updateCurrentNode(PsiElement node) {
        return node;
    }

    public PsiElement extendMatchedByDownUp(PsiElement node) {
        return node;
    }

    public PsiElement extendMatchOnePsiFile(PsiElement file2) {
        return file2;
    }

    public LanguageFileType getDefaultFileType(@Nullable LanguageFileType fileType) {
        return fileType;
    }

    Configuration[] getPredefinedTemplates() {
        return Configuration.EMPTY_ARRAY;
    }

    public void provideAdditionalReplaceOptions(@NotNull PsiElement node, ReplaceOptions options, ReplacementBuilder builder) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/structuralsearch/StructuralSearchProfile", "provideAdditionalReplaceOptions"));
        }
    }

    public int handleSubstitution(ParameterInfo info, MatchResult match, StringBuilder result2, int offset, HashMap<String, MatchResult> matchMap) {
        if (info.getName().equals(match.getName())) {
            String replacementString = match.getMatchImage();
            boolean forceAddingNewLine = false;
            if (match.hasSons() && !match.isScopeMatch()) {
                StringBuilder buf = new StringBuilder();
                for (MatchResult matchResult : match.getAllSons()) {
                    PsiElement currentElement = matchResult.getMatch();
                    if (buf.length() > 0) {
                        if (info.isArgumentContext()) {
                            buf.append(',');
                        } else {
                            buf.append(' ');
                        }
                    }
                    buf.append(matchResult.getMatchImage());
                    forceAddingNewLine = currentElement instanceof PsiComment;
                }
                replacementString = buf.toString();
            } else if (info.isStatementContext()) {
                forceAddingNewLine = match.getMatch() instanceof PsiComment;
            }
            offset = Replacer.insertSubstitution(result2, offset, info, replacementString);
            if (forceAddingNewLine && info.isStatementContext()) {
                result2.insert(info.getStartIndex() + offset + 1, '\n');
                ++offset;
            }
        }
        return offset;
    }

    public int handleNoSubstitution(ParameterInfo info, int offset, StringBuilder result2) {
        if (info.isHasCommaBefore()) {
            result2.delete(info.getBeforeDelimiterPos() + offset, info.getBeforeDelimiterPos() + 1 + offset);
            --offset;
        } else if (info.isHasCommaAfter()) {
            result2.delete(info.getAfterDelimiterPos() + offset, info.getAfterDelimiterPos() + 1 + offset);
            --offset;
        }
        return offset;
    }

    public boolean isIdentifier(PsiElement element) {
        return false;
    }

    public Collection<String> getReservedWords() {
        return Collections.emptySet();
    }

    public boolean isDocCommentOwner(PsiElement match) {
        return false;
    }

    @NotNull
    public PsiElement getPresentableElement(PsiElement element) {
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchProfile", "getPresentableElement"));
        }
        return psiElement;
    }
}

