/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.JavaTestLocator;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.RecentTestRunner;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class RecentTestRunnerImpl
implements RecentTestRunner {
    private static AnAction RUN = ActionManager.getInstance().getAction("RunClass");
    private static AnAction DEBUG = ActionManager.getInstance().getAction("DebugClass");
    protected AnAction myCurrentAction = DEBUG;
    private final Project myProject;

    public RecentTestRunnerImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public void setMode(RecentTestRunner.Mode mode) {
        switch (mode) {
            case RUN: {
                this.myCurrentAction = RUN;
                break;
            }
            case DEBUG: {
                this.myCurrentAction = DEBUG;
            }
        }
    }

    @Override
    public Location getLocation(String url) {
        List<Location> locations;
        String protocol = VirtualFileManager.extractProtocol((String)url);
        String path = VirtualFileManager.extractPath((String)url);
        if (protocol != null && !(locations = JavaTestLocator.INSTANCE.getLocation(protocol, path, this.myProject, GlobalSearchScope.allScope((Project)this.myProject))).isEmpty()) {
            return locations.get(0);
        }
        return null;
    }

    @Override
    public boolean isSuite(String url) {
        String protocol = VirtualFileManager.extractProtocol((String)url);
        return "java:suite".equals(protocol);
    }

    @Override
    public void run(final Location location) {
        DataContext data = new DataContext(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (Location.DATA_KEY.is(dataId)) {
                    return location;
                }
                return null;
            }
        };
        this.myCurrentAction.actionPerformed(AnActionEvent.createFromAnAction((AnAction)this.myCurrentAction, null, (String)"", (DataContext)data));
    }
}

