/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.Patches;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.unscramble.UnscrambleDialog;
import com.intellij.util.Alarm;
import java.util.regex.Pattern;

public class UnscrambleListener
extends ApplicationActivationListener.Adapter {
    private static final int MAX_STACKTRACE_SIZE = 102400;
    private String stacktrace = null;
    private static final Pattern STACKTRACE_LINE = Pattern.compile("[\t]*at [[_a-zA-Z0-9]+\\.]+[_a-zA-Z$0-9]+\\.[a-zA-Z0-9_]+\\([A-Za-z0-9_]+\\.java:[\\d]+\\)+[ [~]*\\[[a-zA-Z0-9\\.\\:/]\\]]*");

    public void applicationActivated(final IdeFrame ideFrame) {
        Runnable processClipboard = new Runnable(){

            @Override
            public void run() {
                String clipboard = AnalyzeStacktraceUtil.getTextInClipboard();
                if (clipboard != null && clipboard.length() < 102400 && !clipboard.equals(UnscrambleListener.this.stacktrace)) {
                    UnscrambleListener.this.stacktrace = clipboard;
                    Project project = ideFrame.getProject();
                    if (project != null && UnscrambleListener.isStacktrace(UnscrambleListener.this.stacktrace)) {
                        UnscrambleDialog dialog = new UnscrambleDialog(project);
                        dialog.createNormalizeTextAction().actionPerformed(null);
                        if (!DumbService.isDumb((Project)project)) {
                            dialog.doOKAction();
                        }
                    }
                }
            }
        };
        if (Patches.SLOW_GETTING_CLIPBOARD_CONTENTS) {
            new Alarm().addRequest(processClipboard, 300);
        } else {
            processClipboard.run();
        }
    }

    public void applicationDeactivated(IdeFrame ideFrame) {
        if (SystemInfo.isMac) {
            return;
        }
        this.stacktrace = AnalyzeStacktraceUtil.getTextInClipboard();
    }

    public static boolean isStacktrace(String stacktrace) {
        stacktrace = UnscrambleDialog.normalizeText(stacktrace);
        int linesCount = 0;
        for (String line : stacktrace.split("\n")) {
            if ((line = line.trim()).length() == 0) continue;
            linesCount = STACKTRACE_LINE.matcher(line = StringUtil.trimEnd((String)line, (String)"\r")).matches() ? ++linesCount : 0;
            if (linesCount <= 2) continue;
            return true;
        }
        return false;
    }
}

