/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.FList;
import gnu.trove.THashMap;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

public class DebugReflectionUtil {
    private static final Map<Class, Field[]> allFields = new THashMap();
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Method Unsafe_shouldBeInitialized = ReflectionUtil.getDeclaredMethod(Unsafe.class, (String)"shouldBeInitialized", (Class[])new Class[]{Class.class});

    @NotNull
    private static Field[] getAllFields(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/DebugReflectionUtil", "getAllFields"));
        }
        Field[] cached = allFields.get(aClass);
        if (cached == null) {
            try {
                Field[] declaredFields = aClass.getDeclaredFields();
                ArrayList<Field> fields = new ArrayList<Field>(declaredFields.length + 5);
                for (Field declaredField : declaredFields) {
                    declaredField.setAccessible(true);
                    Class<?> type = declaredField.getType();
                    if (DebugReflectionUtil.isTrivial(type)) continue;
                    fields.add(declaredField);
                }
                Class superclass = aClass.getSuperclass();
                if (superclass != null) {
                    for (Field sup : DebugReflectionUtil.getAllFields(superclass)) {
                        if (fields.contains(sup)) continue;
                        fields.add(sup);
                    }
                }
                cached = fields.isEmpty() ? EMPTY_FIELD_ARRAY : fields.toArray(new Field[fields.size()]);
            }
            catch (IncompatibleClassChangeError e) {
                cached = EMPTY_FIELD_ARRAY;
            }
            catch (SecurityException e) {
                cached = EMPTY_FIELD_ARRAY;
            }
            catch (NoClassDefFoundError e) {
                cached = EMPTY_FIELD_ARRAY;
            }
            allFields.put(aClass, cached);
        }
        if (cached == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/DebugReflectionUtil", "getAllFields"));
        }
        return cached;
    }

    private static boolean isTrivial(@NotNull Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/DebugReflectionUtil", "isTrivial"));
        }
        return type.isPrimitive() || type == String.class || type == Class.class || type.isArray() && DebugReflectionUtil.isTrivial(type.getComponentType());
    }

    public static boolean processStronglyReferencedValues(@NotNull Object root, PairProcessor<Object, Field> processor2) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/DebugReflectionUtil", "processStronglyReferencedValues"));
        }
        Class<?> rootClass = root.getClass();
        for (Field field : DebugReflectionUtil.getAllFields(rootClass)) {
            Object value;
            String fieldName = field.getName();
            if (root instanceof Reference && "referent".equals(fieldName)) continue;
            try {
                value = field.get(root);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (value == null || processor2.process(value, (Object)field)) continue;
            return false;
        }
        if (rootClass.isArray()) {
            try {
                for (Object object : (Object[])root) {
                    if (object == null || DebugReflectionUtil.isTrivial(object.getClass()) || processor2.process(object, null)) continue;
                    return false;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (root instanceof Class && DebugReflectionUtil.isLoadedAlready((Class)root)) {
            try {
                for (Field field : DebugReflectionUtil.getAllFields((Class)root)) {
                    Object value;
                    if ((field.getModifiers() & 8) == 0 || (value = field.get(null)) == null || processor2.process(value, (Object)field)) continue;
                    return false;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return true;
    }

    private static boolean isLoadedAlready(@NotNull Class root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/DebugReflectionUtil", "isLoadedAlready"));
        }
        if (Unsafe_shouldBeInitialized == null) {
            return false;
        }
        boolean isLoadedAlready = false;
        try {
            isLoadedAlready = (Boolean)Unsafe_shouldBeInitialized.invoke((Object)AtomicFieldUpdater.getUnsafe(), root) == false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isLoadedAlready;
    }

    public static class BackLink {
        @NotNull
        public final Object value;
        private final Field field;
        private final BackLink backLink;

        public BackLink(@NotNull Object value, @Nullable Field field, @Nullable BackLink backLink) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/DebugReflectionUtil$BackLink", "<init>"));
            }
            this.value = value;
            this.field = field;
            this.backLink = backLink;
        }

        public String toString() {
            BackLink backLink = this;
            String result2 = "";
            while (backLink != null) {
                String valueStr;
                try {
                    valueStr = backLink.value instanceof FList ? "FList (size=" + ((FList)backLink.value).size() + ")" : (backLink.value instanceof Collection ? "Collection (size=" + ((Collection)backLink.value).size() + ")" : String.valueOf(backLink.value));
                    valueStr = StringUtil.first((String)StringUtil.convertLineSeparators((String)valueStr, (String)"\\n"), (int)200, (boolean)true);
                }
                catch (Throwable e) {
                    valueStr = "(" + e.getMessage() + " while computing .toString())";
                }
                Field field = backLink.field;
                String fieldName = field == null ? "?" : field.getDeclaringClass().getName() + "." + field.getName();
                result2 = result2 + "via '" + fieldName + "'; Value: '" + valueStr + "' of " + backLink.value.getClass() + "\n";
                backLink = backLink.backLink;
            }
            return result2;
        }
    }
}

