/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.indexing.ChangeTrackingValueContainer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexStorage;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.ValueContainerImpl;
import com.intellij.util.indexing.ValueContainerMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.PersistentMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MapIndexStorage<Key, Value>
implements IndexStorage<Key, Value> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.MapIndexStorage");
    private static final boolean ENABLE_CACHED_HASH_IDS = SystemProperties.getBooleanProperty((String)"idea.index.no.cashed.hashids", (boolean)true);
    private final boolean myBuildKeyHashToVirtualFileMapping;
    private PersistentMap<Key, ValueContainer<Value>> myMap;
    private PersistentBTreeEnumerator<int[]> myKeyHashToVirtualFileMapping;
    private SLRUCache<Key, ChangeTrackingValueContainer<Value>> myCache;
    private volatile int myLastScannedId;
    private final File myBaseStorageFile;
    private final KeyDescriptor<Key> myKeyDescriptor;
    private final int myCacheSize;
    private final Lock l;
    private final DataExternalizer<Value> myDataExternalizer;
    private final boolean myKeyIsUniqueForIndexedFile;
    private static final PersistentHashMapValueStorage.ExceptionalIOCancellationCallback ourProgressManagerCheckCancelledIOCanceller = new PersistentHashMapValueStorage.ExceptionalIOCancellationCallback(){

        public void checkCancellation() {
            ProgressManager.checkCanceled();
        }
    };

    public MapIndexStorage(@NotNull File storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize) throws IOException {
        if (storageFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageFile", "com/intellij/util/indexing/MapIndexStorage", "<init>"));
        }
        if (keyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyDescriptor", "com/intellij/util/indexing/MapIndexStorage", "<init>"));
        }
        if (valueExternalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueExternalizer", "com/intellij/util/indexing/MapIndexStorage", "<init>"));
        }
        this(storageFile, keyDescriptor, valueExternalizer, cacheSize, false, false);
    }

    public MapIndexStorage(@NotNull File storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean keyIsUniqueForIndexedFile, boolean buildKeyHashToVirtualFileMapping) throws IOException {
        if (storageFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageFile", "com/intellij/util/indexing/MapIndexStorage", "<init>"));
        }
        if (keyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyDescriptor", "com/intellij/util/indexing/MapIndexStorage", "<init>"));
        }
        if (valueExternalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueExternalizer", "com/intellij/util/indexing/MapIndexStorage", "<init>"));
        }
        this.l = new ReentrantLock();
        this.myBaseStorageFile = storageFile;
        this.myKeyDescriptor = keyDescriptor;
        this.myCacheSize = cacheSize;
        this.myDataExternalizer = valueExternalizer;
        this.myKeyIsUniqueForIndexedFile = keyIsUniqueForIndexedFile;
        this.myBuildKeyHashToVirtualFileMapping = buildKeyHashToVirtualFileMapping && FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
        this.initMapAndCache();
    }

    private void initMapAndCache() throws IOException {
        ValueContainerMap<Key, Value> map;
        PersistentHashMapValueStorage.CreationTimeOptions.EXCEPTIONAL_IO_CANCELLATION.set(ourProgressManagerCheckCancelledIOCanceller);
        try {
            map = new ValueContainerMap<Key, Value>(this.getStorageFile(), this.myKeyDescriptor, this.myDataExternalizer, this.myKeyIsUniqueForIndexedFile);
        }
        finally {
            PersistentHashMapValueStorage.CreationTimeOptions.EXCEPTIONAL_IO_CANCELLATION.set(null);
        }
        this.myCache = new SLRUCache<Key, ChangeTrackingValueContainer<Value>>(this.myCacheSize, (int)Math.ceil((double)this.myCacheSize * 0.25)){

            @NotNull
            public ChangeTrackingValueContainer<Value> createValue(final Key key) {
                ChangeTrackingValueContainer changeTrackingValueContainer = new ChangeTrackingValueContainer(new ChangeTrackingValueContainer.Initializer<Value>(){

                    @Override
                    @NotNull
                    public Object getLock() {
                        Object object = map.getDataAccessLock();
                        if (object == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapIndexStorage$2$1", "getLock"));
                        }
                        return object;
                    }

                    @Nullable
                    public ValueContainer<Value> compute() {
                        ValueContainerImpl value;
                        try {
                            value = (ValueContainerImpl)map.get(key);
                            if (value == null) {
                                value = new ValueContainerImpl();
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        return value;
                    }
                });
                if (changeTrackingValueContainer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapIndexStorage$2", "createValue"));
                }
                return changeTrackingValueContainer;
            }

            protected void onDropFromCache(Key key, @NotNull ChangeTrackingValueContainer<Value> valueContainer) {
                if (valueContainer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueContainer", "com/intellij/util/indexing/MapIndexStorage$2", "onDropFromCache"));
                }
                if (valueContainer.isDirty()) {
                    try {
                        map.put(key, valueContainer);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        this.myMap = map;
        this.myKeyHashToVirtualFileMapping = this.myBuildKeyHashToVirtualFileMapping ? new KeyHash2VirtualFileEnumerator(this.getProjectFile()) : null;
    }

    @NotNull
    private File getStorageFile() {
        File file2 = new File(this.myBaseStorageFile.getPath() + ".storage");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapIndexStorage", "getStorageFile"));
        }
        return file2;
    }

    @NotNull
    private File getProjectFile() {
        File file2 = new File(this.myBaseStorageFile.getPath() + ".project");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapIndexStorage", "getProjectFile"));
        }
        return file2;
    }

    @Override
    public void flush() {
        this.l.lock();
        try {
            if (!this.myMap.isClosed()) {
                this.myCache.clear();
                if (this.myMap.isDirty()) {
                    this.myMap.force();
                }
            }
            if (this.myKeyHashToVirtualFileMapping != null && this.myKeyHashToVirtualFileMapping.isDirty()) {
                this.myKeyHashToVirtualFileMapping.force();
            }
        }
        finally {
            this.l.unlock();
        }
    }

    @Override
    public void close() throws StorageException {
        try {
            this.flush();
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.myKeyHashToVirtualFileMapping.close();
            }
            this.myMap.close();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw new StorageException(cause);
            }
            if (cause instanceof StorageException) {
                throw (StorageException)cause;
            }
            throw e;
        }
    }

    @Override
    public void clear() throws StorageException {
        try {
            this.myMap.close();
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.myKeyHashToVirtualFileMapping.close();
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        try {
            IOUtil.deleteAllFilesStartingWith((File)this.getStorageFile());
            if (this.myKeyHashToVirtualFileMapping != null) {
                IOUtil.deleteAllFilesStartingWith((File)this.getProjectFile());
            }
            this.initMapAndCache();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw new StorageException(cause);
            }
            if (cause instanceof StorageException) {
                throw (StorageException)cause;
            }
            throw e;
        }
    }

    @Override
    public boolean processKeys(final @NotNull Processor<Key> processor2, GlobalSearchScope scope, final IdFilter idFilter) throws StorageException {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/MapIndexStorage", "processKeys"));
        }
        this.l.lock();
        try {
            this.myCache.clear();
            if (this.myBuildKeyHashToVirtualFileMapping && idFilter != null) {
                TIntHashSet finalHashMaskSet;
                TIntHashSet hashMaskSet = null;
                long l = System.currentTimeMillis();
                File fileWithCaches = this.getSavedProjectFileValueIds(this.myLastScannedId, scope);
                boolean useCachedHashIds = ENABLE_CACHED_HASH_IDS && (scope instanceof ProjectScopeImpl || scope instanceof ProjectAndLibrariesScope) && fileWithCaches != null;
                int id = this.myKeyHashToVirtualFileMapping.getLargestId();
                if (useCachedHashIds && id == this.myLastScannedId) {
                    try {
                        hashMaskSet = MapIndexStorage.loadHashedIds(fileWithCaches);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (hashMaskSet == null) {
                    if (useCachedHashIds && this.myLastScannedId != 0) {
                        FileUtil.asyncDelete((File)fileWithCaches);
                    }
                    finalHashMaskSet = hashMaskSet = new TIntHashSet(1000);
                    this.myKeyHashToVirtualFileMapping.iterateData((Processor)new Processor<int[]>(){

                        public boolean process(int[] key) {
                            if (!idFilter.containsFileId(key[1])) {
                                return true;
                            }
                            finalHashMaskSet.add(key[0]);
                            ProgressManager.checkCanceled();
                            return true;
                        }
                    });
                    if (useCachedHashIds) {
                        this.saveHashedIds(hashMaskSet, id, scope);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanned keyHashToVirtualFileMapping of " + this.myBaseStorageFile + " for " + (System.currentTimeMillis() - l));
                }
                finalHashMaskSet = hashMaskSet;
                boolean bl = this.myMap.processKeys(new Processor<Key>(){

                    public boolean process(Key key) {
                        if (!finalHashMaskSet.contains(MapIndexStorage.this.myKeyDescriptor.getHashCode(key))) {
                            return true;
                        }
                        return processor2.process(key);
                    }
                });
                return bl;
            }
            boolean hashMaskSet = this.myMap.processKeys(processor2);
            return hashMaskSet;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw new StorageException(cause);
            }
            if (cause instanceof StorageException) {
                throw (StorageException)cause;
            }
            throw e;
        }
        finally {
            this.l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static TIntHashSet loadHashedIds(@NotNull File fileWithCaches) throws IOException {
        int capacity;
        if (fileWithCaches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileWithCaches", "com/intellij/util/indexing/MapIndexStorage", "loadHashedIds"));
        }
        FilterInputStream inputStream = null;
        inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(fileWithCaches)));
        TIntHashSet hashMaskSet = new TIntHashSet(capacity);
        for (capacity = DataInputOutputUtil.readINT((DataInput)((Object)inputStream)); capacity > 0; --capacity) {
            hashMaskSet.add(DataInputOutputUtil.readINT((DataInput)((Object)inputStream)));
        }
        inputStream.close();
        TIntHashSet tIntHashSet = hashMaskSet;
        TIntHashSet tIntHashSet2 = tIntHashSet;
        if (tIntHashSet2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapIndexStorage", "loadHashedIds"));
        }
        return tIntHashSet2;
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveHashedIds(@NotNull TIntHashSet hashMaskSet, int largestId, @NotNull GlobalSearchScope scope) {
        if (hashMaskSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMaskSet", "com/intellij/util/indexing/MapIndexStorage", "saveHashedIds"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/util/indexing/MapIndexStorage", "saveHashedIds"));
        }
        File newFileWithCaches = this.getSavedProjectFileValueIds(largestId, scope);
        assert (newFileWithCaches != null);
        DataOutputStream stream = null;
        boolean savedSuccessfully = false;
        try {
            stream = new DataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(newFileWithCaches)));
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)hashMaskSet.size());
            final DataOutputStream finalStream = stream;
            savedSuccessfully = hashMaskSet.forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    try {
                        DataInputOutputUtil.writeINT((DataOutput)finalStream, (int)value);
                        return true;
                    }
                    catch (IOException ex) {
                        return false;
                    }
                }
            });
        }
        catch (IOException iOException) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                    if (savedSuccessfully) {
                        this.myLastScannedId = largestId;
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Nullable
    private File getSavedProjectFileValueIds(int id, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/util/indexing/MapIndexStorage", "getSavedProjectFileValueIds"));
        }
        Project project = scope.getProject();
        if (project == null) {
            return null;
        }
        return new File(this.getProjectFile().getPath() + "." + project.hashCode() + "." + id + "." + scope.isSearchInLibraries());
    }

    @Override
    @NotNull
    public Collection<Key> getKeys() throws StorageException {
        ArrayList keys = new ArrayList();
        this.processKeys((Processor<Key>)new CommonProcessors.CollectProcessor(keys), null, null);
        ArrayList arrayList = keys;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapIndexStorage", "getKeys"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public ChangeTrackingValueContainer<Value> read(Key key) throws StorageException {
        ChangeTrackingValueContainer changeTrackingValueContainer;
        this.l.lock();
        try {
            ChangeTrackingValueContainer changeTrackingValueContainer2 = (ChangeTrackingValueContainer)this.myCache.get(key);
            changeTrackingValueContainer = changeTrackingValueContainer2;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw new StorageException(cause);
            }
            if (cause instanceof StorageException) {
                throw (StorageException)cause;
            }
            throw e;
        }
        finally {
            this.l.unlock();
        }
        if (changeTrackingValueContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MapIndexStorage", "read"));
        }
        return changeTrackingValueContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValue(Key key, int inputId, Value value) throws StorageException {
        try {
            ChangeTrackingValueContainer cached;
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.myKeyHashToVirtualFileMapping.enumerate((Object)new int[]{this.myKeyDescriptor.getHashCode(key), inputId});
            }
            this.myMap.markDirty();
            if (!this.myKeyIsUniqueForIndexedFile) {
                ((ChangeTrackingValueContainer)this.read((Object)key)).addValue(inputId, value);
                return;
            }
            try {
                this.l.lock();
                cached = (ChangeTrackingValueContainer)this.myCache.getIfCached(key);
            }
            finally {
                this.l.unlock();
            }
            if (cached != null) {
                cached.addValue(inputId, value);
                return;
            }
            ChangeTrackingValueContainer<Value> valueContainer = new ChangeTrackingValueContainer<Value>(null);
            valueContainer.addValue(inputId, value);
            this.myMap.put(key, valueContainer);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void removeAllValues(@NotNull Key key, int inputId) throws StorageException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/indexing/MapIndexStorage", "removeAllValues"));
        }
        try {
            this.myMap.markDirty();
            ((ChangeTrackingValueContainer)this.read((Object)key)).removeAssociatedValue(inputId);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    private static class KeyHash2VirtualFileEnumerator
    extends PersistentBTreeEnumerator<int[]> {
        public KeyHash2VirtualFileEnumerator(File projectFile) throws IOException {
            super(projectFile, (KeyDescriptor)new IntPairInArrayKeyDescriptor(), 4096);
        }
    }

    private static class IntPairInArrayKeyDescriptor
    implements KeyDescriptor<int[]>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        private IntPairInArrayKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, int[] value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/indexing/MapIndexStorage$IntPairInArrayKeyDescriptor", "save"));
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value[0]);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value[1]);
        }

        public int[] read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/util/indexing/MapIndexStorage$IntPairInArrayKeyDescriptor", "read"));
            }
            return new int[]{DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in)};
        }

        public int getHashCode(int[] value) {
            return value[0] * 31 + value[1];
        }

        public boolean isEqual(int[] val1, int[] val2) {
            return val1[0] == val2[0] && val1[1] == val2[1];
        }
    }
}

